/*****************************************************************************
 ****                                                                     ****
 **** atree.h                                                             ****
 ****                                                                     ****
 **** atree release 2.0                                                   ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) A. Dwelly, R. Manderscheid, W.W. Armstrong, 1991.     ****
 ****                                                                     ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES ONLY  ****
 **** to adapt logic trees using this program and its modifications.      ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 ****                                                                     ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 90.05.09 Initial implementation, A.Dwelly                           ****
 **** 91.07.15 Release 2, Rolf Manderscheid                               ****
 ****                                                                     ****
 *****************************************************************************/

/*****************************************************************************
 ****                                                                     ****
 **** atree                                                               ****
 ****                                                                     ****
 *****************************************************************************/

#include "bv.h"

#define MEMCHECK(p) \
  if ((p) == NULL) { (void) fprintf(stderr, "Out of memory\n"); exit(1); }

/* Overcoming the problems with rand() */
#define RANDOM(b) ((rand() >> 12) % (b))

typedef union atree_type {

  union atree_node_type {
    union atree_node_type *next;    /* for free list management */
    struct {
      unsigned int tag : 3;
      unsigned int sig_right : 2;
      unsigned int sig_left : 2;
      int cnt_right : 12;
      int cnt_left : 12;
      union atree_type *child[2];
    } data;
  } node;

  union atree_leaf_type {
    union atree_leaf_type *next;
    struct {
      unsigned int tag : 3;
      unsigned int comp : 1;
      unsigned int bit_no : 28;
    } data;
  } leaf;

} atree;

#define c_tag		node.data.tag	/* common tag */
#define l_bit_no	leaf.data.bit_no
#define l_comp		leaf.data.comp
#define n_sig_right	node.data.sig_right
#define n_sig_left	node.data.sig_left
#define n_cnt_right	node.data.cnt_right
#define n_cnt_left	node.data.cnt_left
#define n_child		node.data.child

typedef union atree_node_type atree_node;
typedef union atree_leaf_type atree_leaf;

typedef struct fast_tree_struct {
  struct fast_tree_struct *next[2];
  short bit_no;
  short comp;
} fast_tree;

typedef struct code_struct {
  int vector_count;
  int width;
  float low;
  float high;
  float step;
  bit_vec *vector;
} code_t;

/* Import public routines */

void atree_init();
atree *atree_create();
void atree_free();
void atree_print();
int atree_eval();
int atree_train();
bit_vec *atree_rand_walk();
atree *atree_fold();

fast_tree *atree_compress();
int atree_fast_eval();
void atree_fast_print();

int atree_store();
atree *atree_load();
int atree_write();
atree *atree_read();

int atree_set_code();
int atree_encode();
int atree_decode();
int atree_write_code();
code_t *atree_read_code();

/* for upward compatibility ... */

#define atree_bv_create		bv_create
#define atree_bv_pack		bv_pack
#define atree_bv_diff		bv_diff
#define atree_bv_concat		bv_concat
#define atree_bv_insert		bv_set
#define atree_bv_extract	bv_extract
#define atree_bv_print(v)	(void) bv_print(stdout, v)
#define atree_bv_free		bv_free
#define atree_bv_equal		bv_equal
