/*****************************************************************************
 ****                                                                     ****
 **** bv.h                                                                ****
 ****                                                                     ****
 **** atree release 2.0                                                   ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) A. Dwelly, R. Manderscheid, W.W. Armstrong, 1991.     ****
 ****                                                                     ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES ONLY  ****
 **** to adapt logic trees using this program and its modifications.      ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 ****                                                                     ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 90.05.09 Initial implementation, A.Dwelly                           ****
 **** 91.07.15 Release 2, Rolf Manderscheid                               ****
 ****                                                                     ****
 *****************************************************************************/

/*****************************************************************************
 ****                                                                     ****
 **** bit_vec                                                             ****
 ****                                                                     ****
 **** A bit_vec is a packed vector of bits, stored in an array of chars.  ****
 *****************************************************************************/

#ifndef bv_h
#define bv_h

typedef struct bit_vec_strc
{
    int len;    /* The length of the vector in bits */
    char  *bv;  /* The packed bit vector itself     */
}
bit_vec;

int bv_diff();
bit_vec *bv_create();
bit_vec *bv_pack();
bit_vec *bv_concat();
bit_vec *bv_copy();
void bv_set();
int bv_extract();
int bv_equal();
void bv_free();
int bv_print();

#endif
