/*****************************************************************************
 ****                                                                     ****
 **** lf.h                                                                ****
 ****                                                                     ****
 **** The program lf implements a small language for controlling the      ****
 **** atree software. it takes a single parameter which is the name of    ****
 **** the file it is to execute, or if there is none, reads the standard  ****
 **** input. The language is fully described in the `An implementation..' ****
 **** document.                                                           ****
 ****                                                                     ****
 **** atree release 2.0                                                   ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) A. Dwelly, R. Manderscheid, W.W. Armstrong, 1991.     ****
 ****                                                                     ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES ONLY  ****
 **** to adapt logic trees using this program and its modifications.      ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 ****                                                                     ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 90.02.10 Initial implementation, A.Dwelly                           ****
 **** 91.07.15 Release 2, Rolf Manderscheid                               ****
 ****                                                                     ****
 *****************************************************************************/

#define TRUE 1
#define FALSE 0

typedef int bool_t;

typedef struct prog_struct
{
    bool_t error;
    bool_t warning;
    bool_t forest_folded;

    /*
     * total_dimensions = dimensions + codimensions
     * domain: 0 .. dimensions - 1
     * codomain: dimensions .. total_dimensions - 1
     */
    int dimensions;
    int codimensions;
    int total_dimensions;

    int domain_width;
    int codomain_width;
    int trainset_sz;
    int testset_sz;
    float **train_table;
    float **test_table;

    code_t *code;
    int *walk_step;

    int tree_sz;
    int min_correct;
    int max_epochs;
    int vote;

    char *save_tree;
    char *load_tree;
    char *save_code;
    char *load_code;
}
prog_t;

union stack_type {
  int	i;
  float f;
  char  *s;
};

#define YYSTYPE union stack_type
