/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

#ifdef FSIM
# include "fsim.h"
#else
# include "sim.h"
#endif

int UFvert();
int UFinput();

int seti;

CreateUnits()
{ int i,j,k;
  
  for (i = 0; i < 26; i++)
    {
      j = MakeUnit("node",UFvert,0,0,0,0,0,0);
      AddSite(j,"excite",SFweightedsum, 0);
    }
  NameUnit("VIEW1",ARRAY,0,4,3);
  NameUnit("B-CLOSER",SCALAR,12,1,1);
  NameUnit("VIEW2",ARRAY,13,4,3);
  NameUnit("H-CLOSER",SCALAR,25,1,1);
  for (i = 0; i < 8; i++)
    {
      j = MakeUnit("input",UFinput,0,0,0,0,0,0);
      MakeLink(j,j-26,"excite",150,0,NULL);
    }
  for (i = 0; i < 8; i++)
    {
      j = MakeUnit("input",UFinput,0,0,0,0,0,0);
      MakeLink(j,j-21,"excite",150,0,NULL);
    }
  NameUnit("INPUT",ARRAY,26,8,2);
}

BiLink(unita,unitb,weight)
     int unita,unitb,weight;

{
  MakeLink(unita,unitb,"excite",weight,0,NULL);
  MakeLink(unitb,unita,"excite",weight,0,NULL);
}

CreateInhibition ()

{
  int i,j;
  
  for (j = 0; j < 2; j++)
    for (i = 0; i < 4; i++)
      BiLink(NameToInd("VIEW1",i,j),NameToInd("VIEW2",i,j),-575);
  for (i = 0; i < 4; i++)
    BiLink(NameToInd("VIEW1",i,2),NameToInd("VIEW2",i,2),-800);
  BiLink(NameToInd("B-CLOSER"),NameToInd("H-CLOSER"),-1000);
}

CreateExcite (front,back,depth,cube)
     int front,back,depth,cube;

{
  int i,j,k;

  for (i = 0; i < 4; i++)
    {
      BiLink(front+i,front+((i+1)%4),200);
      BiLink(back+i,back+((i+1)%4),200);
      BiLink(depth+i,depth+((i+1)%4),300);
      BiLink(front+i,back+i,200);
      BiLink(front+i,depth+i,300);
      BiLink(back+i,depth+i,300);
      BiLink(depth+i,cube,500);
    }
}

build()

{
  AllocateUnits(100);
  DeclareState("ACTIVE",0);
  DeclareState("PASSIVE",3);
  CreateUnits();
  CreateInhibition();
  CreateExcite(NameToInd("VIEW1",0,0),NameToInd("VIEW1",0,1),
	       NameToInd("VIEW1",0,2),NameToInd("B-CLOSER"));
  CreateExcite(NameToInd("VIEW2",0,0),NameToInd("VIEW2",0,1),
	       NameToInd("VIEW2",0,2),NameToInd("H-CLOSER"));
}

UFinput(up)
     Unit * up;

{
/*  fprintf(stdout,"executing unit %d\n",UnitIndex(up));*/
}

UFvert(up)
  Unit * up;

{
  FLINT inp;

  inp = up->sites->value;
/*  fprintf(stdout,"executing unit %d\n",UnitIndex(up));*/
  if (inp > 0)
    up->potential += ((1000 - up->potential)*inp)/100;
  else
    up->potential += (up->potential*inp)/100;
  if (up->potential > 1000)
    up->potential = 1000;
  up->output = up->potential/10;
}


