/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/*
  This code implements a simple widget that has scrollbars to control the
  values of BPlearn, BPmomentum and BPtemperature in the backpropagation
  module.
*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Box.h>
#include <X11/Label.h>
#include <X11/Form.h>
#include <X11/Scroll.h>
#include "sim.h"
#include "bp.h"
extern Widget gi_tool;

typedef struct _ct_st
{
  Widget scroll;		/* scrollbar */
  Widget readout;		/* number */
  float * param;			/* controlled variable */
} _control_rec, * _control_ptr;

static void JumpProc(sbar, info, percent)
     Widget sbar;                          /* scrollbar widget */
     caddr_t info;                         /* address of control parameter info */
     caddr_t percent;                      /* percentage from top */
{
  register _control_ptr cptr = (_control_ptr) info;
  static char buf[12];
  static Arg a[] =
    {
      { XtNlabel, (XtArgVal) buf },
    };

  *(cptr->param) = 1.0 - (* (float *) percent);        /* copy value */
  sprintf(buf, " %f ", *(cptr->param));	
  XtSetValues(cptr->readout, a, 1); /* show new value */
}

static void InitScroll(cptr)
     _control_ptr cptr;

{
  static char buf[12];
  static Arg a[] =
    {
      { XtNlabel, (XtArgVal) buf },
    };

  sprintf(buf, " %f ", *(cptr->param));
  XtSetValues(cptr->readout, a, 1); /* show value */
  XtScrollBarSetThumb(cptr->scroll, 1.0-*(cptr->param), 0.05); /* move thumb */
}

static _control_ptr MakeOneControl(parent, name, param)
     Widget parent;
     char * name;
     float * param;

{
  Widget label;
  _control_ptr cptr = (_control_ptr) malloc(sizeof(_control_rec));
  static Widget box = NULL;

  static Arg box_args[] =
    {
      { XtNfromHoriz, (XtArgVal) NULL },
      { XtNborderWidth, (XtArgVal) 1 },
    };
  static Arg scroll_args[] =
    {
      { XtNlength, (XtArgVal) 100},
      { XtNwidth, (XtArgVal) 20 },
    };
  static Arg label_args[] =
    {
      { XtNborderWidth, (XtArgVal) 0 },
      { XtNinternalWidth, (XtArgVal) 0 },
      { XtNinternalHeight, (XtArgVal) 0 },
    };

  box_args[0].value = (XtArgVal) box;

  box = XtCreateManagedWidget("box", boxWidgetClass, parent,
                                 box_args, XtNumber(box_args));
  cptr->param = param;
  cptr->readout = XtCreateManagedWidget(" 0.000000 ", labelWidgetClass, box,
                                 label_args, XtNumber(label_args));
  cptr->scroll = XtCreateManagedWidget("scroll", scrollbarWidgetClass, box,
                                 scroll_args, XtNumber(scroll_args));
  label = XtCreateManagedWidget(name, labelWidgetClass, box,
                                 label_args, XtNumber(label_args));
  XtAddCallback(cptr->scroll, XtNjumpProc, JumpProc, cptr);
  return cptr;
}

MakeBPControl()
{
  Widget shell, form;
  _control_ptr learn, temperature, momentum;
  static Arg form_args[] =
    {
      { XtNdefaultDistance, (XtArgVal) 0},
    };

  shell = XtCreatePopupShell("BP CONTROL",topLevelShellWidgetClass, gi_tool, NULL, 0);
  form = XtCreateManagedWidget("form", formWidgetClass, shell,
			       form_args, XtNumber(form_args));
  learn = MakeOneControl(form, "learn rate", &BPlearn);
  temperature = MakeOneControl(form, "temperature", &BPtemperature);
  momentum = MakeOneControl(form, "momentum", &BPmomentum);
  XtPopup(shell, XtGrabNone);             /* popup scrollbar widget */
  InitScroll(learn);           /* initialize thumb position */
  InitScroll(temperature);           /* initialize thumb position */
  InitScroll(momentum);           /* initialize thumb position */
}




