/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/*----------------------------------------------------------------------------
  Author: Nigel Goddard & Mark Fanty
  Date: May 1 1987
----------------------------------------------------------------------------*/
#ifdef BFLY
# include "bflycontrol.h"
#else
# include "sim.h"
#endif

#define NULL 0
/*---------------------------------------------------------------------------
  Sets output and potential to be the sum of the site values
----------------------------------------------------------------------------*/
func_type UFsum(up)
    Unit *up;
{
    int sum;
    Site *sp;

    for(sp = up->sites,sum = 0;sp != NULL;sp = sp->next)
	sum += sp->value;
    up->output = up->potential = sum;
}

/*---------------------------------------------------------------------------
  Sets the site value to be the weighted sum of the inputs
----------------------------------------------------------------------------*/

/*ARGSUSED*/
func_type SFweightedsum(up,sp)
    Unit *up;
    Site *sp;
{
    int sum;
    Link *lp;

    for(lp = sp->inputs,sum = 0;lp != NULL;lp = lp->next)
	sum += (*(lp->value) * lp->weight);
    sp->value = sum/1000;
}

/*---------------------------------------------------------------------------
   Sets the site value to be the sum of the inputs
----------------------------------------------------------------------------*/

/*ARGSUSED*/
func_type SFsum(up,sp)
    Unit *up;
    Site *sp;
{
    int sum;
    Link *lp;

    for(lp = sp->inputs,sum = 0;lp != NULL;lp = lp->next)
	sum += *(lp->value);
    sp->value = sum;
}

/*---------------------------------------------------------------------------
  Sets the site value to be the maximum weighted input
----------------------------------------------------------------------------*/

/*ARGSUSED*/
func_type SFweightedmax(up,sp)
    Unit *up;
    Site *sp;
{
    int sofar = -1000000,val;
    Link *lp;

    if(sp->inputs == NULL) sp->value = 0;
    else{
	for(lp = sp->inputs;lp != NULL;lp = lp->next){
	    val = (*(lp->value) * lp->weight)/1000;
	    if(val > sofar) sofar = val;
	}
	sp->value = sofar;
    }
}

/*---------------------------------------------------------------------------
  Sets the site value to be the maximum input
----------------------------------------------------------------------------*/

/*ARGSUSED*/
func_type SFmax(up,sp)
    Unit *up;
    Site *sp;
{
    int sofar = -1000000,val;
    Link *lp;

    if(sp->inputs == NULL) sp->value = 0;
    else{
	for(lp = sp->inputs;lp != NULL;lp = lp->next){
	    val = *(lp->value);
	    if(val > sofar) sofar = val;
	}
	sp->value = sofar;
    }
}

/*---------------------------------------------------------------------------
  Sets the site value to be the minimum weighted input
----------------------------------------------------------------------------*/

/*ARGSUSED*/
func_type SFweightedmin(up,sp)
    Unit *up;
    Site *sp;
{
    int sofar = 1000000,val;
    Link *lp;

    if(sp->inputs == NULL) sp->value = 0;
    else{
	for(lp = sp->inputs;lp != NULL;lp = lp->next){
	    val = (*(lp->value) * lp->weight)/1000;
	    if(val < sofar) sofar = val;
	}
	sp->value = sofar;
    }
}

/*---------------------------------------------------------------------------
  Sets the site value to be the minimum input
----------------------------------------------------------------------------*/

/*ARGSUSED*/
func_type SFmin(up,sp)
    Unit *up;
    Site *sp;
{
    int sofar = 1000000,val;
    Link *lp;

    if(sp->inputs == NULL) sp->value = 0;
    else{
	for(lp = sp->inputs;lp != NULL;lp = lp->next){
	    val = *(lp->value);
	    if(val < sofar) sofar = val;
	}
	sp->value = sofar;
    }
}

/*---------------------------------------------------------------------------
  SFand returns 1 if all its inputs are positive, otherwise 0 
----------------------------------------------------------------------------*/

/*ARGSUSED*/
func_type SFand (up,sp)
    Unit *up;
    Site *sp;

    {int i = 1;
     Link *ip;

     ip = sp->inputs;
     while ((i != 0) & (ip != NULL))
      if (*(ip->value) <= 0)
	i = 0;
      else
        ip = ip->next;
     sp->value = i;
    }

/*---------------------------------------------------------------------------
  SFxor returns 1 if exactly one of its inputs is nonzero, otherwise 0
----------------------------------------------------------------------------*/

/*ARGSUSED*/
func_type SFxor (up,sp)
   Unit *up;
   Site *sp;

 { int i = 0;
   Link *ip;

   for (ip = sp->inputs; ip != NULL; ip = ip->next)
     if (*(ip->value) != 0)
        i++;
   sp->value = (i == 1) ? 1 : 0;
 }

/*---------------------------------------------------------------------------
  SFprod returns product of inputs
----------------------------------------------------------------------------*/

/*ARGSUSED*/
func_type SFprod(up,sp)
     Unit *up;
     Site *sp;

{
  int tot = 1;
  Link *ip;
  int j;

  for (ip = sp->inputs; ip != NULL; ip = ip->next)
    {
      j = *(ip->value);
      if (j != 0)
	tot *= j;
    }
  sp->value = tot;
}

/*---------------------------------------------------------------------------
  Stores the incoming value in the data field.  One step memory.
----------------------------------------------------------------------------*/

/*ARGSUSED*/
func_type LFsimple(up,sp,ip)
    Unit *up;
    Site *sp;
    Link *ip;
{
    ip->data = *(ip->value);
}

/*---------------------------------------------------------------------------
  returns the site value at site named "name", which is in the linked list
  pointed to by sp.
----------------------------------------------------------------------------*/

FLINT SiteValue(name,sp)
    char *name;
    Site *sp;
{
    for(;sp != NULL;sp = sp->next)
	if(!strcmp(sp->name,name)) return sp->value;
    fprintf(stderr,"SiteValue: no site with name %s\n",name);
    return 0;
}

