/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

#ifndef _DisplayP_h
#define _DisplayP_h

#include "Display.h"
/* include superclass private header file */
#include <X11/CoreP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

#define XtRDisplayResource		"DisplayResource"

typedef struct {
    int empty;
} DisplayClassPart;

typedef struct _DisplayClassRec {
    CoreClassPart	core_class;
    DisplayClassPart	display_class;
} DisplayClassRec;

extern DisplayClassRec displayClassRec;

typedef struct {
    /* resources */
  XtCallbackList redraw_callback;
  XtCallbackList expose_callback;
  XtCallbackList action_callback;
    /* private state */
} DisplayPart;

typedef struct _DisplayRec {
    CorePart		core;
    DisplayPart	        display;
} DisplayRec;

#endif  _DisplayP_h
