
/**********************************************************************
 * $Id: help.h,v 1.2 92/11/30 12:02:04 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

/**********************************************************************
 * These help strings will be automatically registered 
 * and made available to the "whatis" command and "Help"
 * buttons on the GUI
 *
 * THIS FILE SHOULD ONLY BE INCLUDED BY THE FILE "kcl.c"
 * ANY OTHER FILE INCLUDING IT WILL CAUSE NAME CONFLICTS
 *
 **********************************************************************/

#ifndef scl_help_h
#define scl_help_h

/*********************************************************************/
char	*helpString_epochVarianceDecay[] = {
"  Real valued (should be positive)",
"       The amount by which the variances for Gaussian unit activations",
"       are multiplied after each epoch.  Default value is 1.0 (no decay)",
	 NULL } ;
/*********************************************************************/
char	*helpString_initialVariance[] = {
 "  Real valued (should be greater than zero)",
 "       The initial variance for Gaussian unit activations at ",
 "       the start of learning. Variance is reset to this value ",
 "       whenever the weights are randomized or a new net is built.",
  NULL } ;
/*********************************************************************/
char	*helpString_variance[] = {
"  Real valued (should be greater than zero)",
"       This defines the scale of the Gaussian activation function.",
  NULL } ;
/*********************************************************************/
char	*helpString_minVariance[] = {
"  Real valued (should be greater than zero)",
"       The variance is not permitted to decay below this value.",
	 NULL } ;
/*********************************************************************/
char	*helpString_learningRateDecayFunction[] = {
"  = 1 or 2",
"    1: Exponential decay. ",
"         Learning rate (epsilon) is multiplied by LearningRateDecay",
"	 each epoch.",
"	 Default value of learningRateDecay is 1.0 (no decay).",
"    2: Decay as 1/(1 + epoch/tau) (the default)",
"         Learning rate is multiplied by 1/(1 + epoch/tau) each epoch.",
"	 Default value of tau is infinity (no decay).",
	 NULL } ;
/*********************************************************************/
char	*helpString_learningRateDecay[] = {
"  Real valued (should be greater than zero)",
"       The amount by which the learning rate, epsilon, is multiplied ",
"       after each epoch if learningRateDecayFunction = 1 (exponential ",
"       decay). Default value is 1.0 (no decay)",
	 NULL } ;
/*********************************************************************/
char	*helpString_initialLearningRate[] = {
"  Real valued (should be greater than zero)",
"       The initial learning rate (epsilon) at the start of learning.",
"       Epsilon is reset to this value whenever the weights are ",
"       randomized or a new net is built, and is decayed after each ",
"       learning epoch according to learningRateDecayFunction.",
	 NULL } ;
/*********************************************************************/
char	*helpString_tau[] = {
"  Real valued (should be greater than zero)",
"        Used to decay learning rate (if learningDecayRate = 2)",
"	as 1/(1 + epoch/tau).",
"        A large value of tau means a very slow decay.",
"	Small value of tau (near zero) mean rapid decay.",
	 NULL } ;
/*********************************************************************/


#endif				/* scl_help_h */
