/*
    clos.c -- CLOS bootstrap.
*/
/*
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/



#include "config.h"

/******************************* EXPORTS ******************************/

object class_class, class_object, class_built_in;

/******************************* ------- ******************************/

extern object  Seq;
extern object  Seql;
extern object  Sequal;

object 	siSAclass_name_hash_tableA;
object  Sclass;
object  Sbuilt_in;

object
make_our_hash_table(object test, int size)
{
	enum httest htt;
	int i;
	object rehash_size, rehash_threshold, h;

	rehash_size = make_shortfloat((shortfloat)1.5);
	rehash_threshold = make_shortfloat((shortfloat)0.7);

	if (test == Seq)
		htt = htt_eq;
	else if (test == Seql)
		htt = htt_eql;
	else if (test == Sequal)
		htt = htt_equal;

	h = alloc_object(t_hashtable);
	h->ht.ht_self = NULL;	/* for GC sake */
	h->ht.ht_test = (short)htt;
	h->ht.ht_size = size;
	h->ht.ht_rhsize = rehash_size;
	h->ht.ht_rhthresh = rehash_threshold;
        h->ht.ht_nent = 0;
	h->ht.ht_self = (struct htent *)
	  alloc_relblock(size * sizeof(struct htent), sizeof(int));
	for(i = 0;  i < size;  i++) {
		h->ht.ht_self[i].hte_key = OBJNULL;
		h->ht.ht_self[i].hte_value = OBJNULL;
	}
	return(h);
}

clos_boot()
{

	siSAclass_name_hash_tableA->s.s_dbind = make_our_hash_table(Seq, 1024);

	/* booting Class CLASS */
	
  	class_class = alloc_object(t_instance);
	class_class->in.in_class = class_class;
	class_class->in.in_length = 4;
	class_class->in.in_slots = NULL; /* for GC sake */
	class_class->in.in_slots = (object *)alloc_relblock(sizeof(object)*5,
							   sizeof(object));
	CLASS_NAME(class_class) = Sclass;
	CLASS_SUPERIORS(class_class) = Cnil;
	CLASS_INFERIORS(class_class) = Cnil;
	CLASS_SLOTS(class_class) = OBJNULL;	/* filled later */

	sethash(Sclass, siSAclass_name_hash_tableA->s.s_dbind, class_class);

	/* booting Class BUILT-IN */
	
  	class_built_in = alloc_object(t_instance);
	class_built_in->in.in_class = class_class;
	class_built_in->in.in_length = 4;
	class_built_in->in.in_slots = NULL; /* for GC sake */
	class_built_in->in.in_slots =
	  (object *)alloc_relblock(sizeof(object)*5, sizeof(object));
	CLASS_NAME(class_built_in) = Sbuilt_in;
	CLASS_SUPERIORS(class_built_in) = CONS(class_class, Cnil);
	CLASS_INFERIORS(class_built_in) = Cnil;
	CLASS_SLOTS(class_built_in) = OBJNULL;	/* filled later */

	sethash(Sbuilt_in, siSAclass_name_hash_tableA->s.s_dbind, class_built_in);

	/* booting Class T (= OBJECT) */
	
  	class_object = alloc_object(t_instance);
	class_object->in.in_class = class_built_in;
	class_object->in.in_length = 4;
	class_object->in.in_slots = NULL; /* for GC sake */
	class_object->in.in_slots =
	  (object *)alloc_relblock(sizeof(object)*5, sizeof(object));
	CLASS_NAME(class_object) = St;
	CLASS_SUPERIORS(class_object) = Cnil;
	CLASS_INFERIORS(class_object) = CONS(class_class, Cnil);
	CLASS_SLOTS(class_object) = Cnil;

	sethash(St, siSAclass_name_hash_tableA->s.s_dbind, class_object);

	/* complete now Class CLASS */
	CLASS_SUPERIORS(class_class) = CONS(class_object, Cnil);
	CLASS_INFERIORS(class_class) = CONS(class_built_in, Cnil);
}

init_clos()
{
	siSAclass_name_hash_tableA
	= make_si_special("*CLASS-NAME-HASH-TABLE*",OBJNULL);
	enter_mark_origin(&siSAclass_name_hash_tableA);
	Sclass = make_ordinary("CLASS");
	enter_mark_origin(&Sclass);
	Sbuilt_in = make_ordinary("BUILT-IN");
	enter_mark_origin(&Sbuilt_in);

	clos_boot();
}
