/*
    reference.c -- Reference in Constants and Variables.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

Lfboundp(int narg, object sym)
{
	object sym1;
	check_arg(1);
	if (type_of(sym) != t_symbol)
#ifdef CLOS
	  if ((sym1=setf_namep(sym)) != OBJNULL)
	    sym = sym1;
	  else
#endif
	    not_a_symbol(sym);
	if (SPECIAL(sym))
		VALUES(0) = Ct;
	else if (sym->s.s_gfdef == OBJNULL)
		VALUES(0)= Cnil;
	else
		VALUES(0)= Ct;
	RETURN(1);
}

object
symbol_function(object sym)
{
	object sym1;
	if (type_of(sym) != t_symbol)
#ifdef CLOS
	  if ((sym1=setf_namep(sym)) != OBJNULL)
	    sym = sym1;
	  else
#endif
	    not_a_symbol(sym);
	if (SPECIAL(sym) || sym->s.s_mflag)
		FEinvalid_function(sym);
	if (sym->s.s_gfdef == OBJNULL)
		FEundefined_function(sym);
	return(sym->s.s_gfdef);
}

/*
	Symbol-function returns
                function-closure		for function
		(macro . function-closure)	for macros
		(special . address)		for special forms.
	(if defined CLOS it returns also
		generic-function                for generic functions)
*/
Lsymbol_function(int narg, object sym)
{
	object sym1;
	check_arg(1);
	if (type_of(sym) != t_symbol)
#ifdef CLOS
	  if ((sym1=setf_namep(sym)) != OBJNULL)
	    sym = sym1;
	  else
#endif
	    not_a_symbol(sym);

	if (SPECIAL(sym)) {
		VALUES(0) = CONS(Sspecial, MAKE_FIXNUM((int)(sym->s.s_sfdef)));
		RETURN(1);
	}
	if (sym->s.s_gfdef==OBJNULL)
		FEundefined_function(sym);
	if (sym->s.s_mflag)
		VALUES(0) = CONS(Smacro, sym->s.s_gfdef);
	      else
		VALUES(0) = sym->s.s_gfdef;
	RETURN(1);
}

Fquote(object form)
{
	if (endp(form))
		FEtoo_few_argumentsF(form);
	if (!endp(CDR(form)))
		FEtoo_many_argumentsF(form);
	VALUES(0) = CAR(form);
	RETURN(1);
}

Ffunction(object form)
{
	object fun;
	object fd;
	if (endp(form))
		FEtoo_few_argumentsF(form);
	if (!endp(CDR(form)))
		FEtoo_many_argumentsF(form);
	fun = CAR(form);
	if (type_of(fun) == t_symbol) {
		fd = lex_fd_sch(fun);
		if (Null(fd) || CADR(fd) != Sfunction)
			if (fun->s.s_gfdef == OBJNULL || fun->s.s_mflag)
				FEundefined_function(fun);
			else
			  VALUES(0) = fun->s.s_gfdef;
		else
		  VALUES(0) = CADDR(fd);
	} else if (type_of(fun) == t_cons && CAR(fun) == Slambda)
	  VALUES(0) = listA(5, Slambda_closure, lex_env[0], lex_env[1],
			    lex_env[2], CDR(fun));
	else {
	  	object setf_sym;
#ifdef CLOS
		if ((setf_sym=setf_namep(fun)) != OBJNULL &&
		    (setf_sym->s.s_gfdef != OBJNULL))
		  VALUES(0) = setf_sym->s.s_gfdef;
		else
#endif
		  FEinvalid_function(fun);
	      }
	RETURN(1);
      }

Lsymbol_value(int narg, object sym)
{
	check_arg(1);
	if (type_of(sym) != t_symbol)
		not_a_symbol(sym);
	if (sym->s.s_dbind == OBJNULL)
		FEunbound_variable(sym);
	else
		VALUES(0) = sym->s.s_dbind;
	RETURN(1);
}

Lboundp(int narg, object sym)
{
	check_arg(1);
	if (type_of(sym) != t_symbol)
		not_a_symbol(sym);
	if (sym->s.s_dbind == OBJNULL)
		VALUES(0) = Cnil;
	else
		VALUES(0) = Ct;
	RETURN(1);
}

Lmacro_function(int narg, object sym)
{
	check_arg(1);
	if (type_of(sym) != t_symbol)
		not_a_symbol(sym);
	if (sym->s.s_gfdef != OBJNULL && sym->s.s_mflag)
		VALUES(0) = sym->s.s_gfdef;
	else
		VALUES(0) = Cnil;
	RETURN(1);
}

Lspecial_form_p(int narg, object form)
{
	check_arg(1);
	if (type_of(form) != t_symbol)
		not_a_symbol(form);
	if (SPECIAL(form))
		VALUES(0) = Ct;
	else
		VALUES(0) = Cnil;
	RETURN(1);
}

init_reference()
{
	make_function("SYMBOL-FUNCTION", Lsymbol_function);
	make_function("FBOUNDP", Lfboundp);
	make_special_form("QUOTE", Fquote);
	Sfunction = make_special_form("FUNCTION", Ffunction);
	make_function("SYMBOL-VALUE", Lsymbol_value);
	make_function("BOUNDP", Lboundp);
	make_function("MACRO-FUNCTION", Lmacro_function);
	make_function("SPECIAL-FORM-P", Lspecial_form_p);
}

