/*
    toplevel.c -- Top-Level Forms and Declarations.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

/******************************* EXPORTS ******************************/

object Sdeclare;

object siSvariable_documentation;
object siSfunction_documentation;

#ifdef PDE
object Sdefun;
#endif PDE

/******************************* ------- ******************************/

object Scompile, Sload, Seval, Sprogn, Swarn, Svalues, Stypep;

object siVinhibit_macro_special;


Fdefun(args)
object args;
{
	object name;
	object body, form;

	if (endp(args) || endp(CDR(args)))
		FEtoo_few_argumentsF(args);
	if (CADR(args) != Cnil && type_of(CADR(args)) != t_cons)
		FEerror("~S is an illegal lambda-list.", 1, CADR(args));
	name = CAR(args);
	if (type_of(name) != t_symbol)
		not_a_symbol(name);
	if (SPECIAL(name)) {
		if (name->s.s_mflag) {
			if (symbol_value(siVinhibit_macro_special) != Cnil)
				name->s.s_sfdef = NOT_SPECIAL;
		} else if (symbol_value(siVinhibit_macro_special) != Cnil)
		 FEerror("~S, a special form, cannot be redefined.", 1, name);
	}
	clear_compiler_properties(name);
#ifdef PDE
	record_source_pathname(name, Sdefun);
#endif PDE
	if (name->s.s_hpack == lisp_package &&
	    name->s.s_gfdef != OBJNULL && initflag)
		funcall(3, Swarn, make_simple_string("~S is being redefined."),
			name);
	name->s.s_gfdef = (Null(lex_env[0]) && Null(lex_env[1])
			   && Null(lex_env[2])) ?
			     CONS(Slambda_block, args) :
			     listA(5, Slambda_block_closure, lex_env[0],
				   lex_env[1], lex_env[2], args);
	name->s.s_mflag = FALSE;
	for (body = CDDR(args);  !endp(body);  body = CDR(body)) {
		form = macro_expand(CAR(body));
		if (type_of(form) == t_string) {
			if (endp(CDR(body)))
				break;
			name->s.s_plist =
			putf(name->s.s_plist,
			     form,
			     siSfunction_documentation);
			break;
		}
		if (type_of(form) != t_cons || CAR(form) != Sdeclare)
			break;
	}
	VALUES(0) = name;
	RETURN(1);
}

siLAmake_special(int narg, object sym)
{
	check_arg(1);
	check_type_symbol(&sym);
	if ((enum stype)sym->s.s_stype == stp_constant)
		FEerror("~S is a constant.", 1, sym);
	sym->s.s_stype = (short)stp_special;
	VALUES(0) = sym;
	RETURN(1);
}

siLAmake_constant(int narg, object sym, object val)
{
	check_arg(2);
	check_type_symbol(&sym);
	if ((enum stype)sym->s.s_stype == stp_special)
		FEerror(
		 "The argument ~S to DEFCONSTANT is a special variable.",
		 1, sym);
	sym->s.s_stype = (short)stp_constant;
	sym->s.s_dbind = val;
	VALUES(0) = sym;
	RETURN(1);
}

Feval_when(object arg)
{
	object ss;
	bool flag = FALSE;

	if(endp(arg))
		FEtoo_few_argumentsF(arg);
	for (ss = CAR(arg);  !endp(ss);  ss = CDR(ss))
		if(CAR(ss) == Seval)
			flag = TRUE;
		else if(CAR(ss) != Sload && CAR(ss) != Scompile)
		 FEinvalid_form("~S is an undefined situation for EVAL-WHEN.",
				CAR(ss));
	if(flag)
		RETURN(eval(CONS(Sprogn, CDR(arg))));
	VALUES(0) = Cnil;
	RETURN(1);
}

Fdeclare(object arg)
{
	FEerror("DECLARE appeared in an invalid position.", 0);
}

Flocally(object body)
{
	object *lex_old = lex_env; lex_dcl;
	int nr;

	lex_copy();
	body = process_decl(body, NULL, NULL, 0);
	nr = Fprogn(body);
	lex_env = lex_old;
	RETURN(nr);
}

Fthe(object args)
{
	int nr, i;
	object types;

	if (endp(args) || endp(CDR(args)))
		FEtoo_few_argumentsF(args);
	if (!endp(CDDR(args)))
		FEtoo_many_argumentsF(args);
	nr = eval(CADR(args));
	MV_SAVE(nr);
	types = CAR(args);
	if (type_of(types) == t_cons && CAR(types) == Svalues) {
	  for (types=CDR(types), i = 0; !endp(types); types=CDR(types), i++) {
	    if (i > nr)
	      FEerror("Too few return values.", 0);
	    funcall(3, Stypep, VALUES(i), CAR(types));
	    if (Null(VALUES(0)))
	      FEwrong_type_argument(CAR(types), VALUES(i));
	  }
	    if (i < nr)
	      FEerror("Too many return values.", 0);
	} else {
	  funcall(3, Stypep, VALUES(0), types);
	  if (Null(VALUES(0)))
	    FEwrong_type_argument(types, VALUES(0));
	}
	MV_RESTORE(nr);
	RETURN(nr);
}

init_toplevel()
{
#ifdef PDE
	Sdefun =
#endif PDE
	make_special_form("DEFUN",Fdefun);
	make_si_function("*MAKE-SPECIAL", siLAmake_special);
	make_si_function("*MAKE-CONSTANT", siLAmake_constant);
	make_special_form("EVAL-WHEN", Feval_when);
	make_special_form("THE", Fthe);
	Scompile = make_ordinary("COMPILE");
	enter_mark_origin(&Scompile);
	Sload = make_ordinary("LOAD");
	enter_mark_origin(&Sload);
	Seval = make_ordinary("EVAL");
	enter_mark_origin(&Seval);
	make_special_form("DECLARE",Fdeclare);
	Sdeclare = make_ordinary("DECLARE");
	enter_mark_origin(&Sdeclare);
	Sprogn = make_ordinary("PROGN");
	enter_mark_origin(&Sprogn);
	Seval = make_ordinary("EVAL");
	enter_mark_origin(&Seval);
	make_special_form("LOCALLY",Flocally);

	siSvariable_documentation
	= make_si_ordinary("VARIABLE-DOCUMENTATION");
	siSfunction_documentation
	= make_si_ordinary("FUNCTION-DOCUMENTATION");

	Swarn = make_ordinary("WARN");
	enter_mark_origin(&Swarn);

	Svalues = make_ordinary("VALUES");
	Stypep = make_ordinary("TYPEP");
	enter_mark_origin(&Stypep);
}
