/*
    machines.h -- Machine descriptions.
*/
/*
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#if defined(sparc) || defined(i386) || defined(mips)
#define	stack_align(n)	(((n) + 0x7) & ~0x7)
#else
#define	stack_align(n)	(((n) + 03) & ~03)
#endif

#if !defined(__linux__) && !defined(sun)
#define _setjmp		setjmp
#define	_longjmp	longjmp
#endif

#ifdef	MSDOS
#define IS_DIR_SEPARATOR(x) ((x=='/')||(x=='\\'))
#define DIR_SEPARATOR	'\\'
#define PATH_SEPARATOR	';'
#else
#define IS_DIR_SEPARATOR(x) (x=='/')
#define DIR_SEPARATOR	'/'
#define PATH_SEPARATOR	':'
#endif	MSDOS

#ifdef	MSDOS
#define CRLF
#endif	MSDOS

/***********************************************************************

  Architectural features:

 ***********************************************************************/
#ifdef	vax
#define ARCHITECTURE	"VAX"
#elif	mc68000
#define ARCHITECTURE	"MC68000"
#elif	mc68010
#define ARCHITECTURE	"MC68010"
#elif	mc68020
#define ARCHITECTURE	"MC68020"
#elif	mc68030
#define ARCHITECTURE	"MC68030"
#elif	mc68040
#define ARCHITECTURE	"MC68040"
#elif	sparc
#define ARCHITECTURE	"SPARC"
#elif	i386
#define ARCHITECTURE	"I386"
#elif	ns32000
#define ARCHITECTURE	"NS32000"
#elif	__mips
#define ARCHITECTURE	"MIPS"
#elif	arm2
#define ARCHITECTURE	"ARM2"
#elif	arm
#define ARCHITECTURE	"ARM"
#endif

#ifdef	MSDOS
#define SOFTWARE_TYPE	MSDOS
#elif	unix
#define SOFTWARE_TYPE	UNIX
#else
#define SOFTWARE_TYPE	UNKNOWN
#endif	MSDOS

#if aix
#define SOFTWARE_VERSION	AIX
#elif	__linux__
#define SOFTWARE_VERSION	Linux
#elif	ultrix
#define SOFTWARE_VERSION	ULTRIX
#elif	hpux
#define SOFTWARE_VERSION	HPUX
#elif	domain
#define SOFTWARE_VERSION	DOMAIN
#elif	sgi
#define SOFTWARE_VERSION	IRIX
#elif	bsd4_3
#define SOFTWARE_VERSION	BSD4.3
#elif	bsd4_2
#define SOFTWARE_VERSION	BSD4.2
#elif	BSD
#define SOFTWARE_VERSION	BSD
#elif	sysv
#define SOFTWARE_VERSION	SYSTEM-V
#else
#define SOFTWARE_VERSION	UNKNOWN
#endif

/***********************************************************************/

#ifdef	apollo
#define	IEEEFLOAT
#define	DATA_START 0
#define	DOWN_STACK
#define SP_INDEX 3
#define	BSD
#define COFF
#define	BRAND "HP"
#endif	apollo

#ifdef	hp9000s300
#define	IEEEFLOAT
#define	DATA_START 0
#define	DOWN_STACK
#define SP_INDEX 14
#define	SYSV
#define	AOUT <a.out.h>
#define	BRAND "HP"
#define CFLAGS +Ns2000 +Nd2000
#endif	hp9000s300
 
#ifdef	hp9000s800
#define	IEEEFLOAT
#define	DATA_START 0x40000000
#undef	DOWN_STACK
#define SP_INDEX 14
#define	SYSV
#define COFF
#define UNEXEC unexhp9k800
#define	BRAND "HP"
#endif	hp9000s800

#ifdef	IBMRT
#define	IEEEFLOAT
#define	DATA_START 0x20000000
#define	DOWN_STACK
#define SP_INDEX 0
#define	BSD
#define	AOUT <a.out.h>
#define	BRAND "IBM"
#endif	IBMRT

#ifdef	__linux__
#define	IEEEFLOAT
#define	DATA_START 0
#define	DOWN_STACK
#define SP_INDEX 4
#define	BSD
#define AOUT <a.out.h>
#define	BRAND "IBM-PC"
#endif	linux

#ifdef	mips_dec
#define	IEEEFLOAT
#define	DATA_START 0xA00000	/* normally 0x10000000 */
#define	DOWN_STACK
#define SP_INDEX 32
#define	BSD
#define COFF
#define ECOFF
#define UNEXEC unexelf
#define	BRAND "DEC"
#define	LDFLAGS -Wl,-D -Wl,A00000
#define ILDFLAGS -T 0 -d -N
#define LSPCFLAGS -G 0
#endif	mips_dec

#ifdef	NEWS
#define	IEEEFLOAT
#define	DATA_START 0
#define	DOWN_STACK
#define	BSD
#define	AOUT <a.out.h>
#define	BRAND "SONY"
#endif	NEWS

#ifdef	MSDOS
#include "dos.h"
#define	IEEEFLOAT
#define	DATA_START 0
#define	DOWN_STACK
#define SP_INDEX 3
#define	BSD
#define AOUT <aout.h>
#define	BRAND "IBM-PC"
#endif	MSDOS

#ifdef	OMRON
#define	IEEEFLOAT
#define	DATA_START 0
#define	DOWN_STACK
#define	SYSV
#define COFF
#define	BRAND "OMRON"
#endif	OMRON

#ifdef	SEQ
#define	IEEEFLOAT
#define	DATA_START 0
#define	DOWN_STACK
#define	BSD
#define	AOUT <a.out.h>
#define	BRAND "SEQUENT"
#endif	SEQ

#ifdef	sgi
#define	IEEEFLOAT
#define	DATA_START 0xA00000	/* normally 0x10000000 */
#define	DOWN_STACK
#define SP_INDEX 32
#define	BSD
#define COFF
#define ECOFF
#define UNEXEC unexmips
#define	BRAND "SGI"
#define _BSD_SIGNALS
#define	LDFLAGS -Wl,-D -Wl,A00000
#define ILDFLAGS -T 0 -d -N
#define LSPCFLAGS -G 0
#endif	sgi

#ifdef	sun
#define	IEEEFLOAT
#define	DATA_START 0
#define	DOWN_STACK
#define	BSD
#define	BRAND "SUN"
#define	LDFLAGS -static

#ifdef	sun4_sunos5
#define ELF
#define UNEXEC unexelf
#elif	sun386
#define COFF
#else
#define AOUT <a.out.h>
#endif

#ifdef	mc68000
#define SP_INDEX 14
#elif	sparc
#define SP_INDEX 2
#elif	i386
#define SP_INDEX 2
#endif

#ifdef	sun4
#define SETJMP	setjmpsparc.s
#endif

#endif	sun

#ifdef	TAHOE
#define	DATA_START 0
#define	DOWN_STACK
#define BSD
#define	AOUT <a.out.h>
#define	BRAND "TAHOE"
#endif	TAHOE

#ifdef	vax
#define	DATA_START 0
#define	DOWN_STACK
#define SP_INDEX 13
#define	BSD
#define AOUT <a.out.h>
#define	BRAND "DEC"
#endif	vax

/**********************************************************************/
