#include "scheme.h"

static Object in, out;

static char *String_Eval(expr) char *expr; {
    Object str, res;
    char *p;
    GC_Node;
    static char buf[1024];
    Declare_C_Strings;

    str = Make_String(expr, strlen(expr));
    PORT(in)->name = str;
    PORT(in)->ptr = 0;
    res = General_Read(in, 0);
    GC_Link(res);
    res = Eval(res);
    (void)General_Print_Object(res, out, 1);
    str = P_Get_Output_String(out);
    Make_C_String(str, p);
    if (strlen(p) > sizeof buf - 1)
	p = "too long";
    strcpy(buf, p);
    Dispose_C_Strings;
    GC_Unlink;
    return buf;
}

char *Elk_Eval(expr) char *expr; {
    char *s;

    s = String_Eval("\
	(call-with-current-continuation (lambda (c)\
	  (set! error-handler (lambda a (print a) (c #f))) #t))\
    ");
    if (strcmp(s, "#f") == 0)
	return 0;
    return String_Eval(expr);
}

init_eval() {
    in = P_Open_Input_String(Make_String("", 0));
    Global_GC_Link(in);
    out = P_Open_Output_String();
    Global_GC_Link(out);
}
