#ifndef EXTERN_H
#define EXTERN_H

C_LINKAGE_BEGIN

/* autoload.c:
 */
extern Object V_Autoload_Notifyp;
extern Object P_Autoload P_((Object, Object));
extern Object Do_Autoload P_((Object, Object));

/* bignum.c:
 */
extern int Bignum_Zero P_((Object));
extern int Bignum_Positive P_((Object));
extern int Bignum_Negative P_((Object));
extern int Bignum_Even P_((Object));
extern Object Make_Bignum P_((const char*, int, int));
extern Object Integer_To_Bignum P_((int));
extern Object Bignum_Divide P_((Object, Object));
extern Object Bignum_Abs P_((Object));
extern Object Bignum_Plus P_((Object, Object));
extern Object Bignum_Minus P_((Object, Object));
extern Object Bignum_Fixnum_Multiply P_((Object, Object));
extern Object Bignum_Multiply P_((Object, Object));
extern Object Bignum_Fixnum_Divide P_((Object, Object));
extern Object Double_To_Bignum P_((double));
extern Object Unsigned_To_Bignum P_((unsigned));
extern Object Bignum_To_String P_((Object, int));
extern double Bignum_To_Double P_((Object));
extern Bignum_Equal P_((Object, Object));
extern Bignum_Greater P_((Object, Object));
extern Bignum_Less P_((Object, Object));
extern Bignum_Eq_Less P_((Object, Object));
extern Bignum_Eq_Greater P_((Object, Object));


/* bool.c:
 */
extern Object P_Booleanp P_((Object));
extern Object P_Not P_((Object));
extern Object P_Eq P_((Object, Object));
extern Object P_Eqv P_((Object, Object));
extern Object P_Equal P_((Object, Object));
extern int Eqv P_((Object, Object));
extern int Equal P_((Object, Object));
extern Object P_Empty_List_Is_False P_((Object));

/* char.c:
 */
extern Object Make_Char P_((int));
extern Object P_Charp P_((Object));
extern Object P_Char_Upcase P_((Object));
extern Object P_Char_Downcase P_((Object));
extern Object P_Chr_Eq P_((Object, Object));
extern Object P_Chr_Less P_((Object, Object));
extern Object P_Chr_Greater P_((Object, Object));
extern Object P_Chr_Eq_Less P_((Object, Object));
extern Object P_Chr_Eq_Greater P_((Object, Object));
extern Object P_Chr_CI_Eq P_((Object, Object));
extern Object P_Chr_CI_Less P_((Object, Object));
extern Object P_Chr_CI_Greater P_((Object, Object));
extern Object P_Chr_CI_Eq_Less P_((Object, Object));
extern Object P_Chr_CI_Eq_Greater P_((Object, Object));
extern Object P_Char_Upper_Case P_((Object));
extern Object P_Char_Lower_Case P_((Object));
extern Object P_Char_Alphabetic P_((Object));
extern Object P_Char_Numeric P_((Object));
extern Object P_Char_Whitespace P_((Object));
extern Object P_Char_To_Integer P_((Object));
extern Object P_Integer_To_Char P_((Object));

/* cont.c:
 */
extern WIND *First_Wind, *Last_Wind;
extern Object P_Call_CC P_((Object));
extern Object P_Dynamic_Wind P_((Object, Object, Object));
extern Object P_Control_Pointp P_((Object));
extern Object P_Control_Point_Env P_((Object));
extern Object Internal_Call_CC P_((int, Object));

/* debug.c:
 */
extern Object P_Backtrace_List P_((int, Object*));

/* dump.c and dump.*.c:
 */
extern Object P_Dump P_((Object));
extern Object Dump_Control_Point;

/* env.c:
 */
extern Object The_Environment, Global_Environment;
extern Object P_The_Environment P_((void));
extern Object P_Define P_((Object));
extern Object P_Set P_((Object));
extern Object P_Env_List P_((Object));
extern Object Add_Binding P_((Object, Object, Object));
extern Object Lookup_Symbol P_((Object, int));
extern Object P_Define_Macro P_((Object));
extern Object P_Boundp P_((Object));
extern Object P_Global_Environment P_((void));
extern Object P_Environmentp P_((Object));
extern Object Env_To_List P_((Object));
extern Object List_To_Env P_((Object));

/* error.c:
 */
extern Object Arg_True;
extern Object P_Error P_((int, Object*));
extern Object P_Reset P_((void));
extern Primitive_Error P_((ELLIPSIS));
extern Fatal_Error P_((ELLIPSIS));
extern Range_Error P_((Object));
extern Panic P_((const char*));

/* exception.c:
 */
extern int Intr_Was_Ignored;
extern void Intr_Handler P_((int));
extern void Install_Intr_Handler P_((void));
#ifdef POSIX_SIGNALS
    extern sigset_t Sigset_Old, Sigset_Block;
#endif

/* feature.c:
 */
extern Object P_Featurep P_((Object));
extern Object P_Provide P_((Object));
extern Object P_Require P_((int, Object*));

/* heap.c:
 */
#ifdef GENERATIONAL_GC
    extern Object P_Collect_Incremental P_((void));
#else
    extern char *Hp, *Heap_Start, *Heap_End, *Free_Start, *Free_End;
#endif
extern int GC_In_Progress;
extern GCNODE *GC_List;
extern Object Alloc_Object P_((int, int, int));
extern Object P_Collect P_((void));
extern Object P_Garbage_Collect_Status P_((int, Object *));
extern Register_Before_GC P_((void (*)(void)));
extern Register_After_GC P_((void (*)(void)));
extern Func_Global_GC_Link P_((Object*));

/* io.c:
 */
extern Object Curr_Input_Port, Curr_Output_Port;
extern Object Standard_Input_Port, Standard_Output_Port;
extern Object P_Curr_Input_Port P_((void));
extern Object P_Curr_Output_Port P_((void));
extern Object P_Input_Portp P_((Object));
extern Object P_Output_Portp P_((Object));
extern Object P_Open_Input_File P_((Object));
extern Object P_Open_Output_File P_((Object));
extern Object P_Open_Input_Output_File P_((Object));
extern Object P_Eof_Objectp P_((Object));
extern Object P_With_Input P_((Object, Object));
extern Object P_With_Output P_((Object, Object));
extern Object P_Call_With_Input P_((Object, Object));
extern Object P_Call_With_Output P_((Object, Object));
extern Object General_Open_File P_((Object, int, Object));
extern Object P_Open_Input_String P_((Object));
extern Object P_Open_Output_String P_((void));
extern Object P_Port_File_Name P_((Object));
extern Object P_Tilde_Expand P_((Object));
extern Object P_File_Existsp P_((Object));
extern Object P_Close_Input_Port P_((Object));
extern Object P_Close_Output_Port P_((Object));
extern Object P_Port_Line_Number P_((Object));
extern Object Get_File_Name P_((Object));

/* load.c:
 */
extern char Loader_Input[];
extern Object V_Load_Path, V_Load_Noisilyp, V_Load_Libraries;
extern void Check_Loadarg P_((Object));
extern Object General_Load P_((Object, Object));
extern Object P_Load P_((int, Object*));

/* list.c:
 */
extern Object P_Cons P_((Object, Object));
extern Object P_Car P_((Object));
extern Object P_Cdr P_((Object));
extern Object P_Setcar P_((Object, Object));
extern Object P_Setcdr P_((Object, Object));
extern Object P_Listp P_((Object));
extern Object Const_Cons P_((Object, Object));
extern Object P_List P_((int, Object*));
extern Object P_Length P_((Object));
extern Object P_Nullp P_((Object));
extern Object P_Pairp P_((Object));
extern Object P_Cxr P_((Object, Object));
extern Object P_Cddr P_((Object));
extern Object P_Cdar P_((Object));
extern Object P_Cadr P_((Object));
extern Object P_Caar P_((Object));
extern Object P_Cdddr P_((Object));
extern Object P_Cddar P_((Object));
extern Object P_Cdadr P_((Object));
extern Object P_Cdaar P_((Object));
extern Object P_Caddr P_((Object));
extern Object P_Cadar P_((Object));
extern Object P_Caadr P_((Object));
extern Object P_Caaar P_((Object));
extern Object P_Caaaar P_((Object));
extern Object P_Caaadr P_((Object));
extern Object P_Caadar P_((Object));
extern Object P_Caaddr P_((Object));
extern Object P_Cadaar P_((Object)); 
extern Object P_Cadadr P_((Object));
extern Object P_Caddar P_((Object));
extern Object P_Cadddr P_((Object));
extern Object P_Cdaaar P_((Object));
extern Object P_Cdaadr P_((Object));
extern Object P_Cdadar P_((Object));
extern Object P_Cdaddr P_((Object));
extern Object P_Cddaar P_((Object));
extern Object P_Cddadr P_((Object));
extern Object P_Cdddar P_((Object));
extern Object P_Cddddr P_((Object));
extern Object P_Append P_((int, Object*));
extern Object P_Append_Set P_((int, Object*));
extern Object P_Last_Pair P_((Object));
extern Object P_Reverse P_((Object));
extern Object P_Reverse_Set P_((Object));
extern Object P_List_Tail P_((Object, Object));
extern Object P_List_Ref P_((Object, Object));
extern Object P_Assq P_((Object, Object));
extern Object P_Assv P_((Object, Object));
extern Object P_Assoc P_((Object, Object));
extern Object P_Memq P_((Object, Object));
extern Object P_Memv P_((Object, Object));
extern Object P_Member P_((Object, Object));
extern Object P_Make_List P_((Object, Object));
extern Object Copy_List P_((Object));
extern Object General_Assoc P_((Object, Object, int));
extern int Fast_Length P_((Object));

/* main.c:
 */
extern char *stkbase, *A_Out_Name;
extern int Stack_Grows_Down;
extern int Max_Stack, Interpreter_Initialized, Was_Dumped, GC_Debug;
extern char *Brk_On_Dump;
extern int Verb_Load, Verb_Init, Case_Insensitive;
extern SYMTAB *The_Symbols;
extern Object P_Command_Line_Args P_((void));
extern Object P_Exit P_((int, Object*));
#ifndef ATEXIT
extern void exit P_((int));
#endif

/* math.c:
 */
extern Object Make_Integer P_((int));
extern Object Make_Fixnum P_((int));
extern Object Make_Unsigned P_((unsigned));
extern Object Make_Reduced_Flonum P_((double));
extern Object P_Numberp P_((Object));
extern Object P_Complexp P_((Object));
extern Object P_Realp P_((Object));
extern Object P_Rationalp P_((Object));
extern Object P_Integerp P_((Object));
extern Object P_Abs P_((Object));
extern Object P_Zerop P_((Object));
extern Object P_Positivep P_((Object));
extern Object P_Negativep P_((Object));
extern Object P_Oddp P_((Object));
extern Object P_Evenp P_((Object));
extern Object P_Exactp P_((Object));
extern Object P_Inexactp P_((Object));
extern Object P_Inc P_((Object));
extern Object P_Dec P_((Object));
extern Object P_Generic_Equal P_((int, Object*));
extern Object P_Generic_Less P_((int, Object*));
extern Object P_Generic_Greater P_((int, Object*));
extern Object P_Generic_Eq_Less P_((int, Object*));
extern Object P_Generic_Eq_Greater P_((int, Object*));
extern Object P_Generic_Plus P_((int, Object*));
extern Object P_Generic_Minus P_((int, Object*));
extern Object P_Generic_Multiply P_((int, Object*));
extern Object P_Generic_Divide P_((int, Object*));
extern Object P_Quotient P_((Object, Object));
extern Object P_Remainder P_((Object, Object));
extern Object P_Modulo P_((Object, Object));
extern Object P_Gcd P_((int, Object*));
extern Object P_Lcm P_((int, Object*));
extern Object P_Floor P_((Object));
extern Object P_Ceiling P_((Object));
extern Object P_Truncate P_((Object));
extern Object P_Round P_((Object));
extern Object P_Sqrt P_((Object));
extern Object P_Exp P_((Object));
extern Object P_Log P_((Object));
extern Object P_Sin P_((Object));
extern Object P_Cos P_((Object));
extern Object P_Tan P_((Object));
extern Object P_Asin P_((Object));
extern Object P_Acos P_((Object));
extern Object P_Atan P_((int, Object*));
extern Object P_Min P_((int, Object*));
extern Object P_Max P_((int, Object*));
extern Object P_Random P_((void));
extern Object P_Srandom P_((Object));
extern Object P_Number_To_String P_((int, Object*));
extern double Get_Double P_((Object));
extern Get_Integer P_((Object));
extern Object Fixnum_To_String P_((Object, int));
extern Object Flonum_To_String P_((Object));

/* prim.c:
 */
extern Define_Primitive P_((Object (*)(ELLIPSIS), const char*, int, int,
    enum discipline));

/* print.c:
 */
extern Object P_Write P_((int, Object*));
extern Object P_Display P_((int, Object*));
extern Object P_Write_Char P_((int, Object*));
extern Object P_Newline P_((int, Object*));
extern Object P_Format P_((int, Object*));
extern Object P_Clear_Output_Port P_((int, Object*));
extern Object P_Flush_Output_Port P_((int, Object*));
extern Object P_Print P_((int, Object*));
extern Object P_Get_Output_String P_((Object));
extern Check_Output_Port P_((Object));
extern Discard_Output P_((Object));
extern Printf P_((ELLIPSIS));
extern int Saved_Errno;

/* proc.c:
 */
extern const char *Error_Tag;
extern int Tail_Call;
extern Object Sym_Lambda, Sym_Macro;
extern Object Eval P_((Object));
extern Object P_Eval P_((int, Object*));
extern Object P_Apply P_((int, Object*));
extern Object Funcall P_((Object, Object, int));
extern Object P_Lambda P_((Object));
extern Object P_Map P_((int, Object*));
extern Object P_Procedure_Env P_((Object));
extern Object P_Procedure_Lambda P_((Object));
extern Object Make_Primitive
    P_((Object(*)(ELLIPSIS), const char*, int, int, enum discipline));
extern Object P_For_Each P_((int, Object*));
extern Object P_Procedurep P_((Object));
extern Object Funcall_Compound P_((Object, Object, int));
extern Object Funcall_Primitive P_((Object, Object, int));
extern Funcall_Control_Point P_((Object, Object, int));
extern Object P_Macro P_((Object));
extern Object P_Macro_Body P_((Object));
extern Object P_Macro_Expand P_((Object));
extern Object P_Primitivep P_((Object));
extern Object P_Compoundp P_((Object));
extern Object P_Macrop P_((Object));
extern Check_Procedure P_((Object));

/* promise.c:
 */
extern Object P_Delay P_((Object));
extern Object P_Force P_((Object));
extern Object P_Promisep P_((Object));
extern Object P_Promise_Env P_((Object));

/* read.c:
 */
extern Object Sym_Quote;
extern Object Sym_Quasiquote, Sym_Unquote, Sym_Unquote_Splicing;
extern Object General_Read P_((Object, int));
extern Object P_Read P_((int, Object*));
extern Object P_Read_Char P_((int, Object*));
extern Object P_Peek_Char P_((int, Object*));
extern Object P_Unread_Char P_((int, Object*));
extern Object P_Read_String P_((int, Object*));
extern Object P_Clear_Input_Port P_((int, Object*));
extern Object Parse_Number P_((const char*, int));
extern Check_Input_Port P_((Object));
extern Discard_Input P_((Object));

/* special.c:
 */
extern Object P_Quote P_((Object));
extern Object P_If P_((Object));
extern Object P_Let P_((Object));
extern Object P_Letseq P_((Object));
extern Object P_Letrec P_((Object));
extern Object P_Case P_((Object));
extern Object P_Cond P_((Object));
extern Object P_And P_((Object));
extern Object P_Or P_((Object));
extern Object P_Do P_((Object));
extern Object P_Quasiquote P_((Object));
extern Object P_Fluid_Let P_((Object));
extern Object P_Begin P_((Object));
extern Object P_Begin1 P_((Object));

/* stab.c:
 */
extern SYMTAB *Snarf_Symbols P_((ELLIPSIS));  /* varying args */
extern SYMTAB *Open_File_And_Snarf_Symbols P_((char *));


/* stkmem.c:
 */
extern char *Safe_Malloc P_((unsigned));
#ifndef USE_ALLOCA
extern MEM_NODE *Mem_List;
extern char *Mem_Alloc P_((unsigned));
extern Object Save_GC_Nodes P_((void));
#endif


/* string.c:
 */
extern char Char_Map[];
extern Object General_Make_String P_((const char*, int, int));
extern Object Make_String P_((const char*, int));
extern Object Make_Const_String P_((const char*, int));
extern Object P_Make_String P_((int, Object*));
extern Object P_Stringp P_((Object));
extern Object P_String P_((int, Object*));
extern Object P_String_To_Number P_((int, Object*));
extern Object P_Str_Eq P_((Object, Object));
extern Object P_Str_Less P_((Object, Object));
extern Object P_Str_Greater P_((Object, Object));
extern Object P_Str_Eq_Less P_((Object, Object));
extern Object P_Str_Eq_Greater P_((Object, Object));
extern Object P_Str_CI_Eq P_((Object, Object));
extern Object P_Str_CI_Less P_((Object, Object));
extern Object P_Str_CI_Greater P_((Object, Object));
extern Object P_Str_CI_Eq_Less P_((Object, Object));
extern Object P_Str_CI_Eq_Greater P_((Object, Object));
extern Object P_String_Length P_((Object));
extern Object P_String_Ref P_((Object, Object));
extern Object P_String_Set P_((Object, Object, Object));
extern Object P_Substring P_((Object, Object, Object));
extern Object P_String_Copy P_((Object));
extern Object P_String_Append P_((int, Object*));
extern Object P_List_To_String P_((Object));
extern Object P_String_To_List P_((Object));
extern Object P_Substring_Fill P_((Object, Object, Object, Object));
extern Object P_String_Fill P_((Object, Object));
extern Object P_Substringp P_((Object, Object));
extern Object P_CI_Substringp P_((Object, Object));

/* symbol.c:
 */
extern Object Null, True, False, False2, Unbound, Special, Void, Newline, Eof;
extern Object Zero, One;
extern Object Intern P_((const char*));
extern Object CI_Intern P_((const char*));
extern Object P_Oblist P_((void));
extern Object P_Symbolp P_((Object));
extern Object P_Symbol_To_String P_((Object));
extern Object P_String_To_Symbol P_((Object));
extern Object P_Put P_((int, Object*));
extern Object P_Get P_((Object, Object));
extern Object P_Symbol_Plist P_((Object));
extern void Define_Variable P_((Object*, const char*, Object));
extern void Define_Symbol P_((Object *, const char*));
extern Object Var_Get P_((Object));
extern void Var_Set P_((Object, Object));
extern unsigned long Symbols_To_Bits P_((Object, int, SYMDESCR*));
extern Object Bits_To_Symbols P_((unsigned long, int, SYMDESCR*));

/* terminate.c:
 */
extern void Register_Object P_((Object, GENERIC, PFO, int));
extern void Deregister_Object P_((Object));
extern Object Find_Object P_((ELLIPSIS));
extern void Terminate_Group P_((GENERIC));
extern void Terminate_Type P_((int));

/* type.c:
 */
extern TYPEDESCR Types[];
extern Object P_Type P_((Object));
extern Object P_Voidp P_((Object));
extern Wrong_Type P_((Object, int));
extern Wrong_Type_Combination P_((Object, const char*));
extern Define_Type P_((int, const char*, int (*)(Object), int,
    int (*)(Object, Object), int (*)(Object, Object),
    int (*)(Object, Object, int, int, int),
    int (*)(Object*, int (*)(Object*)) ));

/* vector.c:
 */
extern Object Make_Vector P_((int, Object));
extern Object Make_Const_Vector P_((int, Object));
extern Object P_Make_Vector P_((int, Object*));
extern Object P_Vectorp P_((Object));
extern Object P_Vector P_((int, Object*));
extern Object P_Vector_Length P_((Object));
extern Object P_Vector_Ref P_((Object, Object));
extern Object P_Vector_Set P_((Object, Object, Object));
extern Object P_Vector_To_List P_((Object));
extern Object P_List_To_Vector P_((Object));
extern Object P_Vector_Fill P_((Object, Object));
extern Object P_Vector_Copy P_((Object));
extern Object List_To_Vector P_((Object, int));

C_LINKAGE_END

#endif
