#include "scheme.h"

int Intr_Was_Ignored;

#ifdef POSIX_SIGNALS
sigset_t Sigset_Old, Sigset_Block;
#endif

static Object V_Interrupt_Handler;

Init_Exception () {
    Define_Variable (&V_Interrupt_Handler, "interrupt-handler", Null);
#ifdef POSIX_SIGNALS
    sigemptyset (&Sigset_Block);
    sigaddset (&Sigset_Block, SIGINT);
    (void)sigprocmask (0, (sigset_t *)0, &Sigset_Old);
#endif
}

/*ARGSUSED*/
void Intr_Handler (sig) int sig; {
    Object fun;

#ifndef RELIABLE_SIGNALS
    (void)signal (SIGINT, Intr_Handler);
#endif
    Error_Tag = "interrupt-handler";
    Reset_IO (1);
    fun = Var_Get (V_Interrupt_Handler);
    if (TYPE(fun) == T_Compound)
	(void)Funcall (fun, Null, 0);
    Format (Curr_Output_Port, "~%\7Interrupt!~%", 15, 0, (Object *)0);
    Reset ();
    /*NOTREACHED*/
}

void Install_Intr_Handler () {
    if (signal (SIGINT, SIG_IGN) == SIG_IGN)
	Intr_Was_Ignored = 1;
    else
	(void)signal (SIGINT, Intr_Handler);
}
