/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

/*
  KLIC coding function
*/

#include <stdio.h>
#include <klic/basic.h>
#ifdef STRINGH
#include <string.h>
#else
#include <strings.h>
#endif

#define HEXCHARTOINT(ch) \
  (isdigit(ch) ? (ch) - '0': (islower(ch) ? (ch) - 'a' + 10 : (ch) - 'A' + 10))
   
char *klic_encode(src, dest)
     char *src;
     char *dest;
{
  char *origin = dest;

  while(*src) {
    if(isalnum(*src)) {
      *dest++ = *src++;
    } else if(*src == '_') {
      ++src;
      strcpy(dest, "__");
      dest += 2;
    } else {
      sprintf(dest, "_%02X", *src++);
      dest += 3;
    }
  }
  *dest = '\0';
  return(origin);
}

char *klic_decode(src, dest)
     char *src;
     char *dest;
{
  char *origin = dest;

  while(*src) {
    if(*src == '_') {
      if(*(src + 1) == '_') {
	*dest++ = '_';
	src += 2;
      } else {
	int high = *(src + 1);
	int low = *(src + 2);
/*
	printf("hight = %c low = %c\n", high, low);
*/
	*dest++ = HEXCHARTOINT(high) * 16 + HEXCHARTOINT(low);
	src += 3; 
      }
    } else {
      *dest++ = *src++;
    }
  }
  *dest = '\0';
  return(origin);
}
/* debugging aids
main(argc,argv)
int argc;
char *argv[];
{
  char buf0[256];
  char buf1[256];

  if(argc == 2) {
    printf("encoded to %s\n", klic_encode(argv[1], buf0));
    printf("decoded to %s\n", klic_decode(buf0, buf1));
  } else {
    fprintf(stderr, "%s string\n", argv[0]);
  }
  exit(0);
}
*/
