/* ----------------------------------------------------------
%   (C)1993,1994 Institute for New Generation Computer Technology
%       (Read COPYRIGHT for detailed information.)
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/sighndl.h>
#include <klic/primitives.h>
#include <klic/schedule.h>

int sigint_interrupt = 0;

static struct goalrec *enqueue_resumed_goals(qp)
     struct goalrec *qp;
{
  declare_globals;
  struct goalrec *rsmg = resumed_goals;
  if (rsmg != 0) {
    struct goalrec *newqp = rsmg->next;
    rsmg->next = qp;
    qp = newqp;
    resumed_goals = 0;
    if (interrupt_off) heaplimit = real_heaplimit;
  }
  return qp;
}

q *klic_interrupt(allocp, qp)
     q *allocp;
     struct goalrec *qp;
{
  declare_globals;
  long retry;
  extern q *klic_signal_handler();
#ifdef DEBUGLIB
  extern int trace_flag;
  extern struct goalrec *trace_after();
#endif

  qp = enqueue_resumed_goals(qp);

#ifdef DEBUGLIB
  if (trace_flag) {
    qp = trace_after(qp, allocp);
    allocp = heapp;
  }
#endif

  do {
    retry = 0;

    /* signal handling */
#ifdef USESIG
    if (!signal_done) {
      allocp = klic_signal_handler(allocp);
      retry = (allocp >= real_heaplimit);
      /* some goals may have been resumed by the signal handler */
      qp = enqueue_resumed_goals(qp);
    }
#endif

    if (sigint_interrupt) {
      sigint_interrupt = 0;
      fatal("Execution aborted by SIGINT");
    }

    /* priority support */
    if (higher_priority_goal) {
      higher_priority_goal = 0;
      put_priority_queue(qp, current_prio);
      qp = get_top_priority_queue();
      if (interrupt_off) heaplimit = real_heaplimit;
    }
    if (allocp + this_more_space >= real_heaplimit) {
      extern struct goalrec *klic_gc();
      qp = klic_gc(qp);
      allocp = heapp;
    }
  } while (retry);

  current_queue = qp;
  return allocp;
}
