

UNIT ANN;
{
This unit provides several functions of general use in Artificial Neural
Network (ANN) modelling.
}

{

Copyright 1989 by Wesley R. Elsberry.  All rights reserved.

Commercial use of this software is prohibited without written consent of
the author.

For information, bug reports, and updates contact

Wesley R. Elsberry
528 Chambers Creek Drive South
Everman, Texas 76140
Telephone: (817) 551-7018

}

INTERFACE

{PUBLIC DECLARATIONS}
FUNCTION  Close_enough (target, plus_minus, x : DOUBLE) : BOOLEAN;
FUNCTION  Gaussian_noise (mean, variance : DOUBLE) :DOUBLE;
FUNCTION  Tanh (rr : DOUBLE) :DOUBLE ;
FUNCTION  Linear (m, B, X : DOUBLE):DOUBLE;
FUNCTION  Linear_ramp (low, high, x : DOUBLE) : DOUBLE;
FUNCTION  Threshold (low, high, thresh, x : DOUBLE):DOUBLE;
FUNCTION  Sigmoid (range,slope_mod,shift,X : DOUBLE):DOUBLE;
FUNCTION  Signum (xx : DOUBLE):INTEGER;

IMPLEMENTATION

{PRIVATE DECLARATIONS}

 CONST
    mach_inf = 1E37;
    exp_max = 80.0;

 TYPE
    REAL = DOUBLE;


{IMPLEMENTATIONS OF PROCEDURES AND FUNCTIONS}

 FUNCTION Close_enough (target, plus_minus, x : REAL) : BOOLEAN;
{
  Given a target and an absolute value of allowed deviation (plus_minus),
  Close_enough returns TRUE if the tested value (x) is within the
  defined interval.
}

    BEGIN                          {}
       IF (x >= (target - plus_minus)) AND (x <= (target + plus_minus))
            THEN                   {}
            BEGIN
          Close_enough := TRUE;
          END
       ELSE                        {}
            BEGIN
          Close_enough := FALSE;
          END;
       END;                        {}

 FUNCTION  Gaussian_noise(mean, variance : REAL) :REAL;
{Produces random numbers which conform to a Gaussian distribution}

    VAR
       u1, u2, x : REAL;

    BEGIN                          {Gaussian_noise}
       u1 := Random;
       u2 := Random;
       x := Sqrt(-2*Ln(u1))*Cos(2*Pi*u2);
       x := variance*x + mean;
       Gaussian_noise := x;
       END;                        {Gaussian_noise}


{
  Activation functions
}

 FUNCTION tanh(rr : REAL) :REAL ;
{returns the hyperbolic tangent of rr}

    BEGIN                          {tanh}
       IF (rr > Exp_Max) THEN      {}
            BEGIN
          rr := Exp_Max;
          END;
       IF (rr < -Exp_Max) THEN     {}
            BEGIN
          rr := -Exp_max;
          END;
       tanh := (Exp(rr) - Exp(-rr)) / (Exp(rr) + Exp(-rr));
       END;


 FUNCTION Linear (m, B, X : REAL):REAL;
{
  Linear returns the parameter value times slope, plus intercept.
}

    BEGIN                          {Linear}
       Linear := X*m + B;
       END;                        {Linear}

 FUNCTION Linear_ramp (LOW, HIGH, X : REAL) : REAL;
{
  Returns X when X is between LOW and HIGH, the appropriate bound
  otherwise.
}

    BEGIN                          {Linear_ramp}
       IF (X < HIGH) AND (X > LOW) THEN
                                   {}
            BEGIN
          Linear_ramp := X;
          END
       ELSE                        {}
            BEGIN
          IF (x >= HIGH) THEN      {}
               BEGIN
             Linear_ramp := HIGH;
             END
          ELSE                     {}
               BEGIN
             Linear_ramp := LOW;
             END;
          END;
       END;                        {Linear_ramp}

 FUNCTION Threshold(LOW,HIGH,THRESH,X : REAL):REAL;
{
  Returns LOW when X is below THRESH and HIGH when X is greater
  than or equal to THRESH.
}

    BEGIN                          {Threshold}
       IF (X < THRESH) THEN        {}
            BEGIN
          Threshold := LOW;
          END
       ELSE                        {}
            BEGIN
          Threshold := HIGH;
          END;
       END;                        {Threshold}

 FUNCTION  Sigmoid(range,slope_mod,shift,X : REAL):REAL;
{
 Function of the form :

  [ range / (1 + exp(-slope_mod * X)) ] - shift

  range -     determines the range of values, 0..range
  slope_mod - modifies the slope of the curve
  shift -     changes the range from 0..range to (0-shift)..(range-shift)
}

    CONST
       Machine_Infinity = 1E37;

    VAR
       Temp : REAL;

    BEGIN                          {Sigmoid}
       Temp := 0.0 - (Slope_mod * X);
       IF Temp > Exp_Max THEN Temp := Exp_Max;
       IF Temp < -Exp_Max THEN Temp := -Exp_Max;
       Temp := Exp(Temp);
       Sigmoid := (range/(1+(Temp))) - shift;
       END;                        {Sigmoid}

 FUNCTION signum(xx : REAL):INTEGER;

    BEGIN
       IF xx >= 0.0 THEN signum := 1
       ELSE signum := -1;
       END;


BEGIN {INITIALIZATION}
END.


