

UNIT Globals;
{
This unit provides a variety of constants and types used in the integrated
ANN note generator and related programs.
}
{

Copyright 1989 by Wesley R. Elsberry.  All rights reserved.

Commercial use of this software is prohibited without written consent of
the author.

For information, bug reports, and updates contact

Wesley R. Elsberry
528 Chambers Creek Drive South
Everman, Texas 76140
Telephone: (817) 551-7018

}


INTERFACE

 USES
    Misc1, DOS, ANSI_Z;

{PUBLIC DECLARATIONS}

 CONST
    Pi = 3.141592653589793;
    Exp_Max = 80.0;
    Colon = ':';
    graphic_string = '0123456789';

{For Bach}
    v_len_in = 8;
    v_len_out = 5;

    epsilon : REAL = 0.005;

    HTN_co_res : REAL = 3.5;
    HTN_co_cap : REAL = 10.0;
    HTN_co_wt : REAL = 1.0;
    HTN_co_inp : REAL = 1.0;
    HTN_co_iter : REAL = 1.0;

    ART_co_vigilance : REAL = 1.0;

    global_resistance : REAL = 1.0;
    global_capacitance : REAL = 1.0;

(* System goes low, but then some nodes start getting higher activity...
  global_resistance = 5;
  global_capacitance = 1; *)

{For Play_note}
    N_C_mid = 264;
    N_D = 297;
    N_E = 330;
    N_F =352;
    N_G = 396;
    N_A = 440;
    N_B = 495;
    N_C_hi = 528;

{For Beethoven (ART 1)}
    Max_F2_nodes = 25;
    Max_F1_nodes = 41;
    Vector_length = Max_F1_nodes;

(*  Max_F1_nodes = 16;
  Vector_length = 16;  c. 6/18/89  *)


 TYPE
    REAL = SINGLE;

{For Beethoven (ART 1)}
    LTM_weights_ = ARRAY[1..Max_F1_nodes] OF REAL;

    F1_node_ = RECORD
       Curr_A : REAL;              {Value of node now}
       Last_A : REAL;              {Value from last time step}
       END;

    F1_layer_ptr_ = ^F1_layer_;
    F1_layer_ = ARRAY[1..Max_F1_nodes] OF F1_node_;

    F2_node_ = RECORD
       Curr_B : REAL;              {Value of node now}
       Last_B : REAL;              {Value from last time step}
       Wup : LTM_weights_;         {BU LTM weights}
       Wdn : LTM_weights_;         {TD LTM weights}
       WIN : INTEGER;              {0 if not winner, 1 if winner}
       Eligible : BOOLEAN;         {TRUE if not rejected}
       Committed : BOOLEAN;        {TRUE if represents a category}
       END;

    F2_layer_ptr_ = ^F2_layer_;
    F2_layer_ = ARRAY[1..Max_F2_nodes] OF F2_node_;

{General}

    file_string_ = STRING[127];
    Time_rec_ = RECORD
       h,m,s,f : INTEGER;
       END;
    Note_ = (Note_C_Lo,Note_D,Note_E,Note_F,Note_G,Note_A,Note_B,
         Note_C_Hi);
    Vector_ = ARRAY[1..Max_F1_nodes] OF BYTE;
    Notes_ = ARRAY[1..V_LEN_OUT] OF INTEGER;

    Common_Area_ = RECORD
       Notes : Notes_;
       Delta_Vigilance : BOOLEAN;
       New_category : BOOLEAN;
       Is_Classical : BOOLEAN;
       Candidate_Note : INTEGER;
       END;
    note_record_ = RECORD
       n : ARRAY[1..500] OF BYTE;
       c : INTEGER;
       END;

PROCEDURE Dump_Common(cmn : Common_Area_);


IMPLEMENTATION

{PRIVATE DECLARATIONS}

{IMPLEMENTATIONS OF PROCEDURES AND FUNCTIONS}

 PROCEDURE Dump_Common(cmn : Common_Area_);
{}

    VAR
       ii : INTEGER;

    BEGIN                          {}
       { WRITELN('Dump of Common Area -----------');}
       ANSI_CUP(1,0);
       Write('Notes in sequence:');
       ANSI_CUP(1,27);
       FOR ii := 1 TO V_Len_Out DO BEGIN
                                   {}
          Write(cmn.Notes[ii],' ');
          END;                     {}
       {  WRITELN;}
       ANSI_CUP(3,0);
       Write('Change in vigilance:');
       ANSI_CUP(3,31);
       Write(cmn.Delta_Vigilance:5);
       ANSI_CUP(4,0);
       Write('New Category formed: ');
       ANSI_CUP(4,31);
       Write(cmn.New_category:5);
       ANSI_CUP(5,0);
       Write('Candidate sequence classical?:');
       ANSI_CUP(5,31);
       Write(cmn.Is_Classical:5);
       ANSI_CUP(6,0);
       Write('Candidate note:');
       ANSI_CUP(6,35);
       Write(cmn.Candidate_Note);
       ANSI_CUP(7,0);
       Write('------------------------------------');
       ANSI_CUP(23,0);
       END;                        {}

{----------------------------------------------------------}


BEGIN                             {INITIALIZATION}
END.

