

UNIT struct;
{
This unit provides a general linked-list seet of functions.
}

{

Copyright 1989 by Wesley R. Elsberry.  All rights reserved.

Commercial use of this software is prohibited without written consent of
the author.

For information, bug reports, and updates contact

Wesley R. Elsberry
528 Chambers Creek Drive South
Everman, Texas 76140
Telephone: (817) 551-7018

}


INTERFACE

{PUBLIC DECLARATIONS}


 TYPE
    dve_ptr_ = ^dve_;
    dve_ = RECORD                  {terminology: DVE is diploid vector
                                      element}
                                   {Linkage can be both forward and
                                      backward}
       up, down, left, right : dve_ptr_;
                                   {Forward and backward links}
       dptr : POINTER;             {Untyped pointer}
       END;

    hve_ptr_ = ^hve_;
    hve_ = RECORD                  {terminology: HVE is haploid vector
                                      element}
                                   {Linkage is forward only}
       down, right : hve_ptr_;     {Forward links}
       dptr : POINTER;             {Untyped pointer}
       END;


FUNCTION Create_DVE_vector (num_elem : WORD; size : WORD): POINTER;
 {This function takes a size for a pointer based structure which is based
  on the DVE_ type declaration and returns a pointer to a doubly linked
  list which has NUM_ELEM number of elements.  The calling program should
  assign this pointer's value to a pointer of the type which SIZE
  describes.  The head element's LEFT pointer is NIL, RIGHT points to the
  next element or is NIL, UP and DOWN are NIL.  Elements beside the head
  element have non-NIL LEFT pointers.  Calling routines should check for
  NIL returned pointers, as this indicates that not enough memory was
  available to allocate the vector.}

FUNCTION copy_DVE_vector (aptr : POINTER; num_elem : WORD; size : WORD): POINTER;
{ This function takes a pointer to a DVE vector and creates a copy, then
  passes back a pointer to the copy vector.}

FUNCTION Create_HVE_vector (num_elem : WORD; size : WORD; rt : BOOLEAN): POINTER;
 {This function creates a linked list of HVE_ type, with space allocated
  based on size of a HVE_ based structure definition.  If RT is TRUE, then
  the function allocates a vector using the RIGHT linkages, and DOWN
  pointers are set to NIL.  Otherwise, the obverse is true.  A NIL pointer
  returned as a result indicates that not enough memory was available for
  allocation.}


FUNCTION Create_matrix (n_across, n_down : WORD; size : WORD): POINTER;
 {This function creates a doubly linked matrix of DVE vector elements,
  using the provided size.}

FUNCTION Find_element_DVE (num : WORD; pntr : POINTER): POINTER;

FUNCTION Find_element_HVE (num : WORD; pntr : POINTER): POINTER;

FUNCTION Find_element_matrix (n1, n2 : WORD; pntr : POINTER): POINTER;

IMPLEMENTATION

{PRIVATE DECLARATIONS}

{IMPLEMENTATIONS OF PROCEDURES AND FUNCTIONS}

 FUNCTION Create_DVE_vector (num_elem : WORD;
      size : WORD): POINTER;
 {This function takes a size for a pointer based structure which is based
  on the DVE_ type declaration and returns a pointer to a doubly linked
  list which has NUM_ELEM number of elements.  The calling program should
  assign this pointer's value to a pointer of the type which SIZE
  describes.  The head element's LEFT pointer is NIL, RIGHT points to the
  next element or is NIL, UP and DOWN are NIL.  Elements beside the head
  element have non-NIL LEFT pointers.  Calling routines should check for
  NIL returned pointers, as this indicates that not enough memory was
  available to allocate the vector.}

    VAR
       ii : INTEGER;
       TempStart, Temp : dve_ptr_;

    BEGIN
       GetMem (TempStart,SizeOf(TempStart^));
       Temp := TempStart;
       Temp^.left := NIL;
       Temp^.up := NIL;
       Temp^.down := NIL;
       GetMem(Temp^.dptr,size);;
       FOR II := 2 TO num_elem DO BEGIN
          GetMem (Temp^.right,SizeOf(TempStart^));
          Temp^.right^.left := Temp;
          Temp := Temp^.right;
          Temp^.up := NIL;
          Temp^.down := NIL;
          GetMem(Temp^.dptr,size);
          END;                     {for}
       Temp^.right := NIL;
       Create_DVE_vector := TempStart;
       END;

 FUNCTION copy_DVE_vector (aptr : POINTER;
      num_elem : WORD;
      size : WORD): POINTER;
{ This function takes a pointer to a DVE vector and creates a copy, then
  passes back a pointer to the copy vector.}

    VAR
       tptr, bptr, t2ptr : dve_ptr_;
       ii, jj : WORD;

    BEGIN
       bptr := create_DVE_vector (num_elem,size);
       t2ptr := bptr;
       Tptr := aptr;
       ii := 1;
       WHILE (Tptr <> NIL) AND (ii < num_elem) DO BEGIN
          Move (bptr^.dptr^,tptr^.dptr^,size);
          Tptr := Tptr^.right;
          bptr := bptr^.right;
          INC(ii);
          END;                     {while}
       copy_DVE_vector := t2ptr;
       END;

 FUNCTION Create_HVE_vector (num_elem : WORD;
      size : WORD;
      rt : BOOLEAN): POINTER;
 {This function creates a linked list of HVE_ type, with space allocated
  based on size of a HVE_ based structure definition and on the size of
 the
  user structure pointed to within each vector element.  If RT is TRUE,
 then
  the function allocates a vector using the RIGHT linkages, and DOWN
 pointers
  are set to NIL.  Otherwise, the obverse is true.  A NIL pointer returned
 as
  a result indicates that not enough memory was available for allocation.}

    VAR
       ii : INTEGER;
       TempStart, Temp : HVE_ptr_;

    BEGIN
       IF rt THEN BEGIN
          GetMem (TempStart,SizeOf(TempStart^));
          Temp := TempStart;
          Temp^.down := NIL;
          GetMem(Temp^.dptr,size);;
          FOR II := 2 TO num_elem DO BEGIN
             GetMem (Temp^.right,SizeOf(TempStart^));
             Temp := Temp^.right;
             Temp^.down := NIL;
             GetMem(Temp^.dptr,size);
             END;                  {for}
          Temp^.right := NIL;
          END                      {if}
       ELSE BEGIN
          GetMem (TempStart,SizeOf(TempStart^));
          Temp := TempStart;
          Temp^.right := NIL;
          GetMem(Temp^.dptr,size);;
          FOR II := 2 TO num_elem DO BEGIN
             GetMem (Temp^.down,SizeOf(TempStart^));
             Temp := Temp^.down;
             Temp^.right := NIL;
             GetMem(Temp^.dptr,size);
             END;                  {for}
          Temp^.down := NIL;
          END;                     {else}
       Create_HVE_vector := TempStart;
       END;

 FUNCTION Create_matrix (n_across, n_down : WORD;
      size : WORD): POINTER;
 {This function creates a doubly linked matrix of DVE vector elements,
  using the provided size for allocation of user space.}

    VAR
       ii, jj : WORD;
       StartPtr, T1Ptr, T2Ptr : DVE_ptr_;

    PROCEDURE Link_DVE_vectors (v1, v2 : DVE_ptr_);

       BEGIN
          WHILE (v1 <> NIL) AND (v2 <> NIL) DO BEGIN
             v1^.down := v2;
             v2^.up := v1;         {Next elements}
             v1 := v1^.right;
             v2 := v2^.right;
             END;                  {while}
          END;                     {Link_DVE_vectors}

    BEGIN
       StartPtr := Create_DVE_vector (n_across, size);
       T1Ptr := StartPtr;
       FOR jj := 2 TO n_down DO BEGIN
          T2Ptr := Create_DVE_vector (n_across, size);
          Link_DVE_vectors (T1Ptr, T2Ptr);
          T1Ptr := T2Ptr;
          END;                     {for}
       Create_matrix := StartPtr;
       END;                        {Create_matrix}

 FUNCTION Find_element_DVE (num : WORD;
      pntr : POINTER): POINTER;

    VAR
       ii : WORD;
       T1 : DVE_ptr_;

    BEGIN
       T1 := pntr;
       ii := 1;
       WHILE (T1 <> NIL) AND (ii < num) DO BEGIN
          T1 := T1^.right;
          INC(ii);
          END;                     {while}
       Find_element_DVE := T1;
       END;                        {}

 FUNCTION Find_element_HVE (num : WORD;
      pntr : POINTER): POINTER;

    VAR
       ii : WORD;
       T1 : HVE_ptr_;

    BEGIN
       T1 := pntr;
       ii := 1;
       WHILE (T1 <> NIL) AND (ii < num) DO BEGIN
          T1 := T1^.right;
          INC(ii);
          END;                     {while}
       Find_element_HVE := T1;
       END;                        {}

 FUNCTION Find_element_matrix (n1, n2 : WORD;
      pntr : POINTER): POINTER;

    VAR
       ii, jj : WORD;
       T1 : DVE_ptr_;

    BEGIN
       T1 := pntr;
       ii := 1;
       jj := 1;
       WHILE (T1 <> NIL) AND (jj < n2) DO BEGIN
          T1 := T1^.down;
          jj := jj + 1;
          END;                     {while}
       WHILE (T1 <> NIL) AND (ii < n1) DO BEGIN
          T1 := T1^.right;
          ii := ii + 1;
          END;                     {while}
       Find_element_matrix := T1;
       END;                        {}


BEGIN {Initialization}
END.

