

PROGRAM trannote(Input,Output);
{
This program reads a file written by note_generator and converts it
 to a form usable by Music Transcription System (MTS).
}

{

Copyright 1989 by Wesley R. Elsberry & Diane J. Blackwood.  
All rights reserved.

Commercial use of this software is prohibited without written consent of
the authors.

For information, bug reports, and updates contact

Wesley R. Elsberry
528 Chambers Creek Drive South
Everman, Texas 76140
Telephone: (817) 551-7018

}

    USES
       Dos, CRT, ANN, struct;

    CONST

       {For file_note}
       fnote:  ARRAY[1..8] OF INTEGER = (12,14,16,17,19,21,23,24);


    VAR
       cnote   : INTEGER;
       hunt    : STRING;
       inf     : TEXT;             {Input file handle}
       instr   : STRING;
       line_ct : INTEGER;
       line    : STRING;           {String to hold line from temp file
                                      before writing to final file}
       outf    : TEXT;             {Output file handle}
       panel  : INTEGER;

{----------------------------------------------------------}

    PROCEDURE filenote(cn: INTEGER;
         VAR ln_ct: INTEGER);

       VAR
          i : INTEGER;

       BEGIN
          IF ( (ln_ct = 11) OR (SeekEof(inf)) ) THEN Write (outf,
               '0 1 4 40 0 ')
          ELSE Write (outf,'1 1 4 40 0 ');
          Write (outf,fnote[cn]);
          Writeln (outf,' -1 -1 ');
          IF (ln_ct = 1) THEN inc(panel);
          IF (ln_ct = 11) THEN BEGIN
             ln_ct := 0;
             Writeln (outf);
             Writeln (outf);
             END;
          END;

    BEGIN                          {Main}

  {initialize variables}
       line_ct := 1;
       panel := 0;

  {get filename of input file}
       REPEAT
          Write ('File to translate? ');
          Readln (instr);
          instr := FSearch(instr,GetEnv('PATH'));
          UNTIL (Length(instr) <> 0);
       Assign (inf,instr);
       Reset(inf);

  {get filename of output file}
       REPEAT
          Write ('File to store translated music? ');
          Readln (instr);
          hunt := FSearch(instr,GetEnv('PATH'));
          UNTIL (Length(hunt) = 0);
       Assign (outf,'temp.sng');
       Rewrite(outf);

  {write header to mts file}
       Writeln(outf,'30');
       Writeln(outf,'10');
       Writeln(outf,'4 4 0 3 3 7 6 4 2 2 2 1 1 1 1 2 ');
       Writeln(outf,'0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ');

  {process each note for use by mts}
       WHILE NOT Eof(inf) DO BEGIN
          Readln(inf,cnote);
          filenote(cnote,line_ct);
          line_ct := line_ct+1;
          END;

  {close the files in use}
       Close(outf);
       Close(inf);

  {Copy temp file to final file with the value for panel corrected}
       Assign (inf,'temp.sng');
       Reset (inf);
       Assign (outf,instr);
       Rewrite (outf);

  {read first two header lines and use panel to correct the number of
   panels}
       Readln(inf,line);
       Writeln(outf,line);
       Readln(inf,line);
       Writeln(outf,panel);

  {read the rest of the temp file and write to the final file}
       WHILE NOT Eof(inf) DO BEGIN
          Readln(inf,line);
          Writeln(outf,line);
          END;
       Writeln (outf);
       Writeln (outf);

  {Close the files in use}
       Close(outf);
       Close(inf);
       END.                        {Main}


