.CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
.C $Id: rbp.l,v 1.2 92/11/30 12:01:09 drew Exp $
.CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
.C
.CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
.C   Copyright 1990,1991,1992,1993 by The University of Toronto,
.C                    Toronto, Ontario, Canada.
.C 
.C                       All Rights Reserved
.C 
.C Permission to use, copy, modify, distribute, and sell this software
.C and its  documentation for any  purpose  is hereby granted  without
.C fee, provided that the above copyright notice appears in all copies
.C and that both  the copyright   notice  and  this permission  notice
.C appear in supporting documentation, and that the name of University
.C of Toronto not be  used in  advertising  or publicity pertaining to
.C distribution   of the  software  without   specific,  written prior
.C permission.  University of  Toronto makes no representations  about
.C the suitability  of this  software for  any purpose. It is provided
.C "as is" without express or implied warranty.
.C
.C UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD TO THIS
.C SOFTWARE,  INCLUDING  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
.C FITNESS, IN NO EVENT SHALL UNIVERSITY OF TORONTO  BE LIABLE FOR ANY
.C SPECIAL,  INDIRECT    OR  CONSEQUENTIAL DAMAGES    OR  ANY  DAMAGES
.C WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS, WHETHER IN
.C AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
.C OUT  OF  OR IN  CONNECTION WITH  THE USE OR  PERFORMANCE   OF  THIS
.C SOFTWARE.
.CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
.C
.de BF          \" boldface a word
\fI\\$1\fP
..
.de FT          \" start a field table with title
.PP
.nf
.ta 2.5i 4.5i
.ce 1
\\$1
..
.de CF          \" center a function on a line
.sp
.ce 1
\\$1
.sp
..
.TH rbp LOCAL "October 1991" "Xerion" "Xerion Manual"
.SH NAME
rbp -  Xerion Recurrent Back Propagation module

.SH SYNOPSIS
rbp [ commands ]
.br
run [ run options ] rbp [ commands ]

.SH DESCRIPTION 

\fIrbp\fP is a version of the Recurrent Back Propagation algorithm,
built using the Xerion Neural Network Simulator. As such, it
understands all of the commands that are built into the Xerion
simulator.

For some background and references on the Backprop training and
relaxation algorithms, see the LaTeX documentation in the
$XERIONDIR/doc/*.tex files.

.SH ERROR AND GRADIENT UPDATE ALGORITHMS

Below is a pseudocode representation of the routines that calculate
the error of the network on an example set, and calculate the
derivatives of the connection weights with respect to this error.
Where possible, actual variable and function names are used.  Most of
the support functions (zeroLinks, zeroUnits, etc.)  are defined in the
rbp.c file.

.nf
/***********************************************************
 ********  Update net error and associated derivs   ********
 ***********************************************************/
int             calculateNetErrorDeriv(net, exampleSet)
  Net           net ;
  ExampleSet    exampleSet ;
{
  int           numExamples ;

  /* zero the net error and all derivative fields in the links */
  net->error = 0.0 ;
  for all units { zeroLinks } ;

  /* For each example - zero the unit derivative fields
   *                  - do a forward pass updating activities
   *                  - do a backward pass updating derivatives
   */
  for numExamples = 0 to net->batchSize - 1 { 
    getNextExample(exampleSet) ;
    for all units { zeroUnit } ;
    MupdateNetActivities(net) ;
    MupdateNetGradients(net) ;
  }

  /* update the cost after everything else is done */
  net->cost = 0.0 ;
  for all units { updateCost } ;
  
  return 0 ;
}
/***********************************************************/

/***********************************************************
 *****               Update net error only           *******
/***********************************************************/
int             calculateNetError(net, exampleSet)
  Net           net ;
  ExampleSet    exampleSet ;
{
  int           numExamples ;

  net->error = 0.0 ;
  for numExamples = 0 to net->batchSize - 1 { 
    getNextExample(exampleSet) ;
    MupdateNetActivities(net) ;
  }

  net->cost = 0.0 ;
  for all units { updateCost } ;

  return 0 ;
}
/***********************************************************/
.fi

.SH DETAILS ON IMPORTANT SECTIONS AND FEATURES

This section describes in detail some important points of the above
procedures.

.SS Updating network activations:

The procedure to activate the network activates all the units in
the network at each time step. It then saves the activations, and
reactivates the units at the next time step, using the previous time
step's outputs as the new inputs.

.nf
/***********************************************************
 ********  Update unit activations at each time step *******
 ***********************************************************/
static void	netForward (net)
  Net		net ;
{
  int	time ;

  for time = 0 to net->timeSlices {
    /* move all unit outputs forward one time step */
    for all units { stepUnitForward } ;
    for all units { updateActivity } ;
  }
}
/***********************************************************/
.fi

.SS Updating unit activations:

Unit activations are calculated as the weighted sum of inputs from
connected units as passed through a (0,1) sigmoid function. The
function that calculates the unit activation also updates the network
error for all output units.

.SS Updating network activations:

The procedure to calculate the network gradient uses the outputs
calculated by the activation procedure. It starts at the final time
and then steps backwards in time propagating the errors at each time
step back to the previous time step.

.nf
/***********************************************************
 ********  Update unit gradients at each time step *********
 ***********************************************************/
static void	netBackward (net)
  Net		net ;
{
  int	time ;

  for time = net->timeSlices down to 0 {
    /* move all unit outputs forward one time step */
    for all units { stepUnitBack } ;
    for all units { updateGradient } ;
  }
}
/***********************************************************/
.fi

.SS Updating gradients and network cost:
The cost update procedure features options for controlling
the size of the weights by enforcing "weight costs" or "weight
decay".  Hence:

.nf
For each Link \fIlink\fP:
    unit->net->cost  += weightCost*square(link->weight) ;
    link->deriv      += 2.0*weightCost*link->weight ;
.fi

Since the derivative with respect to the cost is added into the deriv
field in each link, the \fIminimize\fP command will attempt to
minimize the sum of the network error plus the network cost.
Minimization using conjugate gradient descent (minimize -cg) has been
shown to work well for this module.

.SH NET PARAMETERS AND "GLOBAL" NETWORK VARIABLES

The net parameters that govern the training and testing dynamics of
the network on the examples, may be set in a *.in file (as part of
setting up a net and example sets) or in the Xerion "Network
Parameters" window or the Xerion main command window.  The (settable)
network parameters are indicated by the /* netParam: */ comment.  (All
of these variables are defined in the rbp.h file in the rbp directory.)

.IP "\fIint  batchSize ;            /* netParam: */\fP" 1i
The number of examples to process during each batch of training. If
this value is set to 1, the net will be training online. If set to 0,
all the examples in the training set will be processed before updating
the weights, and the net will be doing batch training. Any other
positive number can be used for "semi-batch" learning.

.IP "\fIint   delayCount  ;           /* netParam: */\fP" 1i
Degree of time step slowdown used for viewing the details of network
at each time step.  Basically, a trivial loop from 1 to delayCount*1000 is
used between network time steps.  This may be used while
viewing the "testing" of cases (e.g. "clicking" on them in the
"Activations" window) and only while the "Each Time Step" updating
option is turned on in the Activations window. When viewing, try
setting the var to 100 or 1000; performance and ease of viewing will
vary depending on your machine's speed ("raw" CPU speed, memory access
speed, screen update speed, etc.), of course.

.IP "\fIReal  weightCost ;            /* netParam: */\fP" 1i
Cost associated with magnitude of weights.  It is sometimes useful to
limit the absolute magnitude of weights in this way, in order to
improve the trained net's "generalization" capabilities.  See above
section on gradient updates.

.IP "\fIReal  zeroErrorRadius ;       /* netParam: */\fP" 1i
Interval of acceptance for agreement between desired output and target
output of a unit.  The degree to which a "near miss" will count as a
"hit".

.SH FILES
.nf
$XERIONDIR/src/sim/rbp/rbp.[ch]        Source code for the simulator
$XERIONDIR/nets/rbp/*.in               Input files for sample nets
$XERIONDIR/nets/rbp/*.layout           Layout files for sample nets
$XERIONDIR/nets/*.ex                   Example sets for sample nets
$XERIONDIR/config/rbprc                Initialization file for rbp

.SH SEE ALSO 
.nf
minimize(1XERION), run(LOCAL), mft(LOCAL), fem(LOCAL), bm(LOCAL)
.fi

For general information on the Xerion simulator, its user interface,
and implementation and portability issues, see the appropriate man
(sman) page, README file, or, once inside Xerion, the online help
page.

For some background and references on the BP, MFT, Boltzmann, and FEM
training and relaxation algorithms, see the Latex documentation in the
$XERIONDIR/doc/*.tex files.

.SH AUTHOR
.nf
Drew van Camp (drew@ai.toronto.edu)
Dept. of Computer Science
University of Toronto,
Toronto, ON, Canada
.fi
