
/**********************************************************************
 * $Id: rbp.h,v 1.3 92/11/30 12:01:15 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef RBP_H
#define RBP_H

/* The following structures must be defined, even if you don't
 * need them in you simulator
 */
typedef struct NetExtensionRec {	/* BIND */
  Real		zeroErrorRadius ;	/* netParam: */
  int		delayCount ;		/* netParam: */
  Boolean	running ;
} NetExtensionRec ;

typedef struct GroupExtensionRec {	/* BIND */
  int	foo ;
} GroupExtensionRec ;

typedef struct UnitExtensionRec {	/* BIND */
  Real	nextOutputDeriv ;
} UnitExtensionRec ;

typedef struct LinkExtensionRec {	/* BIND */
  int	foo ;
} LinkExtensionRec ;

typedef struct ExampleExtensionRec {	/* BIND */
  int	foo ;
} ExampleExtensionRec ;

#define simpleSigmoid(x) (1.0/(1.0+exp(-(double)(x))))
#define sigmoid(x)       ((x) > 30 ? 			\
			  (1.0) : ((x) < -30 ? (0.0) : simpleSigmoid(x)))

#define sigmoidDeriv(x)	((x)*(1.0 - (x)))

#define simpleTanh(x)	(tanh((double)(x)))
#define tanhTransfer(x)	((x) > 30 ? (1.0) : \
			 ((x) < -30 ? (-1.0) : SIMPLE_TANH(x)))
#define simpleTanhDeriv(x)	(1.0/square(cosh((double)(atanh((double)x)))))
#define tanhDeriv(x)		((atanh((double)x)) > 30 ? (0.0) : \
				 ((atanh((double)x)) < -30 ? (0.0) : \
				  simpleTanhDeriv(x)))

#define HAS_TARGET(unit, time)    \
  ((unit->group->type & OUTPUT)	\
   && (unit->targetHistory == NULL || !(isNaN(unit->targetHistory[time]))))
#define IS_CLAMPED(unit, time)    \
  ((unit->group->type & INPUT)	\
   && (unit->clampingHistory == NULL || !(isNaN(unit->clampingHistory[time]))))

#define MIN(x, y)	((x) < (y) ? (x) : (y))
#define MAX(x, y)	((x) > (y) ? (x) : (y))

#define MzeroErrorRadius(net)	((net)->extension->zeroErrorRadius)
#define MbatchSize(net)		((net)->batchSize)
#define Mrunning(net)		((net)->extension->running)
#define MdelayCount(net)	((net)->extension->delayCount)
#define MnextOutputDeriv(unit)	((unit)->extension->nextOutputDeriv)

extern struct TRACE	forwardEachTime ; /* BIND */

#define TANH		((Mask)(1<< (HIGHEST_BIT_USED+1)))

#endif				/* RBP_H */
