:- op(600, xfy, :).

% The atomic category X is the name of the rule

eccs_cfg_read(_Args, Name, Type, Definition) :-
    eccs_sys_read(Term),
    (Term == end_of_file -> Name = end_of_file, Definition = end_of_file;
        eccs_cfg_read1(Term, Name, Type, Definition)).
 
eccs_cfg_read1(start_symbol(S),  start_symbol, start_symbol, S).
eccs_cfg_read1((X -> L), X, rule, rule(X, L)).
eccs_cfg_read1(Word:Category, Word, lexical_entry, lex(Word, Category)).

eccs_cfg_compile(cfg_object, 
	lexical_entry, Word, _, lex(Word, Cat),  Cat, []).
eccs_cfg_compile(cfg_object, 
	start_symbol, start_symbol, _, SS, SS, []).
eccs_cfg_compile(cfg_object, rule, X, _Args, rule(X, L), rule(X, L1), [])  :-
    eccs_commas_to_list(L, L1).

:- eccs_new_variable(parser, eccs_cfg_parse, parsing, run, 
			"The name of the parser to be used for analyzing input").

:- eccs_set_variable(parse_printer, eccs_cfg_tree_to_stdform).

:- eccs_set_variable(test_sentence_list, 
	[[this, is, a, angry, angry, boy],
	 [this, is, his, dog],
	 [mary, loves, her, dog]]).


eccs_user_parser_spec(eccs_cfg_parse, 
	[prehook = retractall(eccs_last_sentence_analysis(_, _, _)), 
	 fs_drawer = eccs_cfg_tree_to_stdform]).


eccs_cfg_parse(_, L, Results) :-
    eccs_post_last_sentence(L),
    setof(Tree, eccs_cfg_parse1(L, [], Tree), Results), !.
eccs_cfg_parse(_, L, []).

eccs_cfg_parse1([], [node(Start, Tree)], node(Start, Tree)) :-
    start_symbol(Start).
eccs_cfg_parse1([H|R], Stack, Tree) :-
    lexical_entry(H, Cat),
    eccs_cfg_parse1(R, [node(Cat, [node(H, [])])|Stack], Tree).
eccs_cfg_parse1(Words, [Cat|Cats], Tree) :-
    eccs_cfg_match([Cat|Cats], Remainder),
    eccs_cfg_parse1(Words, Remainder, Tree).

eccs_cfg_match([], []).
eccs_cfg_match(Cats, [node(Mother, D1s)|Remainder]) :-
    rule(Mother, Daughters),
    eccs_reverse(Daughters, Ds),
    eccs_cfg_match1(Cats, Ds, D1s, Remainder).

eccs_cfg_match1(Stack, [], [], Stack).
eccs_cfg_match1([node(C, Tree)|Ds], [C|Cs], [node(C, Tree)|D1s], Remainder) :-
    eccs_cfg_match1(Ds, Cs, D1s, Remainder).
    

lexical_entry(Word, Cat) :-
    lexical_entry(Word, _, _, Cat).

rule(Mother, Daughters) :-
    rule(Mother, _, _, rule(Mother, Daughters)).
start_symbol(Start) :-
    start_symbol(start_symbol, _, _, Start).


/*

A simple generator

generate(Length, Tree)


*/

eccs_generate(N, Tree) :-
    eccs_length(String, N), 
    start_symbol(Start),
    eccs_generate1(String, String, [], Start, Tree),
    eccs_interpolate_char(' ', String, S1),
    eccs_append(['Generated string: "'| S1], ['"'], C),
    eccs_concat_list(C, Caption),
    eccs_cfg_tree_to_stdform(_, Caption, Tree, STDForm),
    eccs_output(STDForm),
    (eccs_do_menu(confirm, [alert = ['Would you like another generation']]) ->
    	fail; !, fail).
eccs_generate(_, _) :-
    eccs_to_user([no, more, generations]).


eccs_generate1(_String, S, S, [], []).
eccs_generate1(_String, [Lex|Lexs], Lexs, Cat, node(Cat, [node(Lex, [])])) :-
    lexical_entry(Lex, Cat).
eccs_generate1(String, Lexs, Rest, Mother, node(Mother, Daughters)) :-
    rule(Mother, Ds),
    eccs_longer_list(Lexs, Ds),
    eccs_generate2(String, Lexs, Rest, Ds, D1s),
    eccs_reverse(D1s, Daughters).

eccs_generate2(_S, Lex, Lex, [], []).
eccs_generate2(String, Lex, Lex1, [Cat|Cats], [Node|Nodes]) :-
    (eccs_recursive_cat(Cat) -> 
    	(eccs_longer_list(String, Lex0),
	 eccs_generate2(String, Lex0, Lex1, Cats, Nodes), 
	 eccs_generate1(String, Lex, Lex0, Cat, Node));
	(eccs_generate1(String, Lex, Lex0, Cat, Node),
	 eccs_generate2(String, Lex0, Lex1, Cats, Nodes))).


eccs_longer_list(_, []).
eccs_longer_list([H|T], [F|R]) :-
    eccs_longer_list(T, R).

eccs_recursive_cat(C) :-
    rule(C, Ds),
    (eccs_member(C, Ds);
     (eccs_member(D, Ds), rule(D, D1s), eccs_member(C, D1s))), 
    !.
     
/*

Printers

*/

eccs_cfg_print(lexical_entry, Word, Cat, 
  captioned('', infix(atomic(':'), atomic(Word), atomic(Cat)))).

eccs_cfg_print(rule, M, rule(M, Ds), STDForm) :-
   STDForm = captioned('', infix(symbol(arrowright), atomic(M), parenth(D1s))),
   eccs_atoms_to_std_form(Ds, D1s).


	

eccs_cfg_print(start_symbol, start_symbol, S, captioned('the start symbol', atomic(S))).

eccs_atoms_to_std_form([], []).
eccs_atoms_to_std_form([F|R], [atomic(F)|R1]) :-
    eccs_atoms_to_std_form(R, R1).

eccs_cfg_tree_to_stdform(_Args, Caption, Tree, captioned(Caption, STDForm)):-
    eccs_cfg_tree_to_stdform(Tree, STDForm).

eccs_cfg_tree_to_stdform(node(Cat, []), italic(Cat)) :- !.
eccs_cfg_tree_to_stdform(node(Cat, Ds), tree(atomic(Cat), D1s)) :-
    eccs_reverse(Ds, D2s),
    eccs_cfg_tree_to_stdform1(D2s, D1s).

eccs_cfg_tree_to_stdform1([], []).
eccs_cfg_tree_to_stdform1([F|R], [H|T]) :-
    eccs_cfg_tree_to_stdform(F, H),
    eccs_cfg_tree_to_stdform1(R, T).



/*

menus

*/

eccs_specialization_menu(generate, popup, 
	[options = 
	   [command('Generate a string of known length', eccs_do_generate)],
	 prompt = 'Generate']).

eccs_do_generate :-
    eccs_do_menu(generatedbox).

eccs_specialization_menu(generatedbox, dbox,
	[fields = [field('Length of string', 3)],
	 command = eccs_generate('$$', _),
	 prompt = 'Generate']).


/*

Interaction with the help system

*/

eccs_spec_info(cfg, 'Top').

/*

Interaction with the derivation checker 

*/

/*


tree is the name of the type we give to partical derivations in the DC. 


*/
spec_dc_prepare(rule, Name, rule(DBRef), Result) :-
    eccs_get_from_databaser(rule, Name, Object, DBRef),
    cfg_tree2spf(Object, Name, [], rule(DBRef), Result).

spec_dc_prepare(lexical_entry, Name, lexical(DBRef),
    tree(atomic(Object), [italic(Name)])) :-
    eccs_get_from_databaser(lexical_entry, Name, Object, DBRef).
    
spec_dc_prepare(derivation(Tag), SPF) :-
    cfg_dc_lookup(derivation(Tag), Deriv),
    eccs_sys_arg(1, Deriv, Name),
    cfg_tree2spf(Deriv, Name, [], derivation(Tag), SPF).
spec_dc_prepare(lexical(Tag), SPF) :-
    spec_dc_prepare(lexical_entry, _Name, lexical(Tag), SPF).
spec_dc_prepare(rule(Tag), SPF) :-
    spec_dc_prepare(rule, _Name, rule(Tag), SPF).

cfg_tree2spf(Rule, M, Path, Tag, tree(atomic(M), SPFDs)) :-
    (Rule = rule(M, Ds); Rule = tree(M, Ds)), !,
    cfg_ds_to_ds(Ds, Rule, Path, 0, Tag, SPFDs).

cfg_ds_to_ds([], _Tree, _Path, _, _, []).
cfg_ds_to_ds([tree(M, Ds)|Rest], Tree, Path, N, Tag, [tree(atomic(M), D1s)|R1]) :-
    !,
    cfg_ds_to_ds(Ds, Tree, [N|Path], 0, Tag, D1s),
    eccs_succ(N, I),
    cfg_ds_to_ds(Rest, Tree, Path, I, Tag, R1).
cfg_ds_to_ds([lexical(D)|Ds], Tree, Path, N, Tag, [italic(D)|SPFDs]) :-
    eccs_succ(N, M),
    cfg_ds_to_ds(Ds, Tree, Path, M, Tag, SPFDs), !.
cfg_ds_to_ds([D|Ds], Tree, Path, N, Tag, [SPF|SPFDs]) :-
    eccs_sys_atomic(D), 
    SPF = sensitize(triangle(atomic(D)), DCHook),
    DCHook = insert_selection([N|Path], Tag),
    eccs_succ(N, M),
    cfg_ds_to_ds(Ds, Tree, Path, M, Tag, SPFDs).

cfg_expansion_site(D) :-
    eccs_get_from_database(rule, D, _), !.
cfg_expansion_site(D) :- 
    eccs_get_from_database(lexical_entry, _, D), !.

spec_dc_do_insert(Path, InsertTag, SelTag, derivation(Tag, SPFTree)) :-
    eccs_reverse(Path, RevPath),
    cfg_dc_lookup(SelTag, Sel),
    cfg_dc_lookup(InsertTag, Insert),
    cfg_new_tree(RevPath, Insert, Sel, Result),
    cfg_note_derivation(Result, Tag),
    eccs_sys_arg(1, Result, Name),
    cfg_tree2spf(Result, Name, [], Tag, SPFTree).


cfg_dc_lookup(rule(DBRef), Rule) :- !,
    eccs_get_from_databaser(rule, _, Rule, DBRef).
cfg_dc_lookup(lexical(DBRef), lexical_entry(Name, Cat)) :- !,
    eccs_get_from_databaser(lexical_entry, Name, Cat, DBRef).
cfg_dc_lookup(derivation(DBRef), Derivation) :-
    eccs_sys_clause(cfg_deriv_table(Derivation), _, DBRef).

:- dynamic cfg_deriv_table/1.

cfg_note_derivation(Result, derivation(Tag)) :-
    eccs_sys_assert(cfg_deriv_table(Result), Tag).



cfg_new_tree([], Old, New, Tree) :- !,
    (cfg_compatible_category(Old, New) -> true;
      cfg_obj2cat(Old, OldC), 
      cfg_obj2cat(New, NewC),
      eccs_message([OldC, and, NewC, are, not, compatible, categories]), fail),
    cfg_basic_tree(New, Tree).
cfg_new_tree([N|Ns], Tree, Insert, tree(M, NewDs)) :-
    (Tree = tree(M, Ds); Tree = rule(M, Ds)), !,
    cfg_delete_nth_daughter(N, Ds, Old, D, NewDs),
    cfg_new_tree(Ns, Old, Insert, D).

cfg_obj2cat(Cat, Cat) :-
    eccs_sys_atomic(Cat), !.
cfg_obj2cat(Obj, Cat) :-
    cfg_compatible_category(Cat, Obj).

cfg_compatible_category(Cat, rule(Cat, _)).
cfg_compatible_category(Cat, tree(Cat, _)).
cfg_compatible_category(Cat, lexical_entry(_, Cat)).

cfg_basic_tree(New, Tree) :-
    eccs_once( (New = rule(M, Ds); New = tree(M, Ds))),
    Tree = tree(M, Ds).
cfg_basic_tree(New, Tree) :-
    New = lexical_entry(Lex, Cat),
    Tree = tree(Cat, [lexical(Lex)]).

cfg_delete_nth_daughter(N, Ds, Old, E, NewDs) :-
    eccs_length(Ds, L),
    eccs_length(NewDs, L),
    cfg_delete_nth_daughter(0, N, Ds, Old, E, NewDs).

cfg_delete_nth_daughter(_, _, [], _, _, []) :- !.
cfg_delete_nth_daughter(N, N, [Old|Ds], Old, E, [E|NewDs]) :- 
    !,
    eccs_succ(N, M),
    cfg_delete_nth_daughter(M, N, Ds, Old, E, NewDs).
cfg_delete_nth_daughter(I, N, [H|Ds], Old, E, [H|NewDs]) :- 
    !,
    eccs_succ(I, J),
    cfg_delete_nth_daughter(J, N, Ds, Old, E, NewDs).


spec_windows([window('Trees', [900, 150], type(rule)), 
	      window('Lexical entries', [900, 200], type(lexical_entry)),
	      window('Derivation Window', [400, 400])]).

:- eccs_set_variable(eccs_spec_supports_dc, true).


spec_report(selection(Tag)) :-
    cfg_tag_to_name_and_type(Tag, Type, Name),
    eccs_message([Type, Name, selected]).
spec_report(insertion_attempt(Sel, Key, Target)) :-
    cfg_tag_to_name_and_type(Sel, SelType, SelName),
    cfg_tag_to_name_and_type(Target, TType, TName),
    eccs_reverse(Key, K1),
    eccs_interpolate_char(':', K1, K2),
    eccs_concat_list(K2, PathSpec),
    eccs_message([attempting, to, insert, SelType, SelName, as,
		daughter, PathSpec, in, TType, TName]).

cfg_tag_to_name_and_type(lexical(Tag), 'lexical entry', Name) :-
    eccs_get_from_databaser(lexical_entry, Name, _, Tag).
cfg_tag_to_name_and_type(rule(Tag), rule, Name) :-
    eccs_get_from_databaser(rule, Name, _, Tag).
cfg_tag_to_name_and_type(derivation(Tag), derivation, Root) :-
    cfg_dc_lookup(derivation(Tag), Deriv),
    eccs_sys_arg(1, Deriv, RootCat),
    eccs_concat('rooted in ', RootCat, Root).


spec_delete_object(lexical(_)).
spec_delete_object(rule(_)).
spec_delete_object(derivation(Tag)) :-
    eccs_sys_erase(Tag).

spec_add_lexical(Tag, SPF)  :-
   eccs_do_menu(dbox, [ fields = [field('Lexical entry to add', '')],
	 		command=cfg_prep_lexical('$$', Tag, SPF)]).

cfg_prep_lexical(Atom, Tag, SPF) :-
    spec_dc_prepare(lexical_entry, Atom, Tag, SPF).



spec_add_parse(Tag, SPF) :-
    eccs_do_menu(dbox, [ fields = [field('String to parse', '')],
    			 command=cfg_prep_parse('$$', Tag, SPF)]).

cfg_prep_parse(Atom, derivation(Tag), SPF) :-
    eccs_sys_name(Atom, L),
    eccs_massage_input(L, list, eccs_generic_tokenizer, Massaged),
    eccs_cfg_budc(Massaged, Parses),
    eccs_length(Parses, N),
    (N = 0 -> eccs_message([no, parses, found, for, Atom]), fail;
    	      eccs_message([N, 'parse(s)', found, for, Atom])),
    eccs_member(P, Parses),
    eccs_cfg_parse2dc(P, Deriv),
    cfg_note_derivation(Deriv, derivation(Tag)),
    eccs_sys_arg(1, Deriv, Name),
    cfg_tree2spf(Deriv, Name, [], derivation(Tag), SPF).

    
    


eccs_cfg_budc(L, Results) :-
    setof(Tree, eccs_cfg_budc1(L, [], Tree), Results), !.
eccs_cfg_budc(_, []).

eccs_cfg_budc1([], [node(Start, Tree)], node(Start, Tree)).
eccs_cfg_budc1([H|R], Stack, Tree) :-
    lexical_entry(H, Cat),
    eccs_cfg_budc1(R, [node(Cat, [node(H, [])])|Stack], Tree).
eccs_cfg_budc1(Words, [Cat|Cats], Tree) :-
    eccs_cfg_match([Cat|Cats], Remainder),
    eccs_cfg_budc1(Words, Remainder, Tree).

    
eccs_cfg_parse2dc(node(M, []), lexical(M)) :-
    !.
eccs_cfg_parse2dc(node(M, Ds), tree(M, TDsRev)) :-
    eccs_cfg_parse2dc(Ds, TDs),
    eccs_reverse(TDs, TDsRev).

eccs_cfg_parse2dc([], []).
eccs_cfg_parse2dc([D|Ds], [D1|TDs]) :-
    eccs_cfg_parse2dc(D, D1),
    eccs_cfg_parse2dc(Ds, TDs).


spec_tag2strictspf(Tag, SPF) :-
    spec_dc_prepare(Tag, SPF1),
    dc_filter_sensitive(SPF1, SPF).


