/*

rcsid('$Author: pleuk $',
	'$Date: 1991/03/06 14:03:08 $',
	'$Revision: 0.1 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/C/RCS/nu.pl,v $',
	'$State: Exp $').

$Log: nu.pl,v $
% Revision 0.1  1991/03/06  14:03:08  pleuk
% *** empty log message ***
%

*/

/*

foreign_file(X, Y) :-
    foreignFile(X, Y).

We need to get the effect of this by renaming



foreignFile('filestatus.o', [eccs_newer, eccs_file_exists, eccs_file_mtime]).
foreignFile('hack_control_c.o', [eccs_hack_control_c]).
foreignFile('environment.o', [eccs_env]).
foreignFile('getselection.o', [eccs_get_selection]).

foreign(eccs_hack_control_c, eccs_hack_control_c).
foreign(eccs_file_mtime, eccs_file_mtime(+string, [-integer])).
foreign(eccs_newer, eccs_newer_file(+string, +string, [-integer])).
foreign(eccs_file_exists, eccs_file_exists(+string, [-integer])).

foreign(eccs_env, eccs_env(+string, [-string(256)])).
foreign(eccs_get_selection, eccs_sunview_get_selection([-string(256)])).


foreign(eccs_seconds_to_date, eccs_seconds_to_date(+integer, [-string])).

load_foreign_files(Fs, Libs) :-
    loadForeignFiles(Fs, Libs).

?- load_foreign_files(['hack_control_c.o'], []).
?- load_foreign_files(['filestatus.o'], []).
?- load_foreign_files(['environment.o'], []).
?- load_foreign_files(['getselection.o'], ['-lsuntool', '-lsunwindow', '-lpixrect']).


*/

eccs_hack_control_c.

eccs_newer_file(Old, New) :-
    stat(Old, OldStat),
    stat(New, NewStat),
    eccs_member(mtime = OldM, OldStat),
    eccs_member(mtime = NewM, NewStat),
    OldStat < NewStat.

eccs_file_exists(File) :-
    stat(File, _).

eccs_environment(Name, Value) :-
    getenv(Name, Value).

foreignFile('datestamp.o', [eccs_datestamp, eccs_seconds_to_date]).

foreign(eccs_datestamp, eccs_datestamp([-string])).
foreign(eccs_seconds_to_date, eccs_seconds_to_date(+integer, [-string])).


?- loadForeignFiles(['datestamp.o'], []).

