/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:09:48 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/C/RCS/sicstus.pl,v $',
	'$State: Exp $').

$Log: sicstus.pl,v $
% Revision 1.0  1993/04/26  16:09:48  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  13:25:19  pleuk
% revisions from SLE - April 1992
%
*/


/* Foreign functions - window system independent */

% maketemp.c is actually only required in quintus, but is included here anyway


foreign_file('filestatus.o', [eccs_newer, eccs_file_exists, eccs_file_mtime]).
foreign_file('environment.o', [eccs_env]).
foreign_file('datestamp.o', [eccs_datestamp, eccs_seconds_to_date]).
foreign_file('maketemp.o', [eccs_mktemp]).

foreign(eccs_file_mtime, c, eccs_file_mtime(+string, [-integer])).
foreign(eccs_newer, c, eccs_newer_file(+string, +string, [-integer])).
foreign(eccs_file_exists, c, eccs_file_exists(+string, [-integer])).
foreign(eccs_env, c, eccs_env(+string, [-string(256)])).
foreign(eccs_datestamp, c, eccs_datestamp([-string(256)])).
foreign(eccs_seconds_to_date, c, eccs_seconds_to_date(+integer, [-string])).
foreign(eccs_mktemp, c, eccs_mktemp(+string, [-string(256)])).

:- load_foreign_files(['filestatus.o'], []).
:- load_foreign_files(['environment.o'], []).
:- load_foreign_files(['datestamp.o'], []).
:- load_foreign_files(['maketemp.o'], []).

/*

Catching interrupts  (taken from file interrupts in this directory)

*/

foreign_file('int.o', [eccs_int_init]).

foreign(eccs_int_init, eccs_int_init).

:- load_foreign_files(['int.o'],[]), eccs_int_init.


:- abolish(foreign_file, 2).
:- abolish(foreign, 3).

eccs_newer_file(Old, New) :-
    eccs_newer_file(Old, New, 0). 

eccs_file_exists(File) :-
    eccs_file_exists(File, 0).

eccs_environment(Name, Value) :-
    eccs_env(Name, Value),
    eccs_not_eq(Value, 'no value').



