/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:18:16 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/gmwindows.pl,v $',
	'$State: Exp $').

$Log: gmwindows.pl,v $
% Revision 1.0  1993/04/26  16:18:16  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:11:31  pleuk
% *** empty log message ***
%
% Revision 0.3  1991/07/15  09:57:13  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.2  1991/05/21  14:48:37  kwh
% allow output to be directed to file information window.
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/


:-  eccs_file_in_code_directory('Code/ispgm_utls.pl', F),
    eccs_sys_ensure_loaded(F).

/*

We don't have a special method for buffering or flushing output. 

*/

eccs_interface_buffer(H) :-
    eccs_gm_handle(H),
    eccs_gm_text(H, Text), 
    eccs_gm_position_at_end(Text).
/*
eccs_interface_buffer(H) :- 
    eccs_gm_handle(H),
    H = gm_out(_, Text),
    gmsend(Text, batchmode).
*/


eccs_interface_flush(H) :- 
    eccs_gm_handle(H),
    eccs_gm_text(H, _Text), !.


/*

eccs_interface_flush(H) :- 
    eccs_gm_handle(H),
    \+ eccs_gm_text(H, Text),
    gmsend(Text, batchmodeoff).

*/


eccs_interface_make_window(Type, Handle) :-
    eccs_gm_make_window(Type, _, Handle).

eccs_gm_make_window(Type, _BufferName, Stream) :-
    gm_ensure_running,
    eccs_global_variable(eccs_window_system, Wins),
    Wins = 'X', 
    eccs_ispgm_make_window(Type, Stream, Stream).

eccs_ispgm_make_window(file, _, gm_out(Window, Text)) :-
    gmcreate(Text, text(5, 80, 8, '-*-courier-*-r-*-*-*-100-*-*-*-*-*-*')),
    gmcreate(Window, window("Pleuk files", scroller(Text))),
    gmsend(Window, open),
    gmsend(Text, readonly).

eccs_ispgm_make_window(output, _Name, ISPGMStream) :-
    gmcreate(Text, text(24, 80, 8, '-*-courier-*-r-*-*-*-100-*-*-*-*-*-*')),
    gmcreate(Window, window("Pleuk Output", scroller(Text))),
    gmsend(Window, open),
    ISPGMStream = gm_out(Window, Text), 
    eccs_attach_filter_to_stream(ISPGMStream, eccs_ispgm_filter(ISPGMStream)),
    gmsend(Text, readonly).


eccs_gm_handle(gm_out(_W, _T)).

eccs_interface_format(Handle, Format, Args) :-
    eccs_gm_handle(Handle), !,
    eccs_gm_text(Handle, Text),
    eccs_gm_position_at_end(Text),
    gmsend(Text, insert(format(Format, Args))).

eccs_gm_text(gm_out(_, Text), Text).


/*

The filter for ispgm output


Assume fixed width fonts!
*/

eccs_ispgm_filter(Stream, ToPrint) :-
    Stream = gm_out(_, _Text), 
    (ToPrint = captioned(Caption, Structure);
     ToPrint = Structure, Caption = ''), !,
     eccs_set_variable(eccs_last_output, captioned(Caption, Structure)),
    eccs_ispgm_draw_fs(Stream, Structure),
    eccs_ispgm_draw_caption(Stream, Caption).

eccs_ispgm_draw_caption(Stream, '') :- !,
    eccs_gm_nl(Stream).
eccs_ispgm_draw_caption(Stream, Caption) :-
    eccs_gm_nl(Stream),
    eccs_gm_string(Stream, "/* ------------------------- "),
    eccs_gm_nl(Stream),
    eccs_ispgm_draw_caption1(Stream, Caption),
    eccs_gm_string(Stream, "   ------------------------- */"),
    eccs_gm_nl(Stream).

eccs_ispgm_draw_caption1(Stream, Caption) :-
    eccs_sys_atomic(Caption), !,
    eccs_gm_write(Stream, Caption), eccs_gm_nl(Stream).
eccs_ispgm_draw_caption1(Stream, Caption) :-
    eccs_likely_string(Caption), !,
    eccs_gm_string(Stream, Caption), eccs_gm_nl(Stream).
eccs_ispgm_draw_caption1(Stream, Caption) :-
    eccs_gm_write(Stream, Caption),
    eccs_gm_nl(Stream).


/* The following predicate draws a feature structure, but occasionally fails, 
   and we don't yet know why (SLE - 3/92) */
eccs_ispgm_draw_fs(Stream, FS) :-
    eccs_ispgm_draw_fs(Stream, FS, 0, 0).

eccs_ispgm_draw_fs(Stream, atomic(A), Tab, _) :-
    eccs_gm_tab(Stream, Tab),
    eccs_ispgm_draw_fs_atomic(Stream, A).
eccs_ispgm_draw_fs(Stream, symbol(A), Tab, _) :-
    eccs_gm_tab(Stream, Tab),
    eccs_dumb_symbol_name(A, Print),
    eccs_ispgm_draw_fs_atomic(Stream, Print).
eccs_ispgm_draw_fs(Stream, italic(A), Tab, _) :-
    eccs_gm_tab(Stream, Tab),
    eccs_gm_write(Stream, '"'), 
    eccs_ispgm_draw_fs_atomic(Stream, A), 
    eccs_gm_write(Stream, '"').
eccs_ispgm_draw_fs(Stream, uninstantiated, Tab, _) :-
    eccs_gm_tab(Stream, Tab),
    eccs_gm_write(Stream, "[]").
eccs_ispgm_draw_fs(Stream, sequence(S), Tab, Count) :-
    eccs_gm_tab(Stream, Tab),
    eccs_gm_write(Stream, '<'),
    Tab1 is Count +1,
    eccs_ispgm_draw_sequence(Stream, S, 0, Tab1),
    eccs_gm_write(Stream, '>').
eccs_ispgm_draw_fs(Stream, set(S), Tab, Count) :-
    eccs_gm_tab(Stream, Tab),
    eccs_gm_write(Stream, '{'),
    Tab1 is Count +1,
    eccs_ispgm_draw_set(Stream, S, Tab1, Count), 
    eccs_gm_write(Stream, '}').
eccs_ispgm_draw_fs(Stream, sort(S), Tab, _Count) :-
    eccs_gm_tab(Stream, Tab), 
    eccs_gm_write(Stream, sort(S)).
eccs_ispgm_draw_fs(Stream, avm(Fvpairs), Tab, Count) :-
    eccs_gm_tab(Stream, Tab), 
    eccs_gm_write(Stream, '['), 
    Tab1 is Count+1, 
    eccs_ispgm_draw_fvpairs(Stream, Fvpairs, 0, Tab1), 
    eccs_gm_write(Stream, ']').  
eccs_ispgm_draw_fs(Stream, tagged(Tag, Object), Tab, Count) :-
    eccs_gm_tab(Stream, Tab),
    eccs_prlength(Tag, N),
    M is N + 1,
    NewCount is Count + M,
    eccs_gm_write(Stream, Tag),
    eccs_gm_write(Stream, '#'),
    eccs_ispgm_draw_fs(Stream, Object, 0, NewCount).
eccs_ispgm_draw_fs(Stream, tagged_avm(Tag, Fvpairs), Tab, Count) :-
    eccs_gm_tab(Stream, Tab),
    eccs_prlength(Tag, N), 
    eccs_gm_write(Stream, Tag),
    eccs_gm_write(Stream, '#['), 
    Tab1 is Count+2+N, 
    (Fvpairs = avm(X); Fvpairs = X), 
    !, 
    eccs_ispgm_draw_fvpairs(Stream, X, 0, Tab1), 
    eccs_gm_write(Stream, ']').  
eccs_ispgm_draw_fs(Stream, tag(T), Tab, _) :-
    eccs_gm_tab(Stream, Tab), 
    eccs_gm_write(Stream, ' #'),
    eccs_gm_write(Stream, T).  
eccs_ispgm_draw_fs(Stream, disj(Ds), Tab, Count) :-
    eccs_ispgm_draw_logic(Stream, disj, Ds, Tab, Count).
eccs_ispgm_draw_fs(Stream, conj(Ds), Tab, Count) :-
    eccs_ispgm_draw_logic(Stream, conj, Ds, Tab, Count).
eccs_ispgm_draw_fs(Stream, neg(N), Tab, Count) :- 
    eccs_gm_tab(Stream, Tab), 
    eccs_gm_write(Stream, '~'), 
    Tab1 is Count+1,
    eccs_ispgm_draw_fs(Stream, N, 0, Tab1).  
eccs_ispgm_draw_fs(Stream, impl(A, B), Tab, Count) :-
    eccs_ispgm_draw_logic(Stream, impl, [A, B], Tab, Count).  
eccs_ispgm_draw_fs(Stream, bicond(A, B), Tab, Count) :-
    eccs_ispgm_draw_logic(Stream, bicond, [A, B], Tab, Count).
eccs_ispgm_draw_fs(Stream, relation(R, Args), Tab, Count) :-
    eccs_gm_tab(Stream, Tab), 
    eccs_ispgm_draw_fs(Stream, R, 0, _),
    eccs_ispgm_atomic_prlength(R, N), 
    Tab1 is Count+1+N, 
    eccs_ispgm_draw_parenth(Stream, Args, 0, Tab1).
eccs_ispgm_draw_fs(Stream, parenth(Args), Tab, Count) :-
    eccs_ispgm_draw_parenth(Stream, Args, Tab, Count).  
eccs_ispgm_draw_fs(Stream, circle(Object), Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, Object, Tab, Count).  
eccs_ispgm_draw_fs(Stream, stack(Args), Tab, Count) :-
    eccs_ispgm_draw_stack_els(Stream, Args, Tab, Count).
eccs_ispgm_draw_fs(Stream, postfix(Op, Arg1), _Tab, _Count) :-
    eccs_ispgm_draw_fs(Stream, infix(Op, Arg1, atomic(''))).
eccs_ispgm_draw_fs(Stream, prefix(Op, Arg1), _Tab, _Count) :-
    eccs_ispgm_draw_fs(Stream, infix(Op, atomic(''), Arg1)).
eccs_ispgm_draw_fs(Stream, infix(Op, Arg1, Arg2), Tab, Count) :-
    (Op = symbol(A) -> eccs_dumb_symbol_name(A, Print);
	(Op = atomic(A) -> Print = A;
	    Op = italic(A) -> eccs_concat_list(['"', A, '"'], Print))),
    eccs_ispgm_atomic_prlength(Op, N),
    eccs_ispgm_draw_logic1(Stream, Print, [Arg1, Arg2], N, Tab, Count).
eccs_ispgm_draw_fs(Stream, tree(M, Ds), Tab, Count) :- 
    eccs_gm_tab(Stream, Tab), 
    (eccs_atomic_type(M, Str) ->
     (eccs_ispgm_draw_fs(Stream, M), 
      eccs_prlength(Str, N), 	 
      Tab1 is Count+N, 	 
      eccs_ispgm_draw_ds(Stream, Ds, 0, Tab1));
      eccs_ispgm_draw_fs(Stream, M), eccs_gm_nl(Stream), 
      eccs_ispgm_draw_ds1(Stream, Ds, Count, Count)).

/*

Additions Mon Feb 22 11:25:37 1993 JC For enhancements to SPF.  In the
case of the dumb filter, we can't do very much for any of these.

*/

eccs_ispgm_draw_fs(Stream, triangle(A), Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, A, Tab, Count). 
eccs_ispgm_draw_fs(Stream, hbox(As), Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, stack(As), Tab, Count).
eccs_ispgm_draw_fs(Stream, hbox(_Posn, Es), Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, stack(Es), Tab, Count).
eccs_ispgm_draw_fs(Stream, vbox(Es), Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, stack(Es), Tab, Count).
eccs_ispgm_draw_fs(Stream, vbox(_Posn, Es), Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, stack(Es), Tab, Count).
eccs_ispgm_draw_fs(_Stream, space(_, _), _, _) :- !.
eccs_ispgm_draw_fs(Stream, box(X), Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, X, Tab, Count).
eccs_ispgm_draw_fs(Stream, concat(Es), Tab, Count) :-
    eccs_ispgm_draw_fs_concat(Stream, Es, Tab, Count).
eccs_ispgm_draw_fs(Stream, over(X, Y), Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, over(X, Y, atomic('')), Tab, Count).
eccs_ispgm_draw_fs(Stream, over(X, Y, Tag), Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, X, Tab, Count),
    eccs_gm_nl(Stream),
    eccs_gm_tab(Stream, Tab),
    eccs_gm_write(Stream, '----------------------------------------'),
    eccs_ispgm_draw_fs(Stream, Tag, 0, 0),
    eccs_gm_nl(Stream),
    eccs_ispgm_draw_fs(Stream, Y, Tab, Count).
eccs_ispgm_draw_fs(Stream, hpsg_sort(Sort, SPF), Tab, Count) :-
    eccs_atomic_type(Sort, A),
    eccs_prlength(A, Alength),
    eccs_ispgm_draw_fs(Stream, Sort, Tab, Count),
    Count1 is Tab+Alength,
    eccs_ispgm_draw_fs(Stream, SPF, 0, Count1).
eccs_ispgm_draw_fs(Stream, prolog_list(H, T), Tab, Count) :-
    eccs_gm_tab(Stream, Tab),
    eccs_gm_write(Stream, '['),
    eccs_ispgm_draw_pllist(Stream, prolog_list(H, T), 0, Count+1),
    eccs_gm_write(Stream, ']').

eccs_ispgm_draw_pllist(Stream, prolog_list(H, T), Tab, Count) :-
    eccs_gm_tab(Stream, Tab), 
    eccs_ispgm_draw_fs(Stream, H, 0, Count),
    (T  = [] ->
        true
      ; (T = prolog_list(_, _) ->
      	     eccs_gm_write(Stream, ', '),
	     eccs_ispgm_draw_pllist(Stream, T, 0, Count+2)
	   ; eccs_gm_write(Stream, '|'),
	     eccs_ispgm_draw_fs(Stream, T, 0, Count+1))).

eccs_ispgm_draw_fs_concat(_, [], _Tab, _Count) :- !.
eccs_ispgm_draw_fs_concat(Stream, [E|Es], Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, E, 0, 0),
    eccs_ispgm_draw_fs_concat(Stream, Es, Tab, Count).



eccs_ispgm_draw_ds(_Stream, [], _, _).  
eccs_ispgm_draw_ds(Stream, [H|R], Tab, Count) :- 
    eccs_gm_tab(Stream, Tab), 
    eccs_gm_write(Stream, ' | '), 
    Tab1 is Count+3, 
    eccs_ispgm_draw_fs(Stream, H, 0, Tab1), 
    (R = [] -> true; eccs_gm_nl(Stream)), 
    eccs_ispgm_draw_ds(Stream, R, Count, Count).




eccs_ispgm_draw_fs_atomic(Stream, A) :- 
    eccs_sys_atomic(A), !,
    (A = [] -> Out = "[]"; Out = A),
    eccs_gm_write(Stream, Out).  

eccs_ispgm_draw_fvpairs(_Stream, [], _Tab, _Count) :-
    !.
eccs_ispgm_draw_fvpairs(Stream, [F = V], Tab, Count) :-
    !,
    eccs_gm_tab(Stream, Tab), 
    eccs_prlength(F, N), 
    eccs_gm_write(Stream, F), 
    eccs_gm_write(Stream, ': '), 
    Tab1 is Count+2+N,
    eccs_ispgm_draw_fs(Stream, V, 0, Tab1).  
eccs_ispgm_draw_fvpairs(Stream, [F = V|R], Tab, Count) :-
    !, 
    eccs_gm_tab(Stream, Tab), 
    eccs_prlength(F, N), 
    eccs_gm_write(Stream, F), 
    eccs_gm_write(Stream, ': '), 
    Tab1 is Count+2+N, 
    eccs_ispgm_draw_fs(Stream, V, 0, Tab1), 
    eccs_gm_write(Stream, ','), 
    eccs_gm_nl(Stream),
    eccs_ispgm_draw_fvpairs(Stream, R, Count, Count).
eccs_ispgm_draw_fvpairs(Stream, [H], Tab, Count) :- 
    !,
    eccs_ispgm_draw_fs(Stream, H, Tab, Count).
eccs_ispgm_draw_fvpairs(Stream, [H|R], Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, H, Tab, Count), 
    eccs_gm_write(Stream, ','), 
    eccs_gm_nl(Stream), 
    eccs_ispgm_draw_fvpairs(Stream, R, Count, Count).

eccs_ispgm_draw_sequence(_Stream, [], _Tab, _Count).
eccs_ispgm_draw_sequence(Stream, S, Tab, Count) :-
    eccs_ispgm_all_on_one_line(S), 
    !, 
    eccs_ispgm_draw_sequence1(Stream, S, Tab, Count).  
eccs_ispgm_draw_sequence(Stream, S, Tab, Count) :-
    eccs_ispgm_draw_sequence2(Stream, S, Tab, Count).

eccs_ispgm_draw_sequence1(Stream, [S], Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, S, Tab, Count).
eccs_ispgm_draw_sequence1(Stream, [F|R], Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, F, Tab, Count), 
    eccs_gm_write(Stream, ', '),
    eccs_ispgm_draw_sequence1(Stream, R, Tab, Count).

eccs_ispgm_draw_sequence2(Stream, [S], Tab, Count) :- 
    !,
    eccs_ispgm_draw_fs(Stream, S, Tab, Count).
eccs_ispgm_draw_sequence2(Stream, [F|R], Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, F, Tab, Count), 
    eccs_gm_write(Stream, ','),
    eccs_gm_nl(Stream), 
    eccs_ispgm_draw_sequence2(Stream, R, Count, Count).

eccs_ispgm_draw_set(Stream, S, Tab, Count) :- 
    eccs_ispgm_draw_sequence(Stream, S, Tab, Count).

eccs_ispgm_draw_logic(Stream, Type, Args, Tab, Count) :-
    eccs_ispgm_symbol(Type, Symbol), 
    eccs_prlength(Symbol, N), 
    Sep is N+2,
    _Tab1 is Count+Sep, % What's this for? - pjw 19.11.91
    eccs_ispgm_draw_logic1(Stream, Symbol, Args, Sep, Tab, Count).

eccs_ispgm_draw_logic1(Stream, _Symbol, [Arg], _Sep, Tab, Count) :- 
    !,
    eccs_ispgm_draw_fs(Stream, Arg, Tab, Count).
eccs_ispgm_draw_logic1(Stream, Symbol, [Arg|Args], Sep, Tab, Count) :-
    (eccs_ispgm_all_on_one_line([Arg]) -> 
        (eccs_prlength(Symbol, SLength), 
	eccs_atomic_type(Arg, A), 
	eccs_prlength(A, Alength), 
	Tab1 is Count + Alength + SLength +2,
	eccs_ispgm_draw_fs(Stream, Arg), 
	eccs_gm_write(Stream, ' '),
	eccs_gm_write(Stream, Symbol), 
	eccs_gm_write(Stream, ' '),
	eccs_ispgm_draw_logic1(Stream, Symbol, Args, Sep, 0, Tab1));
	(eccs_ispgm_draw_fs(Stream, Arg, Tab, Count), 
 	 eccs_gm_nl(Stream),
	 eccs_gm_tab(Stream, Count), 
	 eccs_gm_write(Stream, Symbol),
	 eccs_gm_nl(Stream), 
 	 eccs_ispgm_draw_logic1(Stream, Symbol, Args, Sep, Count, Count))).

eccs_ispgm_symbol(impl, '->').  
eccs_ispgm_symbol(bicond, '<->').
eccs_ispgm_symbol(disj, 'v').  
eccs_ispgm_symbol(conj, '&').

eccs_ispgm_draw_parenth(Stream, Args, Tab, Count) :- 
    eccs_gm_write(Stream, '('), 
    Tab1 is Count+1, 
    eccs_ispgm_draw_sequence(Stream, Args, Tab, Tab1),
    eccs_gm_write(Stream, ')').

eccs_ispgm_draw_stack_els(_Stream, [], _, _).

eccs_ispgm_draw_stack_els(Stream, [H|T], Tab, Count) :-
    eccs_ispgm_draw_fs(Stream, H, Tab, Count),
    eccs_gm_nl(Stream), 
    eccs_ispgm_draw_stack_els(Stream, T, Tab, Count).



eccs_ispgm_all_on_one_line([]).
eccs_ispgm_all_on_one_line([F|R]) :-
    eccs_ispgm_on_one_line(F),
    eccs_ispgm_all_on_one_line(R).

eccs_ispgm_on_one_line(X) :-
    eccs_atomic_type(X, _).
eccs_ispgm_on_one_line(uninstantiated).

eccs_ispgm_atomic_prlength(atomic(A), N) :-
    eccs_prlength(A, N).
eccs_ispgm_atomic_prlength(symbol(S), N) :-
    eccs_dumb_symbol_name(S, Print),
    eccs_prlength(Print, N).
eccs_ispgm_atomic_prlength(italic(I), N) :-
    eccs_prlength(I, M),
    N is M + 2.
    

/*

Low level primitives

*/

eccs_gm_nl(gm_out(_, Text)) :-
    gmsend(Text, insert(format('~n', []))).
eccs_gm_tab(gm_out(_, Text), N) :-
    gmsend(Text, insert(format('~*c', [N, 0' ]))).
eccs_gm_write(gm_out(_, Text), T) :-
    gmsend(Text, insert(T)).
eccs_gm_string(gm_out(_, Text), String) :-
    gmsend(Text, insert(String)).

/*

close

*/

eccs_close_window(Handle) :-
    Handle = gm_out(Window, _),
    gmsend(Window, close).

/*

There is a problem with text windows, in that there is no way to move
the cursor to the end of the window for the next insertion.  A
workaround which seems to be OK under 2.1#6, is to move down by an
arbitrarily large amount.  This doesn't introduce extra lines.  

*/

eccs_gm_position_at_end(Text) :-
    gmsend(Text, moveby(1000000, 0)).

/*

gm_flush_events moved here from pdc.pl, as we need it for select1
style menus.

*/

gm_flush_events :-
    eccs_sys_repeat,
    nextevent(X),
    X == noevent, !.


/*

Wed Apr  7 15:36:34 1993 JC

The following is a temporary definition, referred to only in
(overview)Known Problems and Bugs, as a work around for not being able
to select and copy bits of text from the output window.


eccs_gm_grab_text(Text)

Text is instantiated to a string if some part of the Pleuk Output
Window is selected.  Fails if no area is selected or if ispgm_utls is
not loaded.

Note that we don't attempt to translate the string to an atom.  We
would have to check whether Text is short enough to be an atom and
it's not clear what to do if it isn't.

eccs_gm_grab_text(Text), eccs_print_string(Text).

will print the selection to the current output stream.  

*/


eccs_gm_grab_text(Text) :-
    eccs_global_variable(eccs_window_system, 'X'),
    eccs_sys_current_predicate(started, gmlib:started),
    eccs_sys_call(started), 
    eccs_global_variable(eccs_output_file_handle, Stream),
    !,
    eccs_gm_text(Stream, TextB),
    gmsend(TextB, in(selection, Text1)),  % according to the GM doc,
					  % Text1 should be uninstantiated
    Text = Text1,
    \+ (Text = []).
    
