/*
rcsid('$Id: ispgm_utls.pl,v 1.0 1993/04/26 16:19:18 pleuk Exp $').
$Log: ispgm_utls.pl,v $
% Revision 1.0  1993/04/26  16:19:18  pleuk
% Version 1.00beta from Jo
%

File:	/home/dk2/jcalder/Pleuk/Code/ispgm_utls.pl
Date:	Wed Sep 23 11:08:23 1992
By:	Jo Calder


This file is a minor adaptation of SICStus's library(gmlib).  The
reason for the changes is that gm/opdefs defines a bunch of operators,
most notably =>, and this goes against the policy of not having the fb
define any nonstandard ops.  While there is a comment in the 2.1
manual to the effect that the operator file does not have to be
loaded, assumptions made elsewhere require at least that any loading
of foreign files be done in the library directory.  Therefore, we have
to work out where that directory is.  That's the reason for the
begining of the file.  We also define gm_ensure_running/0 in this
file.  In other respects the following copyright notice applies:

Copyright(C) 1991, Swedish Institute of Computer Science

*/

:- absolute_file_name('', CWD), asserta(temp_note_of_working_dir(CWD)).

/*

Match a library directory against 

.*icstus.*library

*/

:- library_directory(X), Tail1 = "icstus", Tail2 = "library",
    name(X, L),
    eccs_append(L1, Tail2, L),
    eccs_append(L2, L3, L1),
    eccs_append(_, Tail1, L2), !,
    unix(cd(X)).

:- module(gmlib, [
	gm_ensure_running/0,		% Thu Oct 15 14:24:15 1992 JC
	gmsend/2, 
	gmcreate/2,
	start/0,
	start/1,
	start/2, 
	end/0,
	nextevent/1, 
	waitevent/1,
	closeall/0, 
	freeall/0,
	started/0, 
	gmexist/1
		 ]).

/* :- ensure_loaded('gm/opdefs'). */

:- ensure_loaded('gm/load_ff').
:- load_foreign_files(['gm/procomm.o'], []),
   abolish(foreign_file,2),
   abolish(foreign, 3).

:- ensure_loaded('gm/gmlib').



gm_ensure_running :- 
    (started -> true; start).



:- user:temp_note_of_working_dir(CWD), unix(cd(CWD)),
   abolish(user:temp_note_of_working_dir/1).
