/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:20:58 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pcounter.pl,v $',
	'$State: Exp $').

$Log: pcounter.pl,v $
% Revision 1.0  1993/04/26  16:20:58  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:08:05  pleuk
% *** empty log message ***
%
% Revision 0.2  1991/07/15  09:26:13  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/*

File:	/home/user2/jo/Pleuk/Code/pcounter.pl
Date:	Mon Jun 18 18:26:25 1990
By:	Jonathan Calder

Counters 

eccs_set_counter(Counter, Value)
eccs_counter(Counter, Value)
eccs_increment(Counter, Value)
eccs_zero(Counter)

Calling eccs_increment(Counter, Value) instantiates Value to its value 
after the increment.

Counters are stored in the primary database as instances of

eccs_pleuk_counter(Name, Value)

*/

:- dynamic eccs_pleuk_counter/2.

eccs_set_counter(Name, Value) :-
    eccs_sys_if_then_else(eccs_sys_var(Name), eccs_error([eccs_pleuk_counter/2, variable, counter, name]), true),
    eccs_sys_if_then_else(eccs_sys_integer(Value), true, eccs_error([illegal, value, for, counter, Value])),
    !,
    eccs_sys_retractall(eccs_pleuk_counter(Name, _)),
    eccs_sys_assert(eccs_pleuk_counter(Name, Value)).

eccs_counter(Counter, Value) :-
    eccs_pleuk_counter(Counter, Value).

eccs_increment(Counter, New) :-
    eccs_counter(Counter, Value),
    eccs_succ(Value, New),
    eccs_set_counter(Counter, New).

eccs_zero(Counter) :-
    eccs_set_counter(Counter, 0).

