/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:21:18 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pdatabase.pl,v $',
	'$State: Exp $').

$Log: pdatabase.pl,v $
% Revision 1.0  1993/04/26  16:21:18  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:08:05  pleuk
% *** empty log message ***
%
% Revision 0.3  1991/07/15  09:26:33  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.2  1991/05/21  14:21:35  kwh
% access to file attributes modified.
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/*

Database  manipulation

eccs_store_in_database(FileName, ObjType, Name, Read, Compiled, Dependencies)

Make a note in the prolog database of the result of compilation.  


*/

eccs_store_in_database(FileName, ObjType, Name, _Read, Compiled, _Dependencies) :-
    eccs_sys_if_then_else(eccs_global_variable(assertion_args, Args), true, Args = []),
    eccs_add_to_database(Name, Name, ObjType, FileName, Compiled).

/*

This code is now dead, which fact accounts for the coinstantiation 
of Name in the last line above.  


eccs_make_key(ObjType, Name, Compiled, Args, Goodkey)

Determine what is to be the principal functor of the term we store.  
user modifiable if user_make_key/6 defined.

:- dynamic user_make_key/5.

eccs_make_key(ObjType, Name, Compiled, Args, Goodkey) :-
    user_make_key(ObjType, Name, Compiled, Args, Goodkey), !.
eccs_make_key(_, Name, _, _, Name).


*/

/*

Dead code commented out. JC Mon Jul 29 18:21:48 1991. 

eccs_add_to_database(GoodKey, Name, ObjType, FileName, Compiled) :-
    eccs_global_variable(use_secondary_database, true), !,
    eccs_sys_recordz(GoodKey, '$pleukobj$'(Name, FileName, Compiled), _Ref),
    eccs_secondary_key(GoodKey, Name, ObjType, FileName, Compiled). 

The argument GoodKey is here for historical reasons.  It will always
be the same as Name.

*/


eccs_add_to_database(Name, _GoodKey, ObjType, FileName, Compiled) :-
    eccs_current_context(Context),
    eccs_once(eccs_object_db_table(ObjType, DBType)),
    Term =.. [DBType, Name, Context, FileName, Compiled],
    eccs_sys_assertz(Term).

eccs_expunge_file(_File) :-
    eccs_global_variable(use_secondary_database, true), !,
    true.
eccs_expunge_file(File) :-
    (eccs_current_file(File, _),
     eccs_set_file_attributes(File, [state=expunged]),
     eccs_current_object_type(Type),
     eccs_object_db_table(Type, DBType),
     NewTerm =.. [DBType, _, _, File, _],
     clause(NewTerm, _, Ref),
     eccs_sys_erase(Ref), fail; true).

eccs_expunge_definition(Name) :-
    setof(Key, Type^(eccs_current_object_type(Type),
    		       Term =.. [Type, Key, _, _],
		       eccs_possible__object_name(Key, Name)), Names),
    (eccs_current_object_NewType(NewType),
    NewTerm =.. [NewType,  NewName, _, _],
    eccs_member(NewName, Names),
    clause(NewTerm, _, Ref),
    eccs_sys_erase(Ref), fail; true).

eccs_delete_all_definitions :-
    eccs_do_menu(confirm, [ alert ='Really delete all current definitions?']),
    (eccs_expunge_file(_), fail; true),
    eccs_file_window_goal(eccs_file_status).
eccs_delete_all_definitions.

eccs_definition_in_file(FileName, Term) :-
    eccs_current_object_type(Type),
    eccs_object_db_table(Type, DBType),
    Term =.. [DBType, _Key, _Name, FileName, _Object],
    eccs_sys_clause(Term, _).

/*

eccs_get_from_database(ObjType, Name, Object) 

There is an entry in the database of type ObjType, with Name and definition Object

eccs_get_from_databaser(ObjType, Name, Object, DBRef) 

As above, but DBRef is the prolog database reference under which the object is stored. 

eccs_get_from_databasef(ObjType, Name, Object, File) 

As above but with the file name File of the defining file.  

eccs_get_from_database(+Key, +ObjType, ?Name, +Args, -Object)

----------------------------------------------------------------------

JC Mon Jul 29 18:23:33 1991

Changes for contexts.  

*/

eccs_get_from_database(ObjType, Name, Object) :-
    eccs_get_from_database(_Key, ObjType, Name, [], Object).

eccs_get_from_databaser(ObjType, Name, Object, DBRef) :-
    eccs_get_from_databaser(_Key,  ObjType, Name, [], Object, DBRef).

/*

Thu Sep 17 14:11:20 1992 JC

Name in the following =.. was in the wrong position.

*/

eccs_get_from_databasef(ObjType, Name, Object, File) :-
    eccs_object_db_table(ObjType, DBType),
    Term =.. [DBType, Name, _, File, Object],
    eccs_sys_clause(Term, _).

/*
eccs_get_from_database(Key, _ObjType, Name, _Args, Object) :-
    eccs_global_variable(use_secondary_database, true), !,
    eccs_sys_recorded(Key, '$pleukobj$'(Name, _FileName, Object), _).
*/

eccs_get_from_database(_Key, ObjType, Name, _Args, Object) :-
    eccs_object_db_table(ObjType, DBType),
    Term =.. [DBType, Name, Context, _FileName, Object],
    eccs_verify(Term), 
    call(Term),
    eccs_available_context(Context).

/*

eccs_get_from_databaser(Key,  _ObjType, Name, [], Object, DBRef) :-
    eccs_global_variable(use_secondary_database, true), !,
    eccs_sys_recorded(Key, '$pleukobj$'(Name, _FileName, Object), DBRef).
*/    
eccs_get_from_databaser(_Key,  ObjType, Name, [], Object, DBRef) :-
    eccs_object_db_table(ObjType, DBType),
    Term =.. [DBType, Name, Context, _FileName, Object],
    eccs_sys_clause(Term, _, DBRef),
    eccs_available_context(Context).


eccs_get_from_databaserf(_Key,  ObjType, Name, [], Object, DBRef, FileName) :-
    eccs_object_db_table(ObjType, DBType),
    Term =.. [DBType, Name, Context, FileName, Object],
    eccs_sys_clause(Term, _, DBRef),
    eccs_available_context(Context).



/*

eccs_db_retractall(ObjType, Name, Defn)

Delete all things stored in the database of object type ObjType,
name Name and definition Defn.

*/

eccs_db_retractall(ObjType, Name, Defn) :-
    eccs_get_from_databaser(_Key,  ObjType, Name, [], Defn, DBRef),
    eccs_sys_erase(DBRef),
    fail.
eccs_db_retractall(_, _, _).


/*

eccs_erase_all(Key)

erase all database entries with Key

*/


eccs_erase_all(Key) :-
  eccs_sys_recorded(Key,_,Ref),
  eccs_sys_erase(Ref),
  fail.
eccs_erase_all(_).

/*

eccs_store_intermediate_result(Key, Object)

*/

eccs_store_intermediate_result(Key, Object) :-
    eccs_global_variable(eccs_safe_key, X),
    eccs_concat(X, Key, SafeKey),
    eccs_sys_record(SafeKey, Object, _).

eccs_erase_intermediate_results(Key) :-
    eccs_global_variable(eccs_safe_key, X),
    eccs_concat(X, Key, SafeKey),
    (eccs_sys_recorded(SafeKey, _, Ref), eccs_sys_erase(Ref), fail).
eccs_erase_intermediate_results(_Key).

eccs_intermediate_result(Key, Result) :-
    eccs_global_variable(eccs_safe_key, X),
    eccs_concat(X, Key, SafeKey),
    eccs_sys_recorded(SafeKey, Result, _).

eccs_intermediate_result(Key, Result, Ref) :-
    eccs_global_variable(eccs_safe_key, X),
    eccs_concat(X, Key, SafeKey),
    eccs_sys_recorded(SafeKey, Result, Ref).
