/*
rcsid('$Id: pdc.pl,v 1.0 1993/04/26 16:21:55 pleuk Exp $').
$Log: pdc.pl,v $
% Revision 1.0  1993/04/26  16:21:55  pleuk
% Version 1.00beta from Jo
%

File:	/home/dk2/jcalder/Pleuk/Code/pdc.pl
Date:	Thu Sep  3 14:27:48 1992
By:	Jo Calder

Support for a derivation checker.


*/

:- eccs_ensure_variable(dc_window_size, [800, 500],
	printing, run,
	"the default window size for the derivation checker").


/*

We organize the window interaction by making sure that the first entry
in the database for dc_window_handle/2 is the current window.

*/

:- dynamic dc_window_handle/2.

dc_current_window(Name, Handle) :- 
    dc_window_handle(Name, Handle), !.

dc_make_current_window(Name) :-
    eccs_sys_retract(dc_window_handle(Name, Handle)), !,
    eccs_sys_asserta(dc_window_handle(Name, Handle)).


dc_start :-
    eccs_windows_available(_), 
    eccs_global_variable(use_windows, true), 
    eccs_global_variable(eccs_spec_supports_dc, true), 
    !,
    (eccs_known_predicate(spec_dc_start_ok) -> 
	spec_dc_start_ok; true),
    dc_do_windows,
    dc_start_interact_loop.

dc_start :-
    eccs_error([no, windows, available]).

dc_resume :-
    dc_raise_all,
    dc_start_interact_loop.

dc_raise_all :-
    dc_window_handle(_, gm_view_handle(W, _)),
    gmsend(W, raise),
    gmsend(W, deiconify), fail.
dc_raise_all.

dc_iconify_all :-
    dc_window_handle(_, gm_view_handle(W, _)),
    gmsend(W, iconify), fail.
dc_iconify_all.

dc_do_windows :-
    eccs_known_predicate(spec_windows/1), !,
    spec_windows(Ws),
    dc_do_windows(Ws).
dc_do_windows :-
    dc_do_windows([window('Derivation Window')]).

dc_do_windows(L) :-
    eccs_member(W, L),
    dc_do_window(W), fail.
dc_do_windows(_).

dc_do_window(window(Name)) :-
    eccs_global_variable(dc_window_size, [X, Y]),
    dc_make_view(Name, X, Y, _).
dc_do_window(window(Name, [X, Y])) :-
    !,
    dc_make_view(Name, X, Y, _).
dc_do_window(window(Name, Initial)) :-
    eccs_global_variable(dc_window_size, [X, Y]),
    dc_make_view(Name, X, Y, _Handle),
    dc_initialize(Initial).
dc_do_window(window(Name, [X, Y], Initial)) :-
    dc_make_view(Name, X, Y, _Handle),
    dc_initialize(Initial).


dc_make_view(Name, X, Y, Handle) :-
    Handle = gm_view_handle(W, V),
    gmcreate(V, view(X, Y)),
    gmcreate(W, window(Name, scroller(V))),
    gmsend(W, open),
    gmsend(V, enable),
    eccs_sys_asserta(dc_window_handle(Name, Handle)),
    eccs_sys_retractall(dc_next_insert_position(Name, _, _)),
    dc_add_menu(Name).
    
/*


dc_initialize(Description)

Add things which match Description to current window. 


*/

dc_initialize(type(Type)) :-
    spec_dc_prepare(Type, _Name, Tag, Print),
    dc_output(Tag, Print), fail.
dc_initialize(name(Type, Name)) :-
    spec_dc_prepare(Type, Name, Tag, Print),
    dc_output(Tag, Print), fail.
dc_initialize(_).

dc_close_window(Name) :-
    eccs_sys_retract(dc_window_handle(Name, gm_view_handle(W, _))),
    gmsend(W, close), 
    fail.
dc_close_window.

dc_close_all_windows :-
    dc_close_window(_), fail.
dc_close_all_windows :-
    dc_zap_dynamics.
dc_close_all_windows.

dc_zap_dynamics :-
    eccs_member(F/N, 
       [dc_window_handle/2,
	dc_object/7,
	dc_next_insert_position/3,
	dc_sensitive/6,
	dc_quitting/0,
	dc_last_selection/1,
	dc_last_selected_window/1,
	dc_derivation_state/1]),
    eccs_sys_functor(T, F, N),
    eccs_sys_retractall(T),
    fail.

/*

The last couple of lines below require that there is no reference in
some other window to the object we are deleting from this window.  If
there is not, we ask the specialization to delete the object.

*/

dc_clear_window(Name) :-
    dc_window_handle(Name, gm_view_handle(_, V)),
    gmsend(V, clear),
    eccs_sys_functor(T, dc_sensitive, 6),
    eccs_sys_arg(1, T, Name),
    eccs_sys_retractall(T),
    eccs_sys_functor(InsertPosn, dc_next_insert_position, 3),
    eccs_sys_arg(1, InsertPosn, Name),
    eccs_sys_retractall(InsertPosn),
    (Name = 'Derivation Window' -> 
    	(eccs_sys_retractall(dc_last_selection(_)), 
	 dc_deselectall)
	 ;true),
    (eccs_sys_functor(T1, dc_object, 7),
     eccs_sys_arg(2, T1, Name),
     eccs_sys_arg(1, T1, Tag),
     eccs_sys_retract(T1),
     (\+ (dc_object(Tag, OtherW, _, _, _, _, _),
           \+ (OtherW = Name))), 
     spec_delete_object(Tag), fail; true).

dc_output(Tag, Print) :-
    dc_add_object(Tag, Print).

/*

dc_object(Tag, WName, Ref, X, Y, W, Z)

A record of an object in the derivation checker, X, Y, W, Z, give the
locations of a bounding box for SPF (made slightly larger than the
printed version), and the absolute coordinates of the printed object.
Tag is a specialization-dependent name for the object.  Ref is the
graphics system identifier for the object.

*/

:- dynamic dc_object/7.

dc_add_object(Tag, SPF) :-
    dc_add_object(Tag, SPF, _OHandle).

dc_add_object(Tag, SPF, OHandle) :-
    eccs_dummy_window(_Window, Handle),
    eccs_gm_spf_metrics(SPF, Handle, Metrics, [X, Y]),
    dc_current_window(WName, _),
    dc_position(WName, Tag, X, Y, XOrigin, YOrigin),
    eccs_gm_draw_object([XOrigin, YOrigin], SPF, Metrics, OHandle),
    Left is XOrigin - 15,
    Right is XOrigin + X + 15,
    Bottom is YOrigin - 15,
    Top is YOrigin + Y + 15,
    eccs_sys_assertz(dc_object(Tag, WName, OHandle, Left,Bottom,Right, Top)),
    (eccs_member(WName, ['Scratch']) ->
	(dc_window_handle(WName, gm_view_handle(_, V)),
	 gmsend(V, scrollto(XOrigin, YOrigin)))
       ; true).


/* Wed Feb 17 12:29:53 1993 JC The following should really be made
into a variable somehow. */

dc_max_window_size(900, 600).  

dc_check_max_wsize(NeededX, NeededY, UseX, UseY) :-
    dc_max_window_size(MaxX, MaxY),
    (MaxX < NeededX -> UseX = MaxX; UseX = NeededX),
    (MaxY < NeededY -> UseY = MaxY; UseY = NeededY).

/*

dc_display_object(Name, SPF)

Bring up a window displaying SPF.  

If a Caption is given through SPF, use that as the title for the
window; if not and Name is given, use Name; otherwise, use 
'DC untitled'.

*/

dc_display_object(Name, SPF) :-
    dc_current_window(OldW, _),
    (SPF = captioned(Cap, Object); Object = SPF), !,
    (eccs_sys_var(Cap) ->
	(eccs_sys_var(Name) -> 
	    Title = 'DC untitled'
	  ; Title = Name)
      ; Title = Cap),
    eccs_dummy_window(_Window, Handle),
    eccs_gm_spf_metrics(SPF, Handle, Metrics, [X, Y]),
    eccs_view_string_measure(atomic, Title, W),
    WReal is 45 + W,
    XB is X+20+15,	% The scrollers appear to occupy the view, rather 
    YB is Y+20+15,	% than the window.  Add in a top and right border.
    eccs_sys_max(WReal, XB, RealX),
    dc_check_max_wsize(RealX, YB, UseX, UseY),
    dc_make_view(Title, UseX, UseY, _Handle),
    eccs_gm_draw_object([15, 15], Object, Metrics, _OHandle),
    dc_make_current_window(OldW).



dc_position(WName, _, XObj, _YObj, XO, YO) :-
    eccs_sys_retract(dc_next_insert_position(WName, X, Y)), !,
    (X + XObj > 900 -> 
	(findall(Top, dc_object(_, WName, _, _, _, _, Top), Tops),
	 dc_max_of_list(Tops, Max),
	 XO = 15, YO = Max)
	;XO = X, YO = Y),
    XNext is XO + XObj + 30,
    eccs_sys_assertz(dc_next_insert_position(WName, XNext, YO)).
dc_position(WName, _, XObj, _, 15, 15) :-
    XNext is 30 + XObj,
    eccs_sys_assertz(dc_next_insert_position(WName, XNext, 15)).
    
    
:- dynamic dc_next_insert_position/3.



dc_delete_object(Tag) :-
    eccs_sys_retract(dc_object(Tag, WName, Handle, Left, Bottom, Right, Top)),
    dc_window_handle(WName, gm_view_handle(_, VH)),
    gmsend(VH, remove(Handle)), 
    Goal = dc_sensitive(WName, X, Y, XMax, YMax, _),
    eccs_sys_call(Goal), 
    X >= Left, Y >= Bottom, XMax =< Right, YMax =< Top,
    eccs_sys_retract(Goal),
    fail.
dc_delete_object(_Tag) :-
    eccs_sys_retractall(dc_last_selection(_)).

dc_delete_all_objects :-
    dc_delete_object(_), fail.
dc_delete_all_objects.


dc_max_of_list([], 0).
dc_max_of_list([H|T], Max) :-
    dc_max_of_list(T, SoFar),
    eccs_sys_max(H, SoFar, Max).


dc_fix_caption(captioned(_, Result1), Result1) :- !.
dc_fix_caption(R, R).

spec_lemma_to_object(L, Obj) :-
    arg(1, L, M),
    dc_rule_to_tree(L, M, [], Obj).

/*

In order to interpret mouse events in the dc, we use the following set
up.

We add to the specification of SPF the type 

sensitive(SPF, Action)

where SPF is any valid SPF term, and Action is the action to be
performed when a mouse down is detected in the area where SPF is
printed.  SPF' below refers to this extended definition.

Action is drawn from the following:

select(Tag)
             -- Tag is a specialization-dependent tag for some object, 
                The Tag is asserted as the argument of 
		a term dc_last_selection.  
		spec_report_selection(Tag) is called. 

insert_selection(Key, Tag) 
             -- Key and Tag are terms in a specialization-dependent 
	        format, which specify an object Tag in which an insertion 
		is to be made at a position identified by Key. 

A specialization is responsible for defining the following operations:

spec_dc_prepare(+Type, +Name, -Tag, -Result)

Type is likely to be one of the types defined by the grammar and may
also be any specialization defined identifier for partial derivations,
etc.

Name is the name of something of that type,

Tag is a specialization defined reference to the object whose print
form is Result.

Result is an SPF' term appropriately annotated for possible selections
and possible insertion points.

spec_dc_do_insert(Key, Term, CurrentSelection, Results) 

where Key and Term are as in insert_selection above.  CurrentSelection
is the currently selected element.

Results is a description of some sequence of actions to be performed.
The format of the Results field is drawn from

new_object(Name, Object)
                -- 
next_selection(Object)

List (perform

The reason for the asserta here is that we take record the sensitive
areas from larger to smaller.  If a user wants one sensitive area to
lie within another, then we can avoid a lot of pain by storing the
enclosed sensitive areas before the enclosing.  As the term
representing the smaller area will be matched against before that
representing the larger area, we can match, test and cut, and be
certain of getting the smallest area which encloses the point of mouse
down.

*/
:- dynamic dc_sensitive/6.

dc_record_sensitive(X, Y, XMax, YMax, Action) :-
    X1 is X, Y1 is Y, XMax1 is XMax, YMax1 is YMax,
    dc_current_window(Window, _),
    eccs_sys_asserta(dc_sensitive(Window, X1, Y1, XMax1, YMax1, Action)).


dc_action :-
    dc_window_event(E),
    dc_interpret_window_event(E).

dc_window_event(E) :-
    eccs_sys_asserta(eccs_critical_interrupt),
    waitevent(E),
    eccs_sys_retractall(eccs_critical_interrupt).

dc_interpret_window_event(menu(W, Option)) :-
    dc_window_handle(Name, gm_view_handle(W, _V)),    
    dc_do_menu(Name, Option), !.
dc_interpret_window_event(down(W, V, X, Y)) :-
    dc_window_handle(Name, gm_view_handle(W, V)),
    (dc_find_action(Name, X, Y, A) -> dc_interpret(A); true), !.
dc_interpret_window_event(_).

/*

dc_find_action(Window, X, Y, Action)

Action is the action associated with the smallest sensitive area that
includes X, Y.  See the comments above, under dc_record_sensitive for
why this works.

*/

:- dynamic dc_last_selected_window/1.

dc_find_action(Window, X, Y, A) :-
    eccs_sys_retractall(dc_last_selected_window(_)),
    dc_sensitive(Window, X1, Y1, W, Z, Action),
    X >= X1,
    Y >= Y1,
    X =< W,
    Y =< Z, 
    Action = A, !,
    eccs_sys_assert(dc_last_selected_window(Window)).
dc_find_action(Window, X, Y, Action) :- 
    dc_object(Tag, Window, _, X1, Y1, W, Z),
    X >= X1,
    Y >= Y1,
    X =< W,
    Y =< Z, !,
    Action = select(Tag),
    eccs_sys_assert(dc_last_selected_window(Window)).

dc_do_menu(_, dc_stop) :-
    !,
    eccs_sys_assert(dc_quitting),
    dc_iconify_all.
dc_do_menu(Name, dc_reset) :-
    !,
    dc_clear_window(Name).
dc_do_menu(_, Goal) :-
    eccs_sys_call(Goal).

:- dynamic dc_quitting/0.

dc_start_interact_loop :-
    dc_window_handle(_, _), !,
    gm_flush_events,
    eccs_sys_retractall(dc_quitting),
    dc_interact_loop.

dc_interact_loop :-
    eccs_sys_repeat,
    (eccs_global_variable(prolog_type, sicstus) -> garbage_collect; true),
    (dc_quitting -> !;
        eccs_once((dc_loop_setup, dc_action)),
	fail).

:- dynamic dc_last_selection/1.

dc_interpret(X) :-
    eccs_known_predicate(spec_interpret_dc_action/2),
    spec_interpret_dc_action(X, Results),
    !,
    dc_interpret_results(Results).
dc_interpret(select(Tag)) :-
    eccs_sys_retractall(dc_last_selection(_)),
    eccs_sys_assertz(dc_last_selection(Tag)),
    dc_highlight(Tag),
    spec_report(selection(Tag)).
dc_interpret(insert_selection(Key, Tag)) :-
    (dc_last_selection(X) -> true;
        eccs_warning([no, object, is, selected]), fail),
    spec_report(insertion_attempt(X, Key, Tag)),
    spec_dc_do_insert(Key, Tag, X, Results),
    dc_interpret_results(Results).
    
dc_interpret_results(Var) :-
    eccs_sys_var(Var), !,
    eccs_message([no, results, passed, to, derivation, checker]).
dc_interpret_results(Results) :-
    dc_clear_window('Derivation Window'),
    (Results = [_, _|_] -> 
	eccs_length(Results, N),
	eccs_message([N, derivations, result, from, last, insertion])
      ; true),
    dc_interpret_results1(Results).

dc_interpret_results1(derivation(Tag, Print)) :-
    !,
    dc_current_window(W, _),
    dc_make_current_window('Derivation Window'),
    dc_add_object(Tag, Print),
    dc_make_current_window(W).
dc_interpret_results1(List) :-
    List = [_|_],
    !,
    (eccs_member(Result, List),
     dc_interpret_results1(Result),
     fail
    ; true).

/*

Menu for derivation window.

*/

dc_add_menu(WName) :-
    eccs_once(dc_window_handle(WName, gm_view_handle(_, V))),
    dc_build_menu(WName, Menu),
    gmcreate(MenuRef, Menu),
    gmsend(V, setmenu(MenuRef)),
    fail.
dc_add_menu(_WName).

:- dynamic dc_derivation_state/1.

dc_build_menu(WName, menu(Options, Messages)) :-
    dc_all_options(AllOptions, WName),
    (eccs_known_predicate(spec_dc_options/1) ->
    	(spec_dc_options(L), eccs_append(L, AllOptions, Options1));
	Options1 = AllOptions),
    dc_build_menu(Options1, Options, Messages).

dc_build_menu([], [], []).
dc_build_menu([option(O, M)|OMs], [O|Os], [M|Ms]) :-
    !,
    dc_build_menu(OMs, Os, Ms).
dc_build_menu([option(O, M, Goal)|OMs], [O|Os], [M|Ms]) :-
    eccs_sys_call(Goal), !,
    dc_build_menu(OMs, Os, Ms).
dc_build_menu([_OM|OMs], Os, Ms) :-
    dc_build_menu(OMs, Os, Ms).

dc_all_options(
   [
    option('open scratch window', dc_raise_scratch_window, \+ WName = 'Scratch'),
    option('open derivation window', dc_raise_d_window, \+ WName = 'Derivation Window'),
    option('add partial derivations', dc_partial_derivs, WName = 'Scratch'),
    option('copy selection to scratch window',   dc_copy, Selection),
    option('print selection', dc_print, Selection),
    option('show selection', dc_show_selection, Selection),
    option(reset, dc_reset, (DWorScratch, NonEmpty)),
    option('return to Pleuk', dc_stop)|Tail], WName) :-
	Selection = dc_last_selection(_),
	DWorScratch = eccs_member(WName, [ 'Derivation Window', 'Scratch']),
	Empty = (\+ dc_object(_, WName, _, _, _, _, _)),
	NonEmpty = (\+ Empty),
	Tail = [option('help', dc_do_help(File, Node))],
	dc_find_help_info(File, Node).

dc_find_help_info(File, Node) :-
    eccs_sys_safe_call(spec_dc_help(File, Node)), !.
dc_find_help_info('interface', 'DC-online').

dc_do_help(File, Node) :-
    eccs_xinfo(File, Node).



dc_raise_scratch_window :-
    dc_ensure_scratch,
    dc_window_handle('Scratch', gm_view_handle(W, _)), !,
    gmsend(W, raise),
    gmsend(W, deiconify).

dc_raise_d_window :-
    dc_window_handle('Derivation Window', gm_view_handle(W, _)), !,
    gmsend(W, raise),
    gmsend(W, deiconify).


dc_ensure_scratch :-
    dc_window_handle('Scratch', _), !.
dc_ensure_scratch :-
    dc_make_view('Scratch', 100, 100, _).

dc_copy :- 
    dc_last_selection(X),
    dc_copy_to_scratch(X).

dc_copy_to_scratch(Tag) :-
    dc_ensure_scratch,
    spec_dc_prepare(Tag, Print),
    dc_current_window(W, _Handle),
    dc_make_current_window('Scratch'),
    dc_output(Tag, Print),
    dc_make_current_window(W).


dc_print :-
    dc_last_selection(Sel),
    spec_tag2strictspf(Sel, SPF),
    eccs_dc_hardcopy(SPF).

dc_filter_sensitive(A, A) :-
    eccs_sys_atomic(A), !.
dc_filter_sensitive(sensitize(S, _), SPF) :-
    !,
    dc_filter_sensitive(S, SPF).
dc_filter_sensitive(SPF1, SPF) :-
    eccs_sys_functor(SPF1, F, N),
    eccs_sys_functor(SPF, F, N),
    dc_filter_sensitive(0, N, SPF1, SPF).

dc_filter_sensitive(N, N, _, _).
dc_filter_sensitive(I, N, SPF1, SPF) :-
    I < N,
    eccs_succ(I, J),
    eccs_sys_arg(J, SPF1, A1),
    eccs_sys_arg(J, SPF, A),
    dc_filter_sensitive(A1, A),
    dc_filter_sensitive(J, N, SPF1, SPF).

dc_show_selection :-
    dc_last_selection(Tag),
    dc_object(Tag, Window, _, X, Y, _, _), !,
    dc_window_handle(Window, gm_view_handle(WH, VH)),
    gmsend(WH, raise),
    gmsend(VH, scrollto(X, Y)).
dc_show_selection.

dc_partial_derivs :-
    (eccs_do_menu(confirm, [alert = 'Add a lexical entry?']) ->
        spec_add_lexical(Tag, SPF)
      ; (eccs_do_menu(confirm, [alert = 'Add a parse?']) ->
             spec_add_parse(Tag, SPF)
	   ; fail)),
    dc_output_to_scratch(Tag, SPF), fail.
dc_partial_derivs.

dc_output_to_scratch(Tag, SPF) :-
    dc_ensure_scratch,
    dc_current_window(W, _Handle),
    dc_make_current_window('Scratch'),
    dc_output(Tag, SPF),
    dc_make_current_window(W).


/*

dc_loop_setup

called each time we before getting the next action.

*/


dc_loop_setup :-
    (dc_last_selection(_) -> Cursor = crosshairs; Cursor = defaultCursor),
    dc_window_handle(_, gm_view_handle(_, V)),
    gmsend(V, setcursor(Cursor)),
    fail.
dc_loop_setup :-
    dc_redo_menus.

dc_redo_menus :-
    dc_window_handle(WName, _),
    dc_add_menu(WName),
    fail.
dc_redo_menus.
    


/*

Highlighting

*/

:- dynamic dc_last_highlight/2.

dc_highlight(Tag) :-
    dc_last_selected_window(Window),
    dc_object(Tag, Window, _Ref, X, Y, W, Z),
    dc_window_handle(Window, gm_view_handle(_WH, VH)),
    dc_do_highlight(VH, X, Y, W, Z),
    gmsend(VH, update).

dc_do_highlight(VH, X, Y, W, Z) :-
    dc_deselectall,
    gmsend(VH, setcolors(blue, white)),
    gmsend(VH, rect(Ref, X, Y, W, Z)),
    gmsend(VH, setcolors(black, white)),
    eccs_sys_assertz(dc_last_highlight(VH, Ref)).


dc_deselectall :-
    eccs_sys_retract(dc_last_highlight(VH1, Ref1)), 
    gmsend(VH1, remove(Ref1)), 
    gmsend(VH1, update),
    fail.
dc_deselectall.


