/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:40:00 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pfiles.pl,v $',
	'$State: Exp $').

$Log: pfiles.pl,v $
% Revision 1.0  1993/04/26  16:40:00  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:08:41  pleuk
% *** empty log message ***
%
% Revision 0.3  1991/07/15  09:54:26  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.2  1991/05/21  14:28:17  kwh
% 'current_file' database entries clarified.
% more general file attribute access routines added
% (NB old routines also needed until grammar files recompiled).
% output of file status information modified.
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision


*/

/*

File:	/home/user2/jo/Pleuk/Code/pfiles.pl
Date:	Fri May  4 17:03:27 1990
By:	Jonathan Calder

File handling.

We assume that all files that define a grammar have the following specification
associated with them.  

eccs_file_specification(FileType, [Extension, Reader, Compiler, Prehook, Posthook, Globality, Unique])

Type is an atom---an arbitrary term for the types of objects defined
in the file.  Extension a string describing a filename extension.
Reader is a predicate to call to read an object from the file.
Compiler is the compiler to call to compile an object.  ObjectTypes is
a list of atoms, these being the object types that are defined in the
file.  PreHook is the name of a prolog procedure to call before
reading any item from the file, PostHook a procedure called after the
last object in the file has been compiled.  Globality is one of
``global'' or ``local''.  Unique may be either ``unique'' or ``many'';
if unique, only one file of this type may be loaded at any one time.


The existence of a "load script" is also assumed:

load_script


eccs_load_file(File, Restrictions, FileType)

load the definitions given in some *existing* File of a known FileType, 
with possible Restrictions.  The special value for restrictions is `none'
meaning load everything in the file.


*/

eccs_load_from_menu :-
    eccs_global_load.


eccs_global_load :-
    eccs_files_to_load(NewList),
    eccs_sys_if_then_else(
	eccs_no_files(NewList), 
	(eccs_to_user([no, files, need, loading]), fail), 
	true),
    eccs_confirm_load(NewList),
    eccs_global_load(NewList),
    eccs_file_window_goal(eccs_file_status).
eccs_global_load.


% adapted from SLE - 3/92
eccs_load_selected_from_menu :-
    eccs_files_to_load(NewList),
    eccs_sys_if_then_else(
        eccs_no_files(NewList),
        (eccs_to_user([no, files, need, loading]), fail),
        true),
    eccs_confirm_load(NewList, Confirmed),
    eccs_global_load(Confirmed),
    eccs_file_window_goal(eccs_file_status).
eccs_load_selected_from_menu.


/*

eccs_no_files(List)

true if List is a list of directory+files pairs and files is in 
every case empty.

*/

eccs_no_files([]).
eccs_no_files([dir(_, [])|Rest]) :-
    eccs_no_files(Rest).
eccs_no_files([dir(_, _, [])|Rest]) :-
    eccs_no_files(Rest).

eccs_confirm_load([dir(Dir, Files) | Rest]) :-
    \+ eccs_have_grammar_desc_file, !,
    eccs_length(Files, Length),
    eccs_sys_if_then_else(Length = 0,
	eccs_warning(['No files found in', Dir]),
	eccs_sys_if_then_else(Length > 10,
	    (eccs_message(['Files to load from directory ', Dir, ': '|Files]),
	     eccs_do_menu(confirm, [alert=['Load files (see Log window) ?']])),
            eccs_do_menu(confirm, [alert = ['Load the following files from directory', Dir | Files]]) ) ).

eccs_confirm_load([]) :- !.
eccs_confirm_load([dir(Dir, Context, Files) | Rest]) :- !,
    eccs_length(Files, Length),
    eccs_sys_if_then_else(Length = 0,
	eccs_warning(['No files found in', Dir, 'for', Context, 'context']),
	eccs_sys_if_then_else(Length > 10,
	    (eccs_message(['Files to load from directory ', Dir, 'in context ', Context|Files]),
	     eccs_do_menu(confirm, [alert=['Load files (see Log window) ?']])),
            eccs_do_menu(confirm, [alert = ['Load the following files from directory', Dir, 'in context ', Context | Files]]) ) ),
    eccs_confirm_load(Rest).


/* 
eccs_confirm_load\2 - \1 converted to be a binary predicate by CHB,
in order that user should get the chance to load some files but not
others. The file list is a series of specifications of form dir(Dir,
Files) and the new output list allows users to pick files from the
Files list on a one-by-one basis. Code simplified by CHB 
*/

% base case
eccs_confirm_load([],[]) :- !.

% catch empty file lists
eccs_confirm_load([dir(Dir, [])|Rest],Rest1) :-
        eccs_warning(['No files found in', Dir]), !,
        eccs_confirm_load(Rest, Rest1).
eccs_confirm_load([dir(Dir, Context, [])|Rest],Rest1) :-
        eccs_warning(['No files found in', Dir,'in context',Context]), !,
        eccs_confirm_load(Rest, Rest1).

% catch very long file lists
eccs_confirm_load([dir(Dir, Files)|Rest],Rest1) :-
        eccs_length(Files, N), N > 10, !,
        eccs_warning([N, 'files found in', Dir,':too many to load selectively']), !,
        eccs_confirm_load(Rest, Rest1).
eccs_confirm_load([dir(Dir, Context, Files)|Rest],Rest1) :-
        eccs_length(Files, N), N > 10,!,
        eccs_warning([N, 'files found in', Dir,'in context',Context, ':too many to load selectively']), !,
        eccs_confirm_load(Rest, Rest1).

% the usual default cases. 
% If we don't load all files, then we go thru piecewise
eccs_confirm_load([dir(Dir, Files) | Rest],[dir(Dir, Files1) | Rest1]) :-
        \+ eccs_have_grammar_desc_file, !,
        eccs_piecewise_confirm(Dir,Files, Files1),
        eccs_confirm_load(Rest,Rest1).
eccs_confirm_load([dir(Dir,Context,Files)|Rest],[dir(Dir,Context,Files)|Rest1]) :- !,
        eccs_piecewise_confirm(Context, Dir, Files, Files1),
        eccs_confirm_load(Rest,Rest1).

/* eccs_piecewise_confirm -- choose some of the elements of a list of files */
eccs_piecewise_confirm(_Dir, [], []).
eccs_piecewise_confirm(Dir, [X|Xs],[X|Ys]) :-
        eccs_do_menu(confirm, [alert = ['Load the following file from directory', Dir, X ]]),!,
        eccs_piecewise_confirm(Dir,Xs,Ys).
eccs_piecewise_confirm(Dir, [_X|Xs],Ys) :-
        eccs_piecewise_confirm(Dir, Xs, Ys).

eccs_piecewise_confirm(_Context, _Dir, [], []).
eccs_piecewise_confirm(Context, Dir, [X|Xs],[X|Ys]) :-
        eccs_do_menu(confirm, [alert = ['Load the following file from directory', Dir, 'in context', Context, X ]]),!,
        eccs_piecewise_confirm(Context, Dir,Xs,Ys).
eccs_piecewise_confirm(Context, Dir, [_X|Xs],Ys) :-
        eccs_piecewise_confirm(Context, Dir, Xs, Ys).



eccs_files_to_load_from_dir(Dir, GName, NewList) :-
    eccs_load_order(Types),
    eccs_call_command_in_directory(Dir, 
	eccs_find_grammar_files(GName, Types, NewList)).



eccs_files_to_load([dir(Dir, NewList)]) :-
    \+ eccs_have_grammar_desc_file, !,
    eccs_global_variable(grammar_name, GName),
    eccs_sys_if_then_else(eccs_global_variable(grammar_directory, Dir), true,
	    eccs_os_current_directory(Dir)),
    eccs_files_to_load_from_dir(Dir, GName, NewList).

eccs_files_to_load(NewList) :-
    eccs_grammar_desc_file_grammar_names(List),
    eccs_files_from_dirs(List, NewList).

eccs_files_from_dirs([], []).
eccs_files_from_dirs([grammar(Dir, Name)|Gs], [dir(Dir, List)|Ls]) :-
    \+ eccs_have_grammar_desc_file, !,
    eccs_files_to_load_from_dir(Dir, Name, List),
    eccs_files_from_dirs(Gs, Ls).

eccs_files_from_dirs([grammar(Dir, Context, Name)|Gs], [dir(Dir, Context, List)|Ls]) :-
    eccs_files_to_load_from_dir(Dir, Name, List),
    eccs_files_from_dirs(Gs, Ls).



eccs_global_load([]) :- !.
eccs_global_load([dir(Dir, Files)|R]) :-
    \+ eccs_have_grammar_desc_file, !,
    eccs_call_command_in_directory(Dir, eccs_global_load1(Files)),
    eccs_global_load(R).

eccs_global_load([dir(Dir, Context, Files)|R]) :-
    eccs_in_context(Context, 
		eccs_call_command_in_directory(Dir, eccs_global_load1(Files))),
    eccs_global_load(R).


eccs_global_load1([]) :- !.
eccs_global_load1([file(File, Type)|R]) :-
    eccs_load_file(File, none, Type), 
    eccs_global_load1(R).


/*

eccs_find_grammar_files(GName, Types, Files) 

Files is a list of file specifications associated with the 
grammar GName, describing files which are out of date wrt 
the current state.  The names of the files are either of the form 
GName.Ext or Source.Ext where a directive to load the 
file Source.Ext is contained (possibly recursively) in the file GName.Ext.  

*/


eccs_find_grammar_files(_GName, [], []) :- !.
eccs_find_grammar_files(GName, [Type|Rest], FilesOut) :-
    eccs_file_specification(Type, [Extension|_]),
    eccs_find_file(GName, Extension, RealName, fail), 
    eccs_find_sourced_files(RealName, Type, Extension, Sourced),
    eccs_sys_if_then_else(eccs_up_to_date_version_loaded(RealName), 
			  FilesOut = Files,
			  FilesOut = [file(RealName, Type)|Files]),
    !,
    eccs_find_grammar_files(GName, Rest, R),
    eccs_append(Sourced, R, Files).
eccs_find_grammar_files(GName, [_|Rest], R) :-
    eccs_find_grammar_files(GName, Rest, R).

/*

eccs_up_to_date_version_loaded(File)

True if we have loaded File and it has not been since modified.

We know we are in the right directory and that the file exists. 

The 4th line of the body added, JC Wed Dec 11 13:25:52 1991, in 
case we don't have foreign functions available.  

*/

eccs_up_to_date_version_loaded(File) :-
    eccs_current_file(File, _),
    \+ eccs_get_file_attributes(File,[state=expunged]),
    eccs_get_file_attributes(File, [date=MTime]),
    \+ MTime = unknown, 
    eccs_file_mtime(File, FileMTime),
    FileMTime =< MTime.


/*

eccs_find_sourced_files(GName, Type, Extension, Sourced)

GName gives rise to the Sourced files with Extension.  

This requires that findall/3 lists its answers in database order.

*/

eccs_find_sourced_files(MainFile, Type, _Extension, Sourced) :-
    findall(file(FName, Type), 
    	    (eccs_sourced_file(FName, MainFile), 
	     \+ eccs_up_to_date_version_loaded(FName)),
	    Sourced).

eccs_load_file(File, _Restrictions, _Type) :-
    eccs_get_file_attributes(File, [state=loaded]),
    eccs_compiled_version_up_to_date(File, _),
    !,
    eccs_message([File, is, up, to, date, and, loaded]).
eccs_load_file(File, none, Type) :-
    eccs_maybe_restore_compiled_version(File, Type), !,
    eccs_set_file_attributes(File, [type=Type,compiled=compiled,state=loaded]),
    eccs_sys_if_then_else((eccs_have_grammar_desc_file, 
	                   eccs_current_context(Context)),
			  eccs_set_file_attributes(File, [context=Context]),
			  true).
eccs_load_file(File, Restrictions, FileType) :- 
    eccs_file_specification(FileType, [ _Extension, Reader, ObjTypes, Compiler, Prehook, Posthook, Global, Unique]),
    eccs_maybe_clean_out_definitions(File, Restrictions, Global),
    eccs_set_file_attributes(File, [type=FileType, compiled=raw, state=loading]),
    eccs_sys_if_then_else((Unique = unique, 
	eccs_get_file_attributes(F1, [type=FileType, state=Loading]),
    	eccs_member(Loading, [loading, loaded]),
	eccs_not_eq(F1, File)),
	    eccs_error([only, one, file, of, type, FileType, may, be, loaded]), true),
    eccs_sys_call(Prehook),
    eccs_sys_seeing(Old),
    eccs_sys_see(File),
    eccs_get_stats(Heap, CPU),
    repeat,
    eccs_read_object(File, FileType, ObjTypes, ObjType, Name, Reader, Read),
    eccs_sys_if_then_else(eccs_end_of_file(Read), true,
	(eccs_check_restrictions(Restrictions, File, ObjType, Name),
	eccs_object_type(ObjType, Multi, _),
	eccs_compile_object(File, FileType, Compiler, Multi, ObjType, Name, 
    				     Read, Compiled, Dependencies),
	eccs_store_in_database(File, ObjType, Name, Read, Compiled, Dependencies),
	fail)),
    !,
    eccs_sys_seen,
    eccs_sys_see(Old),
    eccs_get_stats(Heap1, CPU1),
    H is Heap1 - Heap,
    C is CPU1 - CPU,
    eccs_message(['File:', File, 'loaded:', H, bytes, C, seconds]),
    eccs_file_mtime(File, MTime),
    eccs_set_file_attributes(File, [state=loaded, date=MTime]),
    eccs_sys_if_then_else((eccs_have_grammar_desc_file, 
	                   eccs_current_context(Context)),
			  eccs_set_file_attributes(File, [context=Context]),
			  true),
    eccs_sys_call(Posthook),
    eccs_sys_after_load_hook,
    eccs_maybe_dump_compilation(File).

eccs_sys_after_load_hook :-
    eccs_flush_all_output_streams.

    

/*

eccs_current_file(FileName, [type=Type, compiled=Compiled, source=Source, state=State, date=Date])

A normalised file name, FileName, is of type, Type.  Compiled is
either compiled or raw, according to whether the last version we
loaded was from a source file of a compiled vesion thereof.  Source is
the name of the file containing the command source([ ... FileName ...])
or the atom none.  State is one of not_loaded, loading,
expunged, loaded, according to whether we have never loaded the file,
are currently loading the file, have deleted it or have successfully
loaded it.  Date is an integer representation of the last mod time of 
the file.
The terms in the data base will always be ground.

*/

:- dynamic eccs_current_file/2.

/* Modified by Kevin - eccs_current_file/7 removed throughout and
access routines below now used to access current file details */


/* set up an attribute record for a file, with default values for
unspecified attributes, or modify an existing record */

/* Modified by Kevin - eccs_change_file_attribute/2 replaced
throughtout (except in previously compiled files - see note below).
Two general routines - eccs_set_file_attributes and
eccs_get_file_attributes - now used for virtually all accessing of
file details */

eccs_set_file_attributes(File, NewAttributes) :-
	eccs_current_file(File, OldAttributes), !,
	eccs_check_file_attributes(NewAttributes, OldAttributes),
	eccs_set_file_attributes(NewAttributes, OldAttributes, Revised),
	eccs_sys_retractall(eccs_current_file(File, OldAttributes)),
	eccs_sys_asserta(eccs_current_file(File, Revised)), !.
eccs_set_file_attributes(File, NewAttributes) :-
	eccs_check_file_attributes(NewAttributes, [type=unknown]),
	eccs_set_file_attributes(NewAttributes, [type=unknown, 
	                                         context=unknown, 
						 compiled=unknown, 
						 source=none, 
						 state=not_loaded, 
						 date=unknown], Initial),
	eccs_sys_asserta(eccs_current_file(File, Initial)), !.


/* retrieve attribute values from an existing record */

eccs_get_file_attributes(File, Attributes) :-
	eccs_current_file(File, OldAttributes),
	eccs_set_file_attributes(Attributes, OldAttributes, OldAttributes).


/* search for each attribute - any order can be given in New but Revised 
preserves order of Original */

eccs_set_file_attributes([], Revised, Revised).
eccs_set_file_attributes([A=V|Rest], Original, Revised) :-
	eccs_set_file_attribute([A=V],Original, New),
	eccs_set_file_attributes(Rest, New, Revised).

eccs_set_file_attribute([A=V], [A=_V2|Rest], [A=V|Rest]) :- 
	eccs_sys_nonvar(V).
eccs_set_file_attribute([A=V], [A=V2|Rest], [A=V2|Rest]) :- 
	eccs_sys_var(V), V=V2, !.
eccs_set_file_attribute(New, [A=V|Rest], [A=V|Revised]) :-
	eccs_set_file_attribute(New, Rest, Revised).


/* verify attribute names and values - 'type' may only be changed from its 
default value */

eccs_check_file_attributes(NewAttributes, [type=OldType|_]) :-
	eccs_check_file_attribute(NewAttributes, OldType).

eccs_check_file_attribute([],_) :- !.
eccs_check_file_attribute([type=Type|Rest], OldType) :- 
	(OldType =  unknown; OldType = Type),
	eccs_current_file_type(Type), !,
	eccs_check_file_attribute(Rest,OldType).
eccs_check_file_attribute([compiled=Compiled|Rest], Type) :-
	eccs_memberchk(Compiled,[raw,compiled]), !,
	eccs_check_file_attribute(Rest, Type).
eccs_check_file_attribute([source=_Source|Rest], Type) :- !,
	eccs_check_file_attribute(Rest, Type).
eccs_check_file_attribute([state=State|Rest], Type) :-
	eccs_memberchk(State,[expunged,loaded,loading]), !,
	eccs_check_file_attribute(Rest, Type).
eccs_check_file_attribute([date=Date|Rest], Type) :-
	eccs_sys_integer(Date), !,
	eccs_check_file_attribute(Rest, Type).
eccs_check_file_attribute([context=_Context|Rest], Type) :- !,
	eccs_check_file_attribute(Rest, Type).
eccs_check_file_attribute([Attribute=Value|_], _) :- 
	eccs_error([invalid,file,attribute,Attribute=Value]). % maybe fatal for type, source or state



/* Modified by Kevin - this is virtually the old definition - currently required because old compiled files may call it - should be deleted after everything has been recompiled */

eccs_change_file_attribute(File, Attribute, Value) :-
    \+ eccs_current_file(File, _), !,
    eccs_sys_asserta(eccs_current_file(File, [type=unknown, compiled=unknown, source=none, state=unknown, date=unknown])),
    eccs_change_file_attribute(File, Attribute, Value), !.
eccs_change_file_attribute(File, Attribute, Value) :-
    eccs_current_file(File, [type=Type, compiled=Compiled, source=Source, state=State, date=Date]),
    eccs_member(Type, [unknown, Type1]), % Type can only be set from unknown to a new constant type
    eccs_once(
       eccs_change_file_attribute(Attribute, Value, Type, Compiled, Source, State, Date, Type1, Compiled1, Source1, State1, Date1)),
    eccs_sys_retractall(eccs_current_file(File, [type=Type|_])), 
    eccs_sys_asserta(eccs_current_file(File, [type=Type1, compiled=Compiled1, source=Source1, state=State1, date=Date1])), !.


eccs_change_file_attribute(type, NewType, _, Comp, Source, State, Date, NewType, Comp, Source, State, Date) :-
    eccs_current_file_type(NewType).
eccs_change_file_attribute(source, NewSo, Type, Comp, _, State, Date, Type, Comp, NewSo, State, Date).
eccs_change_file_attribute(compiled, NewComp, Type, _, Source, State, Date, Type, NewComp, Source, State, Date) :-
    eccs_member(NewComp, [raw, compiled]).
eccs_change_file_attribute(state, NewState, Type, Comp, Source, _,  Date, Type, Comp, Source, NewState, Date) :-
    eccs_member(NewState, [expunged, loaded, loading]).
eccs_change_file_attribute(date, MTime, Type, Comp, Source, State,  _, Type, Comp, Source, State, MTime) :-
    eccs_sys_integer(MTime).




eccs_find_file(File, Extension, File, _Error) :-
    eccs_sys_name(File, L), eccs_append(_, Extension, L), 
    eccs_file_exists(File), !.
eccs_find_file(File, Extension, RealName, _Error) :-
    eccs_sys_name(Ext, Extension),
    eccs_concat_list([File, Ext], RealName),
    eccs_file_exists(RealName), !.
eccs_find_file(File, _, _,  Error) :-
    eccs_sys_if_then_else(Error == error, eccs_error([unable, to, find, file, File]),
      call(Error)).


eccs_read_object(RealName, FileType, ObjTypes, ObjType, Name, Reader, Read1) :-
    eccs_sys_if_then_else(eccs_global_variable(reader_arguments, Args), true, Args = []),
    eccs_once(eccs_construct_and_call([Reader, Args, Name, ObjType, Read])),
    eccs_sys_if_then_else(eccs_sys_nonvar(ObjType), (eccs_member(ObjType, ObjTypes); 
			 eccs_error([illegal, object, type, ObjType, in, file, RealName])),
			ObjType = none), !,
    eccs_maybe_source_file(RealName, Read, FileType, ObjTypes, Read1).


/*

eccs_maybe_source_file(InFile, Source, FType, _ObjTypes, '$$$SOURCED$$$')

Catch directives read in InFile to source some other file.  
We have to do this here in order to allow some generality across non-term 
based readers.  We also have to make a recorded of the files that we load in 
so that we can preserve the ordering.  Info stored in eccs_current_file/2 is
not sufficient, as those records get updated in a way that destroys the 
load order info.  

This routine succeeds if the object read is not a source directive.  

*/

:- dynamic eccs_sourced_file/2.

eccs_maybe_source_file(InFile, source(FName), FType, _ObjTypes, _) :-
    !,
    eccs_sys_if_then_else(FName = [_|_], Files = FName, Files = [FName]),
    eccs_file_specification(FType, [Ext|_]),
    eccs_member(F, Files),
    eccs_find_file(F, Ext, RealName, error),
    eccs_set_file_attributes(RealName, [source=InFile]),
    eccs_once((eccs_sourced_file(RealName, InFile), !; 
    	       eccs_sys_assertz(eccs_sourced_file(RealName, InFile)))),
    eccs_load_file(RealName, none, FType), fail.
eccs_maybe_source_file(_, Read, _, _, Read).

eccs_files_to_file_and_type([], _, []) :- !.
eccs_files_to_file_and_type([File|R], FType, [file(File, FType)|Rest]) :-
    eccs_files_to_file_and_type(R, FType, Rest).
/*

eccs_compile_object(FileName, CompilerName, Multi, FileType, ObjType, ObjName, ObjectRead,
		    CompiledObject, Dependencies).

Apply a compiler to an object read from a file.

*/

eccs_compile_object(FileName, FileType, Compiler, Multi, ObjType, Name, Read, Compiled, Dependencies) :-
    eccs_sys_if_then_else(eccs_global_variable(compiler_arguments, Args), true, Args = []),
    eccs_add_argument(file, FileName, Args, As),
    CompilerGoal = [Compiler, FileType, ObjType, Name, As, Read, Compiled, Dependencies],
    eccs_sys_if_then_else(Multi = single,
	eccs_sys_if_then_else(eccs_construct_and_call(CompilerGoal), true, eccs_error([no, compilation, for, Read, from, file, FileName])),
		eccs_if(eccs_construct_and_call(CompilerGoal), true, eccs_error([no, compilation, for, Read, from, file, FileName]))).


/*

eccs_load_customization_file

Load a customization file at run time.

The default name is given by the variable customization_file 

A file may be specified on the command line.  Otherwise, 
we look first in the current directory, then in the user's 
home directory.

*/

eccs_load_customization_file :-
    eccs_global_variable(eccs_os, mac),
    ask_for_input_file('Customization file to load', [], FName),
    consult(FName).
eccs_load_customization_file :-
    eccs_command_args(List),
    \+ List = [],      % (SLE - 3/92)
    eccs_append(_, ['+pleukfile', FName|_], List), !,
    (eccs_file_exists(FName) -> eccs_srcload([FName]);
    	eccs_warning([customization,file, FName, does, not, 'exist!'])).
eccs_load_customization_file :-
    eccs_global_variable(customization_file, File),
    eccs_sys_if_then_else((eccs_find_file(File, "", Name, fail);
      eccs_os_home_directory(Dir), eccs_os_list_to_path_name([Dir, File], NewFile),
      eccs_find_file(NewFile, "", Name, fail)), 
      eccs_srcload([Name]), true).

/*

eccs_remove_up_to_date(Old, New)

New list is like Old except that it does not contain any 
files that are loaded in memory and whose compile dates are
after their write dates.

*/
eccs_remove_up_to_date([], []).
eccs_remove_up_to_date([file(F, _)|R], Rest) :-
    eccs_get_file_attributes(F,[state=State]),
    eccs_not_eq(State, expunged),
    eccs_compiled_version_up_to_date(F, _), !,
    eccs_remove_up_to_date(R, Rest).
eccs_remove_up_to_date([F|R], [F|Rest]) :-
    eccs_remove_up_to_date(R, Rest).



/* Modified by Kevin - 80 column neat output */

eccs_file_status :- 
    eccs_sys_name('-', Cs),
    eccs_format_to_current_stream("~79c~n", Cs),
    eccs_file_details.

eccs_file_details :- 
    \+ eccs_current_file(_,_), !,
    eccs_format_to_current_stream("No files are currently loaded~n", []).
eccs_file_details :-
    \+ eccs_have_grammar_desc_file, !,
    eccs_format_to_current_stream("File         Type                 Version  Source     State    Date            ~n~n", []),
    eccs_write_file_details(_).
eccs_file_details :-
    eccs_format_to_current_stream("File       Context    Type            Version  Source  State    Date            ~n~n"), 
	eccs_write_file_details(_).

eccs_write_file_details(File) :-
    \+ eccs_have_grammar_desc_file,
    eccs_current_file(File, [type=Type, context=_Context, compiled=Compiled, source=Source, state=State, date=Date]),
    eccs_sys_if_then_else(Date = unknown, PrintDate = unknown, eccs_seconds_to_date(Date, PrintDate)),
    eccs_sys_name(File, FileCs),
    eccs_sys_name(Type, TypeCs),
    eccs_sys_name(Compiled, CompiledCs),
    eccs_sys_name(Source, SourceCs),
    eccs_sys_name(State, StateCs),
    eccs_sys_name(PrintDate, PrintDateCs),
    eccs_format_to_current_stream("~12s ~20s ~8s ~10s ~8s ~16s~n",
	[FileCs, TypeCs, CompiledCs, SourceCs, StateCs, PrintDateCs]),
    fail.
eccs_write_file_details(File) :-
    eccs_have_grammar_desc_file,
    eccs_current_file(File, [type=Type, context=Context, compiled=Compiled, source=Source, state=State, date=Date]),
    eccs_sys_if_then_else(Date = unknown, PrintDate = unknown, eccs_seconds_to_date(Date, PrintDate)),
    eccs_sys_name(File, FileCs),
    eccs_sys_name(Type, TypeCs),
    eccs_sys_name(Compiled, CompiledCs),
    eccs_sys_name(Source, SourceCs),
    eccs_sys_name(State, StateCs),
    eccs_sys_name(PrintDate, PrintDateCs),
    eccs_sys_name(Context, ContextCs),
    eccs_format_to_current_stream("~10s ~10s ~15s ~8s ~7s ~8s ~16s~n",
      [FileCs, ContextCs, TypeCs, CompiledCs, SourceCs, StateCs, PrintDateCs]),
    fail.
eccs_write_file_details(_File).




eccs_recompile :- eccs_error([no, files, specified]).


eccs_recompile(Files) :-
    eccs_sys_if_then_else(eccs_global_variable(grammar_directory, Dir), true,
     eccs_os_current_directory(Dir)),
    eccs_member(F, Files),
    eccs_once((eccs_current_context(Con), eccs_get_from_databasef(_, Con, _, _))),  % (SLE - 3/92)
    eccs_os_list_to_path_name([Dir, F], FName),
    eccs_expunge_file(F),
    (eccs_have_grammar_desc_file ->
	eccs_delete_and_load_in_contexts(F);
	(eccs_delete_compiled_version(FName),
         eccs_load_files([F]))),
    eccs_sys_if_then_else(eccs_global_variable(save_compiled_versions_to_file, false),
	eccs_warning(['save_compiled_versions_to_file = false : no file written']),
	fail),
    fail.

eccs_delete_compiled_version(FName) :-
    eccs_compiled_file_name(FName, CFName),
    eccs_file_exists(CFName), !,
    eccs_do_menu(confirm, [ alert = ['Overwrite current compiled version:', CFName]]),
    eccs_os_delete_file(CFName).
eccs_delete_compiled_version(_FName).


/*
Contexts version
*/
eccs_delete_and_load_in_contexts(F) :-
    eccs_file_type(F, Type),
    findall(path(Name, Dir, Path, AbsPath), 
	    (eccs_context_name_gname_dir(Name, _GName, Dir), 
	     eccs_os_list_to_path_name([Dir, F], Path),
	     eccs_absolute_file_name(Path, AbsPath),
	     eccs_file_exists(AbsPath)), 
	    Paths),
    eccs_member(path(N, D, P, _AP), Paths),
    eccs_sys_if_then_else((eccs_length(Paths, Length), Length > 1),
	eccs_do_menu(confirm,[alert=['Recompile',P,'in context',N]]),
	true),
    eccs_compiled_file_name(F, CF),
    eccs_os_list_to_path_name([D, CF], CPath),
    eccs_absolute_file_name(CPath, CAbsPath),
    eccs_sys_if_then_else(eccs_file_exists(CAbsPath),
	(eccs_do_menu(confirm,[alert=['Overwrite current compiled version of',P]]),
         eccs_os_delete_file(CAbsPath)),
	true),
    eccs_in_context(N, 
	eccs_call_command_in_directory(D,
	    eccs_load_file(F,none,Type))).



eccs_load_files([]) :- !.
eccs_load_files([File|Rest]) :-
	\+ eccs_have_grammar_desc_file, !,
	eccs_file_type(File, Type),
        eccs_global_variable(grammar_name, _GName),
        eccs_sys_if_then_else(eccs_global_variable(grammar_directory, Dir), true, eccs_os_current_directory(Dir)),
        eccs_call_command_in_directory(Dir, eccs_load_file(File, none, Type)),
	eccs_file_window_goal(eccs_write_file_details(File)),
	eccs_load_files(Rest).

/*

Contexts version

*/

eccs_load_files([F|R]) :-
    eccs_file_type(F, Type),
    findall(path(Name, Dir, Path), 
	    (eccs_context_name_gname_dir(Name, _GName, Dir), 
	     eccs_os_list_to_path_name([Dir, F], Path),
	     eccs_absolute_file_name(Path, AbsPath),
	     eccs_file_exists(AbsPath)), 
	    Paths),
    eccs_member(path(N1, D1, P1), Paths),
    eccs_do_menu(confirm, [alert = ['Load the file', P1, 'in context:', N1]]),
    eccs_in_context(N1,    
	eccs_call_command_in_directory(D1, 
	    eccs_load_file(F,none,Type))), !,
    eccs_load_files(R).


/*

eccs_file_type(+F, Type)

F is a file of type Type, determined by its extension.

*/

eccs_file_type(F, Type) :-
    eccs_sys_name(F, String),
    eccs_file_specification(Type, [Ext|_]),
    eccs_append(_, Ext, String), !.

eccs_maybe_recompile_file(FName) :-
    eccs_maybe_recompile_file(FName, _ObjType, _Name).

eccs_maybe_recompile_file(FileName, ObjType, Name) :-
    (eccs_have_grammar_desc_file -> eccs_current_context_dir(Dir);
    	eccs_global_variable(grammar_directory, Dir)),
    eccs_sys_if_then_else((eccs_sys_var(ObjType); eccs_sys_var(Name)),
    			  Restrictions = none,
			  Restrictions = [selective(Name, ObjType, FileName)]),
    eccs_sys_if_then_else(eccs_get_from_databasef(ObjType, Name, _, FileName),
	true,
	(eccs_sys_if_then_else(eccs_sys_var(Name),
	    eccs_warning([no, object, from, FileName, currently, defined]),
	    eccs_warning([no, object, of, name, Name, from, FileName, currently, defined])))),
    eccs_call_command_in_directory(Dir, 
    	eccs_sys_if_then_else( (eccs_up_to_date_version_loaded(FileName), 
				eccs_get_file_attributes(FileName,[state=loaded])),
			       eccs_message([compiled, version, of, FileName, is, up, to, date, and, loaded]),
			    (eccs_verify_recompilation(FileName, Restrictions),
			     eccs_file_type(FileName, Type), 
			     eccs_load_file(FileName, Restrictions, Type)))).


eccs_verify_recompilation(FileName, none) :-
    !,
    eccs_do_menu(confirm, [alert = ['About to recompile the file', FileName, 'Proceed ?']]).
/*
Dumb terminal version:
    eccs_message([about, to, recompile, file, FileName, '$nl$',
    		  do, you, want, to, 'proceed?']),
    eccs_do_menu(confirm).
*/
eccs_verify_recompilation(FileName, Restrictions) :-
    bagof([ObjType, Name], eccs_member(selective(Name, ObjType, FileName), Restrictions), Names),
    eccs_length(Names, Length),
    eccs_sys_if_then_else(Length > 10,
	(eccs_message(Names),
	 eccs_do_menu(confirm, 
	              [alert = ['About to recompile definition(s) (see Log window) from', FileName, 'Proceed ?']])),
	eccs_do_menu([alert = ['About to recompile the following definitions(s) from', FileName, Names, 'Proceed ?']]) ).

/*
Dumb terminal version:
    eccs_message([about, to, recompile, the, following, 'definition(s)', from, file, FileName]),
    (eccs_member(selective(Name, ObjType, FileName), Restrictions),
	eccs_message([ObjType, Name]), fail;
	true), !,
    eccs_message([do, you, want, to, 'proceed?']),
    eccs_do_menu(confirm).
*/

/*

Stuff for partial recompilations.


The bulk of the work is done in chasing down the dependencies


eccs_check_restrictions(Restrictions, FileName, ObjType, Name)

This is a filter which succeeds only if the object defined by Name, 
ObjType and FileName is in the list  Restrictions, or Restrictions  is the 
special atom 'none'.  

Note that the once is in the second clause allows multiple 
references to definitions with the same name.  

Sun Mar 14 17:04:02 1993 JC

HPSG is designed in a way that means we won't always have access to a
ground name until after compilation of the object.  This is
unproblematic, unless we try to selectively recompile a file.  Hence,
the new variable eccs_spec_names_untrustworthy.  If set to true, we
never attempt to do a selective recompile on a file.

*/

eccs_check_restrictions(none, _FileName, _ObjType, _Name) :- !.
eccs_check_restrictions(_, _, _, _) :-
    eccs_global_variable(eccs_spec_names_untrustworthy, true), !.
eccs_check_restrictions(Restrictions, FileName, ObjType, Name) :- 
    eccs_once(eccs_member(selective(Name, ObjType, FileName), Restrictions)).

eccs_maybe_clean_out_definitions(File, none, _Global) :- !,
    eccs_expunge_file(File).
eccs_maybe_clean_out_definitions(File, Restrictions, _Global) :- 
    eccs_member(selective(Name, ObjType, File), Restrictions),
    eccs_get_from_databaserf(_, ObjType, Name, _, _, DBRef, File),
    eccs_sys_erase(DBRef),
    fail.
eccs_maybe_clean_out_definitions(_File, _Restrictions, _Global).


