/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:48:25 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pleuklibrary.pl,v $',
	'$State: Exp $').

$Log: pleuklibrary.pl,v $
% Revision 1.0  1993/04/26  16:48:25  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:09:51  pleuk
% *** empty log message ***
%
% Revision 0.3  1991/07/15  09:54:26  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.2  1991/05/21  14:37:41  kwh
% routines for writing fixed length strings added.
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/* 

A library of routines for Pleuk.

File:	/home/user2/jo/Pleuk/pleukprologlib
Date:	Wed May  2 16:53:59 1990
By:	Jonathan Calder

These predicates have the prefix "eccs_" so that they look at least a
little familiar.

*/

% List operations

eccs_member(X, [X|_]).
eccs_member(X, [_|T]) :-
    eccs_member(X, T).

eccs_append([], X, X).
eccs_append([H|T], X, [H|R]) :-
    eccs_append(T, X, R).

eccs_memberchk(A, [A|_]) :- !.
eccs_memberchk(A, [_|T]) :- eccs_memberchk(A, T).

eccs_reverse(L1, L2) :- eccs_reverse(L1, [], L2).

eccs_reverse([], L, L).
eccs_reverse([H|T], L, R) :- 
    eccs_reverse(T, [H|L], R).


% List operations avoiding any instantiations

eccs_memberchk_var(Var, [H|_T]) :- Var == H, !.
eccs_memberchk_var(Var, [_H|T]) :- eccs_memberchk_var(Var, T).

eccs_delete_var(Var, [H|T], T) :- Var == H.
eccs_delete_var(Var, [H|T], [H|T2]) :-
	eccs_delete_var(Var, T, T2).

% listp(+).  

eccs_listp( []) :- !.
eccs_listp( [_|_]).


eccs_closed_list([]).
eccs_closed_list([_|X]) :-
    eccs_closed_list(X).
/*

eccs_nth_element(N, List, E)

E is the Nth element of List

*/

eccs_nth_element(1, [F|_], F).
eccs_nth_element(N, [_|R], E) :-
    N > 1,
    eccs_succ(M, N),
    eccs_nth_element(M, R, E).

/*

eccs_interpolate_char(Char, L, L1)

L1 is just like L, except that Char is interpolated 
between each element.

*/

eccs_interpolate_char(_, [], []) :- !.
eccs_interpolate_char(_, [Last], [Last]) :- !.
eccs_interpolate_char(Char, [F|R], [F, Char|Rest]) :-
    eccs_interpolate_char(Char, R, Rest).



/*

eccs_delete(X, List, Remainder)

deleting X from List gives remainder

elements of List are assumed to be unique and ground

*/

eccs_delete(X, [X|R], R).
eccs_delete(X, [H|Rest], [H|Remainder]) :-
    eccs_delete(X, Rest, Remainder).

/*---------------------------------------------------------------------------+
|        								     |
|        eccs_subst(NewEl, OldEl, OldL, NewL)				     |
|        the result of substituting NewEl for OldEl in OldL is NewL	     |
|        								     |
+---------------------------------------------------------------------------*/
% Wed Sep 17 16:24:12 1986  There was bug pointed out by Thierry Guillotin,
% in the third clause of eccs_subst/4, which resulted in the procedure throwing
% away the contents of the original list.  Note that this predicate requires
% that OldEl appear in OldL.  The first clause is really an error condition.

eccs_subst(_NewEl, _OldEl, [], _NewL) :- !, fail.
eccs_subst(NewEl, OldEl, [El|R], [El|Result]) :-
	eccs_not_eq(OldEl, El), !,
	eccs_subst(NewEl, OldEl, R, Result).
eccs_subst(NewEl, OldEl, [OldEl|R], [NewEl|R]).

/*

eccs_append_all(Lists, List)

List contains all elements from the lists in Lists as a flat structure.

*/

eccs_append_all(X,Y) :-
  eccs_append_all(X,Y,[]).

eccs_append_all([],X,X) :- !.
eccs_append_all([H|T],X,Z) :- !,
  eccs_append_all(H,X,Y),
  eccs_append_all(T,Y,Z).
eccs_append_all(X,[X|Y],Y).


/*

eccs_append_lists(Lists, List) :-

Like the above, but don't flatten embedded lists

Mon Aug 17 10:20:12 1992 JC

Appears not to be called anywhere and so commented out.

eccs_append_lists(Lists, List) :-
    eccs_append_lists0(Lists, List, []).

eccs_append_lists0([], List, List) :- !.
eccs_append_lists0([Head|Tail], First, List) :- !,
    eccs_append_lists1(Head, First, DL),
    eccs_append_lists0(Tail, DL, List).

    
eccs_append_lists1([], DL, DL) :- !.
eccs_append_lists1([Head|Tail], [Head|Rest], DL) :-
    eccs_append_lists1(Tail, Rest, DL).


*/

/*---------------------------------------------------------------------------+
|        								     |
|        eccs_tail(List, T)							     |
|        								     |
|        unify T with the last cdr of the list L.			     |
|        								     |
+---------------------------------------------------------------------------*/
eccs_tail([_H|T], T) :- (eccs_sys_var(T); T = []), !.
eccs_tail([_|T], Tail) :- eccs_tail(T, Tail).

eccs_same_length([], []).
eccs_same_length([_|T], [_|R]) :-
	eccs_same_length(T, R).


/*

eccs_list(+Length, List)

List has length Length

*/
eccs_list(0,[]) :- !.
eccs_list(I,[_|List])  :-
    eccs_succ(J, I),
    eccs_list(J,List).



/*
eccs_diff(InL, OutL, DL) 

OutL and DL are the difference list representation of InL

*/
eccs_diff([], X, X).
eccs_diff([H|T], [H|R], X) :-
	eccs_diff(T, R, X).

/*

eccs_map(Function, A, B)

List B is the image of list A under Function.  

Function is assumed to be determinate.  Function may be any Prolog term, the 
elements of A and B are added as additional arguments

*/

eccs_map(_Function,[],[]) :- !.
eccs_map(Function, [A|InList],[B| OutList]):-
    eccs_sys_functor(Function, F, N),
    An is N + 1,
    Bn is N + 2,
    eccs_sys_functor(T, F, Bn),
    eccs_map_map_args(0, N, T, Function),
    eccs_sys_arg(An, T, A),
    eccs_sys_arg(Bn, T, B),
    eccs_sys_call(T), !, 
    eccs_map(Function,InList,OutList).

eccs_map_map_args(0, 0, _, _) :- !.
eccs_map_map_args(0, N, A, B) :-
    eccs_sys_arg(N, A, X),
    eccs_sys_arg(N, B, X),
    eccs_succ(M, N),
    eccs_map_map_args(0, M, A, B).
    

eccs_commas_to_list(C, [C]) :-
	eccs_not_eq(C, (_,_)), !.
eccs_commas_to_list((C,Rest), [C|R]) :-
	eccs_commas_to_list(Rest, R).

/*  Now in pdatabase.pl
% utilities from Mike
eccs_erase_all(Key) :-
	eccs_sys_recorded(Key,_,Ref),
	eccs_sys_erase(Ref),
	fail.
eccs_erase_all(_).
*/

% Metalogical stuff

eccs_verify(X) :- \+ \+ X.

eccs_once(X) :- call(X), !.


% eccs_if/3 emulation of Sicstus if/3.

eccs_if(X, Y, _) :-
    findall(X, X, [F|R]), !, eccs_member(X, [F|R]), call(Y).
eccs_if(_, _, Z) :-
    call(Z).

% Unsafe version of not(X = Y)
eccs_not_eq(X, Y) :-
    \+ (X = Y).

% eccs_subsumes(A, B)  A is more general than B
eccs_subsumes(A, B) :-
    eccs_verify(A = B),
    eccs_verify((numbervars(B, 0, 1), A = B)).
    

eccs_variant(X,Y) :-
	eccs_verify((X=Y)),
	eccs_verify((
	  numbervars(X,0,N),
	  numbervars(Y,0,N),
	  X = Y )).

eccs_construct_and_call(List) :-
    Goal =.. List,
    eccs_sys_call(Goal).


/*

Tue Mar  9 13:05:11 1993 Addition by JC

eccs_sys_built_in(Pred)

eccs_sys_safe_call(Pred)

Pred is built in in this version of Prolog
Call Pred only if the predicate is known to the system.

*/

eccs_sys_built_in(Pred) :-
    eccs_sys_nonvar(Pred),
    eccs_sys_functor(Pred, F, N),
    eccs_sys_functor(Pred1, F, N),
    (eccs_global_variable(prolog_type, sicstus) ->
    	predicate_property(Pred1, built_in); 
	eccs_warning([no, definition, for, predicate_property, in, this, prolog])).

eccs_sys_safe_call(Pred) :-
    eccs_sys_built_in(Pred), 
    !,
    eccs_sys_call(Pred).

eccs_sys_safe_call(Pred) :-
    eccs_sys_nonvar(Pred),
    eccs_sys_functor(Pred, F, N),
    eccs_sys_functor(MGHead, F, N),
    eccs_sys_current_predicate(F, MGHead), !,
    eccs_sys_call(Pred).

/*

eccs_forall(Restriction, Scope)

Simulate universal quantification.  

*/
    
eccs_forall(Restriction, Scope) :-
    \+ ( call(Restriction), \+ call(Scope)).

/*

Mon Aug 17 10:21:17 1992 JC Appears not to be called and do 
commented out 

Wed Sep 30 11:37:29 1992 JC Needed for Sdg

*/
eccs_assoc(Key0-Item,[Key-Item|_]) :-
	Key0 == Key, !.
eccs_assoc(X,[_|T]) :-
	eccs_assoc(X,T).


eccs_memberchk_all([], _).
eccs_memberchk_all([Set|Sets], Element) :-
	eccs_memberchk(Element, Set),
	eccs_memberchk_all(Sets, Element).

eccs_member_pair(S0,T0,[S0|_],[T0|_]).
eccs_member_pair(S0,T0,[_|S],[_|T]) :-
	eccs_member_pair(S0,T0,S,T).
eccs_member_eq(X,[H|_]) :-
	X == H, !.
eccs_member_eq(X,[_|T]) :-
	eccs_member_eq(X,T).


eccs_subset([],_).
eccs_subset([X|Y],[X|Z]) :-
	eccs_subset(Y,Z).
eccs_subset([X|Y],[W|Z]) :-
	eccs_subset0(X,Z,R),
	eccs_subset(Y,[W|R]).

eccs_subset0(X,[X|Y],Y).
eccs_subset0(X,[A|B0],[A|B]) :-
	eccs_subset0(X,B0,B).

/*

eccs_sort_by_predicate(Unsorted, Predicate, Sorted)

Sorted is consistent with the partial order defined by the predicate 
Predicate(S, U), where S precedes U.

*/

eccs_sort_by_predicate([], _Predicate, []) :- !.
eccs_sort_by_predicate([OutOfSort|Rest], Predicate, Sorted) :-
    Goal =.. [Predicate, OutOfSort, X],
    eccs_delete(X, Rest, Remainder),
    eccs_sys_call(Goal),
    !,
    eccs_sort_by_predicate([X, OutOfSort|Remainder], Predicate, Sorted).
eccs_sort_by_predicate([InSort|Rest], Predicate, [InSort|Sorted]) :-
        eccs_sort_by_predicate(Rest, Predicate, Sorted).

% eccs_flatten is not the qp flatten predicate which removes uninstantiated
% variables from the list instantiating them to the empty list.

eccs_flatten(X,Y) :-
	eccs_flatten(X,[],Y,[]).

eccs_flatten(X,R,[X|L0],L) :-
	eccs_sys_var(X), !,
	eccs_flatten(R,[],L0,L).
eccs_flatten([],[],L,L) :- !.
eccs_flatten([],X,L0,L) :- !,
	eccs_flatten(X,[],L0,L).
eccs_flatten([H0|T0],R,L0,L) :- !,
	eccs_flatten(H0,[],L0,L1),
	eccs_flatten(T0,[],L1,L2),
	eccs_flatten(R,[],L2,L).
eccs_flatten(A,R,[A|L0],L) :-
	eccs_flatten(R,[],L0,L).

% ***** borrowed or adapted from the quintus prolog library *****

% borrowed from the qp library

eccs_binary_to_list(Unit, _, Unit, List, List) :- !.
eccs_binary_to_list(Term, Operator, Unit, Before, After) :-
	eccs_sys_functor(Term, Operator, 2),	% Term can't be a variable
	!,
	eccs_sys_arg(1, Term, Lhs),
	eccs_binary_to_list(Lhs, Operator, Unit, Before, Middle),
	eccs_sys_arg(2, Term, Rhs),
	eccs_binary_to_list(Rhs, Operator, Unit, Middle, After).
eccs_binary_to_list(Term, _, _, [Term|After], After).

eccs_binary_to_list(Term, Operator, Before, After) :-
	eccs_sys_nonvar(Term),
	eccs_sys_functor(Term, Operator, 2),
	!,
	eccs_sys_arg(1, Term, Lhs),
	eccs_binary_to_list(Lhs, Operator, Before, Middle),
	eccs_sys_arg(2, Term, Rhs),
	eccs_binary_to_list(Rhs, Operator, Middle, After).
eccs_binary_to_list(Term, _, [Term|After], After).

eccs_perm([], []).
eccs_perm(List, [First|Perm]) :-
	eccs_select(First, List, Rest),	%  tries each List element in turn
	eccs_perm(Rest, Perm).

%   eccs_select(?Element, ?Set, ?Residue)
%   is true when Set is a list, Element occurs in Set, and Residue is
%   everything in Set except Element (things stay in the same order).

eccs_select(Element, [Element|Rest], Rest).
eccs_select(Element, [Head|Tail], [Head|Rest]) :-
	eccs_select(Element, Tail, Rest).

%   list_to_set(+List, ?Set)
%   is true when List and Set are lists, and Set has the same elements
%   as List in the same order, except that it contains no duplicates.
%   The two are thus equal considered as sets.  If you really want to
%   convert a list to a set, list_to_ord_set is faster, but this way
%   preserves as much of the original ordering as possible.

eccs_list_to_set([], []).
eccs_list_to_set([Head|Tail], Set) :-
	eccs_memberchk(Head, Tail), !,
	eccs_list_to_set(Tail, Set).
eccs_list_to_set([Head|Tail], [Head|Set]) :-
	eccs_list_to_set(Tail, Set).

% eccs_subtract(S0,S1,S) is true if S0 - S1 = S.

eccs_subtract([], _, []).
eccs_subtract([Element|Residue], Set, Difference) :-
	eccs_memberchk(Element, Set), !,
	eccs_subtract(Residue, Set, Difference).
eccs_subtract([Element|Residue], Set, [Element|Difference]) :-
	eccs_subtract(Residue, Set, Difference).

% eccs_subset_subtract(S0,S1,S) is true if S0 - S1 = S and S1 is a subset of S0

eccs_subset_subtract(A, [], A).
eccs_subset_subtract(L, [H|R], Difference) :-
	eccs_memberchk(H, L), !,
	eccs_delete_all(H, L, Residue),
	eccs_subset_subtract(Residue, R, Difference).

/*

eccs_delete_all(Element, L, Residue)

Resdiue is just like L except that it contains no elements 
unifyable with Element

*/

eccs_delete_all(_, [], []).
eccs_delete_all(Element, [Element|Es], Residue) :-
    !,
    eccs_delete_all(Element, Es, Residue).
eccs_delete_all(Element, [X|Es], [X|Residue]) :-
    eccs_delete_all(Element, Es, Residue).


%   intersection(+ListOfSets, ?Intersection)
%   is true when Intersection is the intersection of all the sets in
%   ListOfSets.  The order of elements in Intersection is taken from
%   the first set in ListOfSets.  This has been turned inside out to
%   minimise the storage turnover.

eccs_intersection([Set|Sets], Intersection) :-
	eccs_intersection1(Set, Sets, Intersection).

eccs_intersection1([], _, []).
eccs_intersection1([Element|Elements], Sets, Intersection) :-
	eccs_memberchk_all(Sets, Element),
	!,
	Intersection = [Element|Rest],
	eccs_intersection1(Elements, Sets, Rest).
eccs_intersection1([_|Elements], Sets, Intersection) :-
	eccs_intersection1(Elements, Sets, Intersection).


eccs_union([], Union, Union).
eccs_union([Element|Elements], Set, Union) :-
	eccs_memberchk(Element, Set), !,
	eccs_union(Elements, Set, Union).
eccs_union([Element|Elements], Set, [Element|Union]) :-
	eccs_union(Elements, Set, Union).

%   eccs_union(+ListOfSets, ?Union)
%   is true when Union is the union of all the sets in ListOfSets.
%   It has been arranged with storage turnover in mind.

eccs_union(Sets, Union) :-
	eccs_union1(Sets, Answer),
	eccs_append(Answer, [], Answer),	% cauterise it
	!,
	Union = Answer.

eccs_union1([], _).
eccs_union1([Set|Sets], Answer) :-
	eccs_union2(Set, Answer),
	eccs_union1(Sets, Answer).

eccs_union2([], _).
eccs_union2([Element|Elements], Answer) :-
	eccs_memberchk(Element, Answer),	% add_element hack
	eccs_union2(Elements, Answer).

% end of borrowed predicates

% eccs_plus_to_list and eccs_comma_to_list are adapted from the qp library

eccs_plus_to_list(Sum, List) :-
	eccs_binary_to_list(Sum, +, List, []).

eccs_comma_to_list(Commas, List) :-
	eccs_binary_to_list(Commas, ',' , List, []).

% this code is slightly modified from the unify and free_of_var
% predicates listed in the qp library.  safe_unify is just a rename of
% unify to prevent Cprolog name clashes.  Also, in both predicates, the
% predicate func is substituted for functor.  The quintus implementation
% of functor fails quietly if all three arguments are uninstantiated.
% func gives the equivalent behaviour in cprolog without an
% instantiation fault.

eccs_safe_unify(X, Y) :-
	eccs_sys_nonvar(X), eccs_sys_nonvar(Y),
	!,
	eccs_sys_functor(X, F, N),
	eccs_sys_functor(Y, F, N),
	eccs_safe_unify(N, X, Y).
eccs_safe_unify(X, Y) :-
    eccs_sys_if_then_else(eccs_sys_nonvar(X),		% must have var(Y)
		(eccs_free_of_var(Y, X),		% Y does not occur in X
		Y = X),
		eccs_sys_if_then_else(eccs_sys_nonvar(Y),		% must have var(X)
				  (eccs_free_of_var(X, Y),		% X does not occur in Y
				  X = Y),
				  			% must have var(X), var(Y)
				  X = Y)).		% unify(X, X) despite X
				  			% occurring in X!

eccs_safe_unify(0, _, _) :- !.
eccs_safe_unify(N, X, Y) :-
	eccs_sys_arg(N, X, Xn),
	eccs_sys_arg(N, Y, Yn),
	eccs_safe_unify(Xn, Yn),
	eccs_succ(M, N),
	eccs_safe_unify(M, X, Y).

%   eccs_free_of_var(Variable, Term)
%   is true when the given Term contains no sub-term identical to the
%   given Variable (which may actually be any term, not just a var).
%   For variables, this is precisely the "occurs check" which is
%   needed for sound unification.

eccs_free_of_var(Variable, Term) :-
	Term == Variable,
	!,
	fail.
eccs_free_of_var(Variable, Term) :-
	eccs_sys_functor(Term, _, Arity),		% compound(Term),
	Arity > 0,				% !,
	!,					% eccs_sys_functor(Term, _, Arity),
	eccs_free_of_var(Arity, Term, Variable).
eccs_free_of_var(_, _).

eccs_free_of_var(1, Term, Variable) :- !,
	eccs_sys_arg(1, Term, Argument),
	eccs_free_of_var(Variable, Argument).
eccs_free_of_var(N, Term, Variable) :-
	eccs_sys_arg(N, Term, Argument),
	eccs_free_of_var(Variable, Argument),
	eccs_succ(M, N), !,
	eccs_free_of_var(M, Term, Variable).

% String operations

% eccs_prlength/2 L is the print length of Atom
eccs_prlength(Atom, L) :- eccs_sys_atomic(Atom), eccs_sys_name(Atom, N), eccs_length(N, L), !.

% eccs_concat/3 C is the string concatenation of the atoms A and B

eccs_concat(A, B, C) :- 
	eccs_sys_name(A, L1),
	eccs_sys_name(B, L2),
	eccs_append(L1, L2, L3),
	eccs_sys_name(C, L3).

% eccs_unconcat(?, ?, +): the inverse of concat/3.  
eccs_unconcat(A, B, C) :-
	eccs_sys_atomic(C),
	eccs_sys_name(C, LC),
	eccs_append(LA, LB, LC),
	eccs_sys_name(A, LA),
	eccs_sys_name(B, LB).

eccs_string_prefix(Prefix, Atom) :-
    eccs_unconcat(Prefix, _, Atom).

/*

eccs_concat_list(List, Atom)

Atom is the concatenation of the elements of List

*/

eccs_concat_list(List, Atom) :-
    eccs_concat_list0(List, Stringified),
    eccs_sys_name(Atom, Stringified).

eccs_concat_list0([], []) :- !.
eccs_concat_list0([F|R], String) :- 
    eccs_sys_name(F, S1),
    eccs_concat_list0(R, NewS),
    eccs_append(S1, NewS, String).
    

    

/*

eccs_copy_term(Old, New)

*/

eccs_copy_term(Old, New) :-
    eccs_sys_abolish('$$$Unique$$$', 1),
    eccs_sys_assert('$$$Unique$$$'(Old)),
    eccs_sys_retract('$$$Unique$$$'(New)).

/*

eccs_make_ground(Term,Term1)

Term1 is a ground version of  Term.  Term is not further instantiated.

*/

eccs_make_ground(Term,Term1) :-
    eccs_copy_term(Term, Term1),
    numbervars(Term1,0,_).


/*

Files etc.

*/


/*

Math stuff

*/

% succ/2 assume prolog error in the case of under instantiation
eccs_succ(M, N) :-
    eccs_sys_nonvar(M),
    !,
    N is M + 1.
eccs_succ(M, N) :-
    eccs_sys_nonvar(N),
    M is N - 1.




/*

Ridiculously non-logical stuff

*/

:- dynamic eccs_gensym_info/2.

:- assert(eccs_gensym_info('$GENSYM$', 0)).  % (SLE - 3/92)

eccs_gensym(Symbol) :-
    eccs_sys_retract(eccs_gensym_info(Atom, Counter)),
    eccs_sys_retractall(eccs_gensym_info(_, _)),
    eccs_succ(Counter, NewCount),
    eccs_sys_asserta(eccs_gensym_info(Atom, NewCount)),
    eccs_concat(Atom, NewCount, Symbol).


/*

Some high-level io stuff

*/

eccs_write_prolog_directive(Term) :-
    eccs_sys_nl, 
    eccs_sys_write((':- ( ')),
    eccs_sys_writeq(Term),
    eccs_sys_write(' ).'),
    eccs_sys_nl.




/* 

String processing stuff for formatted output tables.
(Added by Kevin)

*/

eccs_write_length(Atom,Length) :- 
	eccs_make_fixed_length_string(Atom,Length,String),
	eccs_sys_name(X,String),
	eccs_sys_write(X), !.

eccs_make_fixed_length_string(Atom, Length, String) :-
	eccs_sys_atomic(Atom),
	eccs_sys_name(Atom, Chars),
	eccs_length(Chars, N),
	eccs_sys_if_then_else(N >= Length, 
                          eccs_trim_string(Chars, N-Length, String),
			  eccs_fill_string(Chars, Length-N, String)).

eccs_trim_string(Chars, TrimExp, String) :-
	Trim is TrimExp, 
	eccs_reverse(Chars, RevChars),
	eccs_trim_string2(RevChars, Trim, RevString),
	eccs_reverse(RevString, String).

eccs_trim_string2(RevChars, 0, RevChars) :- !.
eccs_trim_string2([_|Rest], Trim, TrimChars) :-
	NewTrim is Trim - 1,
	eccs_trim_string2(Rest, NewTrim, TrimChars).

eccs_fill_string(Chars, FillExp, String) :-
	Fill is FillExp,
	eccs_make_string(32,Fill,Spaces),          % 32 = ascii space
	eccs_append(Chars,Spaces,String).

eccs_make_string(_Char,0,[]) :- !.
eccs_make_string(Char,Number,[Char|Rest]) :-
	NewNumber is Number - 1,
	eccs_make_string(Char,NewNumber,Rest).



/* 

name_list(List, Chars) 

returns character string including all brackets of a list

*/

eccs_name_list([First|Rest], Chars) :-
	eccs_sys_name(First, FirstChars),
	eccs_name_list_rest(Rest, RestChars),
        eccs_flatten([ "[", FirstChars, RestChars, "]" ], Chars), !.
eccs_name_list([[Head|Tail]|Rest], Chars) :-
	eccs_name_list([Head|Tail], ListChars),
	eccs_name_list_rest(Rest, RestChars),
	eccs_flatten([ "[", ListChars, RestChars, "]" ], Chars), !.
eccs_name_list([Term|Rest], Chars) :-
	Term =.. [Functor|Args],
	eccs_sys_name(Functor, FunctorChars),
	eccs_name_list_rest(Args, [_|ArgsChars]),
	eccs_name_list_rest(Rest, RestChars),
	eccs_flatten([ "[", FunctorChars, "(", ArgsChars, ")", RestChars, "]" ], Chars), !.
eccs_name_list(Term, Chars) :-
	Term =.. [Functor|Args],
	eccs_sys_name(Functor, FunctorChars),
	eccs_name_list_rest(Args, [_|ArgsChars]),
	eccs_flatten([ FunctorChars, "(", ArgsChars, ")" ], Chars), !.


eccs_name_list_rest([], []).
eccs_name_list_rest([Item|Rest], [",", ItemChars, RestChars] ) :-
	eccs_sys_name(Item, ItemChars),
	eccs_name_list_rest(Rest, RestChars).
eccs_name_list_rest([[Head|Tail]|Rest], [",", ListChars, RestChars] ) :-
	eccs_name_list([Head|Tail], ListChars),
	eccs_name_list_rest(Rest, RestChars).
eccs_name_list_rest([Term|Rest], [",", FunctorChars, "(", ArgsChars, ")", RestChars]) :-
	Term =.. [Functor|Args],
	eccs_sys_name(Functor, FunctorChars),
	eccs_name_list_rest(Args, [_|ArgsChars]),
	eccs_name_list_rest(Rest, RestChars).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
%
% File in Code directory

eccs_file_in_code_directory(FName, AbsFile) :-
    eccs_global_variable(prolog_directory, Dir),
    eccs_concat_list([Dir, '/', FName], AbsFile).
    
