
/* 
rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:48:13 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pmenudefs.pl,v $',
	'$State: Exp $').

$Log: pmenudefs.pl,v $
% Revision 1.0  1993/04/26  16:48:13  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:09:51  pleuk
% *** empty log message ***
%
% Revision 0.2  1991/07/15  09:52:47  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 1.1  1991/07/15  09:48:06  pleuk
% Initial revision
%



   eccs_menu( NAME,  popup,  [ options = OPTIONS ,  ARGS ] ). 

   eccs_menu( NAME, dbox, [ fields = [ field ( MESSAGE, DEFAULT ) ] , ARGS ] ).

   eccs_menu( NAME, alert, [ alert = MESSAGE , ARGS ] ).

'messages' (also in OPTIONS) may be either strings or atoms.
*/


/* defaults */

eccs_menu(default, popup,
          [ options = [ '$$CANCEL' ],
	    stayhere = false ]).
eccs_menu_geometry(default, '+100+100').
	    
eccs_menu(default, dbox,
	  [ tokenizer = prolog,
	    command = true ]).
eccs_dbox_geometry(default, '+200+200').

eccs_menu(default, alert,
	  [ yescommand = true,
	    nocommand = fail ]).
eccs_alert_geometry(default, '+0+400').


/* top level */

/* PostScript menu added by Jo: Fri Jul  5 16:31:49 1991
*/

eccs_menu(top_level, popup,
	  [ options = [ command('File menu',
	                    eccs_do_menu(file, [])),
			command('Edit menu',
			    eccs_do_menu(edit, [])),
			command('Analysis',
			    eccs_do_analysis_menu ),

			command('List objects',
			    eccs_do_menu(list_objects, [])),
			'$$CONTEXT_OPTIONS',
			command('Environment menu',
			    eccs_do_menu(environment, [])),
			'$$LINE',
			command('PostScript',
			    eccs_do_menu(postscript, [])),
			'$$PROLOG',
/*		        '$$HELP'(dir, top), */
			'$$LINE',
			command('Help', eccs_do_menu(top_level_help, [])),
			'$$LINE',
		        command('Exit Pleuk', 
                            eccs_do_menu(exit, [])) ],
	    prompt = 'PLEUK Top Level Menu' ]).
eccs_menu_geometry(top_level, '+0+0').


/* file menu */

eccs_menu(file, popup,
	  [ options = [ command('$$CONCAT'('Load ', 'all grammar files'), 
	                    eccs_load_from_menu),
			command('$$CONCAT'('Load ', 'selected files'),
			    eccs_load_selected_from_menu),
			command('$$CONCAT'('Load a ', 'single file'),
			    eccs_do_menu(load_file, [])),
			command('Recompile a single file',
			    eccs_do_menu(recompile, [])),
			command('Delete all current definitions',
			    eccs_maybe_delete_all),
			command('List current files', 
			    eccs_file_window_goal(eccs_file_status)),
	                '$$PROLOG',
			'$$HELP'(interface, 'File Menu') ],
            prompt = 'File Menu' ]).

/* see doc. on '$$CONCAT' for reason for its use in this definition,
i.e. first argument will be omitted in dumb terminal version. */


eccs_menu(load_file, popup,
	  [ options = [ command('$$CURRENT_FILES',
	                        eccs_load_files(['$$'])),
			command('Load other file',
			        eccs_do_menu(load_named_file, [])),
	                '$$PROLOG',
			'$$HELP'(interface, 'File Menu') ],
            prompt = 'Load File' ]).

eccs_menu(recompile, popup,
	  [ options = [ command('$$CURRENT_FILES',
	                        eccs_recompile(['$$'])),
			command('Recompile other file',
			        eccs_do_menu(recompile_named_file, [])),
	                '$$PROLOG',
			'$$HELP'(interface, 'File Menu') ],
            prompt = 'Recompile' ]).


/* edit menu */


eccs_menu(edit, popup,
	  [ options = [ command('$$CONCAT'('Edit ', '$$DEFINED_OBJECT_TYPES'),
			        eccs_edit_object('$$')),
			'$$LINE',
                        command('Edit file',
	                        eccs_do_menu(edit_file, [])),
	                '$$PROLOG',
			'$$HELP'(interface, 'Edit Menu') ],
            prompt = 'Edit Menu' ]).


eccs_menu(edit_file, popup,
	  [ options = [ command('$$CURRENT_FILES',
	                        eccs_edit_file(['$$'])),
			command('Edit other file',
			        eccs_do_menu(edit_named_file, [])),
	                '$$PROLOG',
			'$$HELP'(interface, 'Edit Menu') ],
            prompt = 'Edit File' ]).



/* list_objects menu */

eccs_menu(list_objects, popup,
          [options = [ command('Show all object types',
		               eccs_do_menu(all_objects, [])),
                       command('$$CONCAT'('Show object types from ',
		                          '$$ALL_MODULES'),
	                       eccs_do_menu(module_objects('$$'), [])),
		       command('List named object',
		               eccs_do_menu(named_object, [])),
                       command('List objects from a file',
		               eccs_do_menu(file_objects, [])),
	                '$$PROLOG',
			'$$HELP'(interface, 'List Objects') ],
	    stayhere = true,
            prompt = 'List Objects' ]).

eccs_menu(all_objects, popup,
	  [ options = [ command('$$DEFINED_OBJECT_TYPES', 
	                       eccs_list_objects('$$')),
	                '$$PROLOG',
			'$$HELP'(interface, 'List Objects') ],
            prompt = 'List Object Type' ]).

eccs_menu(module_objects(Module), popup,
	  [ options = [ command('$$DEFINED_OBJECT_TYPES'(Module),
	                        eccs_list_objects('$$')),
	                '$$PROLOG',
			'$$HELP'(interface, 'List Objects') ],
            prompt = 'List Object Type' ]).
          
eccs_menu(file_objects, popup,
	  [ options = [ command('$$CURRENT_FILES',
	                        eccs_list_by_file(['$$'])),
/*			command('Other file',
			        eccs_do_menu(named_file_objects, [])), */
			'$$HELP'(interface, 'List Objects') ],
            prompt = 'List Objects from:' ]).


/*

Thu Mar 18 13:40:43 1993 JC

Alteration of eccs_do_analysis_menu, to check for a variety of conditions, 
before proceeding to the analysis menu.  

We furthermore check that there is some item in the database. If not,
we fall through to a subcase.  

We do the following.  

If there are no files or definitions loaded
then if there are files to load
     then ask whether to load them
          if user says yes
	  then load them
               if nothing ends up in the database
	       then report an error
	       else go to analysis submenu
	       endif
	  else no op
	  endif
    else message about how to set appropriate variables
    endif
else go to analysis submenu
endif

The first clause covers the case where files have been loaded then
expunged. 

*/

eccs_do_analysis_menu :-
    \+ eccs_get_file_attributes(_, [state=loaded]),
    !,
    eccs_files_to_load(Fs),
    (eccs_no_files(Fs) -> 
	eccs_message([no, files, can, be, found, for, the, current, grammar, name]),
	eccs_message([and, directory, 'name.', 'Check', the, settings, of, these, 'variables.'])
      ; (eccs_confirm_load(Fs) -> 
      	    (eccs_global_load(Fs) -> 
	    	eccs_do_analysis_menu_load_done
	      ; eccs_message([loading, of, files, 'failed.', 'Check', for, errors]))
          ; fail)).
eccs_do_analysis_menu :-
    eccs_do_analysis_menu_load_done.

eccs_do_analysis_menu_load_done :-
    \+ eccs_get_from_database(_, _, _),
    !,
    eccs_message([loading, the, grammar, resulted, in, no, definitions, being, stored]),
    eccs_message(['Check', the, grammar, files, you, are, using]).
eccs_do_analysis_menu_load_done :-
    eccs_do_analysis_menu1.


/* (CHB 31 Jan 1992)
Thu Mar 18 13:30:28 1993 renamed from eccs_do_analysis_menu to 
eccs_do_analysis_menu1, to allow above checking on state of database.

* eccs_do_analysis_menu1 -- we are presumed to be able to parse, but
* not every specialization will be able to generate, so we check to see
* whether we can currently generate and put up appropriate menus

Tue Mar 16 12:14:14 1993 JC 

We also check to see whether the derivation checker can run with 
this spec. 

*/
eccs_do_analysis_menu1 :-
    (eccs_find_menu(generate, _, _); 
     eccs_global_variable(eccs_spec_supports_dc, true)), !,
    eccs_do_menu(analysis, []).
eccs_do_analysis_menu1 :-
    eccs_do_menu(parse, []).


/*

Tue Mar 16 12:18:26 1993 JC

Altered, because of change above.  We have to check which options 
are available apart from parse. 

*/

eccs_menu(analysis, popup, 
	[options = [command('Parse', eccs_do_menu(parse, []))|Rest],
	 prompt = 'Analysis']) :-
    (eccs_find_menu(generate, _, _) ->
	Rest = [command('Generate', eccs_do_menu(generate, []))|Tail]
      ; Rest = Tail),
    Tail = ['$$DERIVATION_CHECKER', '$$HELP'(interface, 'Analysis')].


/* contexts menu
   added by JC Wed Jul 31 12:04:18 1991 

NB This popup has a fall through to a dialogue box, if nothing useful can 
be done. 

*/

eccs_menu(contexts, popup,
	  [options = [command('$$CONCAT'('Switch to ', '$$CONTEXTS', ' context'),
			    eccs_set_context('$$')),
		    '$$LINE',
		    command('Show context tree', eccs_show_context_tree),
		    '$$LINE',
		    command('Reload grammar description file', 
			    eccs_reload_gdf),
		    '$$HELP'(interface, 'Contexts')],
	prompt = Prompt]) :-
    eccs_have_grammar_desc_file, !,
    eccs_current_context(Context),
    eccs_concat_list(['Contexts: current context is ', Context], Prompt).



/* top_level_help 
   added by JC Wed Jul 31 12:04:18 1991 */

eccs_menu(top_level_help, popup,
	[options = [
                    command('Overview', eccs_xinfo(overview, top)),
		    command('General help', eccs_xinfo(interface, 'Top Level Menu')),
		    command('First-time user', eccs_xinfo(overview, 'Notes for first-time users')),
		    command('Specialization Information', eccs_menu_spec_info),
		    command('When things go wrong', eccs_xinfo(interface, 'When things go wrong')), 
		    command('Credits', eccs_xinfo(overview, 'Credits')) ],
	 prompt = 'Help']).




/* parse menu */

eccs_menu(parse, popup,
	  [ options = [ '$$PARSING_OPTIONS',
		        '$$DERIVATION_CHECKER',
	  		command('Return to previous analysis', eccs_do_menu(all_parses_analysis)),
	                '$$LINE',
	                command('Load changed files', eccs_load_from_menu),
	                '$$DEBUG_OPTIONS',
	                '$$PROLOG',
			'$$HELP'(interface, 'Parse') ],
	    stayhere = true,
            prompt = 'Parse Menu' ]) :-
    eccs_last_sentence_analysis(_, N, _),
    eccs_sys_gte(N, 0), !.
eccs_menu(parse, popup,
	  [ options = [ '$$PARSING_OPTIONS',
	                '$$LINE',
	                command('Load changed files', eccs_load_from_menu),
	                '$$DEBUG_OPTIONS',
	                '$$PROLOG',
			'$$HELP'(interface, 'Parse') ],
	    stayhere = true,
            prompt = 'Parse Menu' ]).


/*

Additions of next and previous, and stayhere = true

JC Sun Jul  7 22:18:55 1991

*/

eccs_menu(all_parses_analysis, popup,
	  [ options = [ '$$PRINT_PARSE_OPTIONS',
			'$$LINE',
			command('PostScript',
		             eccs_do_menu(postscript, [])),
			'$$DEBUG_OPTIONS',
	                '$$PROLOG',
			'$$HELP'(interface, 'Print Results') ],
            prompt = 'Print Results Menu',
	    stayhere = true]) :-
	\+ (eccs_last_sentence_analysis(_,0,[])).



eccs_menu(reparse, popup, []) :-
	eccs_global_variable(eccs_last_sentence_list, []), !,
	eccs_to_user(['No', strings, entered, yet]),
	fail.

eccs_menu(reparse, popup,
	  [ options = [ command('$$PREVIOUS_STRINGS',
	                        eccs_parse_from_menu('$$')),
			'$$HELP'(interface, 'Parse Menu') ],
            prompt = 'Re-parse Menu' ]) :-
	eccs_global_variable(eccs_last_sentence_list, List),
	eccs_length(List, Length),
	Length < 21, !.

eccs_menu(reparse, dbox,
	[ fields = [ field('Number to parse (see main window)', '')],
	command = (eccs_nth_element('$$', List, String),
	           eccs_parse_from_menu(String)) ]) :-
	eccs_global_variable(eccs_last_sentence_list, List),
	eccs_length(List, Length),
	Length > 20,
	eccs_display_strings(1, List).


eccs_menu(test_parse, popup,
	  [ options = [ command('$$TEST_STRINGS',
	                        eccs_parse_from_menu('$$')),
			'$$HELP'(interface, 'Parse Menu') ],
            prompt = 'Parse Test Menu' ]) :-
	eccs_global_variable(test_sentence_list, List),
	eccs_length(List, Length),
	Length < 20, !.

eccs_menu(test_parse, dbox,
	[ fields = [ field('Number to parse (see main window)', '')],
	command = (eccs_nth_element('$$', List, String),
	           eccs_parse_from_menu(String)) ]) :-
	eccs_global_variable(test_sentence_list, List),
	eccs_display_strings(1, List).


eccs_display_strings(_Num, []) :- !.
eccs_display_strings(Num, [H|T]) :-
	eccs_message([Num, '> ', H]),
	NewNum is Num + 1,
	eccs_display_strings(NewNum, T).


/* environment menu */

eccs_menu(environment, popup,			
	  [ options = [ command('Show all variables', 
	                    eccs_do_menu(all_variables, [])),
			command('$$CONCAT'('Show ', 
	                                   '$$VARIABLE_CLASSES', 
	                                   ' variables'),
			    eccs_do_menu(class_variables('$$'), [])),
	                command('Set variable value',
			    eccs_do_menu(dbox,
			        [ fields = [field('Variable to set:', '')],
				  command=eccs_set_variable_from_menu('$$')])),
	                '$$PROLOG',
			'$$HELP'(interface, 'Environment Menu') ],
	    stayhere = true,
            prompt = 'Environment Menu' ]).


eccs_menu(all_variables, popup,
	  [ options = [ command("Exit Menu", true),
	                '$$LINE',
	                command('$$CONCAT'('', '$$VARIABLE_NAMES',
	                                  ': ', 
					  '$$DISPLAY_VARIABLE'('$$')),
			    eccs_set_variable_from_menu('$$', 
			                                '$$VARIABLE'('$$'))),
	                '$$PROLOG',
			'$$HELP'(interface, 'Environment Menu') ],
            prompt = 'Set Variable' ]).
eccs_menu_geometry(all_variables, '+100+0').

/* see comments on fb_var_routine $$CONCAT for reasons for dummy '' at
start of list to be concatenated */


eccs_menu(class_variables(Class), popup,
	  [ options = [ command("Exit Menu", true),
	                '$$LINE',
                        command('$$CONCAT'('', '$$VARIABLE_NAMES'(Class),
	                                  ': ', 
					  '$$DISPLAY_VARIABLE'('$$')),
			    eccs_set_variable_from_menu('$$', 
			                                '$$VARIABLE'('$$'))),
	                '$$PROLOG',
			'$$HELP'(interface, 'Environment Menu') ],
            prompt = 'Set Variable' ]).

eccs_menu_geometry(class_variables(_Class), '+100+0').



/*

PostScript added by Jo: Fri Jul  5 16:14:01 1991

Wed Mar 17 16:19:23 1993 JC Minor changes to organization of printing
output.  Before we used to run through printing options, before
picking up the SPF to print via the variable eccs_last_output.  This
meant that we couldn't easily print from the derivation checker.  

The strategy is now to pick up the thing to print early on, and pass
it as an argument to the various submenus.

New routine eccs_ps_hardcopy/0.  

*/

eccs_menu(postscript, popup,
	[ options = ['$$POSTSCRIPT_OPTIONS',
		     command('Hardcopy', eccs_ps_hardcopy),
		     command('Show printer queue', eccs_lpq),
		     '$$HELP'(interface, 'PostScript') ],
	  prompt = 'PostScript']).

/*

Sat Apr 3 16:02:45 1993 Altered options order so that Times Roman is
the first option.

*/


eccs_menu(ps_set_font, popup,
	[ options = [command('Times Roman', 
				eccs_ps_set_font('Times Roman')),
		     command('Avant Garde', 
				eccs_ps_set_font('Avant Garde')),
		     command('Computer Modern Roman', 
				eccs_ps_set_font('Computer Modern Roman')),
		     command('User', 
				eccs_ps_set_font('user'))],
	  prompt = 'Set PostScript Font']).


/*

More PostScript stuff.  Jo Tue Jul  9 19:29:49 1991

*/

		     

eccs_menu(hc(Args), popup, 
	[options = [
	    command('Hardcopy to a file', 
		eccs_do_menu(hcf(Args))),
 	    command('... to a printer', 
		eccs_do_menu(hcs(Args)))],
 	 prompt = 'Hardcopy']).



eccs_menu(hcf(Args), dbox, 
	[fields = [field('Name of output file', '')],
	 command = eccs_do_menu(hcfont([outfile='$$'|Args]))]).

eccs_menu(hcs(Args), dbox, 
	[fields = [field('Scale to apply', N)],
	 command = eccs_do_menu(hcaspect([scale='$$'|Args]))]) :-
   (eccs_ps_state(absolute_scale, N); N = 1), !.

eccs_menu(hcaspect(Args), popup,
    [options = [command('Landscape', eccs_do_menu(hcfont([landscape|Args]))),
    		command('Portrait', eccs_do_menu(hcfont(Args)))],
     prompt = 'Hardcopy aspect']).

/*

Mon Apr  5 12:43:44 1993 JC

Made Times Roman the first option. 

*/

eccs_menu(hcfont(Args), popup, 
	[options = [
	     command('Times Roman', 
			eccs_hardcopy_do_it([font='Times Roman'|Args])),
	     command('Computer Modern Roman', 
			eccs_hardcopy_do_it([font='Computer Modern Roman'|Args])),
	     command('Avant Garde', 
			eccs_hardcopy_do_it([ font = 'Avant Garde' | Args]))],
         prompt = 'Set font for hardcopy']).
		     


/*  Other prolog stuff, to allow quicker access to various functions */

eccs_menu(other_prolog, popup,
	  [ options = [ command('spy ...', 
	                       eccs_spy_dialog),
			command('consult ...', 
	                       eccs_consult_dialog),
	                command(debug, debug),
			command(nodebug, nodebug),
			command(trace, trace),
			command('Call predicate',     eccs_do_menu(call_pred))],
            prompt = 'Prolog Operations' ]).

/* DIALOG BOXES */

eccs_menu(dbox, dbox, []).

eccs_menu(load_named_file, dbox, 
          [ fields = [field('Name of file to load:', '')],
            command = eccs_load_files(['$$']) ]).

eccs_menu(recompile_named_file, dbox,
	  [ fields = [ field('File to recompile:', '')],
	    command = eccs_recompile(['$$']) ]).

eccs_menu(edit_named_file, dbox, 
          [ fields = [field('Name of file to edit:', '')],
            command = eccs_edit_file(['$$']) ]).

eccs_menu(edit_object, dbox, 
          [ fields = [field('Object type to edit:', '')],
            command = eccs_edit_object('$$') ]).

eccs_menu(named_object, dbox,
	  [ fields = [field('Name of object to display:', '')],
	    command = eccs_list_named_object('$$') ]).

eccs_menu(named_file_objects, dbox, 
          [ fields = [field('Name of file to list objects from:', '')],
            command = eccs_list_by_file('$$') ]).

eccs_menu(parse_from_menu, dbox,
	  [ fields = [field('String to parse:', String)],
	    command = eccs_parse_from_menu('$$') ]) :-
    (eccs_global_variable(eccs_last_sentence, X),
      eccs_interpolate_char(' ', X, S1),
      eccs_concat_list(S1, String);
      String = ''), !.


/*

PostScript menus added by JC Sun Jul  7 23:21:50 1991

*/

eccs_menu(ps_set_ds, dbox, 
    	  [ fields = [field('Set PostScript default scale:', N)],
	    command = eccs_ps_set_default_scale('$$')]) :-
    (eccs_ps_state(default_scale, N); N=1), !.

eccs_menu(ps_set_as, dbox, 
    	  [ fields = [field('Set PostScript absolute scale:', N)],
	    command = eccs_ps_set_absolute_scale('$$')]) :-
    (eccs_ps_state(absolute_scale, N); N=0), !.


eccs_menu(eccs_ps_resize_dialog, dbox,
	  [ fields = [field('Set New PostScript Window Width', 1000)],
	    command = eccs_do_menu(eccs_ps_resize_dialog1('$$'))]).
eccs_menu(eccs_ps_resize_dialog1(Width), dbox,
	  [ fields = [field('Set New PostScript Window Height', 800)],
	    command = eccs_ps_new_window(Width, '$$')]).

/*

Thu Jan 28 11:51:53 1993 JC

menu for asking user what to do after an interrupt

For the reason why trace is not explicitly called below, see psys.pl

*/

eccs_menu(interrupt, popup,
	  [ options = [ command(abort, 
			    eccs_sys_throw(pleuk_exception(normal, [aborting]))),
			command(trace, 
			    true),
			command(exit, 
			    eccs_pleuk_halt)],
            prompt = 'Pleuk Interrupted' ]).



/*

Prolog stuff

*/

eccs_spy_dialog :-
    eccs_do_menu(spy).

eccs_menu(spy, dbox, 
	  [ fields = [field('Predicate to spy', '')],
	    command = eccs_do_spy('$$')]).

eccs_consult_dialog :-
   eccs_do_menu(consult_or_compile).

eccs_menu(consult_or_compile, popup,
	[ options = [command('Consult', eccs_do_menu(consult(consult))),
		     command('Compile', eccs_do_menu(consult(compile)))],
	  prompt = 'Consult or compile?']).

eccs_menu(consult(Mode), dbox,
	  [ fields = [field('File to consult', '')],
	    command = eccs_load_prolog(Mode, '$$')]).


eccs_menu(call_pred, dbox,
	[ fields = [field('Predicate to call (supply no arguments)', '')],
	  command = eccs_sys_call('$$')]).

eccs_load_prolog(Mode, File) :-
    eccs_file_exists(File),
    !,
    eccs_load_prolog1(Mode, File).
eccs_load_prolog(Mode, File) :-
    eccs_sys_name(File, L),
    \+ eccs_append(_, ".pl", L),
    !,
    eccs_append(L, ".pl", L1),
    eccs_sys_name(F1, L1),
    eccs_file_exists(F1),    
    ((eccs_global_variable(prolog_type, T), eccs_member(T, [quintus, sicstus]))
      -> eccs_load_prolog1(Mode, File)
         ; eccs_load_prolog1(Mode, F1)).

eccs_load_prolog(_, File) :-
    eccs_warning([file, File, does, not, exist]).

eccs_load_prolog1(compile, File) :-
    compile(File).
eccs_load_prolog1(consult, File) :-
    consult(File).

eccs_do_spy(Pred) :-
    eccs_sys_name(Pred, L),
    eccs_append(L1, [0'/|L0], L), !,
    eccs_sys_name(PredF, L1),
    eccs_sys_name(PredA, L0),
    spy(PredF/PredA).
eccs_do_spy(Pred) :-
    spy(Pred).




/* ALERT BOXES */

eccs_menu(exit, alert, [ alert = 'Really Quit?',
                         yescommand = eccs_pleuk_halt]).

eccs_menu(confirm, alert, []).

eccs_menu(contexts, alert, [alert = 'No grammar description file specified--load one',
		yescommand = eccs_load_gdf_from_menu]).





eccs_set_variable_from_menu(Var) :-
	eccs_sys_if_then_else(eccs_global_variable(Var, Value), true,
	                  (eccs_message([no, such, 'variable:', Var]), fail)),
        eccs_set_variable_from_menu(Var, Value).

/* Mon Aug 24 11:33:13 1992 JC  Trap for boolean variables, so
   that the opposite value is the default new value */
eccs_set_variable_from_menu(Var, Bool) :-
	eccs_menu_boolean(Bool, Toggle), !,
	eccs_concat_list([Var, ': current value is ', Bool], L),
	eccs_do_menu(dbox, 
	             [ fields = [field(L, Toggle)],
		       command = eccs_set_variable(Var, '$$') ]).
eccs_set_variable_from_menu(Var, CurrentVal) :-
	eccs_sys_atomic(CurrentVal), !,
	eccs_do_menu(dbox, 
	             [ fields = [field(Var, CurrentVal)],
		       command = eccs_set_variable(Var, '$$') ]).
eccs_set_variable_from_menu(Var, CurrentVal) :-
	eccs_message([Var, ' = ', CurrentVal]),
	eccs_concat_list([Var, ': See main window for current value'], Ms),
	eccs_do_menu(dbox,
	             [ fields = [field(Ms,'')],
		       command = eccs_set_variable(Var, '$$') ]).

eccs_menu_boolean(true, false).
eccs_menu_boolean(false, true).

/*

eccs_xinfo(File, Node)

Invoke xinfo as a subprocess.

Added environment test, JC Wed Dec 11 13:29:10 1991, so that we don't 
get an error when not running under X.

*/

eccs_xinfo(File, Node) :-
    	eccs_environment('DISPLAY', _),
	eccs_user_message(['Starting XInfo.']),
	eccs_global_variable(pleuk_etc, Dir),
	eccs_os_list_to_path_name([Dir, 'xinfo_call'], Path),
	eccs_unix_format_and_call([Path, File, Node]).


/*

Info interface for specializations

should really be done elsewhere ...

*/

eccs_spec_info :-
    eccs_sys_current_predicate(eccs_spec_info, eccs_spec_info(_, _)),
    !,
    eccs_spec_info(File, Node),
    eccs_xinfo(File, Node).
eccs_spec_info :-
    eccs_sys_current_predicate(eccs_spec_info, eccs_spec_info(_)),
    !,
    eccs_spec_info(File),
    eccs_xinfo(File, top).
eccs_spec_info :-
    eccs_to_user(['There', is, no, documentation, available, for, this, specialization]),
    fail.

/*

Info interface for specializations


*/

eccs_menu_spec_info :-
    eccs_sys_current_predicate(eccs_spec_info, eccs_spec_info(_, _)),
    !,
    eccs_spec_info(File, Node),
    eccs_xinfo(File, Node).
eccs_menu_spec_info :-
    eccs_sys_current_predicate(eccs_spec_info, eccs_spec_info(_)),
    !,
    eccs_spec_info(File),
    eccs_xinfo(File, top).
eccs_menu_spec_info :-
    eccs_to_user(['There', is, no, documentation, specified
, for, this, specialization]),
    fail.


/*

Wed Jan 20 15:31:50 1993 JC

The cut is in here to prevent failing back into the confirm, which
seemed to be resatisfying.

*/


eccs_maybe_delete_all :- 
    eccs_delete_all_definitions,
    eccs_maybe_reload, !.

eccs_maybe_reload :-
    eccs_global_variable(reload_after_deleting_all_defs, true), !,
    eccs_load_from_menu.
eccs_maybe_reload.

/*

Thu Jan 28 12:20:49 1993 JC

Check with the user if an abort is really wanted and, if so, do it. 

*/

eccs_ask_abort :-
    eccs_do_menu(confirm, [alert = 'Really abort?']), !,
    eccs_message([type, 'pleuk.', to, restart]),
    eccs_sys_abort. 


/*

Stuff for PostScript and DC output

*/

eccs_ps_hardcopy :-
    eccs_global_variable(eccs_last_output, X),
    \+ X = [],		% may be nothing printed yet
    !,
    eccs_do_menu(hc([to_print = X])).
eccs_ps_hardcopy :-
    eccs_message([no, output, to, print]).

eccs_dc_hardcopy(Output) :-
    eccs_do_menu(hc([to_print = Output])).
