/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:59:15 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pmenuvars.pl,v $',
	'$State: Exp $').

$Log: pmenuvars.pl,v $
% Revision 1.0  1993/04/26  16:59:15  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:09:51  pleuk
% *** empty log message ***
%
% Revision 0.2  1991/07/15  09:52:47  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 1.1  1991/07/15  09:48:06  pleuk
% Initial revision
%

*/



/* Menu Variable definitions */

eccs_fb_var_routines(ConcatTerm, [Atom]) :-
	ConcatTerm =.. ['$$CONCAT',First|List],
	eccs_sys_if_then_else(eccs_windows_available(_),
	    eccs_concat_menu_list([First|List], String),
	    eccs_concat_menu_list(List, String)),
	eccs_sys_name(Atom, String).

/* for dumb terminal version, first item of each concatenated list is
omitted.  this avoids lists such as 'show x', 'show y', 'show z'
making tty entry easier.  but, if first item required in dumb terminal
version, dummy must be added which can be safely deleted but won't
show up in X menus - see variable setting menu definitions for egs. */

eccs_concat_menu_list([],[]).
eccs_concat_menu_list([Head|Tail], ConcatList) :-   
	eccs_sys_if_then_else(eccs_sys_name(Head, HeadChars), true,
	                      eccs_name_list(Head, HeadChars)),
	eccs_concat_menu_list(Tail, ConcatTail),
	eccs_append(HeadChars, ConcatTail, ConcatList), !.


eccs_fb_var_routines('$$PROC'(Term), [Result]) :-
	Term =.. [Functor|Args],
	eccs_append(Args, [Result], NewArgs),
	NewTerm =.. [Functor|NewArgs],
	eccs_sys_call(NewTerm).


/* variable values - all return lists */

eccs_fb_var_routines('$$MAJOR_MODULE', [Module]) :-
	eccs_module(Module, _Doc, major, _Dir, _File, _FTypes).

/*

Mod Thu Aug 1 11:02:14 1991, JC, to remove assumption that there are
always minor modules.

*/

eccs_fb_var_routines('$$MINOR_MODULES', Modules) :-
	bagof(Module,
	      Doc^Dir^File^FTypes^(eccs_module(Module, Doc, minor, Dir, File, FTypes)),
	      Modules), !.
eccs_fb_var_routines('$$MINOR_MODULES', []).

eccs_fb_var_routines('$$ALL_MODULES', [MajorModule|MinorModules]) :-
	eccs_module(MajorModule, _Doc, major, _Dir, _File, _FTypes),
	eccs_fb_var_routines('$$MINOR_MODULES', MinorModules), !.

eccs_fb_var_routines('$$DEFINED_OBJECT_TYPES', Types) :-
	setof(Type,
	      eccs_object_type_with_definition(Type),
	      Types).

eccs_fb_var_routines('$$DEFINED_OBJECT_TYPES'(Module), Types) :-
	setof(Type,
	      (eccs_module_type(Module, Type),
               eccs_object_type_with_definition(Type)),
	      Types).

eccs_fb_var_routines('$$ALL_OBJECT_TYPES', Types) :-
	eccs_current_object_types(Types).

eccs_fb_var_routines('$$ALL_OBJECT_TYPES'(Module), Types) :-
	setof(Type,
	      eccs_module_type(Module, Type),
	      Types).


eccs_module_type(Module, Type) :-
	eccs_current_object_type(Type),
	eccs_file_gives_rise_to_objects(File, ObjectTypes),
	eccs_memberchk(Type, ObjectTypes),
	eccs_module(Module, _Doc, _Type, _ModuleDir, _ModuleFile, FileTypes),
	eccs_memberchk(File, FileTypes).

eccs_fb_var_routines('$$VARIABLE_CLASSES', Classes) :-
	eccs_sys_if_then_else(
	eccs_global_variable(show_only_user_variables, true),
	setof(Class,
	      Name^Value^Access^Comment^(
	            eccs_global_variable(Name, Value, Class, Access, Comment),
		    \+ (Class = private)),
	      Classes),
	setof(Class,
	      Name^Value^Access^Comment^(
	            eccs_global_variable(Name, Value, Class, Access, Comment)),
	      Classes)).

eccs_fb_var_routines('$$VARIABLE_NAMES', Names) :-
	eccs_global_variable(show_only_runtime_variables, true), !,
	eccs_sys_if_then_else(
	eccs_global_variable(show_only_user_variables, true),
	setof(Name,
	      Value^Class^Comment^(
	            eccs_global_variable(Name, Value, Class, run, Comment),
		    \+ (Class = private)),
	      Names),
	setof(Name,
	      Value^Class^Comment^(
	            eccs_global_variable(Name, Value, Class, run, Comment)),
	      Names)).
eccs_fb_var_routines('$$VARIABLE_NAMES', Names) :-
	eccs_sys_if_then_else(
	eccs_global_variable(show_only_user_variables, true),
	setof(Name,
	      Value^Class^Access^Comment^(
	            eccs_global_variable(Name, Value, Class, Access, Comment),
		    \+ (Class = private)),
	      Names),
	setof(Name,
	      Value^Class^Access^Comment^(
	            eccs_global_variable(Name, Value, Class, Access, Comment)),
	      Names)).

eccs_fb_var_routines('$$VARIABLE_NAMES'(Class), Names) :-
	eccs_global_variable(show_only_runtime_variables, true), !,
	setof(Name,
	      Value^Class^Comment^(eccs_global_variable(Name, Value, Class, run, Comment)),
	      Names).
eccs_fb_var_routines('$$VARIABLE_NAMES'(Class), Names) :-
	setof(Name,
	      Value^Class^Access^Comment^(eccs_global_variable(Name, Value, Class, Access, Comment)),
	      Names).

eccs_fb_var_routines('$$ALL_VARIABLE_NAMES', Names) :-
	eccs_global_variable(show_only_runtime_variables, true), !,
	setof(Name,
	      Value^Class^Comment^(eccs_global_variable(Name, Value, Class, run, Comment)),
	      Names).
eccs_fb_var_routines('$$ALL_VARIABLE_NAMES', Names) :-
	setof(Name,
	      Value^Class^Access^Comment^(eccs_global_variable(Name, Value, Class, Access, Comment)),
	      Names).

eccs_fb_var_routines('$$CURRENT_FILES', Files) :-
	setof(Name,
	      Attributes^(eccs_current_file(Name, Attributes)),
	      Files).

eccs_fb_var_routines('$$CURRENT_FILES'(Module), Files) :-
	eccs_module(Module, _Doc, _Type, _Dir, _FileName, FTypes),
	setof(File,
	      FTypes^(eccs_module_file(FTypes, File)),
	      Files).

eccs_module_file(FTypes, File) :-
	eccs_current_file(File, [type=FileType|_]),
	eccs_member(FileType, FTypes).


eccs_fb_var_routines('$$VARIABLE'(Variable_Name), [Value]) :-
	eccs_global_variable(Variable_Name, Value).

eccs_fb_var_routines('$$DISPLAY_VARIABLE'(Variable_Name), [Value]) :-
	eccs_global_variable(Variable_Name, Value),
	eccs_sys_atomic(Value), !.
eccs_fb_var_routines('$$DISPLAY_VARIABLE'(_Variable_Name), ['(too long to display)']).

eccs_fb_var_routines('$$PARSING_OPTIONS',
	            [ command('Parse a string',
		              eccs_do_menu(parse_from_menu, [])),
		      command('Reparse a previous string',
		              eccs_do_menu(reparse, [])) |
		      OtherOptions ]) :-
	eccs_sys_if_then_else(
                 eccs_global_variable(test_sentence_list, []),
		 OtherOptions = [],
		 OtherOptions = [ command('Parse a test string',
		                          eccs_do_menu(test_parse, [])) ]).

eccs_fb_var_routines('$$DERIVATION_CHECKER', Options) :-
    \+ dc_running, 
    eccs_sys_if_then_else(eccs_global_variable(eccs_spec_supports_dc, true),
    	Options = [ command('Start derivation checker', dc_top_level_start)],
	Options = []).
eccs_fb_var_routines('$$DERIVATION_CHECKER', Options) :-
    dc_running,
    Options = [command('Return to derivation checker', dc_resume),
    	       command('Stop derivation checker', dc_stop)].

eccs_fb_var_routines('$$PREVIOUS_STRINGS', Strings) :-
	eccs_global_variable(eccs_last_sentence_list, List),
	findall(String,
	        (eccs_member(X, List),
		 eccs_interpolate_char(' ', X, S1),
		 eccs_concat_list(S1, String)),
		Strings).

eccs_fb_var_routines('$$TEST_STRINGS', Strings) :-
	eccs_global_variable(test_sentence_list, List),
	findall(String,
	        (eccs_member(X, List),
		 eccs_interpolate_char(' ', X, S1),
		 eccs_concat_list(S1, String)),
		Strings).


eccs_fb_var_routines('$$PRINT_PARSE_OPTIONS',
	[ command('Print parse', eccs_show_current_parse(_)),
	  line,
	  command('Environment', eccs_do_menu(environment))]) :-
    eccs_last_sentence_analysis(_, 1, _), !.  % only one parse found
eccs_fb_var_routines('$$PRINT_PARSE_OPTIONS',
	[ command('Print current parse', eccs_show_current_parse(_)),
	  command('Print next parse', eccs_show_next_parse),
	  command('Print previous parse', eccs_show_previous_parse),
	  line,
	  command('Environment', eccs_do_menu(environment))]).

eccs_fb_var_routines('$$DEBUG_OPTIONS',
	[ line, command('Debug', eccs_do_menu(debug)) ]) :-
    eccs_find_menu(debug, _, _), !.
eccs_fb_var_routines('$$DEBUG_OPTIONS',	[]).


eccs_fb_var_routines('$$POSTSCRIPT_OPTIONS', []) :-
	\+ eccs_windows_available(_), 
	\+ eccs_environment('DISPLAY', _), !.
eccs_fb_var_routines('$$POSTSCRIPT_OPTIONS', 
	           [ command('Start PostScript', 
		             (eccs_user_message(['Starting PostScript.']),
			      eccs_start_postscript,
			      eccs_do_menu(postscript))),
		     line ]) :-
	\+ (eccs_postscript_available), !.
eccs_fb_var_routines('$$POSTSCRIPT_OPTIONS', 
		   [ command('Reset PostScript', eccs_reset_postscript),
		     command('Stop PostScript', eccs_stop_postscript),
		     line,
		     command('Set Font', eccs_do_menu(ps_set_font)),
		     command('Show/Hide A4 Landscape Borders', eccs_ps_show_a4_borders),
		     command('Show/Hide A4 Portrait Borders', eccs_ps_show_a4_portrait_borders),
		     command('Set Default Scale', eccs_do_menu(ps_set_ds)),
		     command('Set Absolute Scale', eccs_do_menu(ps_set_as)),
%		     line,
%		     command('New Window', eccs_ps_new_window),
		     command('Resize Window', 
		             eccs_do_menu(eccs_ps_resize_dialog)),
		     line ]).

/* 
Fri Jan 15 16:59:31 1993 JC

The four lines commented out above reflect changes to ghostscript that
we can't work around.

*/


/* ???
eccs_fb_var_routines('$$GRAMMAR_NAMES', Names) :-
*/

/* ??? enourmous lists (too big for screen) */
eccs_fb_var_routines('$$DEFINED_OBJECTS'(Type), Object_Names) :-
	setof(Name,
	      Object^(eccs_get_from_database(Type, Name, Object)),
	      Object_Names).

/* ???
eccs_fb_var_routines('$$LAST_SELECTED_OBJECT_TYPE', [Object_Type]) :-
*/

/* ???
eccs_fb_var_routines('$$LAST_SELECTED_OBJECT_NAME', [Object_Name]) :-
*/

/* ???
eccs_fb_var_routines('$$NAME', [Menu_Name]) :-
*/

eccs_fb_var_routines('$$LINE', [line]).

eccs_fb_var_routines('$$HELP'(_File, _Node), []) :-
	\+ (eccs_windows_available(_)), !.
eccs_fb_var_routines('$$HELP'(File, Node), 
	             [ line,
		       command("Help", eccs_xinfo(File, Node))]).

eccs_fb_var_routines('$$PROLOG', Options) :-
	eccs_sys_if_then_else(eccs_global_variable(add_prolog_options_to_menu, true),
	        Options = [ line,
	                       command("Prolog trace",
		                      (trace,
				       eccs_user_message(['Pleuk resumed.']))),
		               command("Prolog break", 
			              (break, 
				       eccs_user_message(['Pleuk resumed.']))),
			       command("Prolog halt", eccs_do_menu(exit)),
			       command("Prolog abort", eccs_ask_abort),
			       command("Other", eccs_do_menu(other_prolog))],
		Options = []).

eccs_fb_var_routines('$$CANCEL', [line, 
	                          command("Exit Menu", true)]).

/*

Context support

added by JC Wed Jul 31 12:04:18 1991 

*/

eccs_fb_var_routines('$$CONTEXT_OPTIONS', [command('Contexts', eccs_do_menu(contexts))]) :-
    eccs_have_contexts, !.
eccs_fb_var_routines('$$CONTEXT_OPTIONS', []).

eccs_fb_var_routines('$$CONTEXTS', [Top|Cs]) :-
	eccs_top_of_context_tree(Top),
	findall(C,
		eccs_context_tree(_, C),
		Cs).



:- dynamic eccs_spec_var_routines/2.
:- multifile eccs_spec_var_routines/2.

eccs_spec_var_routines('$$DUMMY_SPECIALIZATION_MENU_VARIABLE', [dummy]).

    

