/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:59:15 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pmenux.pl,v $',
	'$State: Exp $').

$Log: pmenux.pl,v $
% Revision 1.0  1993/04/26  16:59:15  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:09:51  pleuk
% *** empty log message ***
%
% Revision 0.2  1991/07/15  09:52:47  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 1.1  1991/07/15  09:48:06  pleuk
% Initial revision
%

*/

/* Callouts to dumb terminal versions of all menus added by kwh: 
Wed Sep 18 18:57:39 BST 1991
pmenus.pl removed */



eccs_fancy_input :-
    eccs_windows_available(_),
    \+ eccs_global_variable(eccs_input_mode, dumb).

eccs_do_menu(Menu) :- eccs_do_menu(Menu, []).



/* POPUP MENUS */


/* (Selection == 'Exit Menu' -> !; true)
added by JC Sun Jul  7 22:27:10 1991, so as to prevent 
failing back to the menu when the exit option is chosen.*/


eccs_do_menu(Menu, ExtraArgs) :-
	eccs_sys_if_then_else(eccs_fancy_input,
	    eccs_find_menu(Menu, popup, MenuArgs),
	    eccs_find_dumb_menu(Menu, popup, MenuArgs)),
	eccs_build_menu(Menu, popup, MenuArgs, ExtraArgs, Args),
	eccs_get_argument(prompt, Prompt, Args),
	eccs_get_option_argument(Args, Options),
	eccs_expand_menu_options(Options, ExpandedOptions), !,
	eccs_sys_if_then_else(eccs_get_argument(stayhere, true, Args),
	                      eccs_maybe_abort_repeat,
			      true),
        eccs_do_selection(Menu, Prompt, ExpandedOptions, Selection),
	eccs_do_exit_command(Args, Selection), 
	(Selection == 'Exit Menu' -> !; true),
	fail.


eccs_do_selection(Menu, Prompt, Options, Selection) :-
	eccs_construct_menu_list(Menu, Prompt, Options, MenuList),
	eccs_sys_if_then_else(eccs_fancy_input,
	    eccs_xmenu(MenuList, Selection),
	    eccs_dumb_menu(MenuList, Selection)),
	eccs_find_command(Options, Selection, Command),
	eccs_sys_call(Command).


eccs_construct_menu_list(Menu, Prompt, Options, XMenuList) :-
	eccs_construct_menu_list(Options, MenuList),
	((eccs_menu_geometry(Menu, Geom), !);
	 eccs_menu_geometry(default, Geom)),
	eccs_append(['-geometry', Geom], MenuList, XMenuList1),
	eccs_sys_if_then_else(eccs_sys_atomic(Prompt),
	                      PromptAtom = Prompt,
			      eccs_sys_name(PromptAtom, Prompt)),
	eccs_append(['-heading', PromptAtom], XMenuList1, XMenuList).

eccs_construct_menu_list([], []).
eccs_construct_menu_list([[]|Rest], RestAtoms) :-
	eccs_construct_menu_list(Rest, RestAtoms).
eccs_construct_menu_list([line|Rest], [line|RestAtoms]) :-
	eccs_construct_menu_list(Rest, RestAtoms).
eccs_construct_menu_list([command(Command, _Action)|Rest], [Atom|RestAtoms]) :-
	eccs_sys_if_then_else(eccs_sys_atomic(Command),
	                      Atom = Command,
			      eccs_sys_name(Atom, Command)),
	eccs_construct_menu_list(Rest, RestAtoms).

eccs_find_command(Options, Selection, Command) :-
	eccs_memberchk(command(Selection, Command), Options).
eccs_find_command(Options, Selection, Command) :-
	eccs_sys_name(Selection, SelectionChars),
	eccs_memberchk(command(SelectionChars, Command), Options).



/* ALERT BOX */
eccs_do_menu(Menu, ExtraArgs) :-
	eccs_find_menu(Menu, alert, MenuArgs),
	eccs_build_menu(Menu, alert, MenuArgs, ExtraArgs, Args),
	eccs_get_argument(alert, Alert, Args),
	eccs_sys_if_then_else(eccs_listp(Alert),
                              eccs_add_alert_nl(Alert, AlertNL),
			      AlertNL = Alert),
	eccs_sys_if_then_else(eccs_sys_atomic(AlertNL),
			      AlertAtom = AlertNL,
	                      eccs_sys_name(AlertAtom, AlertNL)),
	((eccs_alert_geometry(Menu, Geom), !);
	 eccs_alert_geometry(default, Geom)),
	eccs_sys_if_then_else(eccs_do_confirm(['-heading', AlertAtom,
	                                      '-geometry', Geom]),
	                      (eccs_get_argument(yescommand, Yes, Args),
			       eccs_sys_call(Yes)),
			      (eccs_get_argument(nocommand, No, Args),
			       eccs_sys_call(No)) ),
        eccs_do_exit_command(Args, _).	

eccs_do_confirm(Args) :-
	eccs_sys_if_then_else(eccs_fancy_input,
	    eccs_xconfirm(Args),
	    eccs_confirm(Args)).

/* dependent on newline character */
eccs_add_alert_nl([], []).
eccs_add_alert_nl([Item | Rest], Chars) :-
	eccs_sys_if_then_else(eccs_sys_name(Item, ItemChars), true,
	                      eccs_name_list(Item, ItemChars)),
	eccs_append(ItemChars, [10], ItemCharsNL),
	eccs_add_alert_nl(Rest, RestChars),
	eccs_append(ItemCharsNL, RestChars, Chars).



/* DIALOG BOX */
eccs_do_menu(Menu, ExtraArgs) :-
	eccs_find_menu(Menu, dbox, MenuArgs),
	eccs_build_menu(Menu, dbox, MenuArgs, ExtraArgs, Args),
	eccs_get_argument(fields, Field, Args),
	eccs_get_dbox_arguments(Menu, Field, DboxArgs),
	eccs_sys_if_then_else(eccs_fancy_input,
            eccs_xdialog(DboxArgs, InputValue),	    
	    eccs_dialog(DboxArgs, InputValue)),
	((eccs_cast_to_number(InputValue, UserInput), !); 
	  UserInput = InputValue),
	eccs_get_argument(tokenizer, Tokenizer, Args),
	eccs_check_dbox_input(UserInput, Tokenizer, CheckedUserInput),
	eccs_get_argument(command, Command, Args),
	eccs_expand_menu_item(Command, CheckedUserInput, _, Expansion),
	eccs_sys_call(Expansion),
	eccs_do_exit_command(Args, CheckedUserInput).


eccs_get_dbox_arguments(Menu, [field(Message, Default)], 
	                ['-heading', MessageAtom,
			 '-default', DefaultAtom, 
			 '-geometry', Geom]) :-
	eccs_sys_if_then_else(eccs_sys_atomic(Message),
	                      MessageAtom = Message,
			      eccs_sys_name(MessageAtom, Message)),
        eccs_atomize_dbox_default(Default, DefaultAtom),
	((eccs_dbox_geometry(Menu, Geom),!);eccs_dbox_geometry(default, Geom)).

eccs_atomize_dbox_default(Default, Default) :-
	eccs_sys_atom(Default), !.
eccs_atomize_dbox_default(Default, DefaultAtom) :-
	eccs_sys_name(Default, Chars),
	eccs_sys_name(DefaultAtom, [35|Chars]). /* append '#' character -
	                                           indicates a numeric value
					           to C routines */

eccs_check_dbox_input(In, _Tokenizer, In).
/* ??? */




/* eccs_build_menu/5 - compile and expand definitions */
/* returns arguments in order: Extra, Menu, Inherited, Default.
   may be duplications but 'eccs_get_argument' only returns first */

eccs_build_menu(Menu, Type, MenuArgs, ExtraArgs, Args) :-
	eccs_sys_if_then_else(Menu = top_level,
	                      DefaultArgs = [],
	                      eccs_menu(default, Type, DefaultArgs)),
        eccs_inherit_menu(MenuArgs, InheritedArgs),
	eccs_append(ExtraArgs, MenuArgs, IntArgs1),
	eccs_append(IntArgs1, InheritedArgs, IntArgs2),
	eccs_append(IntArgs2, DefaultArgs, Args).


eccs_do_exit_command(Args, Selection) :-
	eccs_get_argument(exit_command, Command, Args), !,
	eccs_call_exit_command(Command, Selection).
eccs_do_exit_command(_Args, _Selection).

eccs_call_exit_command(true, _Selection).
eccs_call_exit_command(fail, _Selection) :- fail.
eccs_call_exit_command(cuttrue, _Selection) :- !.
eccs_call_exit_command(cutfail, _Selection) :- !, fail.
eccs_call_exit_command(Command, Selection) :-
	eccs_expand_menu_item(Command, Selection, _, Expansion),
	eccs_sys_call(Expansion).


eccs_default_menu(MenuType, DefaultArgs) :-
	eccs_menu(_Name, MenuType, DefaultArgs), !.
eccs_default_args(_MenuType, []).

eccs_inherit_menu(MenuArgs, InheritedArgs) :-
	eccs_get_argument(inherit, InheritMenu, MenuArgs),
	eccs_find_menu(InheritMenu, _Type, InheritedArgs), !.
eccs_inherit_menu(_MenuArgs, []).

                        

eccs_get_option_argument([], []).
eccs_get_option_argument([ options = Options | Rest ], OptionsOut) :-
	eccs_get_option_argument(Rest, OtherOptions),
	eccs_append(Options, OtherOptions, OptionsOut).
eccs_get_option_argument([ _ | Rest ], OptionsOut) :-
	eccs_get_option_argument(Rest, OptionsOut).



/* expand all $$.. symbols */

eccs_expand_menu_argument(Command, Selection, ExpandedCommand) :-
	Command =.. Elements,
	eccs_expand_menu_item_list(Elements, Selection, _, ExpandedElements),
	ExpandedCommand =.. ExpandedElements.


eccs_expand_menu_item_list([], Value, Value, []).
eccs_expand_menu_item_list([Item|Rest], Value1, Value3 , [ExpandedItem|ExpandedRest]) :-
	eccs_expand_menu_item(Item, Value1, Value2, ExpandedItem),
	eccs_expand_menu_item_list(Rest, Value2, Value3, ExpandedRest).


/* collect all expansions */
eccs_expand_menu_options([], []) :- !.
eccs_expand_menu_options([First|Rest], ExpandedList) :-
	bagof(Expansion, 
	      Value1^Value2^(eccs_expand_menu_item(First, Value1, Value2, Expansion)), 
	      Expansions), !,
	eccs_expand_menu_options(Rest, RestExpansions),
	eccs_append(Expansions, RestExpansions, ExpandedList).
eccs_expand_menu_options([_First|Rest], ExpandedList) :-
	eccs_expand_menu_options(Rest, ExpandedList).





/* pass through any variables */
eccs_expand_menu_item(Item, Value, Value, Item) :-
	eccs_sys_var(Item), !.

eccs_expand_menu_item([Item], Value, Value, [Item]) :-
	eccs_sys_var(Item), !.

/* non-expandable item */
eccs_expand_menu_item(Item, Value, Value, Item) :-
% pjw 25.11.91 to avoid raising exception in quintus
% > >      Item =.. [Item],
% >    	   eccs_sys_atom(Item),
% kwh 1/4/92 - but at least use something that does the same thing
	eccs_sys_atomic(Item),
	\+ (eccs_sys_name(Item, [36,36|_])).

/* $$ sign - left uninstantiated if no value for expansion specified */
eccs_expand_menu_item('$$', Expansion, Expansion, Expansion) :-
	eccs_sys_nonvar(Expansion), !.
eccs_expand_menu_item('$$', Expansion, Expansion, '$$') :- !.

/* attribute/value pair */
eccs_expand_menu_item([X = Y], Value1, Value2, [X = Expanded_Y]) :- !,
	Y =.. YList,
	eccs_expand_menu_item_list(YList, Value1, Value2, Expanded_YList),
	Expanded_Y =.. Expanded_YList.

/* predicate with arguments */
eccs_expand_menu_item(Item, Value1, Value2, ExpandedItem) :-
	Item =.. [Functor|Args],
	\+ (Functor = Item),
	\+ (eccs_sys_name(Functor, [36,36|_])),
	eccs_expand_menu_item_list([Functor|Args], Value1, Value2, ExpandedItemList),
	ExpandedItem =.. ExpandedItemList.

/* menu variable */
eccs_expand_menu_item(Item, ValueIn, ExpansionOut, NewExpansion) :-
	Item =.. [Functor|Args],
	eccs_sys_name(Functor, [36,36|_]),
	eccs_expand_menu_item_list(Args, ValueIn, ValueOut, ExpandedArgs),
	ExpandedItem =.. [Functor|ExpandedArgs],
	(eccs_fb_var_routines(ExpandedItem, Values);
	 eccs_spec_var_routines(ExpandedItem, Values)),
	eccs_check_empty_expansion(Values, ValueList),
	eccs_member(NewExpansion, ValueList),
	eccs_sys_if_then_else(eccs_memberchk(Functor,['$$CONCAT', 
	                                              '$$VARIABLE',
	                                              '$$DISPLAY_VARIABLE']),
	                      ExpansionOut = ValueOut,
			      ExpansionOut = NewExpansion).

eccs_check_empty_expansion([], [[]]) :- !.
eccs_check_empty_expansion(ValueList, ValueList).



/*

eccs_find_menu(Name,  Type, Args)

A menu with Name and Type (from alert, dbox or popup) exists, with
specification Args.  If there is a definition for 
eccs_specialization_menu/3 which matches wrt Name and Type, and the
call to that procedure succeeds, that definition will be used for
Args.  Otherwise, eccs_menu/3 is called instead. 

*/

eccs_find_menu(Name, Type, Args) :-
    eccs_sys_current_predicate(eccs_specialization_menu, eccs_specialization_menu(_, _, _)),
    eccs_sys_call(eccs_specialization_menu(Name, Type, Args)), !.
eccs_find_menu(Name, Type, Args) :-
    eccs_menu(Name, Type, Args).

/*

eccs_find_dumb_menu(Name, Type, Args)

As above, but for the dumb terminal case.  Changed last call of 2nd
clause, JC Wed Dec 11 13:31:06 1991, from eccs_menu, to
eccs_find_menu.  Otherwise we don't get the specialization defined
menus in the dumb terminal case.

*/

eccs_find_dumb_menu(Name, Type, Args) :-
    eccs_sys_current_predicate(eccs_dumb_menu, eccs_dumb_menu(_, _, _)),
    eccs_sys_call(eccs_dumb_menu(Name, Type, Args)), !.
eccs_find_dumb_menu(Name, Type, Args) :-
    eccs_find_menu(Name, Type, Args).




