/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:59:34 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pread_in.pl,v $',
	'$State: Exp $').

$Log: pread_in.pl,v $
% Revision 1.0  1993/04/26  16:59:34  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:10:33  pleuk
% *** empty log message ***
%
% Revision 0.2  1991/07/15  09:30:20  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/*---------------------------------------------------------------------------+
|        								     |
|        Definitions of character types					     |
|        								     |
+---------------------------------------------------------------------------*/
eccs_alpha(Char) :- ((Char >= 97, Char =< 122) ;	% a thru z
		  (Char >= 65, Char =< 90)), 	% A thru Z
		  !.
eccs_uc(Char) :- Char >= 65, Char =< 90.
eccs_lc(Char) :- Char >= 97, Char =< 122.

/* The following fiddling about is to get round C-Prolog's casting of
   reals to ints.  Otherwise 17.00 would read in as 17.  Now we use
   into 17:00
*/
eccs_digit(Char) :- Char >= 48, Char =< 57.
eccs_digit(58).	

eccs_white(Char) :- Char =< 32.		% ascii ' '.
eccs_printingchar(Char) :- Char > 32.

/*---------------------------------------------------------------------------+
|        								     |
|        eccs_read_in(Terminators, List)					     |
|        fetch a list of characters and parse them as a string of words      |
|        and numbers							     |
|        								     |
+---------------------------------------------------------------------------*/
eccs_read_in(End, List) :- 
        get0(Char),
	eccs_sys_if_then_else(Char = 26, (List = end_of_file, EOF = end_of_file,
					  D = []),	% 26 == ascii ^Z
	              eccs_read1(End, Char, D, EOF)),
	eccs_sys_if_then_else(eccs_sys_var(EOF), eccs_words(List, D, []), 
		List = end_of_file), !,
	eccs_sys_if_then_else((List = end_of_file, \+(D = [])),
			eccs_error([end, of, file, while, reading, entry], line),
		    true).

/*---------------------------------------------------------------------------+
|        								     |
|        eccs_read1(End, Char, Result, Comments)				     |
|        read a stream of characters until a terminating char,  	     |
|        returning them as a list.  Comments is a flag that determines 	     |
|        whether prolog one-line comment conventions apply.		     |
|        								     |
+---------------------------------------------------------------------------*/
eccs_read1(_, 26, [], eof) :- !.		% 26  == ascii ^Z
eccs_read1(End, End, [], _) :- !.
eccs_read1(End, Char, [Char|Rest], EOF) :- 
        get0(B),
        eccs_read1(End, B, Rest, EOF).

/*---------------------------------------------------------------------------+
|        								     |
|        A DCG to parse characters read in.  				     |
|        								     |
|        Comments are removed here					     |
|        								     |
+---------------------------------------------------------------------------*/
eccs_words([]) --> [].
eccs_words([F|R]) --> 
	eccs_whitespace,
	eccs_word(F),
	eccs_whitespace,
	eccs_words1(R).  % remove leading whitespace

eccs_words1([First|Rest]) --> eccs_word(First),  !,
			  eccs_whitespace,
		          eccs_words1(Rest).
eccs_words1([]) --> [].

eccs_word(Punc) --> [Char], {eccs_memberchk(Char, ".?,!"), eccs_sys_name(Punc, [Char])}, !.
eccs_word(Word) --> 	  [First], {eccs_alpha(First)},
			  eccs_alphanums(Rest), !,
				    {eccs_checkword([First|Rest], Word)}.
eccs_word(Number) --> 	  [First], {eccs_digit(First)},
				    eccs_digits(Rest), !,
				    {eccs_sys_name(Number, [First|Rest])}.
eccs_word(Symbol) --> 	  [First], {symbol([First|Rest])},
			  eccs_sym_rest(Rest), !, {eccs_sys_name(Symbol, [First|Rest])}.
eccs_word(X) --> 		  [First], {eccs_sys_name(X, [First])}.



eccs_whitespace --> [Char],  {eccs_white(Char)},  !, eccs_whitespace.
eccs_whitespace --> [].

eccs_alphas([Char|Rest]) --> [Char], {eccs_alpha(Char)},
		       eccs_alphas(Rest).
eccs_alphas([])	   --> [].

 

eccs_digits([Char|Rest]) --> [Char], {eccs_digit(Char)},
			  eccs_digits(Rest).
eccs_digits([]) 	      --> [].

%  The \= 58 bit in here is to rule out `:' as an alphanumeric.  It's
% defined to be a digit to get times (as in 17:00 right).
eccs_alphanums([Char|Rest]) --> [Char], {eccs_digit(Char), eccs_not_eq(Char, 58); 
				      eccs_alpha(Char);
				      Char = 95}, !,  % 95 == ascii '_'
			     eccs_alphanums(Rest).
eccs_alphanums([]) --> [].


eccs_sym_rest([]) --> [].
eccs_sym_rest([H|T]) --> [H], eccs_sym_rest(T).

/*---------------------------------------------------------------------------+
|        								     |
|        declarations of non-alphanumeric strings			     |
|        								     |
+---------------------------------------------------------------------------*/

/*
symbol("-->").
symbol("=>").
symbol("[]").
*/

/*---------------------------------------------------------------------------+
|        								     |
|        eccs_checkword(List, Real)					     |
|        								     |
|        Real is the lexical entry for List.  This is where we do 	     |
|        upper to lower case mapping in the case of words that are 	     |
|        not names.  The test for whether some is a name is a hack.	     |
|        								     |
+---------------------------------------------------------------------------*/
eccs_checkword("I", 'I') :- !.
eccs_checkword([F|R], W) :- 
	eccs_lc(F), 
	eccs_sys_name(W, [F|R]).
eccs_checkword([F|R], W) :- 
	eccs_uc(F), 
	eccs_sys_name(Entry, [35, F|R]), 
	eccs_sys_if_then_else(eccs_sys_recorded(Entry, _, _), eccs_sys_name(W, [F|R]),
	 (C is F + 32, eccs_sys_name(W, [C|R]))).


/*

eccs_generic_tokenizer(String, List)

List is a tokenized version of the characters in String.  Any non-printing
character is assumed to be a word separator.

*/

eccs_generic_tokenizer(String, List) :-
    eccs_once(eccs_generic_tokenizer(List, String, [])).

eccs_generic_tokenizer([]) --> [].
eccs_generic_tokenizer([F|R]) -->
    eccs_whitespace,
    eccs_generic_word(F),
    (eccs_real_whitespace, !; eccs_whitespace),
    eccs_generic_tokenizer(R).
eccs_generic_tokenizer([F]) --> 
    eccs_generic_word(F),
    eccs_whitespace.

eccs_generic_word(Word) -->
    eccs_non_white_chars(List),
    {eccs_sys_name(Word, List)}.

eccs_non_white_chars([F|R]) -->
    eccs_non_white(F),
    eccs_non_white_chars(R).
eccs_non_white_chars([]) -->
    [].


eccs_real_whitespace -->
     [Char],  {eccs_white(Char)}.

eccs_non_white(Char) -->
    [Char], {eccs_printingchar(Char)}.

/*

eccs_likely_string(+String)

String is a list consisting wholly of integers representing printing 
characters. An arbitrary upper bound of 256 characters is put on its length.

*/

eccs_likely_string(String) :-
    eccs_likely_string0(256, 0, String).

eccs_likely_string0(Min, Min, []) :- !, fail.
eccs_likely_string0(_Max, _Min, []) :- !.
eccs_likely_string0(Max, Min, [Char|Rest]) :- 
    Max > Min,
    eccs_sys_integer(Char),
    31 < Char, Char < 127,
    eccs_succ(Count, Max),
    eccs_likely_string0(Count, Min, Rest).

