/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:59:34 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pruntime.pl,v $',
	'$State: Exp $').

$Log: pruntime.pl,v $
% Revision 1.0  1993/04/26  16:59:34  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:10:33  pleuk
% *** empty log message ***
%
% Revision 0.3  1991/07/15  09:30:36  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.2  1991/05/21  14:47:09  kwh
% close file information window.
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/*

File:	/home/user2/jo/Pleuk/Code/pruntime.pl
Date:	Fri May 11 15:52:13 1990
By:	Jonathan Calder

Code for use at runtime

*/

eccs_run_time_command_args :- true.

pleuk :- 
    eccs_global_variable(eccs_system_state, run), % already started up
    !,
    eccs_go.
pleuk :- 
    eccs_start_up_hook.


    
eccs_start_up_hook :-
    eccs_load_customization_file,
    eccs_call_spec_init_hooks,
    eccs_do_command_line,
    eccs_determine_window_system,
    eccs_set_up_environment,
    eccs_set_variable(eccs_system_state, run),
    eccs_sys_if_then_else(eccs_global_variable(eccs_start_up_hook, X), call(X), true).

/*

eccs_call_spec_init_hooks 

call any routines requested by a specialization. 

Note that as this is call after the customization file, any routines
the spec asks to be run must *not* affect the settings of variables,
etc.

*/

eccs_call_spec_init_hooks :-
    eccs_sys_safe_call(spec_init_hook(Hook)),
    eccs_sys_safe_call(Hook),
    fail.
eccs_call_spec_init_hooks.

eccs_set_up_environment :-
    eccs_global_variable(prolog_type, sicstus),
    eccs_global_variable(eccs_batch_mode, false),
    fail.

eccs_set_up_environment :-
    eccs_sys_if_then_else(eccs_global_variable(eccs_batch_mode, true),
    		(eccs_set_variable(use_windows, false),
		eccs_set_variable(eccs_start_up_hook, eccs_batch_compile)),
		eccs_sys_if_then_else(eccs_global_variable(use_windows, false),
				      eccs_set_variable(eccs_start_up_hook, 
				            (eccs_runtime_welcome, eccs_top_level)),
				      eccs_set_variable(eccs_start_up_hook, (eccs_runtime_welcome, eccs_top_level)))),
    fail.
eccs_set_up_environment :-
    eccs_once(eccs_set_output_format(feature_structure)),
    fail.
eccs_set_up_environment :-
    eccs_current_directory(Dir),
    eccs_set_variable(eccs_working_directory, Dir),
    eccs_normalize_file_names,
    eccs_sys_if_then_else(eccs_windows_available(_), eccs_window_start_up, eccs_no_windows_start_up).

/*

Altered, JC Wed Dec 11 13:33:44 1991, negative case of the last
implication from ``true'', so that we get a real menu interpreter.

*/

/*

To make certain we always refer to file names which are the values of variables in 
a canonical way ...

*/

eccs_normalize_file_names :-
    FileVariables = [eccs_working_directory,
%		     eccs_log_file,
		     grammar_directory, 
		     eccs_grammar_desc_file],
    eccs_member(Var, FileVariables),
    eccs_global_variable(Var, File),
    eccs_absolute_file_name(File, AFile),
    eccs_set_variable(Var, AFile),
    fail.
eccs_normalize_file_names.

eccs_no_windows_start_up.
%    eccs_make_session_log,
%    eccs_make_output_file.

eccs_pleuk_halt :-
    \+ (eccs_windows_available(_)),
    eccs_call_exit_hooks,
    eccs_sys_halt.
eccs_pleuk_halt :-
    eccs_window_halt,
    eccs_call_exit_hooks,
    eccs_sys_halt.

eccs_window_halt :-
    eccs_close_output_window,
%    eccs_close_log_window,
    eccs_close_file_window.


eccs_close_session_log :-
    eccs_global_variable(session_log_file, File),
    eccs_sys_if_then_else(eccs_file_is_open_for_writing(File),
    	eccs_close_buffer(File), true).




eccs_object_type_with_definition(Type) :-
    eccs_current_object_type(Type),
    eccs_object_db_table(Type, DBType),
    eccs_sys_functor(T, DBType, 4),
    eccs_sys_arg(2, T, Context),
    eccs_once(clause(T, _)),
    eccs_available_context(Context).


 
eccs_do_command_line :-
    eccs_command_args(List),
    eccs_do_command_line1(List).

eccs_do_command_line1([]) :- !.
eccs_do_command_line1(List) :-
    eccs_do_command_line2(List, Rest), !,
    eccs_do_command_line1(Rest).

/*

The +pleukfile option is caught before we get here

Note that in SICStus0.7 and later, all command line options to Prolog
beginning with `-' are assumed to be meaningful to SICStus.  If
they're not, we get an error and so we use `+' as the option marker.
JC Wed Dec 11 13:36:45 1991

In the case where the +nw version is used, we previously set
eccs_set_variable(add_prolog_operations_to_menu, false) this means
that you can't get prolog options at the top level, which is a pain
for debugging.  As `false' is the default, it doesn't make much 
difference.  

*/

eccs_do_command_line2(['+trace'|Rest], Rest) :-
    eccs_set_variable(add_prolog_options_to_menu, true),
    eccs_sys_trace.
eccs_do_command_line2(['+pleukfile', _|Rest], Rest).
eccs_do_command_line2(['+d', Name|Rest], Rest) :-
    eccs_set_variable(grammar_directory, Name).
eccs_do_command_line2(['+dumb_menu'|Rest], Rest) :-
    eccs_set_variable(dumb_menu, true).
eccs_do_command_line2(['+n', Name|Rest], Rest) :-
    eccs_set_variable(grammar_name, Name).
eccs_do_command_line2(['+c'|Rest], Rest) :-
    eccs_set_variable(eccs_batch_mode, true),
    eccs_set_variable(use_windows, false).
eccs_do_command_line2(['+nw'|Rest], Rest) :-
    eccs_set_variable(use_windows, false),
    eccs_set_variable(eccs_start_up_hook, ( eccs_runtime_welcome,eccs_top_level)).
eccs_do_command_line2(['+g', GDFile|Rest], Rest) :-
    (eccs_have_contexts -> 
    	eccs_do_gd_file(GDFile);
	eccs_sys_write('Error: contexts unavailable.  File ignored: '),
	eccs_sys_write(GDFile), eccs_sys_nl).
eccs_do_command_line2(['+restore'|Rest], Rest).
eccs_do_command_line2([X|Rest], Rest) :-
    eccs_sys_write('unknown command line switch '), 
    eccs_sys_write(X), eccs_sys_nl.

eccs_do_gd_file(FileName) :-
    eccs_file_exists(FileName), !,
    eccs_set_variable(eccs_grammar_desc_file, FileName),
    eccs_load_gdf(FileName).



/*

Batch mode compilation

?? This should be checked out for compatibiility with contexts, etc. 

*/


eccs_batch_compile :-
    eccs_global_variable(eccs_batch_mode, true), !,
    eccs_global_variable(grammar_name, GName),
    eccs_load_order(Types),
    eccs_sys_if_then_else(eccs_global_variable(grammar_directory, Dir), true,
     eccs_os_current_directory(Dir)),
     eccs_call_command_in_directory(Dir, eccs_find_grammar_files(GName, Types, NewList)),
    eccs_sys_if_then_else(NewList = [], (eccs_to_user([no, files, need, loading]), fail), true),
    eccs_to_user([the, following, files, will, be, loaded|NewList]),
    eccs_call_command_in_directory(Dir, eccs_global_load(NewList)),
    halt.



/*

The real top level call

*/


eccs_top_level :-
    eccs_maybe_load_X,
    eccs_sys_repeat,
    eccs_sys_init,
    eccs_sys_call_top_level_hooks,
    Ball = pleuk_exception(_, _),
    eccs_sys_catch(eccs_do_menu(top_level), Ball, eccs_top_level_error(Ball)).


/*

And two synonyms

*/

eccs_go :- eccs_top_level.

/*

eccs_sys_call_top_level_hooks

Run through possible hooks to get called at the top level.  These are found 
from 

eccs_sys_top_level_hook/1

spec_top_level_hook/1.

There is no guarantee as to the order in which these hooks get called.

*/

:- multifile eccs_sys_top_level_hook/1, spec_top_level_hook/1.
:- dynamic  eccs_sys_top_level_hook/1, spec_top_level_hook/1.


eccs_sys_call_top_level_hooks :-
    eccs_sys_top_level_hook(Hook),
    eccs_sys_safe_call(Hook), 
    fail.
eccs_sys_call_top_level_hooks :-
    spec_top_level_hook(Hook), 
    eccs_sys_safe_call(Hook), 
    fail.
eccs_sys_call_top_level_hooks.


eccs_sys_top_level_hook(garbage_collect) :-
    eccs_global_variable(prolog_type, sicstus).
eccs_sys_top_level_hook(eccs_close_all_file_streams).

/*

Under SICStus streams can get left open if we abort in the middle of a
file load.  So, every time we get back to the top level, we close all
streams that correspond to grammar files.

*/

eccs_close_all_file_streams :-
    eccs_current_file(File, _),
    (File = AbsFile; eccs_absolute_file_name(File, AbsFile)),
    eccs_current_stream(File, read, S),
    eccs_sys_close(S), fail.
eccs_close_all_file_streams.


/*

eccs_call_exit_hooks

This routine gets called whenever we exit pleuk.


*/
   
eccs_call_exit_hooks :-
    eccs_sys_safe_call(spec_exit_hook(Hook)),
    eccs_sys_safe_call(Hook),
    fail.
eccs_call_exit_hooks :-
    eccs_sys_safe_call(eccs_exit_hook(Hook)),
    eccs_sys_safe_call(Hook),
    fail.
eccs_call_exit_hooks.

:- dynamic eccs_exit_hook/1.
:- multifile eccs_exit_hook/1.

/*

Top level exception handler

Fri Jan 15 14:54:04 1993  JC

This is just a guess at what will be likely.

Divide exceptions into three categories:

Rating is one of fatal, warning, normal

i.e. fatal means a situation from which we can't recover; tidy up as best 
           we can and exit.
     warning means a situation we can probably fix up
     normal means that there is not really any problem.

The latter could be used to implement throws from more deeply to less
deeply embedded menus, but that may not be the best use of the
exception system.

pleuk_exception(Rating, Explanation)

Explanation has the form

dummy		-- do nothing but what is specified in Rating
call(Goal)	-- call Goal (allowed to succeed at most once)
[H|T] 		-- call eccs_{warning,error}([H|T])

Testing routines

throw0 :- eccs_sys_throw(pleuk_exception(normal, dummy)).

throw1 :- eccs_sys_throw(pleuk_exception(normal, [all, is, well])).

throw2 :- eccs_sys_throw(pleuk_exception(normal,
	call((write('all is well'), nl)))).

throw3 :- eccs_sys_throw(pleuk_exception(warning,
	dummy)).
throw4 :- eccs_sys_throw(pleuk_exception(warning,
	[all, is, quite, well])).
throw5 :- eccs_sys_throw(pleuk_exception(warning,
	call((write('all is quite well'), nl)))).

throw6 :- eccs_sys_throw(pleuk_exception(fatal, dummy)).
throw7 :- eccs_sys_throw(pleuk_exception(fatal,
	[all, is, not, well])).
throw8 :- eccs_sys_throw(pleuk_exception(fatal,
	call((write('all is very bad'), nl)))).


*/

eccs_top_level_error(pleuk_exception(fatal, Explanation)) :-
    eccs_once((eccs_tl_error(fatal, Explanation); true)),
    eccs_pleuk_halt.
eccs_top_level_error(pleuk_exception(warning, Explanation)) :-
    eccs_once((eccs_tl_error(warning, Explanation); true)),
    fail.
eccs_top_level_error(pleuk_exception(normal, Explanation)) :-
    eccs_once((eccs_tl_error(normal, Explanation); true)),
    fail.

eccs_tl_error(_, dummy) :- !.
eccs_tl_error(_Type, call(Goal)) :-
    !,
    (Goal, !; true).
eccs_tl_error(Type, L) :-
    eccs_listp(L), !,
    eccs_tl_error1(Type, L).

eccs_tl_error1(fatal, Message) :-
    eccs_error(Message).
eccs_tl_error1(warning, Message) :-
    eccs_warning(Message).
eccs_tl_error1(normal, Message) :-
    eccs_message(Message).


/*

Thu Jan 28 11:03:20 1993 JC

Added the following, so that we keep track of whether we've loaded the
code for X.  This allows eccs_top_level to be called repeatedly
without messages.

*/

:- dynamic eccs_x_loaded/0.

eccs_maybe_load_X :-
    eccs_global_variable(prolog_type, quintus), !,
    eccs_set_variable(eccs_input_mode, dumb).
eccs_maybe_load_X :-
    eccs_sys_current_predicate(eccs_init_dialog_box, eccs_init_dialog_box),
    !.
eccs_maybe_load_X :-
    eccs_global_variable(eccs_window_system, 'X'), 
    \+ eccs_global_variable(dumb_menu, true),
    !,
    eccs_start_X.
eccs_maybe_load_X.

eccs_start_X :-
    eccs_x_loaded, !.
eccs_start_X :-
    eccs_to_user([starting, 'X', system, '...']),
    eccs_srcload([library('Code/C/Xsicstus.pl')]),
    eccs_to_user([loaded, 'X.']),
    eccs_sys_assert(eccs_x_loaded).
/*

Determination of whether or not we have contexts and whether we have a
grammar description file.

*/

eccs_have_contexts :-
    eccs_sys_current_predicate(eccs_set_context, eccs_set_context(_)).

eccs_have_grammar_desc_file :-
    eccs_have_contexts,
    eccs_global_variable(eccs_grammar_desc_file, _).

/*

Somethings which might get called, but which are really to do 
with contexts, so that we can run unknown without contexts. 

*/

:- dynamic eccs_current_context/1.

eccs_current_context(universal).


:- dynamic(eccs_context_tree/2).


eccs_available_context(Context) :-
    (eccs_sys_var(Context) -> Cut = false; Cut=true),
    eccs_current_context(C1),
    eccs_context_tree_tc(Context, C1),
    (Cut = true -> !; true).

eccs_context_tree_tc(C, C).
eccs_context_tree_tc(Mother, Daughter) :-
    eccs_context_tree(M1, Daughter),
    eccs_context_tree_tc(Mother, M1).

eccs_available_context(Context) :-
    (eccs_sys_var(Context) -> Cut = false; Cut=true),
    eccs_current_context(C1),
    eccs_context_tree_tc(Context, C1),
    (Cut = true -> !; true).

eccs_context_tree_tc(C, C).
eccs_context_tree_tc(Mother, Daughter) :-
    eccs_context_tree(M1, Daughter),
    eccs_context_tree_tc(Mother, M1).


/*

Support for the derivation checker

*/

dc_top_level_start :-
    eccs_windows_available(_), 
    eccs_global_variable(use_windows, true), 
    eccs_global_variable(eccs_spec_supports_dc, true), 
    !,
    ensure_loaded(library('Code/pdc')),
    ensure_loaded(library('Code/pgmviews')),
    dc_start.

dc_running :-
    eccs_sys_clause(dc_window_handle(_, _), _), !.

dc_tidy :-
    eccs_sys_current_predicate(dc_zap_dynamics, dc_zap_dynamics),
    dc_zap_dynamics.
dc_tidy :-
    eccs_sys_assert(dc_quitting), fail.
dc_tidy.

dc_stop :-
    dc_running, 
    dc_close_all_windows.
    

/*

Tue Feb 23 13:02:30 1993 JC

Added definition for eccs_help.

*/

eccs_help :-
    eccs_environment('DISPLAY', _), !,
    eccs_xinfo(dir, 'Top').
eccs_help :-
    eccs_message([unable, to, provide, help, via, 'XInfo.', 
    		  'Please', consult, hardcopy, documentation]).

