/*

rcsid('$Author: pleuk $',
	'$Date: 1993/05/04 11:09:52 $',
	'$Revision: 1.1 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/pstream_filters.pl,v $',
	'$State: Exp $').

$Log: pstream_filters.pl,v $
% Revision 1.1  1993/05/04  11:09:52  pleuk
% corrected justification flags in spf_check_body
%
% Revision 1.0  1993/04/26  16:59:34  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:10:33  pleuk
% *** empty log message ***
%
% Revision 0.2  1991/07/15  09:52:47  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 1.1  1991/07/15  09:48:06  pleuk
% Initial revision
%



File:	/home/user2/pleuk/Pleuk/Code/pstream_filters.pl
Date:	Thu Jul  4 12:30:44 1991
By:	Jo Calder


A stream filter is an arbitrary prolog procedure which is called to
produce output for a particular stream.  

*/


:- dynamic eccs_stream_filter/2. 



eccs_output_to_current_stream(X) :-
    eccs_current_output(Stream),
    eccs_output_to_filtered_stream(Stream, X).

eccs_output(X) :-
    eccs_sys_if_then_else(eccs_global_variable(check_output_syntax, true),
	eccs_spf_check(X),
	true),
    (eccs_postscript_available -> eccs_sys_graphics_stream(Stream);
          (eccs_windows_available(_) -> 
		eccs_global_variable(eccs_output_file_handle, Stream);
		Stream = user_output)),
     eccs_output_to_filtered_stream(Stream, X).


eccs_output_to_filtered_stream(Stream, Structure) :-
    eccs_sys_nonvar(Stream),
    eccs_valid_stream(Stream), !,
    (eccs_stream_filter(Stream, Filter) -> 
        (Filter =.. [Pred|Args],
	 eccs_append(Args, [Structure], Args1),
    	 Goal =.. [Pred|Args1]);
	Goal = eccs_dumb_filter(Structure)), 
    !,
    eccs_current_output(Old),
    eccs_set_output(Stream),
    eccs_buffer(Stream),
    (eccs_once(Goal); true), !,
    eccs_set_output(Old),
    eccs_flush(Stream).
eccs_output_to_filtered_stream(Stream, _Structure) :-
    eccs_error([invalid, stream, in, eccs_output_to_filtered_stream,
    ':', Stream]).  

eccs_attach_filter_to_stream(Stream, Filter) :-
    eccs_sys_nonvar(Stream),
    eccs_sys_nonvar(Filter),
    !,
    (eccs_sys_retract(eccs_stream_filter(Stream, _)), fail; true),
    eccs_sys_assert(eccs_stream_filter(Stream, Filter)).

eccs_attach_filter_to_stream(_Stream, _Filter) :-
    eccs_error([variable, passed, to, eccs_attach_filter_to_stream]).


/*

File:	/home/user2/jo/spf.pl
Date:	Wed Aug  7 14:27:41 1991
By:	Jonathan Calder

A syntax checker to make sure that a term is in 
standard printing format.

called as

eccs_spf_check(+SPF)

Success means that SPF is within the standard printing 
format specification, failure (with diagnostics) that it is not. 

spy eccs_spf_fail to trap out of band cases. 

*/

eccs_spf_check(Term) :-
    eccs_sys_var(Term), !,
    eccs_error([term, is, a, variable]).
eccs_spf_check(Term) :-
    eccs_spf_check_captioned(Term), !.
eccs_spf_check(Term) :-
    eccs_spf_check_body(Term).

eccs_spf_check_captioned(captioned(Caption, SPF)) :- !,
    eccs_spf_check_caption(Caption), !,
    eccs_spf_check_body(SPF).

eccs_spf_check_caption(Caption) :- 
    eccs_sys_atomic(Caption), !.
eccs_spf_check_caption(Caption) :-
    eccs_likely_string(Caption), !.
eccs_spf_check_caption(X) :-
    eccs_spf_fail([invalid, caption, X, '(should', be, atom, or, 'string)']).



eccs_spf_check_feature_name(F) :-
    eccs_sys_atomic(F).



eccs_spf_check_body(Var) :-
    eccs_sys_var(Var), !,
    eccs_spf_fail([variables, not, allowed, in, 'SPF']).
eccs_spf_check_body(atomic(X)) :-
    !,
    (eccs_sys_atomic(X) -> true; 
        eccs_spf_fail([atomic(X), X, is, not, atomic])).
eccs_spf_check_body(symbol(X)) :-
    !,
    
    ((eccs_sys_nonvar(X), eccs_spf_symbol_encoding(X, _)) -> true;
       eccs_spf_fail([symbol(X), X, is, not, a, valid, symbol, name])).
eccs_spf_check_body(italic(X)) :-
    !,
    (\+ eccs_sys_atomic(X) -> eccs_spf_fail([nonatomic, arg, in, italic(X)]); true).
eccs_spf_check_body(uninstantiated) :- !.
eccs_spf_check_body(sequence(S)) :-
    !,
    eccs_spf_check_list(sequence, S).
eccs_spf_check_body(set(S)) :-
    !,
    eccs_spf_check_list(set, S).
eccs_spf_check_body(sort(S)) :-
    !,
    (\+ eccs_sys_atomic(S) -> eccs_spf_fail([nonatomic, sort, name]); true).
eccs_spf_check_body(avm(FVPairs)) :-
    !,
    eccs_spf_check_fvp(FVPairs).
eccs_spf_check_body(tagged(Tag, Object)) :-
    !,
    eccs_spf_check_tag(Tag),
    eccs_spf_check_body(Object).
eccs_spf_check_body(tagged_avm(Tag, FVPairs)) :-
    !,
    eccs_spf_check_tag(Tag),
    eccs_spf_check_fvp(FVPairs).
eccs_spf_check_body(tag(T)) :-
    !,
    eccs_spf_check_tag(T).
eccs_spf_check_body(disj(Ds)) :-
    !,
    eccs_spf_check_list(disj, Ds).
eccs_spf_check_body(conj(Ds)) :- 
    !,
    eccs_spf_check_list(conj, Ds).
eccs_spf_check_body(neg(N)) :-
    !,
    eccs_spf_check_body(N).
eccs_spf_check_body(impl(A, B)) :-
    !,
    eccs_spf_check_body(A),
    eccs_spf_check_body(B).
eccs_spf_check_body(bicond(A, B)) :-
    !,
    eccs_spf_check_body(A),
    eccs_spf_check_body(B).
eccs_spf_check_body(relation(R, Args)) :-
    !,
    eccs_spf_check_rsymbol(R),
    eccs_spf_check_list(relation, Args).
eccs_spf_check_body(parenth(Args)) :-
    !,
    eccs_spf_check_list(parenth, Args).
eccs_spf_check_body(circle(SPF)) :-
    !,
    eccs_spf_check_body(SPF).
eccs_spf_check_body(stack(Args)) :-
    !,
    eccs_spf_check_list(stack, Args).
eccs_spf_check_body(postfix(Op, A)) :-
    !,
    eccs_spf_check_rsymbol(Op),
    eccs_spf_check_body(A).
eccs_spf_check_body(prefix(Op, A)) :-
    !,
    eccs_spf_check_rsymbol(Op),
    eccs_spf_check_body(A).
eccs_spf_check_body(infix(Op, A, B)) :-
    !,
    eccs_spf_check_rsymbol(Op),
    eccs_spf_check_body(A),
    eccs_spf_check_body(B).
eccs_spf_check_body(tree(M, Ds)) :-
    !,
    eccs_spf_check_body(M),
    eccs_spf_check_list(tree, Ds).
eccs_spf_check_body(triangle(SPF)) :-
    !,
    eccs_spf_check_body(SPF).
eccs_spf_check_body(sensitize(SPF, _Action)) :-
    !,
    eccs_spf_check_body(SPF).
eccs_spf_check_body(hbox(Posn, Elements)) :-
    !,
    (eccs_memberchk(Posn, [top,bottom,center]) -> true;
    	eccs_warning([bad, position, statement, Posn, in, hbox])),
    eccs_spf_check_list(hbox, Elements).
eccs_spf_check_body(hbox(Elements)) :-
    !,
    eccs_spf_check_list(hbox, Elements).
eccs_spf_check_body(vbox(Posn, Elements)) :-
    !,
    (eccs_memberchk(Posn, [left,right, center]) -> true;
    	eccs_warning([bad, position, statement, Posn, in, vbox])),
    eccs_spf_check_list(vbox, Elements).
eccs_spf_check_body(vbox(Elements)) :-
    !,
    eccs_spf_check_list(vbox, Elements).
eccs_spf_check_body(space(X, Y)) :-
    !,
    (eccs_sys_number(X) -> true;
	eccs_spf_check_body(X)),
    (eccs_sys_number(Y) -> true;
    	eccs_spf_check_body(Y)).
eccs_spf_check_body(box(SPF)) :-
    !,
    eccs_spf_check_body(SPF).
eccs_spf_check_body(concat(Es)) :-
    !,
    eccs_spf_check_list(concat, Es).
eccs_spf_check_body(over(T, B, Tag)) :-
    !,
    eccs_spf_check_list(over, [T, B, Tag]).
eccs_spf_check_body(over(T, B)) :-
    !,
    eccs_spf_check_list(over, [T, B]).
eccs_spf_check_body(hpsg_sort(Sort, SPF)) :-
    !,
    eccs_spf_check_list(hpsg_sort, Sort, SPF).
eccs_spf_check_body(prolog_list(Head, Tail)) :-
    eccs_spf_check_body(Head),
    eccs_spf_check_prolog_list_tail(Tail), !.
eccs_spf_check_body(X) :-
    eccs_spf_fail([X, not, in, 'SPF']).

eccs_spf_check_prolog_list_tail([]) :- !.
eccs_spf_check_prolog_list_tail(prolog_list(Head, Tail)) :-
    eccs_spf_check_body(Head),
    eccs_spf_check_prolog_list_tail(Tail).


eccs_spf_atomic(Var) :-
    eccs_sys_var(Var), !,
    eccs_spf_fail([variable, as, atomic, value]).
eccs_spf_atomic(atomic(Atom)) :-
    eccs_sys_atomic(Atom), !.
eccs_spf_atomic(italic(X)) :-
    !,
    eccs_sys_atomic(X).
eccs_spf_atomic(symbol(X)) :-
    (eccs_spf_symbol_encoding(X, _) -> true;
    	eccs_message([invalid, symbol, name, in, 'SPF:', X]), fail).


eccs_spf_check_fvp(Var) :-
    eccs_sys_var(Var), 
    !,
    eccs_spf_fail([variable, in, feature, value, pairs]).
eccs_spf_check_fvp([]).
eccs_spf_check_fvp([F = V|Rest]) :-
    !,
    eccs_spf_check_feature_name(F),
    eccs_spf_check_body(V),
    eccs_spf_check_fvp(Rest).
eccs_spf_check_fvp([H|T]) :-
    !,
    eccs_spf_check_body(H),
    eccs_spf_check_fvp(T).


eccs_spf_check_list(Type, Var) :-
    eccs_sys_var(Var),
    eccs_spf_fail([variable, in, list, as, value, of, Type]).
eccs_spf_check_list(_, []).
eccs_spf_check_list(_, [H|T]) :-
    eccs_spf_check_body(H),
    eccs_spf_check_list(T), !.
eccs_spf_check_list(Type, NonList) :-
    Term =.. [Type, NonList],
    eccs_spf_fail(['non-list', 'argument:', Term]).

eccs_spf_check_rsymbol(Relation) :-
    eccs_spf_atomic(Relation), !.
eccs_spf_check_rsymbol(Relation) :-
    eccs_spf_fail([nonatomic, relation, symbol, Relation]).

eccs_spf_check_tag(Tag) :-
    eccs_sys_atomic(Tag), !.
eccs_spf_check_tag(Tag) :-
    eccs_spf_fail([nonatomic, tag, Tag]).

eccs_spf_fail(Message) :-
    eccs_error(Message).

eccs_spf_test_and_print(SPF) :-
    eccs_spf_check(SPF), !,
    (eccs_output(SPF) -> true;
	eccs_error([the, output, routine, 'failed.', 'This', is,
		    probably, a, 'Pleuk', bug])).
eccs_spf_test_and_print(_SPF) :-
    eccs_spf_fail([the, term, does, not, fail, within, the, 
		   standard, printing, format, specification]).


/*

Added Wed Mar  3 11:52:07 1993 JC

Other SPF utilities

eccs_spf_order_attributes(SPFIn, Atts, SPFOut)

SPFOut differs from SPFIn only  in that 

- SPFIn may contain attribute-value pairs in an order which differs
from the ordering given in the list Atts, while SPF contains only
lists of AV pairs ordered by attribute according to Atts.

- SPFIn may contain things which are not AV pairs which do not precede
all AV pairs.

Attributes not mentioned in Atts appear at the end of the list of AV
pairs, in the same order as in SPF in.  

We trap for tags, not caring whether variables appear in the Tag
position, as we will probably want to number tags after ordering.

This is a potentially expensive operation if SPF and Atts are both
large and it is probably best to fold in this operation with other
operations which build SPF.

*/


eccs_spf_order_attributes(In, Atts, Out) :-
    eccs_spf_filter_nonatomic(Atts, Atoms, Nonatoms),
    (Nonatoms = [] -> 
	true
      ; eccs_warning([nonatomic, elements, in, list, of, attribute, 'names:']),
        eccs_message(Nonatoms)),
    eccs_spf_order_attributes1(In, Atoms, Out).

eccs_spf_filter_nonatomic([], [], []).
eccs_spf_filter_nonatomic([A|As], [A|Atoms], Nonatoms) :-
    eccs_sys_atomic(A), !,
    eccs_spf_filter_nonatomic(As, Atoms, Nonatoms).
eccs_spf_filter_nonatomic([NonA|As], Atoms, [NonA|Nonatoms]) :-
    eccs_spf_filter_nonatomic(As, Atoms, Nonatoms).

eccs_spf_order_attributes1(In, [], In) :-   
    !.
eccs_spf_order_attributes1(Var, _, _) :-
    eccs_sys_var(Var), !,
    eccs_error([variable, in, 'SPF']).
eccs_spf_order_attributes1(X, _, X) :-
    eccs_spf_atomic(X), !.
eccs_spf_order_attributes1(tag(X), _, tag(X)) :- % trap for tags etc
    !.
eccs_spf_order_attributes1(tagged_avm(X, Avm), Atts, tagged_avm(X, AvmS)) :-
    !,
    eccs_spf_order_attributes1(avm(Avm), Atts, avm(AvmS)).
eccs_spf_order_attributes1(tagged(X, SPF), Atts, tagged(X, SPFS)) :-
    !,
    eccs_spf_order_attributes1(SPF, Atts, SPFS).
eccs_spf_order_attributes1(avm(AVPs), Atts, avm(AVPsOut)) :-
    !,
    eccs_spf_order_attributes2(AVPs, Atts, AVPsOut).
eccs_spf_order_attributes1(tagged_avm(Tag, AVPs), Atts, tagged_avm(Tag, AVPsOut)) :-
    !,
    eccs_spf_order_attributes2(AVPs, Atts, AVPsOut).
eccs_spf_order_attributes1(TIn, Atts, TOut) :-
    eccs_sys_functor(TIn, F, N),
    eccs_sys_functor(TOut, F, N),
    eccs_spf_order_attributes_args(0, N, TIn, Atts, TOut).

eccs_spf_order_attributes_args(N, N, _, _, _) :- !.
eccs_spf_order_attributes_args(I, N, TIn, Atts, TOut) :-
    I < N,
    eccs_succ(I, J),
    eccs_sys_arg(J, TIn, TInJ),
    eccs_sys_arg(J, TOut, TOutJ),
    eccs_spf_order_attributes(TInJ, Atts, TOutJ),
    eccs_spf_order_attributes_args(J, N, TIn, Atts, TOut).

eccs_spf_order_attributes2(L, [], L) :- !.
eccs_spf_order_attributes2(LIn, Atts, LOut) :-
    eccs_spf_filter_nonavps(LIn, Atts, NonAvs, UnOrdered, Rest),
    eccs_spf_order_attributes3(Rest, Atts, RestOrdered),
    eccs_append_all([NonAvs, RestOrdered, UnOrdered], LOut).


eccs_spf_filter_nonavps([], _Atts, [], [], []) :-
    !.
eccs_spf_filter_nonavps([X|Rest], Atts, [X|T], UnOrdered, RestAVs) :-
    eccs_sys_nonvar(X),
    \+ (X = (_ = _)), !,    
    eccs_spf_filter_nonavps(Rest, Atts, T, UnOrdered, RestAVs).
eccs_spf_filter_nonavps([F = V|Rest], Atts, T, [F = VOrdered|UnOrdered], RestAVs) :-
    \+ eccs_memberchk(F, Atts),
    eccs_spf_order_attributes(V, Atts, VOrdered),
    eccs_spf_filter_nonavps(Rest, Atts, T, UnOrdered, RestAVs).
eccs_spf_filter_nonavps([F = V|Rest], Atts, T, UnOrdered, [F = VO|RestAVs]) :-
    eccs_spf_order_attributes(V, Atts, VO),
    eccs_spf_filter_nonavps(Rest, Atts, T, UnOrdered, RestAVs).

eccs_spf_order_attributes3([], _, []) :- !.
eccs_spf_order_attributes3(L, [], L) :- !.
eccs_spf_order_attributes3(LIn, [Att|Atts], LOut) :-
    eccs_delete(Att=Val, LIn, Rest), !,
    LOut = [Att=Val|T],
    eccs_spf_order_attributes3(Rest, Atts, T).
eccs_spf_order_attributes3(LIn, [_|Atts], LOut) :-
    eccs_spf_order_attributes3(LIn, Atts, LOut).

/*

eccs_spf_number_tags(SPF)

walk through SPF term SPF, instantiating any variables that occur as
the first argument to

tag/1
tagged_avm/2
tagged/2

to an integer, if not already instantiated.  Integers will be
generated from 1.

eccs_spf_number_tags(SPF, Start, End)

tags in SPF are numbered with integers starting at Start and finishin
at End.

*/

eccs_spf_number_tags(SPF) :-
    eccs_spf_number_tags(SPF, 1, _).

eccs_spf_number_tags(SPF, _, _) :-
    eccs_sys_var(SPF), !,
    eccs_error([variable, in, 'SPF']).
eccs_spf_number_tags(SPF, N, N) :-
    eccs_spf_atomic(SPF), !.
eccs_spf_number_tags(SPF, N, M) :-
    eccs_spf_number_tags_target(SPF, Var, ToDo), !,
    (eccs_sys_var(Var) -> 
	Var = N, eccs_succ(N, I)
      ; N = I),
    eccs_spf_number_tags(ToDo, I, M).
eccs_spf_number_tags(T, N, M) :-
    eccs_sys_functor(T, _, Arity),
    eccs_spf_number_tags1(0, Arity, T, N, M).

eccs_spf_number_tags1(Arity, Arity, _, N, N) :-
    !.
eccs_spf_number_tags1(Count, Arity, T, N, M) :-
    Count < Arity,
    eccs_succ(Count, Count1),
    eccs_sys_arg(Count1, T, TCount1),
    eccs_spf_number_tags(TCount1, N, J),
    eccs_spf_number_tags1(Count1, Arity, T, J, M).


eccs_spf_number_tags_target(tag(Var), Var, atomic('')).
eccs_spf_number_tags_target(tagged_avm(Var, AVM), Var, avm(AVM)).
eccs_spf_number_tags_target(tagged(Var, Object), Var, Object).

/*

eccs_spf_prolog_clauses2spf(Clauses, SPF)
eccs_spf_prolog_clause2spf(Head, Body, SPF)

SPF is a format ready for printing which is intended to produce
reasonably formatted versions of one or more prolog clause.  Clauses
is a list containing elements of the form

clause(Head, Body)

There is no special provision for printing the (If -> Then;Else)
construct, and this may end up looking pretty bad.  Try

Head = foo, Body = [(this, is -> an, example ; of, how, it, turns, out)],
eccs_spf_prolog_clause2spf(Head, Body, SPF), eccs_output(SPF).

These routines also give very bad results with the dumb terminal
filter. The failt of the latter, rather than the formatter here.


*/


eccs_spf_prolog_clauses2spf(Cs, vbox(SPFs)) :-
    eccs_spf_prolog_clauses2spf1(Cs, SPFs).

eccs_spf_prolog_clauses2spf1([], []).
eccs_spf_prolog_clauses2spf1([clause(Head, Body)|Cs], [CSpf|SPFs]) :-
    eccs_spf_prolog_clause2spf(Head, Body, CSpf),
    eccs_spf_prolog_clauses2spf1(Cs, SPFs).


eccs_spf_prolog_clause2spf(Head, Body, SPF) :-
    numbervars([Head|Body], 0, _),
    eccs_spf_prolog_clause2spf1([Head|Body], SPF1),
    eccs_spf_prolog_clause2spf_final_format(SPF1, SPF).

eccs_spf_prolog_clause2spf1([], []).
eccs_spf_prolog_clause2spf1([T|Ts], [SPFT|SPFTs]) :-
    eccs_spf_prolog_term2spf(T, SPFT),
    eccs_spf_prolog_clause2spf1(Ts, SPFTs).

eccs_spf_prolog_term2spf('$VAR'(N), atomic(A)) :-
    !,
    eccs_spf_prolog_nv2atom(N, A).
eccs_spf_prolog_term2spf(X, atomic(X)) :-
    eccs_sys_atomic(X), !.
eccs_spf_prolog_term2spf(X, prolog_list(H, T)) :-
    X =.. ['.', F, R], !,
    eccs_spf_prolog_term2spf(F, H),
    (R == [] -> T = R; eccs_spf_prolog_term2spf(R, T)).
eccs_spf_prolog_term2spf(X, SPF) :-
    eccs_spf_prolog_term2spf_term_is_op(X, Fix, P), !,
    eccs_spf_prolog_term2spf_term_do_op(Fix, X, P, SPF).
eccs_spf_prolog_term2spf(T, relation(atomic(F), Args)) :-
    T =.. [F|PArgs],
    eccs_spf_prolog_term2spf_args(PArgs, Args).

eccs_spf_prolog_term2spf_args([], []).
eccs_spf_prolog_term2spf_args([P|PArgs], [A|Args]) :-
    eccs_spf_prolog_term2spf(P, A),
    eccs_spf_prolog_term2spf_args(PArgs, Args).

eccs_spf_prolog_term2spflist([], []).
eccs_spf_prolog_term2spflist([F|R], prolog_list(H, T)) :-
    eccs_spf_prolog_term2spf(F, H),
    eccs_spf_prolog_term2spflist(R, T).


eccs_spf_prolog_term2spf_term_is_op(Term, Fix, Priority) :-
    eccs_sys_functor(Term, Op, N), 
    eccs_sys_current_op(Priority, Fix, Op),
    eccs_spf_prolog_term2spf_term_is_op1(Fix, N).

eccs_spf_prolog_term2spf_term_is_op1(fx, 1).
eccs_spf_prolog_term2spf_term_is_op1(fy, 1).
eccs_spf_prolog_term2spf_term_is_op1(yf, 1).
eccs_spf_prolog_term2spf_term_is_op1(xf, 1).
eccs_spf_prolog_term2spf_term_is_op1(xfx, 2).
eccs_spf_prolog_term2spf_term_is_op1(xfy, 2).
eccs_spf_prolog_term2spf_term_is_op1(yfx, 2).

eccs_spf_prolog_term2spf_term_do_op(xfx, X, P, SPF) :-
    X =.. [Op, L, R],
    ((eccs_spf_prolog_term2spf_term_is_op(L, _, PL), PL >= P) -> 
              LSPF = parenth([LSPF1])
	    ; LSPF = LSPF1),
    ((eccs_spf_prolog_term2spf_term_is_op(R, _, PR), PR >= P) ->
    	      RSPF = parenth([RSPF1])
            ; RSPF = RSPF1),
    SPF = infix(atomic(Op), LSPF, RSPF),
    eccs_spf_prolog_term2spf(L, LSPF1),
    eccs_spf_prolog_term2spf(R, RSPF1).
eccs_spf_prolog_term2spf_term_do_op(yfx, X, P, SPF) :-
    X =.. [Op, L, R],
    ((eccs_spf_prolog_term2spf_term_is_op(L, _, PL), PL > P) -> 
              LSPF = parenth([LSPF1])
	    ; LSPF = LSPF1),
    ((eccs_spf_prolog_term2spf_term_is_op(R, _, PR), PR >= P) ->
    	      RSPF = parenth([RSPF1])
            ; RSPF = RSPF1),
    SPF = infix(atomic(Op), LSPF, RSPF),
    eccs_spf_prolog_term2spf(L, LSPF1),
    eccs_spf_prolog_term2spf(R, RSPF1).
eccs_spf_prolog_term2spf_term_do_op(xfy, X, P, SPF) :-
    X =.. [Op, L, R],
    ((eccs_spf_prolog_term2spf_term_is_op(L, _, PL), PL >= P) -> 
              LSPF = parenth([LSPF1])
	    ; LSPF = LSPF1),
    ((eccs_spf_prolog_term2spf_term_is_op(R, _, PR), PR > P) ->
    	      RSPF = parenth([RSPF1])
            ; RSPF = RSPF1),
    SPF = infix(atomic(Op), LSPF, RSPF),
    eccs_spf_prolog_term2spf(L, LSPF1),
    eccs_spf_prolog_term2spf(R, RSPF1).
eccs_spf_prolog_term2spf_term_do_op(fx, X, P, SPF) :-
    X =.. [Op, R],
    ((eccs_spf_prolog_term2spf_term_is_op(R, _, PR), PR >= P) ->
             RSPF = parenth([RSPF])
           ; RSPF = RSPF1),
    SPF = prefix(atomic(Op), RSPF),
    eccs_spf_prolog_term2spf(R, RSPF1).
eccs_spf_prolog_term2spf_term_do_op(fy, X, P, SPF) :-
    X =.. [Op, R],
    ((eccs_spf_prolog_term2spf_term_is_op(R, _, PR), PR > P) ->
             RSPF = parenth([RSPF])
           ; RSPF = RSPF1),
    SPF = prefix(atomic(Op), RSPF),
    eccs_spf_prolog_term2spf(R, RSPF1).
eccs_spf_prolog_term2spf_term_do_op(xf, X, P, SPF) :-
    X =.. [Op, L],
    ((eccs_spf_prolog_term2spf_term_is_op(L, _, PL), PL >= P) ->
             LSPF = parenth([LSPF])
           ; LSPF = LSPF1),
    SPF = prefix(atomic(Op), LSPF),
    eccs_spf_prolog_term2spf(L, LSPF1).
eccs_spf_prolog_term2spf_term_do_op(yf, X, P, SPF) :-
    X =.. [Op, L],
    ((eccs_spf_prolog_term2spf_term_is_op(L, _, PL), PL > P) ->
             LSPF = parenth([LSPF])
           ; LSPF = LSPF1),
    SPF = prefix(atomic(Op), LSPF),
    eccs_spf_prolog_term2spf(L, LSPF1).


eccs_spf_prolog_clause2spf_final_format([SPF], vbox([postfix(atomic(.), SPF)])) :- !.
eccs_spf_prolog_clause2spf_final_format([Head|Body], 
		vbox([postfix(atomic(':-'), Head1)|BSPF])) :-
    Head1 = hbox([Head, space(0, 0)]),
    eccs_spf_prolog_clause2spf1_indent(N),
    eccs_spf_prolog_clause2spf_final_format_body(Body, N, BSPF).

eccs_spf_prolog_clause2spf1_indent(18).  % indent body by 18pts

eccs_spf_prolog_clause2spf_final_format_body([Last], N, [SPF]) :-
    !,
    SPF = hbox([space(N, 0), postfix(atomic('.'), Last)]).
eccs_spf_prolog_clause2spf_final_format_body([H|T], N, [SPF|SPFs]) :-
    SPF = hbox([space(N, 0), postfix(atomic(','), H)]),
    eccs_spf_prolog_clause2spf_final_format_body(T, N, SPFs).


eccs_spf_prolog_nv2atom(N, A) :-
    AChar is "A"+ N,
    eccs_sys_name(A, [AChar]).

/*

eccs_spf_strip_boring(Old, New)

New spf is just like Old, except that any attributes with the value
`uninstantiated' or `avm([])' is deleted.  In case we then end up with
spf like `tagged(Tag, uninstantiated)', this is replaced by `tag(Tag)'. 

*/

eccs_spf_strip_boring(A, A) :-
    (eccs_sys_atomic(A); eccs_sys_var(A)), !.
eccs_spf_strip_boring(avm(AVPS), avm(Out)) :-
    !,
    eccs_spf_strip_boring1(AVPS, Out).
eccs_spf_strip_boring(SPF, SPF1) :-
    SPF =.. [F|Args],
    eccs_spf_strip_boring_list(Args, Out),
    SPF1 =.. [F|Out].

eccs_spf_strip_boring1([], []).
eccs_spf_strip_boring1([A = Val|AVs], Out) :-
    !,
    eccs_spf_strip_boring(Val, Val1),
    eccs_spf_strip_boring2(Val1, A, Out, Tail),
    eccs_spf_strip_boring1(AVs, Tail).
eccs_spf_strip_boring1([NonAVP|AVs], [NonAVP1|Out]) :-
    eccs_spf_strip_boring(NonAVP, NonAVP1),
    eccs_spf_strip_boring1(AVs, Out).
    
eccs_spf_strip_boring2(uninstantiated, _, Tail, Tail) :-
    !.
eccs_spf_strip_boring2(avm([]), _, Tail, Tail) :-
    !.
eccs_spf_strip_boring2(tagged(Tag, X), Att, [Att = Val|Tail], Tail) :-
    eccs_memberchk(X, [uninstantiated, avm([])]),
    !,
    Val = tag(Tag).
eccs_spf_strip_boring2(avm([NonAVp]), Att, [Att = NonAVp|Tail], Tail) :-
    eccs_sys_nonvar(NonAVp), 
    \+ NonAVp = (_ = _), !.
eccs_spf_strip_boring2(Val, Att, [Att=Val|Tail], Tail).



eccs_spf_strip_boring_list([], []).
eccs_spf_strip_boring_list([A|As], [B|Bs]) :-
    eccs_spf_strip_boring(A, B),
    eccs_spf_strip_boring_list(As, Bs).
	


/*

End of additions Wed Mar  3 11:52:33 1993 JC

*/



/*********************************************************************

eccs_spf_symbol_encoding(Name, Int)

Int is the decimal character number of Name.

This table derived from the Symbol Font encoding vector supplied with
GhostScript.

*********************************************************************/

eccs_spf_symbol_encoding(space, 32).
eccs_spf_symbol_encoding(exclam, 33).
eccs_spf_symbol_encoding(universal, 34).
eccs_spf_symbol_encoding(numbersign, 35).
eccs_spf_symbol_encoding(existential, 36).
eccs_spf_symbol_encoding(percent, 37).
eccs_spf_symbol_encoding(ampersand, 38).
eccs_spf_symbol_encoding(suchthat, 39).
eccs_spf_symbol_encoding(parenleft, 40).
eccs_spf_symbol_encoding(parenright, 41).
eccs_spf_symbol_encoding(asteriskmath, 42).
eccs_spf_symbol_encoding(plus, 43).
eccs_spf_symbol_encoding(comma, 44).
eccs_spf_symbol_encoding(minus, 45).
eccs_spf_symbol_encoding(period, 46).
eccs_spf_symbol_encoding(slash, 47).
eccs_spf_symbol_encoding(zero, 48).
eccs_spf_symbol_encoding(one, 49).
eccs_spf_symbol_encoding(two, 50).
eccs_spf_symbol_encoding(three, 51).
eccs_spf_symbol_encoding(four, 52).
eccs_spf_symbol_encoding(five, 53).
eccs_spf_symbol_encoding(six, 54).
eccs_spf_symbol_encoding(seven, 55).
eccs_spf_symbol_encoding(eight, 56).
eccs_spf_symbol_encoding(nine, 57).
eccs_spf_symbol_encoding(colon, 58).
eccs_spf_symbol_encoding(semicolon, 59).
eccs_spf_symbol_encoding(less, 60).
eccs_spf_symbol_encoding(equal, 61).
eccs_spf_symbol_encoding(greater, 62).
eccs_spf_symbol_encoding(question, 63).
eccs_spf_symbol_encoding(congruent, 64).
eccs_spf_symbol_encoding('Alpha', 65).
eccs_spf_symbol_encoding('Beta', 66).
eccs_spf_symbol_encoding('Chi', 67).
eccs_spf_symbol_encoding('Delta', 68).
eccs_spf_symbol_encoding('Epsilon', 69).
eccs_spf_symbol_encoding('Phi', 70).
eccs_spf_symbol_encoding('Gamma', 71).
eccs_spf_symbol_encoding('Eta', 72).
eccs_spf_symbol_encoding('Iota', 73).
eccs_spf_symbol_encoding(theta1, 74).
eccs_spf_symbol_encoding('Kappa', 75).
eccs_spf_symbol_encoding('Lambda', 76).
eccs_spf_symbol_encoding('Mu', 77).
eccs_spf_symbol_encoding('Nu', 78).
eccs_spf_symbol_encoding('Omicron', 79).
eccs_spf_symbol_encoding('Pi', 80).
eccs_spf_symbol_encoding('Theta', 81).
eccs_spf_symbol_encoding('Rho', 82).
eccs_spf_symbol_encoding('Sigma', 83).
eccs_spf_symbol_encoding('Tau', 84).
eccs_spf_symbol_encoding('Upsilon', 85).
eccs_spf_symbol_encoding(sigma1, 86).
eccs_spf_symbol_encoding('Omega', 87).
eccs_spf_symbol_encoding('Xi', 88).
eccs_spf_symbol_encoding('Psi', 89).
eccs_spf_symbol_encoding('Zeta', 90).
eccs_spf_symbol_encoding(bracketleft, 91).
eccs_spf_symbol_encoding(therefore, 92).
eccs_spf_symbol_encoding(bracketright, 93).
eccs_spf_symbol_encoding(perpendicular, 94).
eccs_spf_symbol_encoding(underscore, 95).
eccs_spf_symbol_encoding(radicalex, 96).
eccs_spf_symbol_encoding(alpha, 97).
eccs_spf_symbol_encoding(beta, 98).
eccs_spf_symbol_encoding(chi, 99).
eccs_spf_symbol_encoding(delta, 100).
eccs_spf_symbol_encoding(epsilon, 101).
eccs_spf_symbol_encoding(phi, 102).
eccs_spf_symbol_encoding(gamma, 103).
eccs_spf_symbol_encoding(eta, 104).
eccs_spf_symbol_encoding(iota, 105).
eccs_spf_symbol_encoding(phi1, 106).
eccs_spf_symbol_encoding(kappa, 107).
eccs_spf_symbol_encoding(lambda, 108).
eccs_spf_symbol_encoding(mu, 109).
eccs_spf_symbol_encoding(nu, 110).
eccs_spf_symbol_encoding(omicron, 111).
eccs_spf_symbol_encoding(pi, 112).
eccs_spf_symbol_encoding(theta, 113).
eccs_spf_symbol_encoding(rho, 114).
eccs_spf_symbol_encoding(sigma, 115).
eccs_spf_symbol_encoding(tau, 116).
eccs_spf_symbol_encoding(upsilon, 117).
eccs_spf_symbol_encoding(omega1, 118).
eccs_spf_symbol_encoding(omega, 119).
eccs_spf_symbol_encoding(xi, 120).
eccs_spf_symbol_encoding(psi, 121).
eccs_spf_symbol_encoding(zeta, 122).
eccs_spf_symbol_encoding(braceleft, 123).
eccs_spf_symbol_encoding(bar, 124).
eccs_spf_symbol_encoding(braceright, 125).
eccs_spf_symbol_encoding(similar, 126).
eccs_spf_symbol_encoding('Upsilon1', 161).
eccs_spf_symbol_encoding(minute, 162).
eccs_spf_symbol_encoding(lessequal, 163).
eccs_spf_symbol_encoding(fraction, 164).
eccs_spf_symbol_encoding(infinity, 165).
eccs_spf_symbol_encoding(florin, 166).
eccs_spf_symbol_encoding(club, 167).
eccs_spf_symbol_encoding(diamond, 168).
eccs_spf_symbol_encoding(heart, 169).
eccs_spf_symbol_encoding(spade, 170).
eccs_spf_symbol_encoding(arrowboth, 171).
eccs_spf_symbol_encoding(arrowleft, 172).
eccs_spf_symbol_encoding(arrowup, 173).
eccs_spf_symbol_encoding(arrowright, 174).
eccs_spf_symbol_encoding(arrowdown, 175).
eccs_spf_symbol_encoding(degree, 176).
eccs_spf_symbol_encoding(plusminus, 177).
eccs_spf_symbol_encoding(second, 178).
eccs_spf_symbol_encoding(greaterequal, 179).
eccs_spf_symbol_encoding(multiply, 180).
eccs_spf_symbol_encoding(proportional, 181).
eccs_spf_symbol_encoding(partialdiff, 182).
eccs_spf_symbol_encoding(bullet, 183).
eccs_spf_symbol_encoding(divide, 184).
eccs_spf_symbol_encoding(notequal, 185).
eccs_spf_symbol_encoding(equivalence, 186).
eccs_spf_symbol_encoding(approxequal, 187).
eccs_spf_symbol_encoding(ellipsis, 188).
eccs_spf_symbol_encoding(arrowvertex, 189).
eccs_spf_symbol_encoding(arrowhorizex, 190).
eccs_spf_symbol_encoding(carriagereturn, 191).
eccs_spf_symbol_encoding(aleph, 192).
eccs_spf_symbol_encoding('Ifraktur', 193).
eccs_spf_symbol_encoding('Rfraktur', 194).
eccs_spf_symbol_encoding(weierstrass, 195).
eccs_spf_symbol_encoding(circlemultiply, 196).
eccs_spf_symbol_encoding(circleplus, 197).
eccs_spf_symbol_encoding(emptyset, 198).
eccs_spf_symbol_encoding(intersection, 199).
eccs_spf_symbol_encoding(union, 200).
eccs_spf_symbol_encoding(propersuperset, 201).
eccs_spf_symbol_encoding(reflexsuperset, 202).
eccs_spf_symbol_encoding(notsubset, 203).
eccs_spf_symbol_encoding(propersubset, 204).
eccs_spf_symbol_encoding(reflexsubset, 205).
eccs_spf_symbol_encoding(element, 206).
eccs_spf_symbol_encoding(notelement, 207).
eccs_spf_symbol_encoding(angle, 208).
eccs_spf_symbol_encoding(gradient, 209).
eccs_spf_symbol_encoding(registerserif, 210).
eccs_spf_symbol_encoding(copyrightserif, 211).
eccs_spf_symbol_encoding(trademarkserif, 212).
eccs_spf_symbol_encoding(product, 213).
eccs_spf_symbol_encoding(radical, 214).
eccs_spf_symbol_encoding(dotmath, 215).
eccs_spf_symbol_encoding(logicalnot, 216).
eccs_spf_symbol_encoding(logicaland, 217).
eccs_spf_symbol_encoding(logicalor, 218).
eccs_spf_symbol_encoding(arrowdblboth, 219).
eccs_spf_symbol_encoding(arrowdblleft, 220).
eccs_spf_symbol_encoding(arrowdblup, 221).
eccs_spf_symbol_encoding(arrowdblright, 222).
eccs_spf_symbol_encoding(arrowdbldown, 223).
eccs_spf_symbol_encoding(lozenge, 224).
eccs_spf_symbol_encoding(angleleft, 225).
eccs_spf_symbol_encoding(registersans, 226).
eccs_spf_symbol_encoding(copyrightsans, 227).
eccs_spf_symbol_encoding(trademarksans, 228).
eccs_spf_symbol_encoding(summation, 229).
eccs_spf_symbol_encoding(parenlefttp, 230).
eccs_spf_symbol_encoding(parenleftex, 231).
eccs_spf_symbol_encoding(parenleftbt, 232).
eccs_spf_symbol_encoding(bracketlefttp, 233).
eccs_spf_symbol_encoding(bracketleftex, 234).
eccs_spf_symbol_encoding(bracketleftbt, 235).
eccs_spf_symbol_encoding(bracelefttp, 236).
eccs_spf_symbol_encoding(braceleftmid, 237).
eccs_spf_symbol_encoding(braceleftbt, 238).
eccs_spf_symbol_encoding(braceex, 239).
eccs_spf_symbol_encoding(angleright, 241).
eccs_spf_symbol_encoding(integral, 242).
eccs_spf_symbol_encoding(integraltp, 243).
eccs_spf_symbol_encoding(integralex, 244).
eccs_spf_symbol_encoding(integralbt, 245).
eccs_spf_symbol_encoding(parenrighttp, 246).
eccs_spf_symbol_encoding(parenrightex, 247).
eccs_spf_symbol_encoding(parenrightbt, 248).
eccs_spf_symbol_encoding(bracketrighttp, 249).
eccs_spf_symbol_encoding(bracketrightex, 250).
eccs_spf_symbol_encoding(bracketrightbt, 251).
eccs_spf_symbol_encoding(bracerighttp, 252).
eccs_spf_symbol_encoding(bracerightmid, 253).
eccs_spf_symbol_encoding(bracerightbt, 254).

