/*
rcsid('$Id: pstreams.pl,v 1.0 1993/04/26 16:59:34 pleuk Exp $').
$Log: pstreams.pl,v $
% Revision 1.0  1993/04/26  16:59:34  pleuk
% Version 1.00beta from Jo
%

File:	/home/dk2/jcalder/Pleuk/Code/pstreams.pl
Date:	Thu Aug 13 12:45:02 1992
By:	Jo Calder

General stream manipulation

*/ 


eccs_prolog_stream(X) :-
    eccs_stream_name(X).
eccs_prolog_stream(X) :-
    eccs_current_stream(X).

eccs_current_stream(X) :-
    eccs_current_stream(_, _, X).

eccs_current_write_stream(X, Z) :-
    eccs_current_stream(X, Y, Z),
    eccs_member(Y, [write, append]).


eccs_valid_stream(X) :-
    eccs_prolog_stream(X).
eccs_valid_stream(X) :-
    eccs_gm_stream(X).
/*

A gm stream is of the form gm_out(Window, Text)

where Window is the window that ultimately contains the text box Text.

*/

eccs_gm_stream(gm_out(_, _)).

eccs_write_method(Stream, Proc) :-
    eccs_prolog_stream(Stream), !,
    Proc = eccs_sys_write_to_stream(Stream).
eccs_write_method(Stream, Proc) :-
    eccs_gm_stream(Stream), !,
    Proc = eccs_write_to_gmstream(Stream).

eccs_flush_method(Stream, eccs_flush_output(Stream)) :-
    eccs_prolog_stream(Stream), !.
eccs_flush_method(gm_out(_Window, Text), gmsend(Window, update)).


/*

eccs_flush(Handle)

Flush all output going to Handle.

eccs_buffer(Handle)

Delaying flushing on Handle until asked for.  

*/

eccs_flush(Handle) :-
    eccs_prolog_stream(Handle), !,
    eccs_flush_output(Handle).
eccs_flush(Handle) :-
    eccs_interface_flush(Handle), !.


eccs_buffer(Handle) :- 
        eccs_prolog_stream(Handle), !.
eccs_buffer(Handle) :-
    eccs_interface_buffer(Handle).

eccs_format_to_current_stream(Format, Args) :-
    eccs_current_output(Stream),
    eccs_format_to_stream(Stream, Format, Args).
    
eccs_format_to_stream(Stream, Format, Args) :-
    eccs_prolog_stream(Stream), !,
    eccs_sys_format(Stream, Format, Args).
eccs_format_to_stream(Stream, Format, Args) :-   /* not a prolog stream */
    eccs_interface_format(Stream, Format, Args).


/*

Output to various destinations

*/

eccs_output_file_goal(Goal) :-
    eccs_windows_available(_), !,
    eccs_global_variable(eccs_output_file_handle, Handle),
    eccs_set_stream(Handle, Goal).
eccs_output_file_goal(Goal) :-
    eccs_set_stream(user_output, Goal).

eccs_log_file_goal(Goal) :-
	eccs_write_to_user(Goal).


eccs_file_window_goal(Goal) :-
    eccs_windows_available(_), !,
    eccs_global_variable(eccs_file_window_handle, F),
    eccs_set_stream(F, Goal).
eccs_file_window_goal(Goal) :-
    eccs_set_stream(user_output, Goal).

eccs_write_to_user(Goal) :-
    eccs_user_output_stream(UserStream),
    eccs_set_stream(UserStream, Goal).


eccs_set_stream(S, Goal) :-
    eccs_current_output(Out),
    eccs_set_output(S),
    eccs_once((Goal; true)), 
    eccs_flush(S),
    eccs_set_output(Out).


/*

eccs_flush_all_output_streams

ensure all buffered output is flushed.

*/

eccs_flush_all_output_streams :-
    eccs_current_write_stream(_, Stream),
    eccs_flush_output(Stream),
    fail.
eccs_flush_all_output_streams :-
    eccs_user_output_stream(Stream),
    eccs_flush_output(Stream),
    fail.
eccs_flush_all_output_streams.

