

:- dynamic eccs_global_variable/5.

/*

eccs_global_variable(Name, Value, Class, Access, Comment)

Name: any atom 
Value: any object 
Class: partition in which variable is classed - {private, system, 
	parsing, printing, graphics, 
	<major module name>, <minor module no.1 name>, 
	<minor module no.2 name>, <etc.>}
Access: system state when the value can be changed by the user - 
	{install, start_up, configure, run}
Comment: documentation string

*/


eccs_global_variable(Name, Value) :-
	eccs_global_variable(Name, Value, _Class, _Access, _Comment), !.


/*
eccs_ensure_variable/5: for compatibility with latest SLE version
kwh : Wed Apr 1 15:04:51 BST 1992)

from SLE - 3/92
% eccs_ensure_variable(Var,Value,What,When, Message) :-
%         eccs_sys_if_then_else(
%              eccs_global_variable(Var,_),
%              true,
%              eccs_new_variable(Var, Value, What, When, Message)).

*/

eccs_ensure_variable(Var, Value, What, _When, _Message) :-
	eccs_set_variable(Var, Value, What).

/*

eccs_new_variable/5: create new database entry - arguments identical to
                     the 'eccs_global_variable' entry described above.

% original

% eccs_new_variable(Name, _Value, _Class, _Access, _Comment) :-
% 	eccs_global_variable(Name, _, _, _, _), !,
%	eccs_sys_write(Name), 
%	eccs_sys_write(' is already defined as a variable'),
%	eccs_sys_nl,
%	fail.

*/

% new (more sensible) version - no failure.
% same behaviour as SLE + warning message

eccs_new_variable(Name, _Value, _Class, _Access, _Comment) :-
	eccs_global_variable(Name, Value, _, _, _), !,
	eccs_warning([Name,already,'defined.','Value =',Value,'Unchanged']).
eccs_new_variable(Name, Value, Class, Access, Comment) :-
	eccs_sys_assertz(eccs_global_variable(Name, Value, Class, Access, Comment)).



/*
eccs_set_variable/2: system internal call to change value of any variable.

eccs_set_variable/3: call from 'set variable' option of a menu - required
                     to specify class in case variable is new.
*/

eccs_set_variable(Name, Value) :- eccs_set_variable(Name, Value, _Class).

eccs_set_variable(Name, Value, _Class) :-
	eccs_global_variable(Name, _OldValue, _Class, Access, Comment), !,
	eccs_sys_if_then_else(eccs_settable_variable(Access), true,
	                  eccs_error([Name,cannot,be,set,at,Access,time])),
	eccs_sys_retract(eccs_global_variable(Name, _, Class, _, _)),
	eccs_sys_assert(eccs_global_variable(Name, Value, Class, Access, Comment)), !.

eccs_set_variable(Name, Value, Class) :-
	eccs_sys_write('Creating new variable '), eccs_sys_write(Name),
	eccs_sys_write(' with value '), eccs_sys_write(Value),
	eccs_sys_nl,
	eccs_new_variable(Name, Value, Class, run, "").


eccs_settable_variable(run).
eccs_settable_variable(Access) :-
	eccs_global_variable(eccs_system_state, State),
	eccs_settable_variable(Access, State).
eccs_settable_variable(Access, Access).
eccs_settable_variable(start_up, State) :- eccs_not_eq(State, run).
eccs_settable_variable(install, run).



eccs_enumerate_variables(Class) :-
	eccs_sys_if_then_else(
	       eccs_global_variable(show_only_runtime_variables, true),
	       Access = run,
	       true),
	eccs_global_variable(Name, Value, Class, Access, _Comment),
	eccs_write_length(Name,30),
	eccs_sys_write(' = '),
	eccs_sys_write(Value),
	eccs_sys_nl,
	fail.
eccs_enumerate_variables(_Class).
	



eccs_enumerate_variables :-
	eccs_sys_write('Private Variables:'), eccs_sys_nl,
	eccs_enumerate_variables(private), eccs_sys_nl,
	eccs_sys_write('System Variables:'), eccs_sys_nl,
	eccs_enumerate_variables(system), eccs_sys_nl,
	eccs_sys_write('Printing Variables:'), eccs_sys_nl,
	eccs_enumerate_variables(printing), eccs_sys_nl,
	eccs_sys_write('Parsing Variables:'), eccs_sys_nl,
	eccs_enumerate_variables(parsing), eccs_sys_nl,
	eccs_sys_write('Major module Variables:'), eccs_sys_nl,
	eccs_enumerate_variables(major_module), eccs_sys_nl,
	eccs_sys_write('Minor module Variables:'), eccs_sys_nl,
	eccs_enumerate_variables(minor_module), eccs_sys_nl, eccs_sys_nl.
