/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:59:34 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/sicstus-020106.pl,v $',
	'$State: Exp $').

$Log: sicstus-020106.pl,v $
% Revision 1.0  1993/04/26  16:59:34  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:11:04  pleuk
% *** empty log message ***
%
% Revision 0.2  1991/07/15  09:33:04  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

/*

File:	/home/user2/jo/Pleuk/Code/sicstus.pl
Date:	Fri May 11 12:54:14 1990
By:	Jonathan Calder and Neil Leslie


Replication of system predicates for sicstus prolog.

eccs_sys_Predicate/n replaces Predicate/n. 

Only those predicates suspected to differ in their  semantics from one 
prolog to  another are replicated.  

*/

/* execution control */
eccs_sys_call(A)	:-	call(A).
eccs_sys_abort	:-	abort.
eccs_sys_halt	:-	halt.
eccs_sys_repeat :- repeat.

/*

Fri Jan 15 14:15:29 1993 JC Added catch/3 and throw/1, as per draft
ISO standard.  Note that the argument order is different, relative to
SICStus and Quintus.  

The strategy for prologs without appropriate builtins should probably
be to have all throws fail, printing an error message, and continue.
catch is then the same as call.  

*/

eccs_sys_catch(Goal, Catcher, Handler) :-
    on_exception(Catcher, Goal, Handler).

eccs_sys_throw(Ball) :-
    raise_exception(Ball).

/*stats*/
eccs_sys_cputime(CPU)	:-	
    statistics(runtime, [C, _]),
    CPU is C / 1000.
eccs_sys_heapused(Heap)	:-
    statistics(heap, [Heap, _]).
eccs_sys_stackused(Local, Global) :-	
    statistics(local_stack, [Local, _]),
    statistics(global_stack, [Global, _]).
eccs_sys_statistics	:-	statistics.

/* term inspection */

eccs_sys_floor(A)	:-	floor(A).
eccs_sys_var(X)	:-	var(X).
eccs_sys_nonvar(X)	:-	nonvar(X).
eccs_sys_integer(X)	:-	integer(X).
eccs_sys_number(X)	:-	number(X).
eccs_sys_primitive(X)	:-	primitive(X).
eccs_sys_db_reference(X)	:-	db_reference(X).
eccs_sys_atomic(X)	:-	atomic(X).
eccs_sys_atom(X)	:-	atom(X).
eccs_sys_compare(Op,T1,T2)	:-	compare(Op,T1,T2).
% eccs_sys_name(X,L)	:-	name(X,L).
eccs_sys_name(X,L)      :-      (var(X);atomic(X)),
     % to avoid quintus raising exception pjw 26.11.91
                                name(X,L),!.
     % ! to shorten tracing pjw 22.11.91

eccs_sys_functor(T,F,N)	:-	functor(T,F,N).
eccs_sys_arg(N,T,A)	:-	arg(N,T,A).


/* database manipulation */

eccs_sys_assertz(C)	:- 	assertz(C).
eccs_sys_asserta(C)	:-	asserta(C).
eccs_sys_assert(C)	:-	assert(C).
eccs_sys_assert(C,R)	:-	assert(C,R).
eccs_sys_assertz(C,R)	:-	assertz(C,R).
eccs_sys_asserta(C,R)	:-	asserta(C,R).
eccs_sys_instance(R,T)	:-	instance(R,T).
eccs_sys_erase(R)	:-	erase(R).
eccs_sys_erased(R)	:-	erased(R).
eccs_sys_current_atom(A)	:-	current_atom(A). 
eccs_sys_current_predicate(Name, MGHead) :- current_predicate(Name, MGHead). 

eccs_sys_abolish(F,N)	:-	abolish(F,N).
eccs_sys_abolish(P)	:-	abolish(P).
eccs_sys_clause(Head, Body)	:-	clause(Head, Body).
eccs_sys_clause(Head, Body, Ref)	:-	 clause(Head, Body, Ref).
eccs_sys_retract((Head :- Body))	 :- retract((Head :- Body)).
eccs_sys_retract(Unit)	:-	retract(Unit).
eccs_sys_retractall(Head) :-	retractall(Head).	%  PDP-11 compatibility


eccs_sys_recorded(K,T,R) :- recorded(K,T,R).
eccs_sys_recorda(K,T,R)  :- recorda(K,T,R).
eccs_sys_recordz(K,T,R)  :- recordz(K,T,R).
eccs_sys_record(K,T,R)   :- recordz(K,T,R).

/* ********** */

/* File handling and i/o */
eccs_sys_see(F)		:-	see(F). 
eccs_sys_see(_A, F)	:-	see(F). 
eccs_sys_seeing(F)	:-	seeing(F). 
eccs_sys_seeing(F,G)	:-	seeing(F), see(G). 
eccs_sys_seen(_F)	:-	seen. 
eccs_sys_seen		:-	seen. 
eccs_sys_tell(F)	:-	tell(F).
eccs_sys_append_file(F)	:-	append(F).
eccs_sys_telling(F)	:-	telling(F). 
eccs_sys_telling(F,G)	:-	telling(F), tell(G). 
eccs_sys_told	:-	told.

/*

eccs_sys_close(F)	:-	close(F). 

*/

eccs_sys_close(F) :-	
    (eccs_valid_stream(F), 
     retract(eccs_stream_filter(F, _)), fail;
     true), !,
    close(F).


eccs_sys_read(X)	:- 	read(X).
eccs_sys_read(_File, T)	:-	read(T). 
eccs_sys_get0(C)	:-	get0(C). 
eccs_sys_get0(Stream, C) :-	get0(Stream, C). 
eccs_sys_get(Stream, C)	:-	get(Stream, C). 
eccs_sys_display(T)	:-	display(T). 

eccs_sys_write(T)	:-	write(T). 

eccs_sys_nl :- nl.

eccs_sys_writeq(T)	:-	writeq(T). 
eccs_sys_print(T)       :-      print(T). % added CHB
eccs_sys_portray_clause(C) :-	portray_clause(C).


eccs_sys_nl(Stream)	:-	nl(Stream).

eccs_sys_put(C)	:-	put(C). 
eccs_sys_put(Stream, C) :- put(Stream, C).


eccs_sys_tab(0) :- !.
eccs_sys_tab(C)	:-
    C > 0,
    eccs_sys_write(' '),
    C1 is C -1,
    eccs_sys_tab(C1).



eccs_sys_exists(F)	:-	exists(F). 
eccs_sys_cd(X)	:-	unix(cd(X)).
eccs_sys_sh	:-	unix(shell).
eccs_sys_shell(S)	:-	unix(shell(S)).

/* Mon Jan 18 15:56:47 1993  Written this way for Quintus compatibility. JC

eccs_sys_save(FName, Goal)

Save program state to a file FName, executing Goal on restore.  

 */

eccs_sys_save(FName, Goal) :-
    save(FName, N),
    (N = 0; N = 1, call(Goal)).

eccs_sys_expand_file_name(O,N)	:-	expand_file_name(O,N). 
eccs_sys_fileerrors	:-	fileerrors.
eccs_sys_nofileerrors	:-	nofileerrors.
eccs_sys_op(P,T,O)	:-	op(P,T,O).
eccs_sys_current_op(P, T, O) :- current_op(P,T,O).

eccs_sys_prompt(A,B)	:-	prompt(A,B).
eccs_sys_trace	:-	trace.
eccs_sys_tty_flush :-   ttyflush.
eccs_absolute_file_name(File, Abs) :-
    absolute_file_name(File, Abs).


eccs_sys_not(Goal)	:-	\+(Goal).
eccs_sys_if_then(If, Then)	:- (If -> Then).
eccs_sys_if_then_else(If,Then, Else)	:- (If -> Then; Else).
eccs_sys_disj_goal(A,B)	:- (A;B).


eccs_sys_pos(A, +(A)).
eccs_sys_neg(A, -(A)).
eccs_sys_add(A, B, A+B).
eccs_sys_minus(A, B, A-B).
eccs_sys_star(A, B, A*B).
eccs_sys_slash(A, B, A/B).
eccs_sys_mod(A, B, A mod B).
eccs_sys_bit_conj(A, B, A/\B).
eccs_sys_bit_disj(A, B, A\/B).
eccs_sys_bit_left_shift(A, B, A<<B).
eccs_sys_bit_right_shift(A, B , A>>B).
eccs_sys_2_slash(A, B, A//B).
eccs_sys_hat(A, B, A^B).

eccs_sys_max(M, N, N) :-
    N >= M, !.
eccs_sys_max(M, N, Max) :-
    M > N,
    Max = M.

eccs_sys_min(M, N, N) :-
    M >= N, !.
eccs_sys_min(M, N, Min) :-
    N > M,
    Min = M.


eccs_sys_lt(X, Y)	:-	X < Y.
eccs_sys_gt(X, Y)	:-	X > Y. 
eccs_sys_lte(X, Y)	:-	X =< Y.
eccs_sys_gte(X, Y)	:-	X >= Y.
eccs_sys_lit_id(A, B)	:-	A == B.
eccs_sys_not_lit_id(A, B)	:-	A \== B.
eccs_sys_before(A, B)	:-	A @< B.
eccs_sys_after(A, B)	:-	A @> B. 
eccs_sys_not_after(A, B)	:-	A @=< B. 
eccs_sys_not_before(A, B)	:-	A @>= B. 
eccs_sys_unif(X, L)	:-	X=L.


/*

Under sicstus 2.1, sort fails if the first argument is an improper 
list.

*/

eccs_sort(X, Y) :- 
    eccs_length(X, _), !,
    sort(X, Y).

eccs_length(L, N) :- length(L, N).

/*

Tue Feb 23 13:40:54 1993 Added JC

*/
eccs_keysort(X, Y) :-
    keysort(X, Y).



/*

eccs_sys_mkfilename(Oldname, NewName):-
	eccs_sys_if_then_else(eccs_sys_full_unix_name(Oldname), Oldname = NewName,
		(eccs_sys_pleuk_path(PleukPathStr),
		eccs_sys_name(PleukPathA, PleukPathStr),
		eccs_sys_concat(PleukPathA, Oldname, NewName))).
		



eccs_sys_full_unix_name(X):-
	eccs_sys_name(X, [Y|_]),
	(eccs_sys_name("/",Y);eccs_sys_name("~",Y)).



*/

eccs_prolog_version :- version.


eccs_listing(X) :- listing(X).

user_help :- !, eccs_help.

/*

Wed Sep 16 15:54:37 1992 JC

The three last clauses below added to fix an incompatible change in
patch 0.6 of SICStus 2.1.  user_input user_output and user_error are
no longer valid stream names.

*/

eccs_current_stream(X, Y, Z) :-
    current_stream(X, Y, Z).
eccs_current_stream(user_input, read, Z) :-
    on_exception(_, prolog_flag(user_input, Z), fail).
eccs_current_stream(user_output, write, Z) :-
    on_exception(_, prolog_flag(user_output, Z), fail).
eccs_current_stream(user_error, write, Z) :-
    on_exception(_, prolog_flag(user_error, Z), fail).



:- dynamic eccs_interface_stream/1.

eccs_current_output(OStream) :-
    eccs_interface_stream(OStream), !.
eccs_current_output(OStream) :-
     current_output(OStream).

eccs_set_output(Stream) :-
    eccs_prolog_stream(Stream), !,
    eccs_sys_retractall(eccs_interface_stream(_)),
    set_output(Stream).
eccs_set_output(Stream) :-
    eccs_valid_stream(Stream), 
    eccs_sys_retractall(eccs_interface_stream(_)),
    eccs_sys_assert(eccs_interface_stream(Stream)).

eccs_flush_output:-
    eccs_current_output(Stream),
    eccs_flush_output(Stream).

eccs_flush_output(Stream) :-
    current_stream(_, _, Stream),
    !,
    flush_output(Stream).
eccs_flush_output(_Stream).


eccs_user_output_stream(user_output).
eccs_user_input_stream(user_input).


eccs_stream_name(user_input).
eccs_stream_name(user).
eccs_stream_name(user_output).
eccs_stream_name(user_error).



eccs_file_is_open_for_writing(File) :- 
    eccs_absolute_file_name(File, Abs),
    current_stream(Abs, WA, _),
    eccs_member(WA, [write, append]).

eccs_open_for_writing(File, _Mode) :-
    eccs_file_is_open_for_writing(File), !.
eccs_open_for_writing(File, Mode) :-
    open(File, Mode, _).

eccs_open_file(File, Mode) :-
    eccs_sys_nonvar(File),
    eccs_sys_nonvar(Mode),
    open(File, Mode, _).

eccs_open(File, Mode, Stream) :-
    open(File, Mode, Stream).


/*

Formatting for streams

*/

eccs_sys_format(Format, Args) :-
    format(Format, Args).
eccs_sys_format(Stream, Format, Args) :-
    format(Stream, Format, Args).

/*

foreign functions

*/

:- ensure_loaded('C/sicstus').


eccs_make_unique_temporary_file(FName) :-
    unix(mktemp('/tmp/#PleukXXXXXX', FName)).

eccs_end_of_file_char(-1).


/*

The following given as an idiom in Quintus, and appears to work 
in SICStus

*/
eccs_current_directory(Dir) :-
    eccs_absolute_file_name('', Dir).


/*

Fix up Prolog environment

*/

:- nofileerrors.

eccs_sys_ensure_loaded(F) :-
    ensure_loaded(F).

/*

eccs_known_predicate(+PName)

PName of form Pred/N or Pred (meaning N = 0), atomic(Pred).

*/

eccs_known_predicate(PredSpec) :-
    (eccs_sys_atomic(PredSpec) -> 
	 (N = 0, Pred = PredSpec)
	;(PredSpec = Pred/N, eccs_sys_atomic(Pred))),
    eccs_sys_functor(T, Pred, N),
    current_predicate(Pred, T).

:- prolog_flag(syntax_errors, Old, dec10).
