/*

rcsid('$Author: pleuk $',
	'$Date: 1993/04/26 16:59:34 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Code/RCS/su_utils.pl,v $',
	'$State: Exp $').

$Log: su_utils.pl,v $
% Revision 1.0  1993/04/26  16:59:34  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  12:54:52  pleuk
% revisions from SLE - April 1992
%
% Revision 0.10  1992/01/23  16:29:46  pleuk
% revisions from Jo - January 1992
%
% Revision 0.9  1991/10/21  12:53:20  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 0.8  1991/09/25  12:52:34  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 0.7  1991/09/21  02:30:57  pleuk
% version for Jo
%
% Revision 0.6  1991/09/02  12:00:50  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.5  1991/07/15  10:11:31  pleuk
% *** empty log message ***
%
% Revision 0.2  1991/07/15  09:33:50  pleuk
% revisions up to SLE visit 11-12 July 1991
%
% Revision 0.1  1991/03/06  12:19:38  pleuk
% *** empty log message ***
%
%Revision 1.1  1991/03/06  11:47:03  pleuk
%Initial revision
%

*/

% The following list of chars_to_list_of_integer predicates is
% inspired, copied or adapted from the qp library.

eccs_atom_to_chars(Atom,Chars,L) :-
	eccs_sys_name(Atom,IntegerList),
	eccs_map_integer_list_to_chars(IntegerList,Chars,L).

eccs_map_integer_list_to_chars([],L,L).
eccs_map_integer_list_to_chars([H0|T],[H:_|L0],L) :-
	eccs_sys_name(H,[H0]),
	eccs_map_integer_list_to_chars(T,L0,L).
	
eccs_chars_to_integer_list([],[]).
eccs_chars_to_integer_list([H0|T0],[H|T]) :-
	eccs_sys_name(H0,[H]),
	eccs_chars_to_integer_list(T0,T).

eccs_chars_to_atom(X0,X) :-
	eccs_string_flatten(X0,X1),
	eccs_chars_to_integer_list(X1,X2),
	eccs_sys_name(X,X2).


%  Another version of flatten, but this time map to format that 
%  chars_to_atom expects from things in constraint list form. 

eccs_string_flatten(X,Y) :-
	eccs_string_flatten(X,[],Y,[]).

eccs_string_flatten(X,R,[X|L0],L) :-
	xvar(X), !,
	eccs_string_flatten(R,[],L0,L).
eccs_string_flatten([],[],L,L) :- !.
eccs_string_flatten([],X,L0,L) :- !,
	eccs_string_flatten(X,[],L0,L).
eccs_string_flatten(0:_,0:_,L,L) :- !.
eccs_string_flatten(0:_,X,L0,L) :- !,
	eccs_string_flatten(X,[],L0,L).
eccs_string_flatten([H0|T0]:_,R,L0,L) :- !,
	eccs_string_flatten(H0,[],L0,L1),
	eccs_string_flatten(T0,[],L1,L2),
	eccs_string_flatten(R,[],L2,L).
eccs_string_flatten([H0|T0],R,L0,L) :- !,
	eccs_string_flatten(H0,[],L0,L1),
	eccs_string_flatten(T0,[],L1,L2),
	eccs_string_flatten(R,[],L2,L).
eccs_string_flatten(X,R,[V|L0],L) :-
	xnonvar(X), !,
	X = V:_, 
	eccs_string_flatten(R,[],L0,L).
eccs_string_flatten(A,R,[A|L0],L) :-
	eccs_string_flatten(R,[],L0,L).

   
