/*
rcsid('$Id: xtermwindows.pl,v 1.0 1993/04/26 16:59:34 pleuk Exp $').
$Log: xtermwindows.pl,v $
% Revision 1.0  1993/04/26  16:59:34  pleuk
% Version 1.00beta from Jo
%
*/

:- eccs_set_variable(eccs_output_mode, xterm).


eccs_interface_make_window(Type, Stream) :- 
    eccs_make_xterm_window(Type, _, Stream).

eccs_make_xterm_window(Type, BufferName, Stream) :-
    eccs_global_variable(prolog_type, sicstus), !,
    eccs_global_variable(pleuk_etc, Dir),
    eccs_global_variable(eccs_window_system, Wins),
    eccs_window_command(Wins, sicstus, _, Command),
    eccs_os_list_to_path_name([Dir, Command], L),
    eccs_sys_if_then_else(eccs_sys_var(BufferName), 
	                  eccs_make_temporary_unique_filename(BufferName), 
			  true),
    eccs_unix_call_in_environment([L, Type, BufferName]),
    open(BufferName, write, Stream).
eccs_make_xterm_window(Type, BufferName, Stream) :-
    eccs_global_variable(prolog_type, quintus), !,
    eccs_sys_ensure_loaded(library(pipe)),
    eccs_global_variable(pleuk_etc, Dir),
    eccs_global_variable(eccs_window_system, Wins),
    eccs_window_command(Wins, quintus, _, Command),
    eccs_os_list_to_path_name([Dir, Command], L),
    eccs_concat_list([L, ' ', Type], Shell),
    popen(Shell, write, Stream).

eccs_close_window(Handle) :-
    eccs_global_variable(prolog_type, quintus), !,
    eccs_sys_close(Handle).
eccs_close_window(Handle) :-
    eccs_current_stream(Handle, _, Stream),
    eccs_sys_close(Stream).

eccs_interface_close_all_windows :-
    eccs_global_variable(eccs_file_window_handle, Handle),
    eccs_close_window(Handle), fail.
eccs_interface_close_all_windows :-
    eccs_global_variable(eccs_output_window_handle, H1),
    eccs_close_window(H1), fail.
eccs_interface_close_all_windows.

/*

We don't have a special method for buffering or flushing output. 

*/

eccs_interface_buffer(_) :- fail.
eccs_interface_flush(_) :- fail.

