/*

English UCG Grammar

Copyright 1986, 1989 
University of Edinburgh,
Centre for Cognitive Science

These files may not be redistributed in any form 
without prior permission.

Contact: jo@uk.ac.ed.epistemi

Jonathan Calder
University of Edinburgh
Centre for Cognitive Science
2 Buccleuch Place
Edinburgh
Scotland
EH8 9LW

'SCCSId'('aux.lex', '1.2', '1').

*/
/*

English UCG Grammar

Copyright 1986, 1989 
University of Edinburgh,
Centre for Cognitive Science

These files may not be redistributed in any form 
without prior permission.

Contact: jo@uk.ac.ed.epistemi

Jonathan Calder
University of Edinburgh
Centre for Cognitive Science
2 Buccleuch Place
Edinburgh
Scotland
EH8 9LW

'SCCSId'('aux.lex', '1.2', '1').

*/
/*---------------------------------------------------------------------------+
|        								     |
|        /mnt1/jo/Acord/Prototype/Upimp/Grams/auxiliaries		     |
|        Created:           Mon Nov 24 18:47:55 1986			     |
|        By:                Jo Calder					     |
|        date of last edit: "Mon Nov 24 18:47:55 1986"			     |
|        								     |
|        Auxiliaries and copulas					     |
|        and negation							     |
+---------------------------------------------------------------------------*/
/*
OBJECTs:	AUXILIARIES
SYNOPSIS:	DO, BE and HAVE forms.
MORE INFO:	The "3sg" and "PluPres" lexical rules map the auxiliary in these
		examples into third person singular and plural present verbs
		respectively.  The "Question" lexical rule changes the
		subcategorization of the auxiliary so that the subject NP follows the
		auxiliary instead of preceding it.
*/

does : [@ 'Auxiliary','3sg'].
does : [@ 'Auxiliary','3sg','Question'].
did : [@ 'Auxiliary','Past'].
did : [@ 'Auxiliary','Past','Question'].
do : [@ 'Auxiliary','PluPres'].
do : [@ 'Auxiliary','PluPres','Question'].

be : [@ 'Copula1','Bse'].
be : [@ 'Copula2','Bse'].
be : [@ 'Copula3','Bse'].

am : [@ 'Copula1',
      : cat2 : phonology = 'I',
      @ 'Finite_Copula'].
are : [@ 'Copula1',
       : cat2 : category : feature : number = pl,
       @ 'Finite_Copula'].
am : [@ 'Copula2',
      : cat2 : phonology = 'I',
      @ 'Finite_Copula'].
are : [@ 'Copula2',
       : cat2 : category : feature : number = pl,
       @ 'Finite_Copula'].
am : [@ 'Copula3',
      : cat2 : phonology = 'I',
      @ 'Finite_Copula'].
are : [@ 'Copula3',
       : cat2 : category : feature : number = pl,
       @ 'Finite_Copula'].

am : [@ 'Copula1',
      : cat2 : phonology = 'I',
      @ 'Finite_Copula','Question'].
are : [@ 'Copula1',
       : cat2 : category : feature : number = pl,
       @ 'Finite_Copula','Question'].
am : [@ 'Copula2',
      : cat2 : phonology = 'I',
      @ 'Finite_Copula','Question'].
are : [@ 'Copula2',
       : cat2 : category : feature : number = pl,
       @ 'Finite_Copula','Question'].
am : [@ 'Copula3',
      : cat2 : phonology = 'I',
      @ 'Finite_Copula','Question'].
are : [@ 'Copula3',
       : cat2 : category : feature : number = pl,
       @ 'Finite_Copula','Question'].

(is) : [@ 'Copula1',
	@ 'Finite_Copula','3sg'].
(is) : [@ 'Copula2',
	@ 'Finite_Copula','3sg'].
(is) : [@ 'Copula3',
	@ 'Finite_Copula','3sg'].

been : [@ 'Copula1',
	@ 'Finite_Copula','Perfect'].
been : [@ 'Copula2',
	@ 'Finite_Copula','Perfect'].
been : [@ 'Copula3',
	@ 'Finite_Copula','Perfect'].

being : [@ 'Copula2',
	 @ 'Passive_Complement',
	 @ 'Finite_Copula','Progressive'].
being : [@ 'Copula3',
	 @ 'Passive_Complement',
	 @ 'Finite_Copula','Progressive'].

/*---------------------------------------------------------------------------+
|        								     |
|        The ordering of lexical rules within these entries has been 	     |
|        changed so that 3sg precedes Question.  This is because Question    |
|        shifts the subject np from the position 3sg expects to find it in.  |
|        								     |
+---------------------------------------------------------------------------*/

(is) : [@ 'Copula1',
	@ 'Finite_Copula','3sg','Question'].
(is) : [@ 'Copula2',
	@ 'Finite_Copula','3sg','Question'].
(is) : [@ 'Copula3',
	@ 'Finite_Copula','3sg','Question'].

was : [@ 'Copula1','Past',
       : cat2 : category : feature : number = sg].
was : [@ 'Copula2','Past',
       : cat2 : category : feature : number = sg].
was : [@ 'Copula3','Past',
       : cat2 : category : feature : number = sg].

was : [@ 'Copula1','Past',
       : cat2 : category : feature : number = sg,'Question'].
was : [@ 'Copula2','Past',
       : cat2 : category : feature : number = sg,'Question'].
was : [@ 'Copula3','Past',
       : cat2 : category : feature : number = sg,'Question'].

were : [@ 'Copula1','Past',
	: cat2 : category : feature : number = pl].
were : [@ 'Copula2','Past',
	: cat2 : category : feature : number = pl].
were : [@ 'Copula3','Past',
	: cat2 : category : feature : number = pl].

were : [@ 'Copula1','Past',
	: cat2 : category : feature : number = pl,'Question'].
were : [@ 'Copula2','Past',
	: cat2 : category : feature : number = pl,'Question'].
were : [@ 'Copula3','Past',
	: cat2 : category : feature : number = pl,'Question'].

have : [@ perfaux,'Bse'].
have : [@ perfaux,'PluPres'].
have : [@ perfaux,'PluPres','Question'].

has : [@ perfaux,'3sg','Question'].
has : [@ perfaux,'3sg'].

had : [@ perfaux,'Past'].
had : [@ perfaux,'Past','Question'].  


/*
OBJECT: 	not
SYNOPSIS:	S[bse or pap or prp or pas] / NP[nom] / (S[bse or pap or prp or pas] / NP[nom])
MORE INFO:	The negative looks for a base ("bse"), past participial ("pap"),
		present participial ("prp") or passive participial ("pas") VP and
		gives back a VP of the same type.  The relevant fields of the two
		subject NPs are co-instantiated in the usual way.  The semantics is an
		implication between the semantics of the VP and the "absurdum" predicate.

*/

/*
(not):sent^ (#1)/ (_506:np^ (nom+_535):_548:_565:_584:_595:_606:_623)/ (_638:sent^1# (bse or pap or prp or pas)/ (_705:np^ (nom+_734):_548:_565:_771:_782:_606:_804):_817:pre:_842:_859:_876:_893):(@Sta:imp:[_817,@Sta:absurdum:`[]]):_987:_842:_859:_876:_1031

Error: cannot be processed as any of 
q_lexical_entry lexical_entry File: ../../Lexicon/aux.lex 
(not): #1/ (_490:1# (_513/ (_532:_513/ (_556:(np or pn or
pp)^_595:_612:_629:_640:_651:_662:_681):_694:_705:_716:_727:_738:_755)):_770:pre:_795:_814:_738:_844):(@Sta:imp:[_770,@Sta:absurdum:`[]]):_938:_795:_814:_738:_986

Error: cannot be processed as any of 
q_lexical_entry lexical_entry File: ../../Lexicon/aux.lex 
*/



