/*

English UCG Grammar

Copyright 1986, 1989 
University of Edinburgh,
Centre for Cognitive Science

These files may not be redistributed in any form 
without prior permission.

Contact: jo@uk.ac.ed.epistemi

Jonathan Calder
University of Edinburgh
Centre for Cognitive Science
2 Buccleuch Place
Edinburgh
Scotland
EH8 9LW

'SCCSId'('gen.lex', '1.3', '1').

*/
/*---------------------------------------------------------------------------+
|                                                                            |
|        Unchanged version of        					     |
|        /mnt1/jo/Acord/PIMPLE/Protolexicon/Lexicon/UCG/gen.lex              |
|        Created:           Mon Nov 24 18:43:34 1986			     |
|        By:                Jo Calder					     |
|        date of last edit: "Mon Nov 24 18:43:34 1986"			     |
|        								     |
|        genitives, partitives andd some measure words			     |
|        								     |
+---------------------------------------------------------------------------*/

/*
GENITIVE CONSTRUCTIONS:
There are four definitions for the genitive construction.  They define
the singular genitive, plural genitive, singular genitive predicate
nominal and plural genitive predicate nominal. 
*/

/*
OBJECT:		s
SYNOPSIS:	C / (C / PN) / NP[obj,sg] / LEX, singular genitive predicate nominal.
MORE INFO:	The genitive predicate nominals combine with an accusative "possessor"
		NP to give back a genitive predicate nominal ("pn").  The signs for
		genitive predicate nominals are essentially like the signs for the
		genitives (see below) except that no semantics is introduced for the missing
		"possessed" noun.  However, the "index" "# 4" is still introduced in the
		semantics as the referent of the possessed object.  Furthermore, the
		"position" of the "occlist" of the PN and the "occnumber" of the sign
		are co-instantiated to get the linear order number of the genitive
		predicate nominal in the "occlist" since the noun is not available.
		The singular genitive predicate nominal looks for an accusative NP and
		a lexical "'" to its left to give back a predicate nominal ("pn").
		The "index" of the possessor NP is "Si" (mass or singular).
*/
s : [: category = [: remainder = [: remainder = [: remainder = # 1,
						 : active = [: category = [: remainder = # 1,
									   : active = [: category = [: cat = pn],
										       : semantics = 2 # (@ 'Obj'),
										       : order = # 3,
										       : occlist = [: term = # 2,
												    : position = # 11,
												    : class = def] # 5]],
							     : semantics = [: index = # 6] # 7,
							     : order = # 3,
							     : in = # 8,
							     : out = # 9,
							     : occlist = # 10]],
				  : active = [: category = [: cat = np,
							    : feature = [: case = obj,
									 : number = sg]],
					      : semantics = # 4,
					      : order = pre,
					      : occlist = [: term = # 4,
							   : function = adj,
							   : class = ~ pers,
							   : class = ~ poss,
							   : class = ~ refl,
							   : commander = # 5]]],
		   : active = [: phonology = '''',
			       : category = lex,
			       : order = post]],
     : semantics = [: index = # 6,
		    : predicate = and,
		    @binary(# 5, [: index = # 6,
				  : predicate = and,
				  @binary([: index = # 2,
					   : predicate = poss,
					   @unary(4 # (@ 'Si'))], # 7)])],
     : in = # 8,
     : out = # 9,
     : occlist = # 10,
     : occnumber = # 11].

/*
OBJECT:		''''
SYNOPSIS:	C / (C / PN) / NP[obj,pl], plural genitive predicate nominal.
MORE INFO:	See "s" above. The plural genitive predicate nominal looks for an
		accusative NP to its left to give back a predicate nominal ("pn").
		The "index" of the possessor NP is "Pl" (plural).
*/
'''' : [: category = [: remainder = [: remainder = # 1,
				     : active = [: category = [: remainder = # 1,
							       : active = [: category = [: cat = pn],
									   : semantics = 2 # (@ 'Obj'),
									   : order = # 3,
									   : occlist = [: term = # 2,
											: position = # 11,
											: class = def] # 4]],
						 : semantics = [: index = # 5] # 7,
						 : order = # 3,
						 : in = # 8,
						 : out = # 9,
						 : occlist = # 10]],
		      : active = [: category = [: cat = np,
						: feature = [: case = obj,
							     : number = pl]],
				  : semantics = # 6,
				  : order = pre,
				  : occlist = [: function = adj,
					       : class = ~ pers,
					       : class = ~ poss,
					       : class = ~ refl,
					       : commander = # 4]]],
	: semantics = [: index = # 5,
		       : predicate = and,
		       @binary(# 4, [: index = # 5,
				     : predicate = and,
				     @binary([: index = # 2,
					      : predicate = poss,
					      @unary(# 6)], # 7)])],
	: in = # 8,
	: out = # 9,
	: occlist = # 10,
	: occnumber = # 11].

/*
OBJECT:		''''
SYNOPSIS:	C / (C / NP) / N / NP[obj], plural genitive.
MORE INFO:	The genitives combine with an accusative "possessor"
		NP and a "possessed" noun to give back a genitive NP.  The semantics
		and "occlists" of both of these must be introduced in the resulting
		sign.  The NP introduces its own semantics and "occlist" since it is
		type-raised over the genitive.  The semantics and "occlist" of the
		noun must be introduced explicitly in the semantics of the genitive
		NP.  The "occlists" of the noun and the genitive NP are
		co-instantiated since the noun is the head of the phrase.  The "class"
		of the "occlist" of the NP is "def".  The "function" of the "occlist"
		of the possessor NP is "adj".  The noun commands the possessor NP so
		the "commander" of the "occlist" of the possessor NP and the "occlist"
		of the noun are co-instantiated.  The "occlists" of the sign and the
		active part of the sign are co-instantiated as in other NPs.  The
		semantics is a conjunction of the "occlist" of the noun, the semantics
		of the noun and the semantics of the active part of the sign.  The
		predicate "poss" relates a possed entity (corresponding to the index)
		and a possessor (its argument).  Finally, the possessor NP cannot be a
		personal, possessive or reflexive pronoun.  The plural genitive looks for
		an accusative NP to its left and a noun to its right to give back a type-raised NP.
		The "index" of the possessor NP is "Pl" (plural).
*/
'''' : [: category = [: remainder = [: remainder = [: remainder = # 1,
						    : active = [: category = [: remainder = # 1,
									      : active = [: category = [: cat = np],
											  : semantics = # 2,
											  : order = # 3,
											  : occlist = [: term = # 2,
												       : class = def] # 5]],
								: semantics = [: index = # 7] # 10,
								: order = # 3,
								: in = # 4,
								: out = # 12,
								: occlist = # 13]],

				     : active = [: category = noun,
						 : semantics = [: index = # 2] # 9,
						 : order = pre,
						 : in = # 11,
						 : out = # 4,
						 : occlist = # 5]],
		      : active = [: category = [: cat = np,
						: feature = [: case = obj]],
				  : semantics = # 6,
				  : order = pre,
				  : occlist = [: term = # 6,
					       : position = # 8,
					       : function = adj,
					       : class = ~ pers,
					       : class = ~ poss,
					       : class = ~ refl,
					       : commander = # 5]]],
	: semantics = [: index = # 7,
		       : predicate = and,
		       @binary(# 5, [: index = # 7,
				     : predicate = and,
				     @binary([: index = # 8,
					      : predicate = and,
					      @binary([: index = # 8,
						       : predicate = poss,
						       @unary(# 6)], # 9)], # 10)])],
	: in = # 11,
	: out = # 12,
	: occlist = # 13].

/*
OBJECT:		s
SYNOPSIS:	C / (C / NP[sg]) / N[sg] / NP[obj] / LEX, singular genitive (singular noun argument).
MORE INFO:	See "''''" above. The singular genitive looks for an accusative NP and a lexical "'" to
		its left and a noun to its right to give back a type-raised NP.
		The "index" of the possessor NP is "Si" (mass or singular).
*/
s : [: category = [: remainder = [: remainder = [: remainder = [: remainder = # 1,
								: active = [: category = [: remainder = # 1,
											  : active = [: category = [: cat =
														    np,
														    : feature =
														    [: number =
														     sg]],
												      : semantics = # 2,
												      : order = # 3,
												      : occlist = [: term =
														   # 2,
														   : class =
														   def] #
														  5]],
									    : semantics = [: index = # 6] # 10,
									    : order = # 3,
									    : in = # 4,
									    : out = # 12,
									    : occlist = # 13]],
						 : active = [: category = [: cat = noun,
									   : feature = sg],
							     : semantics = [: index = # 2] # 9,
							     : order = pre,
							     : in = # 11,
							     : out = # 4,
							     : occlist = # 5]],
				  : active = [: category = [: cat = np,
							    : feature = [: case = obj]],
					      : semantics = # 8,
					      : order = pre,
					      : occlist = [: term = # 7,
							   : function = adj,
							   : class = ~ pers,
							   : class = ~ poss,
							   : class = ~ refl,
							   : commander = # 5]]],
		   : active = [: phonology = '''',
			       : category = lex,
			       : order = post]],
     : semantics = [: index = # 6,
		    : predicate = and,
		    @binary(# 5, [: index = # 6,
			          : predicate = and,
				  @binary([: index = # 7,
					   : predicate = and,
					   @binary([: index = # 7,
						    : predicate = poss,
						    @unary(# 8)], # 9)], # 10)])],
     : in = # 11,
     : out = # 12,
     : occlist = # 13].

/*
OBJECT:		s
SYNOPSIS:	C / (C / NP[pl]) / N[pl] / NP[obj] / LEX, singular genitive (plural noun argument).
MORE INFO:	See "s" above.
*/
s : 
[: category = [: remainder = [: remainder = [: remainder = [: remainder = # 1,
							    : active = [: category = [: remainder = # 1,
										      : active = [: category = [: cat = np,
														: feature =
															[: number = pl]],
												   : semantics = # 3,
												   : order = # 2,
												   : occlist = [: term = 8 # (@ 'Pl'),
														: class = def] # 5]],
									 : semantics = [: index = 7 # (@ 'Tem')] # 11,
									 : order = # 2,
									 : in = # 4,
									 : out = # 13,
									 : occlist = # 14]],
					     : active = [: category = [: cat = noun,
								       : feature = pl],
							 : semantics = [: index = # 3] # 10,
							 : order = pre,
							 : in = # 12,
							 : out = # 4,
							 : occlist = # 5]],
			      : active = [: category = [: cat = np,
							: feature = [: case = obj]],
					  : semantics = # 6,
					  : order = pre,
					  : occlist = [: term = # 6,
						       : function = adj,
						       : class = ~ pers,
						       : class = ~ poss,
						       : class = ~ refl,
						       : commander = # 5],
					  : occnumber = # 9]],
	       : active = [: phonology = '''',
			   : category = lex,
			   : order = post]],
 : semantics = [: index = # 7,
		: predicate = and,
		@binary(# 5, [: predicate = set,
			      @quintuple(= # 8, # 9, [: index = # 9,
						      : predicate = and,
						      @binary([: index = # 9,
							       : predicate = poss,
							       @unary(# 6)],  # 10)], # 11, [])])],
 : in = # 12,
 : out = # 13,
 : occlist = # 14].

/* 	This used to be 

:semantics:arg2:arg1:arg1 = @'Si'

*/
/* Old definition of measures

%MEASURES

pound:	[@'MeasureN', :semantics:arg1 = pound, :cat2:cat1 = sg].
tonne:	[@'MeasureN', :semantics:arg1 = ton, :cat2:cat1 = sg].
ton:	[@'MeasureN', :semantics:arg1 = ton, :cat2:cat1 = sg].
mile:	[@'MeasureN', :semantics:arg1 = mile, :cat2:cat1 = sg].
kilo:	[@'MeasureN', :semantics:arg1 = kilo, :cat2:cat1 = sg].
litre: 	[@'MeasureN', :semantics:arg1 = liter, :cat2:cat1 = sg].
metre: 	[@'MeasureN', :semantics:arg1 = meter, :cat2:cat1 = sg].
kilometre: [@'MeasureN', :semantics:arg1 = kilometer, :cat2:cat1 = sg].
hectolitre: [@'MeasureN',:semantics:arg1 = hectoliter, :cat2:cat1 = sg].
gram: 	[@'MeasureN', @'Measure',:semantics:arg1 = gram, :cat2:cat1 = sg].


pounds:	[@'MeasureN', :semantics:arg1 = pound, 
	:cat2:cat1 = pl].
tonnes:	[@'MeasureN', :semantics:arg1 = ton, 
	:cat2:cat1 = pl].
tons:	[@'MeasureN', :semantics:arg1 = ton, 
	:cat2:cat1 = pl].
miles:	[@'MeasureN', :semantics:arg1 = mile, 
	:cat2:cat1 = pl].
kilos:	[@'MeasureN', :semantics:arg1 = kilo, 
	:cat2:cat1 = pl].
litres: 	[@'MeasureN', :semantics:arg1 = liter, 
	:cat2:cat1 = pl].
metres: 	[@'MeasureN', :semantics:arg1 = meter, 
	:cat2:cat1 = pl].
kilometres: 	[@'MeasureN', :semantics:arg1 = kilometer, 
	:cat2:cat1 = pl].
hectolitres: [@'MeasureN', :semantics:arg1 = hectoliter, 
	:cat2:cat1 = pl].
grams: 	[@'MeasureN', :semantics:arg1 = gram, 
	:cat2:cat1 = pl].

*/

/*
New hecked measures.  See extra.def for more details

*/

pound : [@ 'N',
	 @ 'Measure',
	 @ 'Neuter',
	 : semantics = [: predicate = pound],
	 @ 'Neuter'].
tonne : [@ 'N',
	 @ 'Measure',
	 @ 'Neuter',
	 : semantics = [: predicate = ton]].
ton : [@ 'N',
       @ 'Measure',
       @ 'Neuter',
       : semantics = [: predicate = ton]].
mile : [@ 'N',
	@ 'Measure',
	@ 'Neuter',
	 : semantics = [: predicate = mile]].
kilo : [@ 'N',
	@ 'Measure',
	@ 'Neuter',
	: semantics = [: predicate = kilo]].
litre : [@ 'N',
	 @ 'Measure',
	 @ 'Neuter',
	 : semantics = [: predicate = liter]].
metre : [@ 'N',
	 @ 'Measure',
	 @ 'Neuter',
	 : semantics = [: predicate = meter]].
kilometre : [@ 'N',
	     @ 'Measure',
	     @ 'Neuter',
	     : semantics = [: predicate = kilometer]].
hectolitre : [@ 'N',
	      @ 'Measure',
	      @ 'Neuter',
	      : semantics = [: predicate = hectoliter]].
gram : [@ 'N',
	@ 'Measure',
	@ 'Neuter',
	: semantics = [: predicate = gram]].

pounds : [@ 'N',
	  @ 'Measure',
	  : category = [: feature = pl],
	  : semantics = [: predicate = pound]].
tonnes : [@ 'N',
	  @ 'Measure',
	  : category = [: feature = pl],
	  : semantics = [: predicate = ton]].
tons : [@ 'N',
	@ 'Measure',
	: category = [: feature = pl],
	: semantics = [: predicate = ton]].
miles : [@ 'N',
	 @ 'Measure',
	 : category = [: feature = pl],
	 : semantics = [: predicate = mile]].
kilos : [@ 'N',
	 @ 'Measure',
	 : category = [: feature = pl],
	 : semantics = [: predicate = kilo]].
litres : [@ 'N',
	  @ 'Measure',
	  : category = [: feature = pl],
	  : semantics = [: predicate = liter]].
metres : [@ 'N',
	  @ 'Measure',
	  : category = [: feature = pl],
	  : semantics = [: predicate = meter]].
kilometres : [@ 'N',
	      @ 'Measure',
	      : category = [: feature = pl],
	      : semantics = [: predicate = kilometer]].
hectolitres : [@ 'N',
	       @ 'Measure',
	       : category = [: feature = pl],
	       : semantics = [: predicate = hectoliter]].
grams : [@ 'N',
	 @ 'Measure',
	 : category = [: feature = pl],
	 : semantics = [: predicate = gram]].

