/*

English UCG Grammar

Copyright 1986, 1989 
University of Edinburgh,
Centre for Cognitive Science

These files may not be redistributed in any form 
without prior permission.

Contact: jo@uk.ac.ed.epistemi

Jonathan Calder
University of Edinburgh
Centre for Cognitive Science
2 Buccleuch Place
Edinburgh
Scotland
EH8 9LW

'SCCSId'('prep.lex', '1.3', '1').

*/
/*---------------------------------------------------------------------------+
|                                                                            |
|	 this file is an updated copy of				     |
|	 /mnt/jo/Acord/PIMPLE/Protolexicon/Lexicon/UCG/prep.lex		     |
|	 Created: Mon Nov 24 18:32:38 1986				     |
|	 By: Jo Calder							     |
|									     |
|	 Date of last edit: "Thu Aug 18, 1988" (marc)			     |
|									     |
|	 Prepositions 							     |
|									     |
|	 This file also includes sentential conjunctions, and adverbials     |
|	 such as 'apart from', 'without', etc.  			     |
|									     |
+---------------------------------------------------------------------------*/

/* The ordering of entries in this file has been changed so that
subcategorized for preopsitions, i.e.  those that are @'SPreposition'
precede other forms.  This is to get sentences which are ambiguous
between a V + PP and a V' + PP to produce the V + PP reading first.  JC
Wed Jan 13 13:24:52 1988
*/

above : [@ 'LocPreposition',
	 : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	 : semantics = [: arglist = [: argfirst = [: predicate = [: first = aboveloc,
								  : rest = `[]]]]]].

across : [@ 'LocPreposition',
	  : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	  : semantics = [: arglist = [: argfirst = [: predicate = [: first = path,
								   : rest = `[]]]]]].

after : [@ 'LocPreposition',
	 : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	 : semantics = [: arglist = [: argfirst = [: predicate = [: first = aftertemp,
								  : rest = `[]]]]]].

along : [@ 'LocPreposition',
	 : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	 : semantics = [: arglist = [: argfirst = [: predicate = [: first = path,
								  : rest = `[]]]]]].

amid : [@ 'Preposition',
	: category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	: semantics = [: arglist = [: argfirst = [: predicate = [: first = amidloc,
								 : rest = `[]]]]]].

amidst : [@ 'Preposition',
	  : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	  : semantics = [: arglist = [: argfirst = [: predicate = [: first = amidloc,
								   : rest = `[]]]]]].

among : [@ 'Preposition',
	 : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	 : semantics = [: arglist = [: argfirst = [: predicate = [: first = amongloc,
								  : rest = `[]]]]]].

amongst : [@ 'Preposition',
	   : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	   : semantics = [: arglist = [: argfirst = [: predicate = [: first = amongloc,
								    : rest = `[]]]]]].

around : [@ 'LocPreposition',
	  : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	  : semantics = [: arglist = [: argfirst = [: predicate = [: first = aroundtemp,
								   : rest = [: first = path,
									     : rest = `[]]]]]]].

at : [@ 'LocPreposition',
      : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
      : semantics = [: arglist = [: argfirst = [: predicate = [: first = atloc,
							       : rest = [: first = attemp,
									 : rest = `[]]]]]]].

away : [@ 'LocPreposition1',
	: category = [: remainder = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or
														   loc]]]]]],
		      : active = [: phonology = from]],
	: semantics = [: arglist = [: argfirst = [: predicate = [: first = source,
								 : rest = `[]]]]]].


because : [@ 'Preposition1',
	   : category = [: remainder = [: remainder = [: active = [: category = [: active = [: category = [: feature =
														  adj]]]]]], 
			 : active = [: phonology = of]],
	   : semantics = [: arglist = [: argfirst = [: predicate = [: first = cause,
								    : rest = `[]]]]]].

before : [@ 'Preposition',
	  : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	  : semantics = [: arglist = [: argfirst = [: predicate = [: first = beforetemp,
								   : rest = `[]]]]]].

behind : [@ 'LocPreposition',
	  : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	  : semantics = [: arglist = [: argfirst = [: predicate = [: first = behindloc,
								   : rest = [: first = path,
									     : rest = `[]]]]]]].

below : [@ 'LocPreposition',
	 : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	 : semantics = [: arglist = [: argfirst = [: predicate = [: first = belowloc,
								  : rest = `[]]]]]].

beneath : [@ 'LocPreposition',
	   : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	   : semantics = [: arglist = [: argfirst = [: predicate = [: first = underloc,
								    : rest = `[]]]]]].

beside : [@ 'LocPreposition',
	  : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	  : semantics = [: arglist = [: argfirst = [: predicate = [: first = besideloc,
								   : rest = `[]]]]]].

between : [@ 'LocPreposition',
	   : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]],
			 : active = [: semantics = @ 'Pl']],
	   : semantics = [: arglist = [: argfirst = [: predicate = [: first = betweenloc,
								    : rest = [: first = temploc,
									      : rest = `[]]]]]]].

beyond : [@ 'LocPreposition',
	  : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	  : semantics = [: arglist = [: argfirst = [: predicate = [: first = path,
								   : rest = `[]]]]]].

but : [@ 'Preposition',
       : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj]]]]]],
       : semantics = [: arglist = [: argfirst = [: predicate = [: first = exception,
								: rest = `[]]]]]].

by : [@ 'SPreposition',
      : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = by]]]]]]].

by : [@ 'LocPreposition',
      : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
      : semantics = [: arglist = [: argfirst = [: predicate = [: first = besideloc,
							       : rest = [: first = byloc,
									 : rest = [: first = temploc,
										   : rest = [: first = manner,
											     : rest = [: first = path,
												       : rest = `[]]]]]]]]]].

down : [@ 'LocPreposition',
        : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	: semantics = [: arglist = [: argfirst = [: predicate = [: first = path,
								 : rest = `[]]]]]].

due : [@ 'Preposition1',
       : category = [: remainder = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj]]]]]],
		     : active = [: phonology = to]],
       : semantics = [: arglist = [: argfirst = [: predicate = [: first = cause,
								: rest = `[]]]]]].


during : [@ 'Preposition',
          : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj]]]]]],
	  : semantics = [: arglist = [: argfirst = [: predicate = [: first = duration,
								   : rest = `[]]]]]].

except : [@ 'Preposition1',
          : category = [: remainder = [: remainder = [: active = [: category = [: active = [: category = [: feature = 
														adj]]]]]],
			: active = [: phonology = for]],
	  : semantics = [: arglist = [: argfirst = [: predicate = [: first = exception,
								   : rest = `[]]]]]].

for : [@ 'Preposition',
       : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj]]]]]],
       : semantics = [: arglist = [: argfirst = [: predicate = [: first = tmeasure,
								: rest = `[]]]]]].

/*

Tue Sep 19 10:59:42 1989 JC
Subcat'ed version of in added to get "unload X from Y"

*/

from : [@ 'SPreposition',
	: category = [: remainder = [: active = [: category = [: active = [: category = [: feature = from]]]]]]].

from : [@ 'LocPreposition',
	: category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	: semantics = [: arglist = [: argfirst = [: predicate = [: first = source,
								 : rest = [: first = tempsource,
									   : rest = [: first = substance,
										     : rest = `[]]]]]]]].

front : [@ 'LocPreposition2',
	 : category = [: remainder = [: remainder = [: remainder = [: active = [: category = [: active = [: category = 
													    [: feature =
													       adj or 
													       loc]]]]]],
				      : active = [: phonology = in]],
		       : active = [: phonology = of]],
	 : semantics = [: arglist = [: argfirst = [: predicate = [: first = beforeloc,
								  : rest = `[]]]]]].

/*

Tue Sep 19 10:59:42 1989 JC
Subcat'ed version of in added to get "put X in Y"

*/

in : [@ 'SPreposition',
      : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = in]]]]]]].


in : [@ 'LocPreposition',
      : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
      : semantics = [: arglist = [: argfirst = [: predicate = [: first = inloc,
							       : rest = [: first = tmeasure,
									 : rest = `[]]]]]]].


into : [@ 'LocPreposition',
        : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	: semantics = [: arglist = [: argfirst = [: predicate = [: first = ingoal,
								 : rest = `[]]]]]].

left : [@ 'LocPreposition',
        : category = [: remainder = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or
														   loc]]]]]],
		      : active = [: phonology = of]],
	: semantics = [: arglist = [: argfirst = [: predicate = [: first = leftloc,
								 : rest = `[]]]]]].

of : [@ 'SPreposition',
      : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = of]]]]]]].


of : [@ 'Preposition',
      : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj]]]]]],
      : semantics = [: arglist = [: argfirst = [: predicate = [: first = theme,
							       : rest = [: first = measure,
									 : rest = [: first = poss,
										   : rest = [: first = substance,
											     : rest = [: first = component,
												       : rest = `[]]]]]]]]]].


of : [@ 'Partitive'].



off : [@ 'Preposition',
       : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
       : semantics = [: arglist = [: argfirst = [: predicate = [: first = source,
								: rest = `[]]]]]].

on : [@ 'SPreposition',
      : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = on]]]]]]].

onto : [@ 'SPreposition',
        : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = onto]]]]]]].

on : [@ 'LocPreposition',
      : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
      : semantics = [: arglist = [: argfirst = [: predicate = [: first = onloc,
							       : rest = [: first = temploc,
									 : rest = `[]]]]]]].

onto : [@ 'LocPreposition',
        : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	: semantics = [: arglist = [: argfirst = [: predicate = [: first = ongoal,
								 : rest = `[]]]]]].

opposite : [@ 'LocPreposition',
            : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	    : semantics = [: arglist = [: argfirst = [: predicate = [: first = oppositeloc,
								     : rest = `[]]]]]].

out : [@ 'LocPreposition1',
       : category = [: remainder = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or
														   loc]]]]]],
		     : active = [: phonology = of]],
       : semantics = [: arglist = [: argfirst = [: predicate = [: first = source,
								: rest = `[]]]]]].

outside : [@ 'LocPreposition',
           : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	   : semantics = [: arglist = [: argfirst = [: predicate = [: first = outsideloc,
								    : rest = `[]]]]]].

over : [@ 'LocPreposition',
        : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	: semantics = [: arglist = [: argfirst = [: predicate = [: first = path,
								 : rest = [: first = aboveloc,
									   : rest = `[]]]]]]].

past : [@ 'LocPreposition',
        : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	: semantics = [: arglist = [: argfirst = [: predicate = [: first = path,
								 : rest = `[]]]]]].

round : [@ 'LocPreposition',
         : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	 : semantics = [: arglist = [: argfirst = [: predicate = [: first = temploc,
								  : rest = [: first = path,
									    : rest = `[]]]]]]].

right : [@ 'LocPreposition1',
         : category = [: remainder = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or
														   loc]]]]]],
		       : active = [: phonology = of]],
	 : semantics = [: arglist = [: argfirst = [: predicate = [: first = rightloc,
								  : rest = `[]]]]]].

since : [@ 'Preposition',
	 : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj]]]]]],
	 : semantics = [: arglist = [: argfirst = [: predicate = [: first = tempsource,
								  : rest = `[]]]]]].


through : [@ 'LocPreposition',
	   : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	   : semantics = [: arglist = [: argfirst = [: predicate = [: first = path,
								    : rest = [: first = duration,
									      : rest = `[]]]]]]].

throughout : [@ 'Preposition',
	      : category = [: remainder = [: remainder = [: remainder = [: active = [: category = [: active = [: category =
													       [: feature =
														adj]]]]]]]],
	      : semantics = [: arglist = [: argfirst = [: predicate = [: first = duration,
								       : rest = `[]]]]]].

till : [@ 'Preposition',
	: category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj]]]]]],
	: semantics = [: arglist = [: argfirst = [: predicate = [: first = tempgoal,
								 : rest = `[]]]]]].


to : [@ 'SPreposition',
      : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = to]]]]]]].


to : [@ 'LocPreposition',
      : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
      : semantics = [: arglist = [: argfirst = [: predicate = [: first = togoal,
							       : rest = [: first = tempgoal,
									 : rest = `[]]]]]]].

towards : [@ 'LocPreposition',
           : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	   : semantics = [: arglist = [: argfirst = [: predicate = [: first = togoal,
								    : rest = `[]]]]]].


under : [@ 'LocPreposition',
         : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	 : semantics = [: arglist = [: argfirst = [: predicate = [: first = underloc,
								  : rest = `[]]]]]].

underneath : [@ 'LocPreposition',
              : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	      : semantics = [: arglist = [: argfirst = [: predicate = [: first = underloc,
								       : rest = `[]]]]]].

until : [@ 'Preposition',
	 : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	 : semantics = [: arglist = [: argfirst = [: predicate = [: first = tempgoal,
								  : rest = `[]]]]]].


via : [@ 'LocPreposition',
       : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
       : semantics = [: arglist = [: argfirst = [: predicate = [: first = path,
								: rest = `[]]]]]].

with : [@ 'SPreposition',
	: category = [: remainder = [: active = [: category = [: active = [: category = [: feature = with]]]]]]].


with : [@ 'Preposition',
	: category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj]]]]]],
	: semantics = [: arglist = [: argfirst = [: predicate = [: first = accompany,
								 : rest = [: first = instrument,
									   : rest = [: first = cause,
										     : rest = [: first = component,
											       : rest = `[]]]]]]]]].
/*

Tue Sep 19 12:44:58 1989 JC
Zapped  besideloc, yet again

*/

within : [@ 'LocPreposition',
	  : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj or loc]]]]]],
	  : semantics = [: arglist = [: argfirst = [: predicate = [: first = inloc,
								   : rest = [: first = tmeasure,
									     : rest = `[]]]]]]].

without : [@ 'Preposition',
	   : category = [: remainder = [: active = [: category = [: active = [: category = [: feature = adj]]]]]],
	   : semantics = [: arglist = [: argfirst = [: predicate = [: first = exception,
								    : rest = `[]]]]]].

/*---------------------------------------------------------------------------+
|        								     |
|        Sentential conjunctions					     |
|        								     |
+---------------------------------------------------------------------------*/

although : [@ 'Sentpreposition',
	    : semantics = [: predicate = and,
			   : arglist = [: argrest = [: argfirst = [: arglist = [: argfirst = [: predicate = conc]]]]]]].

because : [@ 'Sentpreposition',
	   : semantics = [: predicate = and,
			  : arglist = [: argrest = [: argfirst = [: arglist = [: argfirst = [: predicate = [: first = cause,
													    : rest = `[]]]]]]]]].

if : [@ 'Sentprepositionimp'].

though : [@ 'Sentpreposition',
	  : semantics = [: predicate = and,
			 : arglist = [: argrest = [: argfirst = [: arglist = [: argfirst = [: predicate = conc]]]]]]].

until : [@ 'Sentpreposition',
	 : semantics = [: predicate = and,
			: arglist = [: argrest = [: argfirst = [: arglist = [: argfirst = [: predicate = [: first = tempgoal,
													  : rest = `[]]]]]]]]].

while : [@ 'Sentpreposition',
	 : semantics = [: predicate = and,
			: arglist = [: argrest = [: argfirst = [: arglist = [: argfirst = [: predicate = [: first = duration,
													  : rest = `[]]]]]]]]].
when : [@ 'Sentpreposition',
	: semantics = [: predicate = and,
		       : arglist = [: argrest = [: argfirst = [: arglist = [: argfirst = [: predicate = [: first = temploc,
													 : rest = `[]]]]]]]]].
whenever : [@ 'Sentprepositionimp'].

where : [@ 'Sentpreposition',
	 : semantics = [: predicate = and,
			: arglist = [: argrest = [: argfirst = [: arglist = [: argfirst = [: predicate = [: first = atloc,
													 : rest = `[]]]]]]]]].
% Locative NPs.  Henk sometime in October, 1988 

where : [@ 'LocativeWH'].
where : [@ 'LocativeWHR'].

there : [@ 'LocativeDemonstrative'].

here : [@ 'LocativeDemonstrative'].

