/*

English UCG Grammar

Copyright 1986, 1989 
University of Edinburgh,
Centre for Cognitive Science

These files may not be redistributed in any form 
without prior permission.

Contact: jo@uk.ac.ed.epistemi

Jonathan Calder
University of Edinburgh
Centre for Cognitive Science
2 Buccleuch Place
Edinburgh
Scotland
EH8 9LW

'SCCSId'('proto.mt', '1.3', '1').

*/
/*---------------------------------------------------------------------------+
|                                                                            |
|	 this file is an updated copy of                                     |
|        /mnt/jo/Acord/PIMPLE/Protolexicon/Lexicon/UCG/proto.mt  	     |
|        Created:                                                            |
|        By:                Jo Calder					     |
|                                                                            |
|        Date of last edit: "Wed Sep 28, 1988" (marc)                        |
|        								     |
+---------------------------------------------------------------------------*/
class(v,{a,e,i,o,u,y}).
class(c,{b,c,d,f,g,h,j,k,l,m,n,p,q,r,s,t,v,w,x,y,z}).
class(stops, {p,b,d,t,c,g,k,q}).
class(sibs, {c,s,x,z}).
class(semis, {w,y}).
class(voiced, {b,d,g,j,m,n,r,v,w,z}).
class(unvoiced, {c,f,h,k,p,q,s,t,x,y}).
class(alv, {t,d}).
class(liquids, {l,r}).
class(affricates, {g,j}).
class(nasals, {m,n}).

/*
Superceded Sun Aug 27 17:04:06 1989 JC

table( noun_regular,
	[noun, morph_stem(Noun)],
	[],
	[]).

*/

table( noun_regular,
	[noun, morph_stem(Noun)],
	['SingularNoun', 'PluralNoun'],
	[Noun, Noun + s]).
table( noun_in_o,
	[noun, morph_stem(Noun),
%	The following line imported into the following table
%	 Noun \= {dynamo,kilo,piano,photo,piccolo,quarto,solo},
	 Noun = Stem+C+o,
	 C = `c],
	['SingularNoun', 'PluralNoun'],
	[Noun, Noun + es]).	
table( irregular_noun_in_o,
	[noun, morph_stem(Noun),
	 Noun = {dynamo,kilo,piano,photo,piccolo,quarto,solo}],
	['SingularNoun', 'PluralNoun'],
	[Noun, Noun + s]).	
/*
table( alternating_noun_in_o,	
	[noun, morph_stem(Noun),
	 Noun = {cargo,banjo},
	 Cargoes = Noun+{e,0}+s],
	['SingularNoun', 'PluralNoun'],
	[Noun, Cargoes]).	
*/
table( noun_in_sib,
	[noun, morph_stem(Bus),
	 Bus = B+U+S,
	 S = {s,x,zz,sh,ch}],
	['SingularNoun', 'PluralNoun'],
	[ Bus, Bus + es]).
	%buses, gases, boxes, buzzes, bushes, churches
/*
table( noun_in_sib,
	[noun, morph_stem(Fez),
	 Fez = F+E+z,
	 E = `v],
	['SingularNoun', 'PluralNoun'],
	[ Fez, Fez + z + es]).	%fezzes, quizzes
*/
table( noun_in_y,
	[noun, morph_stem(Noun),
	 Noun = Stem+C+y,
	 C = `c],
	['SingularNoun', 'PluralNoun'],
	[ Noun, Stem + C + ies]).	%cities
/*
table( noun_in_y,
	[noun, morph_stem(Noun),
	 Noun = Stem+q+u+y],
	['SingularNoun', 'PluralNoun'],
	[ Noun, Stem + q + u + ies]).		%soliloquies
*/
/*
table( noun_in_lf,
	[noun, morph_stem(Calf),
	 Calf = Ca+lf],
	['SingularNoun', 'PluralNoun'],
	[ Calf, Ca+lves]).
*/
table( noun_in_ife,
	[noun, morph_stem(Wife),
	 Wife = W+ife],
	['SingularNoun', 'PluralNoun'],
	[ Wife, W+ives]).
/*
table( noun_in_ouse,
	[noun, morph_stem(Mouse),
	 Mouse = M+ouse,
	 M = {m,l}],
	['SingularNoun', 'PluralNoun'],
	[ Mouse, M+ice]).

table( noun_with_oo,
	[noun, morph_stem(Foot),
	 Foot = {foot,goose,tooth},
	 Foot = F+oo+T],
	['SingularNoun', 'PluralNoun'],
	[ Foot, F+ee+T]).
*/
table( noun_in_man,
	[noun, morph_stem(Woman),
%	The following line imported into the following table
%	 Woman \= {doberman, human},
	 Woman = Wo+man],
	['SingularNoun', 'PluralNoun'],
	[ Woman, Wo+men]).
table( irregular_noun_in_man,
	[noun, morph_stem(Woman),
	 Woman = {doberman, human}],
	['SingularNoun', 'PluralNoun'],
	[ Woman, Woman+s]).
/*
table( children,
	[noun, morph_stem(child)],
	['SingularNoun', 'PluralNoun'],
	[ child, children]).
*/



table(	verb_regular,
	[verb,
	 morph_stem(Depart),
	 Departs = Depart+s,
	 Departed = Depart+ed,
	 Departing = Depart+ing],
	['Base', '3sg', 'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Depart, Departs, Depart, Departed, Departed, Departing,Departed]).

table(	verb_in_e,		% drop -e in progressive	
	[verb, 
	 morph_stem(Hike), 
	 Hike = Hik+e,
	 Hikes = Hike+s,
	 Hiked = Hike+d,
	 Hiking = Hik+ing ],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive',	'Passive'],
	[Hike, Hikes,	Hike,	  Hiked,   Hiked,    Hiking,		Hiked]).
/*
table(	age,		% keep -e in progressive
	[verb, 
	 morph_stem(Age), % morph_root(Age),
	 Age = {age, dye, hoe, singe, swinge, tinge},
	 Ages = Age+s,
	 Aged = Age+d,
	 Ageing = Age+ing],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive',	'Passive'],
	[Age, Ages,	Age,	  Aged,	  Aged,	     Ageing,		Aged     ]).
*/
table(	pass,		% take -es in 3sg
	[verb,  
	 morph_stem(Pass), % morph_root(Pass),
	 Pass = Pas+S,
	 S = {h,s,z,x},		%fetch,wash,reach,coax,buzz
	 Passes = Pass+es,
	 Passed = Pass+ed,
	 Passing = Pass+ing],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Pass, Passes, Pass, Passed, Passed, Passing, Passed]).

/*
table(	panic,		% frolic, traffic
	[verb, 
	 morph_stem(Panic), % morph_root(Panic),
	 Panic = Pan+i+c,
	 Panics = Panic+s,
	 Panicked = Panic+ked,
	 Panicking = Panic+king],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Panic, Panics, Panic,	Panicked, Panicked, Panicking, Panicked]).
*/

/*
  The following table is not correct for cut, put, etc.
  JC 12/10/88
*/

table(	hit,		% put,cut; double consonant; no vowel change
	[verb, 
	 morph_stem(Hit), % morph_root(Hit),
	 Hit = Stem+C,
	 C = `c,
	 Hit = {hit,put,cut,stop},
	 Hits = Hit+s,
	 Hitted = Hit+C+ed,
	 Hitting = Hit+C+ing],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Hit, Hits,	Hit,	Hitted,	  Hitted,	Hitting,    Hitted]).

table(	sell,
	[verb, 
	 morph_stem(Sell),
	 Sell = S+ell,
	 Sells = Sell+s,
	 Selled = S+old,
	 Selling = Sell+ing],
	['Base', '3sg', 'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Sell, Sells, Sell, Selled, Selled, Selling,Selled]).

table(	give,
	[verb, 
	 morph_stem(give)],
	['Base', '3sg', 'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[give, gives, give, gave, given, giving,given]).

/*
  The following table is not correct for throw, etc.
  JC 12/10/88
*/

table(	show,
	[verb, 
	 morph_stem(Show),
	 Show = Sh+V+w,
	 V = {o,a},
	 Sh = C + C1,
	 C = `c, C1 = `c,
	 Shows = Sh+V+w+s,
	 Shown = Sh+V+w+n,
	 Shew = Sh+ew],
	['Base', '3sg', 'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Show, Shows, Show, Shew, Shown, Show+ing, Shown]).


/*
table(	break,		
	[verb,  
	 morph_stem(Break), % morph_root(Break),
	 Break = {break,speak,steal},
	 Break = Br+ea+K,
	 Breaks = Br+ea+K+s,
	 Breaking = Br+ea+K+ing,
	 Broke = Br+o+K+e,
	 Broken = Br+o+K+en],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Break, Breaks, Break, Broke, Broken, Breaking, Broken]).
*/
/*
table(	choose,		
	[verb, 
	 morph_stem(Choose), % morph_root(Choose),
	 Choose= {choose,freeze,awake,weave},
	 Choose= Choo+S+e,
	 S = {s,z,k,v},	
	 Choo = Ch+Oo,
	 Oo = {oo,ee,a,ea},
	 Ch = C+H,
	 H \= `v,
	 Chooses = Choo+S+es,
	 Choose= Choo+S+ing,
	 Chose = Ch+o+S+e,
	 Chosen = Ch+o+S+en],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Choose, Chooses, Choose, Chose, Chosen, Choosing, Chosen]).
*/
/*
table(	ring,
	[verb, 
	 morph_stem(Ring), % morph_root(Ring),
	 Ring = {begin,drink,ring,shrink,sing,sink,spring,stink,swim},
	 Ring = R+i+Ng,
	 Rang = R+a+Ng,
	 Rung = R+u+Ng,
	 Rings = Ring+s,
	 Ringing = Ring+ing],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Ring, Rings, Ring, Rang, Rung, Ringing, Rung]).
*/
table(	come,		%overcome,become
	[verb, 
	 morph_stem(Come), % morph_root(Come),
	 Come = C+o+m+e,
	 Came = C+a+m+e,
	 Comes = Come+s,
	 Coming = C+o+m+ing],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Come, Comes,	Come,	Came,	Come,	Coming, Come]).
/*
table(	blow,
	[verb, 
	 morph_stem(Blow),% morph_root(Blow),
	 Blow = {blow,grow,know,outgrow,overthrow,throw},
	 Blow = Bl+o+w,			%rules out snow-snew-snown
	 Blew = Bl+e+w,
	 Blows = Blow+s,
	 Blown = Blow+n,
	 Blowing= Blow+ing],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Blow, Blows,	Blows, Blew, Blown, Blowing, Blown]).
*/
table(	shake,
	[verb, 
	 morph_stem(Shake), % morph_root(Shake),
	 Shake = {betake,forsake,mistake,overtake,partake,take,undertake},
	 Shake = Sh+ak+e,		%rules out brake-brook-braken
	 Shakes = Sh+ak+es,
 	 Shook = Sh+ook,
	 Shaken = Sh+ak+en,
	 Shaking = Sh+ak+ing],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Shake, Shakes, Shake, Shook, Shaken, Shaking, Shaken]).

table(	pay,
	[verb, 
	 morph_stem(Pay), % morph_root(Pay),
	 Pay = {lay,mislay,pay,repay,say,waylay}, %to rule out delay,stay
	 Pay = P+ay,		
	 Pays = Pay+s,
	 Paid = P+aid,
	 Paying = P+ay+ing],
	['Base', '3sg',	 'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Pay, Pays, Pay, Paid, Paid, Paying, Paid]).
 
table(	empty,	%carry,try,dry,deny,fancy
	[verb, 
	 morph_stem(Empty), % morph_root(Empty),
	 Empty = Emp+T+y,
	 T = `c,
	 Empties = Emp+T+ies,
	 Emptied = Emp+T+ied,
	 Emptying = Emp+T+ying],
	['Base', '3sg',	 'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Empty, Empties, Empty, Emptied, Emptied, Emptying, Emptied]).

table(	die,	%lie,tie,vie
	[verb, 
	 morph_stem(Die), % morph_root(Die),
	 Die = D+ie,
	 Dies = Die+s,
	 Died = Die+d,
	 Dying = D+ying],
	['Base', '3sg',	 'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Die, Dies, Die, Died, Died, Dying, Died]).

table(	leave,	%cleave,bereave
	[verb, 
	 morph_stem(Leave), % morph_root(Leave),
	 Leave = L+ea+v+e,
	 Leaves = Leave+s,
	 Left = L+eft,
	 Leaving = L+ea+v+ing],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Leave, Leaves, Leave,	Left, Left, Leaving, Left]).

table(	have,
	[verb,
	 morphology(strong),
	 morph_stem(Have), % morph_root(Have),
	 Have = have,
	 Have = Hav+e,
	 Having = Hav+ing],
	['Base', '3sg',	'Non3sg',	'Past',	'Perfect',	'Progressive',	'Passive'],
	[have, has,	Have,	had,	had,	Having,	had]).

table(	transfer,
	[verb, final_stress,
	 morph_stem(Transfer), % morph_root(Transfer),
	 R = `c,
	 Transfer = {transfer,occur,begin},
	 Transfer = Transfe+R,
	 Transfers = Transfer+s,
	 Transferring = Transfe+R+R+ing,
	 Transferred = Transfe+R+R+ed],
	['Base', '3sg', 'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Transfer, Transfers, Transfer, Transferred, Transferred, Transferring, Transferred]).

table(	bring,
	[verb,
	 morph_stem(Bring), % morph_root(Bring),
	 Bring = bring,
	 Bring = Br+ing,
	 Brings = Bring+s,
	 Brought = Br+ought,
	 Bringing = Bring+ing],
	['Base', '3sg', 'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Bring, Brings, Bring,	Brought, Brought, Bringing, Brought]).

table(	go,
	[verb, morphology(strong),
	 morph_stem(Go), % morph_root(Go),
	 Go = go],
	['Base', '3sg', 'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Go, goes,	Go, went, gone,	going, gone]).

table(	drive,
	[verb, 
	 morph_stem(Drive), % morph_root(Drive),
	 Drive = {drive,rise,strive},
	 Drive = Dr+i+v+e,
	 Drives = Drive+s,
	 Drove = Dr+o+v+e,
	 Driven = Drive+n,
	 Driving = Dr+i+v+ing],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Drives, Drives, Drive,	Drove, Driven, Driving, Driven]).
/*
table(	write,
	[verb, 
	 morph_stem(Write), % morph_root(Write),
	 Write= {write,ride,smite,stride},
	 Write = Wr+i+T+e,
	 Writes = Write+s,
	 Wrote = Wr+o+T+e,
	 Written = Wr+i+T+Te+n,
	 Writing= Wr+i+T+ing],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Writem Writes, Write,	Wrote, Written, Writing, Written]).
*/
table(	get,
	[verb,morphology(strong),
	 morph_stem(Get), % morph_root(Get),
	 Get = get],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[get, gets,	get, got, got, getting, got]).

table(	cost,
	[verb,morphology(strong),
	 morph_stem(Cost), % morph_root(Cost),
	 Cost = cost],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[cost, costs, cost, cost, cost, costing, cost]).

table(	send,
	[verb,
	 morph_stem(Send), % morph_root(Send),
	 Send = Sen+d,
	 Sen = S+e+n],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Send, Send+s, Send,	Sen+t,	Sen+t,	Send+ing,	    Sen+t]).

table(	buy,
	[verb,morphology(strong),
	 morph_stem(Buy), % morph_root(Buy),
	 Buy = B+uy,
	 Bought = B+ought,
	 Buying = Buy+ing,
	 Buys = Buy+s],
	['Base', '3sg',	'Non3sg', 'Past', 'Perfect', 'Progressive', 'Passive'],
	[Buy, Buys,	Buy, Bought, Bought, Buying, Bought]).

