/****************************************************************
*
*   File:        tugtree.h
*   Written by:  Ian Harder, Simon Fraser University
*                as a research project for Dr. Fred Popowich
*   Date:        Sept, 1989
*   
*   Revised by : Sue Baker, Simon Fraser University
*          Date:        October 1989 - April 1990
*
*   Revised by : Rob Hamm,  Simon Fraser University
*          Date:        May 1990 - 
*   
*   This is the header file for tug.c, a graphic output program
*   showing the parse tree(s) resulting from the Tree Unification
*   Grammar.
*
****************************************************************/

#define FALSE        0
#define TRUE         1

#define STRSZE    1000  /* size of string arrays */
#define AUXLSTSZE   10  /* maximum size of auxiliary list */
#define FASZE      150  /* maximum number of fa structures */
#define COMPLSTSZE  10  /* maximum size of component list */

#define HORIZ_PITCH  8  /* number of points per character */
#define VERTI_PITCH 15  /* number of points per line */
#define HORIZ_GAP   40  /* horizontal points between nodes */
#define VERTI_GAP   70  /* vertical points between nodes */
#define NODE_SIZE    5  /* number of character lines per node */

#define C_WIDTH   5000  /* maximum display canvas width  */
#define C_HEIGHT  2000  /* maximum display canvas height */
#define MAX_TREES   10  /* maximun number of trees allowed - RH */

#define ferr(msg) {fprintf(stderr, "Error: %s\n", msg); exit(-1);}


/* TUG tree structure definitions */

typedef struct {
   char phonology[STRSZE];
   char syntax[STRSZE];
   char semantics[STRSZE];
   char anaphors[STRSZE];
   char pronouns[STRSZE];
} NODE, *NODE_PTR;

typedef struct tree_type {
   char aux_label;
   NODE *node;
   int  num_trees ;
   struct tree_type *ntree[MAX_TREES] ;
} TREE, *TREE_PTR;
	
typedef struct {
   char name[STRSZE];
   TREE *tree;
   char aux_list[AUXLSTSZE];
   char comp_list[COMPLSTSZE][STRSZE];
   char total_comp[STRSZE];
} FA_STRUC, *FA_PTR;
   

/* TUG function type declarations */

void     fa_display();
int      tree_display();
int      edge_x_size();
void     node_display();
int      node_width();
int      get_structs();
FA_PTR   create_fa_struct();
TREE_PTR create_tree_node();
void     eat_white_space();
void     get_fa_name();
TREE_PTR get_fa_tree();
void     get_tree_node();
void     get_node_element();
void     get_fa_aux_list();
void     label_tree();
FILE     *open_input();
void     read_str();
char     next_char();
int      average();
void     get_args();
void     get_variable();
void  	 next_proc();
void     previous_proc();
void     quit_proc();
void     super_proc();
void     clear_proc();
void	 display_proc();
void     component_proc();
void     get_fa_comp_list();
int      get_fa_comp_element();

/* ----------------------------------------------------------- */ 
