/*

File:	/home/dk2/jcalder/Pleuk/HPSG/hpsgpleukvars.pl
Date:	Thu Mar  4 16:21:12 1993
By:	Jo Calder


*/

/*

Sun Mar 14 17:11:34 1993 JC

We have to set the following variable to true, because the reader
doesn't always return a nonvariable name for an object.  

*/


/*

Parsing variables -- based on flag/1

*/

:- eccs_new_variable(printsem, false, parsing, run,
	"print out semantics each time we hit a successful parse").

:- eccs_new_variable(tracer, false, parsing, run, 
	"whether to trace various things").

:- eccs_new_variable(explicit, false, parsing, run,
	"whether to construct daughters of phrasal constituents on line").

:- eccs_new_variable(lisp, false, system, run, 
	"whether to run in `lisp-compatible' mode").

:- eccs_new_variable(silent, false, parsing, run, 
	"whether to print out any messages at all during processing and parsing").

:- eccs_new_variable(phrasal, false, parsing, run,
	"whether to reconstruct information about daughters").

:- eccs_new_variable(optimize, false, parsing, run,
	"Not sure about this one ...??").

:- eccs_new_variable(dbunify, false, parsing, run, 
	"Determines how semantic information is processed").

:- eccs_new_variable(conp, false, parsing, run,
	"Determines how semantic information from adjuncts is handled").

/*

Additions



*/

:- eccs_new_variable('SystemX mode', false, system, run, 
	"Whether to run in SystemX mode").


:- eccs_new_variable(delete_uninstantiated_attributes, true, printing,
	run, "If true, hide structure where the values of attributes is uninstantiated").

:- eccs_new_variable(attribute_ordering, [phon, syn, sem, dtrs, loc, non_loc],
	printing,
	run, "The ordering in which we wish attributes to appear").


/*

We are in something of a pickle here, given that we have to support
both Pleuk Variables and the flags of the underlying HPSG-PL.  

The strategy we adopt is as follows.  We assume on start up that the
correct state is represented in terms of Pleuk variables and that the
only way that that information can get into the system is via a Pleuk
customization files.  As this assumption is really invalid (with
.sicstusrc files and so on), we must explicitly ask the user not to set
flags via the plus and minus command.  

On starting the top level 

*/

hpsg2_vars_list([
    printsem,
    explicit, 
    tracer,
    lisp,
    silent,
    phrasal,
    optimize,
    dbunify,
    conp]).

/*

hpsg_prepare_flags

copy state represented in Pleuk vars into HPSG's flags.


*/

hpsg_prepare_flags :-
    hpsg2_vars_list(L),
    hpsg2_do_flag_vars(L).

hpsg2_do_flag_vars([]).
hpsg2_do_flag_vars([Flag|Flags]) :-
    (eccs_global_variable(Flag, Val) ->
    	hpsg2_do_flag_vars1(Flag, Val); true),
    hpsg2_do_flag_vars(Flags).

hpsg2_do_flag_vars1(Flag, false) :- !, remove_flag(Flag).
hpsg2_do_flag_vars1(Flag, true) :-  !, add_flag(Flag).
hpsg2_do_flag_vars1(_, _).


